/*
 * Decompiled with CFR 0.152.
 */
package xcsf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Vector;
import xcsf.XCSFConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XCSFUtils {
    public static double mean(double[] values) {
        double mean = 0.0;
        for (double d : values) {
            mean += d;
        }
        return mean /= (double)values.length;
    }

    public static double variance(double[] values, double mean) {
        double var = 0.0;
        for (double d : values) {
            var += (d - mean) * (d - mean);
        }
        return var /= (double)(values.length - 1);
    }

    public static double standardDeviation(double[] values, double mean) {
        return Math.sqrt(XCSFUtils.variance(values, mean));
    }

    public static void flip(int position, double[] array1, double[] array2) {
        double tmp = array1[position];
        array1[position] = array2[position];
        array2[position] = tmp;
    }

    public static boolean arrayEquals(double[] array1, double[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static String checkPath(String path) {
        if (path != null && path.length() > 0) {
            if (!path.endsWith(File.separator)) {
                path = path + File.separator;
            }
            if (!new File(path).isDirectory()) {
                throw new IllegalArgumentException("path '" + path + "' does not exist.");
            }
        } else {
            path = "";
        }
        return path;
    }

    public static void print(String string, int length) {
        if (XCSFConstants.verbose) {
            System.out.format("%-" + length + "s", string);
        }
    }

    public static void println(String s) {
        if (XCSFConstants.verbose) {
            System.out.println(s);
        }
    }

    public static int putNumFirstObjectsFirst(double[] votes, int[] nums, Object[] objs, int size, int num) {
        XCSFUtils.putNumFirstRec(votes, nums, objs, 0, size - 1, num);
        int numsum = 0;
        for (int i = 0; i < size; ++i) {
            if ((numsum += nums[i]) < num) continue;
            return i + 1;
        }
        return size;
    }

    private static void putNumFirstRec(double[] votes, int[] nums, Object[] objs, int begin, int end, int num) {
        if (num <= 0 || begin >= end) {
            return;
        }
        double help = 0.0;
        double pivot = votes[end];
        int pivotN = nums[end];
        Object pivotO = objs[end];
        if (end - begin > 20) {
            int pos0 = begin + (int)(Random.uniRand() * (double)(end + 1 - begin));
            int pos1 = begin + (int)(Random.uniRand() * (double)(end + 1 - begin));
            int pos2 = begin + (int)(Random.uniRand() * (double)(end + 1 - begin));
            int posChosen = 0;
            posChosen = votes[pos2] < votes[pos1] ? (votes[pos1] < votes[pos0] ? pos1 : (votes[pos0] < votes[pos2] ? pos2 : pos0)) : (votes[pos2] < votes[pos0] ? pos2 : (votes[pos0] < votes[pos1] ? pos1 : pos0));
            pivot = votes[posChosen];
            pivotN = nums[posChosen];
            pivotO = objs[posChosen];
            votes[posChosen] = votes[end];
            nums[posChosen] = nums[end];
            objs[posChosen] = objs[end];
            votes[end] = pivot;
            nums[end] = pivotN;
            objs[end] = pivotO;
        }
        int i = begin;
        int numSize = 0;
        for (int j = begin; j < end; ++j) {
            if (!(pivot <= votes[j])) continue;
            help = votes[j];
            votes[j] = votes[i];
            votes[i] = help;
            int helpN = nums[j];
            nums[j] = nums[i];
            nums[i] = helpN;
            Object helpO = objs[j];
            objs[j] = objs[i];
            objs[i] = helpO;
            numSize += nums[i];
            ++i;
        }
        votes[end] = votes[i];
        nums[end] = nums[i];
        objs[end] = objs[i];
        votes[i] = pivot;
        nums[i] = pivotN;
        objs[i] = pivotO;
        if (num < numSize) {
            XCSFUtils.putNumFirstRec(votes, nums, objs, begin, i - 1, num);
        } else {
            if (num < numSize + nums[i]) {
                return;
            }
            XCSFUtils.putNumFirstRec(votes, nums, objs, i + 1, end, num - numSize - nums[i]);
        }
    }

    public static Constructor<?> loadConstructor(String className, Class<?> implementedInterface, Class<?>[] constructorSignature) {
        try {
            Class<?> c = Class.forName(className);
            boolean found = false;
            for (Class<?> ob : c.getInterfaces()) {
                found |= ob.equals(implementedInterface);
            }
            if (!found) {
                throw new IllegalArgumentException("Class " + className + " is not implementing the " + implementedInterface.getSimpleName() + " interface.");
            }
            int modifiers = c.getModifiers();
            if (Modifier.isAbstract(modifiers) || Modifier.isInterface(modifiers) || c.isArray() || c.isPrimitive()) {
                throw new IllegalArgumentException("Class " + className + " cannot be instantiated, because the class is" + " 1) abstract or 2) an interface or" + " 3) an array or 4) primitive.");
            }
            return c.getConstructor(constructorSignature);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            String signature = "";
            for (int i = 0; i < constructorSignature.length; ++i) {
                if (i > 0) {
                    signature = signature + ", ";
                }
                signature = signature + constructorSignature[i].getCanonicalName();
            }
            System.err.println("The class " + className + " implements the " + implementedInterface.getSimpleName() + " \n" + "interface, but does not provide the required constructor:\n" + "  new " + className + "(" + signature + ")");
            e.printStackTrace();
        }
        return null;
    }

    public static class Random {
        private static final long _M = Integer.MAX_VALUE;
        private static final long _A = 16807L;
        private static final long _Q = 127773L;
        private static final long _R = 2836L;
        private static long seed = 101L;
        private static boolean haveUniNum = false;
        private static double uniNum = 0.0;

        public static void setSeed(long s) {
            seed = s;
        }

        public static long getSeed() {
            return seed;
        }

        public static double uniRand() {
            long lo = seed % 127773L;
            long hi = seed / 127773L;
            long test = 16807L * lo - 2836L * hi;
            seed = test > 0L ? test : test + Integer.MAX_VALUE;
            return (double)seed / 2.147483647E9;
        }

        public static double normRand() {
            double x2;
            double x1;
            double w;
            if (haveUniNum) {
                haveUniNum = false;
                return uniNum;
            }
            while ((w = (x1 = 2.0 * Random.uniRand() - 1.0) * x1 + (x2 = 2.0 * Random.uniRand() - 1.0) * x2) >= 1.0) {
            }
            w = Math.sqrt(-2.0 * Math.log(w) / w);
            uniNum = x1 * w;
            haveUniNum = true;
            return x2 * w;
        }
    }

    public static class FileIO {
        private static final String COMMENT_CHAR = "#";
        private static final String DEFAULT_REGEX = "\\s+";

        public static String[][] parseCSV(File file, int skipLines) throws IOException {
            return FileIO.parseCSV(file, DEFAULT_REGEX, skipLines);
        }

        public static String[][] parseCSV(File file, String splitregex, int skipLines) throws IOException {
            BufferedReader in = new BufferedReader(new FileReader(file));
            Vector<String> lines = new Vector<String>();
            for (int i = 0; i < skipLines; ++i) {
                in.readLine();
            }
            while (in.ready()) {
                String line = in.readLine().trim();
                if (line.length() <= 0 || line.startsWith(COMMENT_CHAR)) continue;
                lines.add(line);
            }
            in.close();
            int size = lines.size();
            String[][] data = new String[size][];
            for (int i = 0; i < size; ++i) {
                data[i] = ((String)lines.get(i)).split(splitregex);
                for (int j = 0; j < data[i].length; ++j) {
                    data[i][j] = data[i][j].trim();
                }
            }
            return data;
        }

        public static double[][] parseDoubleCSV(File file) throws IOException {
            String[][] stringData = FileIO.parseCSV(file, DEFAULT_REGEX, 0);
            double[][] data = new double[stringData.length][];
            for (int row = 0; row < stringData.length; ++row) {
                data[row] = new double[stringData[row].length];
                for (int col = 0; col < stringData[row].length; ++col) {
                    data[row][col] = Double.parseDouble(stringData[row][col]);
                }
            }
            return data;
        }

        public static void writeDoubleCSV(File file, double[][] content) throws IOException {
            PrintStream ps = new PrintStream(file);
            double[][] arr$ = content;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                double[] row;
                for (double value : row = arr$[i$]) {
                    ps.print(value + " ");
                }
                ps.println();
            }
            ps.flush();
            ps.close();
        }

        public static double[] parseDoubleArray(String string) {
            string = string.trim();
            Arrays.toString(new double[0]);
            string = string.substring(1, string.length() - 1);
            String[] splited = string.split(",");
            int l = splited.length;
            double[] arr = new double[l];
            for (int i = 0; i < l; ++i) {
                arr[i] = Double.parseDouble(splited[i].trim());
            }
            return arr;
        }

        public static double[][] parse2dDoubleArray(String string) {
            string = string.replaceAll(DEFAULT_REGEX, "").replaceAll("\\],", "\\];");
            string = string.substring(1, string.length() - 1);
            String[] splited = string.split(";");
            double[][] arr = new double[splited.length][];
            for (int i = 0; i < splited.length; ++i) {
                arr[i] = FileIO.parseDoubleArray(splited[i]);
            }
            return arr;
        }

        public static void fileCopy(File source, File destination) {
            try {
                FileChannel srcChannel = new FileInputStream(source).getChannel();
                FileChannel dstChannel = new FileOutputStream(destination).getChannel();
                dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
                srcChannel.close();
                dstChannel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                System.err.println("Failed to copy " + source.getName() + " to " + destination.getName() + ".");
            }
        }
    }

    public static class Gnuplot {
        public static String executable = null;
        private PrintStream console;

        public Gnuplot() throws IOException {
            if (executable == null) {
                String os = System.getProperty("os.name").toLowerCase();
                if (os.contains("linux")) {
                    executable = "gnuplot";
                } else if (os.contains("windows")) {
                    String programFiles = System.getenv("ProgramFiles");
                    if (programFiles == null) {
                        programFiles = "C:" + File.separatorChar + "Program Files";
                    }
                    if (!programFiles.endsWith(File.separator)) {
                        programFiles = programFiles + File.separatorChar;
                    }
                    executable = programFiles + "gnuplot" + File.separatorChar + "bin" + File.separatorChar + "pgnuplot.exe";
                } else {
                    throw new IOException("Operating system '" + os + "' is not supported. " + "If you have Gnuplot installed, " + "specify the executable command via" + System.getProperty("line.separator") + "xcsf.XCSFUtils.Gnuplot.executable " + "= \"your executable\"");
                }
            }
            Process p = Runtime.getRuntime().exec(executable);
            this.console = new PrintStream(p.getOutputStream());
        }

        public void execute(String command) {
            if (this.console == null) {
                return;
            }
            this.console.println(command);
            this.console.flush();
        }

        public void close() {
            if (this.console == null) {
                return;
            }
            this.execute("exit");
            this.console.close();
            this.console = null;
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }

    public static class Matrix {
        public static void multiply(double[][] srcMatrix, double[] srcVector, double[] destination, int n) {
            for (int i = 0; i < n; ++i) {
                destination[i] = srcMatrix[i][0] * srcVector[0];
                for (int j = 1; j < n; ++j) {
                    int n2 = i;
                    destination[n2] = destination[n2] + srcMatrix[i][j] * srcVector[j];
                }
            }
        }

        public static void multiplyExtended(double[][] srcMatrixExt, double[] srcVector, double[] destination, int n) {
            for (int i = 0; i < n; ++i) {
                destination[i] = srcMatrixExt[i][0] * srcVector[0];
                for (int j = 1; j < n; ++j) {
                    int n2 = i;
                    destination[n2] = destination[n2] + srcMatrixExt[i][j] * srcVector[j];
                }
                int n3 = i;
                destination[n3] = destination[n3] + srcMatrixExt[i][n];
            }
        }

        public static void multiply(double[][] srcA, double[][] srcB, double[][] destination, int n) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    destination[i][j] = srcA[i][0] * srcB[0][j];
                    for (int k = 1; k < n; ++k) {
                        double[] dArray = destination[i];
                        int n2 = j;
                        dArray[n2] = dArray[n2] + srcA[i][k] * srcB[k][j];
                    }
                }
            }
        }

        public static void copyMatrix(double[][] source, double[][] destination, int n) {
            for (int i = 0; i < n; ++i) {
                System.arraycopy(source[i], 0, destination[i], 0, n);
            }
        }
    }
}

