/*
 * Decompiled with CFR 0.152.
 */
package xcsf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Properties;
import xcsf.classifier.ConditionRotatingEllipsoid;
import xcsf.classifier.PredictionLinearRLS;

public class XCSFConstants {
    public static int numberOfExperiments = 1;
    public static int averageExploitTrials = 500;
    public static long initialSeed = 101L;
    public static boolean doRandomize = false;
    public static boolean multiThreading = true;
    public static int threadingThreshold = -1;
    public static boolean verbose = true;
    public static int maxLearningIterations = 100000;
    public static int maxPopSize = 6400;
    public static double epsilon_0 = 0.01;
    public static String conditionType = ConditionRotatingEllipsoid.class.getName();
    public static String predictionType = PredictionLinearRLS.class.getName();
    public static double minConditionStretch = 0.01;
    public static double coverConditionRange = 0.99;
    public static double beta = 0.1;
    public static double delta = 0.1;
    public static double alpha = 1.0;
    public static double startCompaction = 0.9;
    public static int compactionType = 1;
    public static boolean doNumClosestMatch = false;
    public static int numClosestMatch = 20;
    public static int theta_GA = 50;
    public static double selectionType = 0.4;
    public static double pM = 1.0;
    public static double pX = 1.0;
    public static int theta_del = 20;
    public static int theta_sub = 20;
    public static boolean doGASubsumption = true;
    public static double nu = 5.0;
    public static double predictionErrorReduction = 1.0;
    public static double fitnessReduction = 0.1;
    public static double predictionErrorIni = 0.0;
    public static double fitnessIni = 0.01;
    public static double rlsInitScaleFactor = 1000.0;
    public static double lambdaRLS = 1.0;
    public static double resetRLSPredictionsAfterSteps = startCompaction;
    public static double predictionOffsetValue = 1.0;

    public static void load(String filename) {
        Properties prop = new Properties();
        try {
            FileInputStream in = new FileInputStream(filename);
            prop.load(in);
            in.close();
        }
        catch (IOException e) {
            File f = new File(filename);
            System.err.println("Failed to load properties from");
            System.err.println("   " + f.getAbsolutePath());
            System.err.println("Continuing with default values.");
            return;
        }
        for (Field f : XCSFConstants.class.getFields()) {
            String value = prop.getProperty(f.getName());
            if (value == null) {
                System.err.println("Failed to load property '" + f.getName() + "'");
                continue;
            }
            if (f.getName().equals("resetRLSPredictionsAfterSteps") && value.toLowerCase().equals("startcompaction")) {
                resetRLSPredictionsAfterSteps = startCompaction;
                continue;
            }
            if (f.getName().equals("threadingThreshold") && value.toLowerCase().equals("auto")) {
                threadingThreshold = -1;
                continue;
            }
            XCSFConstants.setValue(f, value);
        }
    }

    public static void load() {
        XCSFConstants.load("xcsf.ini");
    }

    private static void setValue(Field field, String value) {
        try {
            if (field.getType().toString().equals("boolean")) {
                field.setBoolean(field, Boolean.parseBoolean(value));
            } else if (field.getType().toString().equals("int")) {
                field.setInt(field, Integer.parseInt(value));
            } else if (field.getType().toString().equals("double")) {
                field.setDouble(field, Double.parseDouble(value));
            } else if (field.getType().toString().equals("long")) {
                field.setLong(field, Long.parseLong(value));
            } else if (field.getType().toString().equals("class java.lang.String")) {
                field.set(field, value);
            } else {
                System.err.println("Failed to set property '" + field.getName() + "': IllegalArgument '" + value + "'");
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

