/*
 * Decompiled with CFR 0.152.
 */
package xcsf;

import java.util.Collection;
import java.util.Vector;
import xcsf.EvolutionaryComp;
import xcsf.Function;
import xcsf.MatchSet;
import xcsf.PerformanceEvaluator;
import xcsf.Population;
import xcsf.StateDescriptor;
import xcsf.XCSFConstants;
import xcsf.XCSFListener;
import xcsf.XCSFUtils;
import xcsf.classifier.PredictionLinearRLS;
import xcsf.classifier.PredictionQuadraticRLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XCSF {
    private Function function;
    private Vector<XCSFListener> listeners = new Vector();
    private PerformanceEvaluator performanceEvaluator;

    public XCSF(Function function) {
        this.function = function;
    }

    public XCSF(Function function, String settingsFilename) {
        this(function);
        XCSFConstants.load(settingsFilename);
    }

    public void runExperiments() {
        XCSFUtils.println("");
        this.performanceEvaluator = new PerformanceEvaluator();
        for (int exp = 0; exp < XCSFConstants.numberOfExperiments; ++exp) {
            for (XCSFListener l : this.listeners) {
                l.nextExperiment(exp, this.function.toString());
            }
            if (XCSFConstants.numberOfExperiments > 1) {
                XCSFUtils.print(" > " + this.function.toString() + ", Experiment " + (exp + 1) + "/" + XCSFConstants.numberOfExperiments, 60);
            } else {
                XCSFUtils.println("Running on Function '" + this.function.toString() + "'...");
            }
            long time = System.currentTimeMillis();
            this.runSingleExperiment();
            time = (System.currentTimeMillis() - time) / 1000L;
            XCSFUtils.println("done in " + (int)(time / 60L) + "m " + time % 60L + "s");
        }
    }

    public Population runSingleExperiment() {
        return this.runSingleExperiment(new Population());
    }

    public Population runSingleExperiment(Population population) {
        if (this.performanceEvaluator == null) {
            this.performanceEvaluator = new PerformanceEvaluator();
        }
        MatchSet matchSet = new MatchSet(XCSFConstants.doNumClosestMatch, XCSFConstants.multiThreading);
        EvolutionaryComp evolutionaryComponent = new EvolutionaryComp();
        this.performanceEvaluator.nextExperiment();
        for (int iteration = 1; iteration <= XCSFConstants.maxLearningIterations; ++iteration) {
            StateDescriptor state = this.function.nextProblemInstance();
            matchSet.match(state, population);
            matchSet.ensureStateCoverage(population, iteration);
            double[] functionPrediction = matchSet.getWeightedPrediction();
            double[] functionValue = this.function.getNoiselessFunctionValue();
            if (functionValue == null) {
                functionValue = state.getOutput();
            }
            this.performanceEvaluator.evaluate(population, matchSet, iteration, functionValue, functionPrediction);
            matchSet.updateClassifiers();
            evolutionaryComponent.evolve(population, matchSet, state, iteration);
            if (!this.listeners.isEmpty()) {
                double[][] performance = this.performanceEvaluator.getCurrentExperimentPerformance();
                for (XCSFListener l : this.listeners) {
                    l.stateChanged(iteration, population, matchSet, state, performance);
                }
            }
            if ((XCSFConstants.predictionType.equalsIgnoreCase(PredictionLinearRLS.class.getName()) || XCSFConstants.predictionType.equalsIgnoreCase(PredictionQuadraticRLS.class.getName())) && iteration + 1 == (int)(XCSFConstants.resetRLSPredictionsAfterSteps * (double)XCSFConstants.maxLearningIterations)) {
                for (int i = 0; i < population.size; ++i) {
                    ((PredictionLinearRLS)population.elements[i].getPrediction()).resetGainMatrix();
                }
            }
            if (iteration + 1 != (int)(XCSFConstants.startCompaction * (double)XCSFConstants.maxLearningIterations)) continue;
            evolutionaryComponent.setCondensation(true);
            if (XCSFConstants.compactionType % 2 == 1) {
                matchSet.setNumClosestMatching(true);
            }
            if (XCSFConstants.compactionType < 2) continue;
            population.applyGreedyCompaction();
        }
        try {
            matchSet.shutDownThreads();
            matchSet = null;
        }
        catch (Throwable e) {
            // empty catch block
        }
        return population;
    }

    public String getFinalPerformance() {
        return this.performanceEvaluator.getAvgFinalPerformance();
    }

    public void writePerformance(String filename) {
        this.performanceEvaluator.writeAvgPerformance(filename);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("XCSF on ");
        sb.append(this.function.toString());
        sb.append(" in ");
        sb.append(this.function.getConditionInputDimension());
        sb.append("D");
        sb.append(", settings:");
        sb.append(System.getProperty("line.separator"));
        sb.append(" * max ");
        sb.append(XCSFConstants.maxPopSize);
        sb.append(" CLs for ");
        sb.append(XCSFConstants.maxLearningIterations);
        sb.append(" iterations, target error=");
        sb.append(XCSFConstants.epsilon_0);
        sb.append(System.getProperty("line.separator"));
        sb.append(" * ");
        sb.append(XCSFConstants.conditionType.substring(1 + XCSFConstants.conditionType.lastIndexOf(46)));
        sb.append("/");
        sb.append(XCSFConstants.predictionType.substring(1 + XCSFConstants.predictionType.lastIndexOf(46)));
        if (XCSFConstants.multiThreading && Runtime.getRuntime().availableProcessors() > 1) {
            sb.append(", up to ");
            sb.append(Runtime.getRuntime().availableProcessors());
            sb.append(" threads");
        }
        return sb.toString();
    }

    public void addListener(XCSFListener listener) {
        for (XCSFListener el : this.listeners) {
            if (!el.getClass().equals(listener.getClass())) continue;
            System.err.println("Listener of Class '" + el.getClass() + "' already registered - ignoring " + listener);
            return;
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void addListeners(Collection<XCSFListener> listener) {
        for (XCSFListener l : listener) {
            this.addListener(l);
        }
    }

    public void removeListener(XCSFListener l) {
        this.listeners.remove(l);
    }

    public void clearListeners() {
        this.listeners.clear();
    }
}

