/*
 * Decompiled with CFR 0.152.
 */
package xcsf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import xcsf.ClassifierSet;
import xcsf.XCSFConstants;
import xcsf.XCSFUtils;
import xcsf.classifier.Classifier;

public class Population
extends ClassifierSet {
    private static final String SEPARATOR1 = ";";
    private static final String SEPARATOR2 = ":";
    private static final Comparator<Classifier> COMPACTION_COMPARATOR = new Comparator<Classifier>(){
        private static final double INEXPERIENCED = 1000.0;

        @Override
        public int compare(Classifier cl1, Classifier cl2) {
            int exp1 = cl1.getExperience();
            int exp2 = cl2.getExperience();
            if (exp1 < XCSFConstants.theta_sub && exp2 < XCSFConstants.theta_sub) {
                return 0;
            }
            if (exp1 < XCSFConstants.theta_sub) {
                return Double.compare(1000.0, cl2.getPredictionError());
            }
            if (exp2 < XCSFConstants.theta_sub) {
                return Double.compare(cl1.getPredictionError(), 1000.0);
            }
            return Double.compare(cl1.getPredictionError(), cl2.getPredictionError());
        }
    };

    void deleteWorstClassifiers(int number) {
        double meanFitness = 0.0;
        int numerositySum = 0;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            meanFitness += this.elements[i].getFitness();
            numerositySum += this.elements[i].getNumerosity();
        }
        double[] rouletteWheel = new double[n];
        rouletteWheel[0] = this.elements[0].getDeletionVote(meanFitness /= (double)numerositySum);
        for (int i = 1; i < n; ++i) {
            rouletteWheel[i] = rouletteWheel[i - 1] + this.elements[i].getDeletionVote(meanFitness);
        }
        int[] deletedIndices = new int[number];
        for (int i = 0; i < number; ++i) {
            deletedIndices[i] = -1;
        }
        int deleted = 0;
        int reallyDeleted = 0;
        while (deleted < number) {
            double choicePoint = rouletteWheel[n - 1] * XCSFUtils.Random.uniRand();
            int index = Population.binaryRWSearch(rouletteWheel, choicePoint);
            boolean alreadyDeleted = false;
            for (int j = 0; j < deleted; ++j) {
                if (deletedIndices[j] != index) continue;
                alreadyDeleted = true;
                break;
            }
            if (alreadyDeleted) continue;
            Classifier cl = this.elements[index];
            cl.addNumerosity(-1);
            if (cl.getNumerosity() == 0) {
                deletedIndices[deleted] = index;
                ++reallyDeleted;
            }
            ++deleted;
        }
        if (reallyDeleted > 0) {
            int[] indices = new int[reallyDeleted];
            int i = 0;
            for (int index : deletedIndices) {
                if (index == -1) continue;
                indices[i++] = index;
            }
            super.remove(indices);
        }
    }

    void applyGreedyCompaction() {
        if (this.size < 2) {
            return;
        }
        super.sort(COMPACTION_COMPARATOR);
        for (int i = 0; i < this.size; ++i) {
            Classifier clLow = this.elements[i];
            double[] reference = clLow.getCondition().getCenter();
            for (int j = i + 1; j < this.size; ++j) {
                Classifier clHigh = this.elements[j];
                if (!clHigh.getCondition().doesMatch(reference)) continue;
                clLow.addNumerosity(clHigh.getNumerosity());
                super.remove(j);
                --j;
            }
        }
    }

    private static int binaryRWSearch(double[] rw, double choicePoint) {
        int low = 0;
        int high = rw.length - 1;
        while (low < high) {
            int mid = low + high >>> 1;
            if (choicePoint < rw[mid]) {
                high = mid;
                continue;
            }
            if (choicePoint > rw[mid]) {
                low = mid + 1;
                continue;
            }
            return mid + 1;
        }
        return low;
    }

    public void writePopulation(File file) throws FileNotFoundException {
        this.writePopulation(file, SEPARATOR1, SEPARATOR2);
    }

    public Population parse(File file) throws IOException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return this.parse(file, SEPARATOR1, SEPARATOR2, 0);
    }

    public void writePopulation(File file, CharSequence seperator1, CharSequence separator2) throws FileNotFoundException {
        PrintStream ps = new PrintStream(file);
        for (int i = 0; i < this.size; ++i) {
            this.elements[i].write(ps, seperator1, separator2);
            ps.println();
        }
        ps.flush();
        ps.close();
    }

    public Population parse(File file, String splitRegex1, String splitRegex2, int skipLines) throws IOException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        BufferedReader in = new BufferedReader(new FileReader(file));
        this.clear();
        for (int i = 0; i < skipLines && in.ready(); ++i) {
            in.readLine();
        }
        while (in.ready()) {
            String line = in.readLine().trim();
            if (line.length() <= 0) continue;
            Classifier cl = Classifier.parse(line, splitRegex1, splitRegex2);
            this.add(cl);
        }
        in.close();
        return this;
    }
}

