/*
 * Decompiled with CFR 0.152.
 */
package xcsf;

import java.io.IOException;
import java.io.PrintStream;
import xcsf.MatchSet;
import xcsf.Population;
import xcsf.XCSFConstants;
import xcsf.XCSFUtils;
import xcsf.classifier.Classifier;

public class PerformanceEvaluator {
    public static final String[] HEADER = new String[]{"Iteration", "avg. Error", "Macro Classifier", "Micro Classifier", "avg. Matchset Macro Cl.", "avg. MatchSet Micro Cl.", "avg. Pred.Error", "avg. Fitness", "avg. Generality", "avg. Experience", "avg. SetSizeEstimate", "avg. Timestamp", "avg. Individual Error"};
    private static final String SYSO_FORMAT = "| %6d | %-12g | %6d %6d %5d %5d | %-10g | %-10g |";
    private static final String SYSO_HEADER = "|  iter. | avg. err.    |popSize  micro msSize micro|  fitness   | generality |" + System.getProperty("line.separator") + "+--------+--------------+--------------" + "-------------+------------+------------+";
    private double[][] predictionError = new double[XCSFConstants.averageExploitTrials][];
    private int[] matchSetSize = new int[XCSFConstants.averageExploitTrials];
    private int[] matchSetNumerositySum = new int[XCSFConstants.averageExploitTrials];
    private int experiment = -1;
    private double[][][] avgPerformance = new double[XCSFConstants.numberOfExperiments][XCSFConstants.maxLearningIterations / XCSFConstants.averageExploitTrials][];

    PerformanceEvaluator() {
    }

    double[][] getCurrentExperimentPerformance() {
        return this.avgPerformance[this.experiment];
    }

    void nextExperiment() {
        ++this.experiment;
    }

    void evaluate(Population population, MatchSet matchSet, int iteration, double[] noiselessFunctionValue, double[] functionPrediction) {
        double[] error = new double[functionPrediction.length];
        for (int i = 0; i < functionPrediction.length; ++i) {
            error[i] = Math.abs(noiselessFunctionValue[i] - functionPrediction[i]);
        }
        int index = (iteration - 1) % XCSFConstants.averageExploitTrials;
        this.predictionError[index] = error;
        this.matchSetSize[index] = matchSet.size;
        this.matchSetNumerositySum[index] = 0;
        for (int i = 0; i < matchSet.size; ++i) {
            Classifier cl = matchSet.elements[i];
            int n = index;
            this.matchSetNumerositySum[n] = this.matchSetNumerositySum[n] + cl.getNumerosity();
        }
        if (index == XCSFConstants.averageExploitTrials - 1) {
            this.avgPerformance[this.experiment][iteration / XCSFConstants.averageExploitTrials - 1] = this.evaluatePerformance(population);
            if (XCSFConstants.numberOfExperiments == 1) {
                XCSFUtils.println(PerformanceEvaluator.performanceToString(iteration, this.avgPerformance[this.experiment][iteration / XCSFConstants.averageExploitTrials - 1]));
            }
        } else if (iteration == 1 && XCSFConstants.numberOfExperiments == 1) {
            XCSFUtils.println(SYSO_HEADER);
        }
    }

    void writeAvgPerformance(String file) {
        int rows = this.avgPerformance[0].length;
        int length = this.avgPerformance[0][0].length;
        double[][] mean = new double[rows][length];
        double[][] deviation = new double[rows][length];
        for (int row = 0; row < rows; ++row) {
            this.determineMeanAndDeviation(row, mean[row], deviation[row]);
        }
        try {
            PrintStream ps = new PrintStream(file + ".txt");
            ps.println(PerformanceEvaluator.getHeader(true));
            for (int row = 0; row < rows; ++row) {
                String str = PerformanceEvaluator.meanAndVarianceToString((row + 1) * XCSFConstants.averageExploitTrials, mean[row], deviation[row]);
                ps.println(str);
            }
            ps.flush();
            ps.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            XCSFUtils.Gnuplot gnuplot = new XCSFUtils.Gnuplot();
            gnuplot.execute("set xlabel 'number of learning steps'");
            gnuplot.execute("set ylabel 'pred. error, macro cl.'");
            gnuplot.execute("set logscale y");
            gnuplot.execute("set mytics 10");
            gnuplot.execute("set style data errorlines");
            gnuplot.execute("set term postscript eps enhanced color");
            gnuplot.execute("set out '" + file + ".eps'");
            gnuplot.execute("plot '" + file + ".txt' " + "using 1:2:2:($2+$3) title 'pred. error' pt 1, " + "'' using 1:4:4:($4+$5) title 'macro cl.' pt 2, " + "'' using 1:16:16:($16+$17) title 'generality' pt 3");
            gnuplot.execute("save '" + file + ".plt'");
            gnuplot.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    String getAvgFinalPerformance() {
        int lastRow = this.avgPerformance[0].length - 1;
        int length = this.avgPerformance[0][0].length;
        double[] mean = new double[length];
        double[] deviation = new double[length];
        this.determineMeanAndDeviation(lastRow, mean, deviation);
        StringBuffer sb = new StringBuffer(80);
        for (int i = 0; i < mean.length; ++i) {
            if (i > 0) {
                sb.append("\t");
            }
            sb.append(mean[i]);
            sb.append("\t");
            sb.append(deviation[i]);
        }
        return sb.toString();
    }

    private void determineMeanAndDeviation(int row, double[] mean, double[] deviation) {
        int experiments = this.avgPerformance.length;
        for (int i = 0; i < mean.length; ++i) {
            int exp;
            for (exp = 0; exp < experiments; ++exp) {
                int n = i;
                mean[n] = mean[n] + this.avgPerformance[exp][row][i] / (double)experiments;
            }
            if (experiments > 1) {
                for (exp = 0; exp < experiments; ++exp) {
                    double dif = this.avgPerformance[exp][row][i] - mean[i];
                    int n = i;
                    deviation[n] = deviation[n] + dif * dif / ((double)experiments - 1.0);
                }
                deviation[i] = Math.sqrt(deviation[i]);
                continue;
            }
            deviation[i] = 0.0;
        }
    }

    private double[] evaluatePerformance(Population population) {
        int dim;
        int outputDim = this.predictionError[0].length;
        double[] avgPredError = new double[outputDim];
        double avgMatchSetSize = 0.0;
        double avgMatchSetNumerositySum = 0.0;
        for (int expl = 0; expl < this.predictionError.length; ++expl) {
            for (dim = 0; dim < outputDim; ++dim) {
                int n = dim;
                avgPredError[n] = avgPredError[n] + this.predictionError[expl][dim];
            }
            avgMatchSetSize += (double)this.matchSetSize[expl];
            avgMatchSetNumerositySum += (double)this.matchSetNumerositySum[expl];
        }
        int dim2 = 0;
        while (dim2 < outputDim) {
            int n = dim2++;
            avgPredError[n] = avgPredError[n] / (double)XCSFConstants.averageExploitTrials;
        }
        avgMatchSetSize /= (double)XCSFConstants.averageExploitTrials;
        avgMatchSetNumerositySum /= (double)XCSFConstants.averageExploitTrials;
        double[] performance = new double[11 + outputDim];
        for (dim = 0; dim < outputDim; ++dim) {
            performance[0] = performance[0] + avgPredError[dim];
        }
        performance[1] = population.size;
        int popNumerositySum = 0;
        performance[3] = avgMatchSetSize;
        performance[4] = avgMatchSetNumerositySum;
        performance[5] = 0.0;
        performance[6] = 0.0;
        performance[7] = 0.0;
        performance[8] = 0.0;
        performance[9] = 0.0;
        for (int i = 0; i < population.size; ++i) {
            Classifier cl = population.elements[i];
            popNumerositySum += cl.getNumerosity();
            performance[5] = performance[5] + cl.getPredictionError() * (double)cl.getNumerosity();
            performance[6] = performance[6] + cl.getFitness();
            performance[7] = performance[7] + cl.getGenerality() * (double)cl.getNumerosity();
            performance[8] = performance[8] + (double)(cl.getExperience() * cl.getNumerosity());
            performance[9] = performance[9] + cl.getSetSizeEstimate() * (double)cl.getNumerosity();
            performance[10] = performance[10] + (double)(cl.getTimestamp() * cl.getNumerosity());
        }
        performance[2] = popNumerositySum;
        performance[5] = performance[5] / (double)popNumerositySum;
        performance[6] = performance[6] / (double)popNumerositySum;
        performance[7] = performance[7] / (double)popNumerositySum;
        performance[8] = performance[8] / (double)popNumerositySum;
        performance[9] = performance[9] / (double)popNumerositySum;
        performance[10] = performance[10] / (double)popNumerositySum;
        for (int dim3 = 0; dim3 < outputDim; ++dim3) {
            performance[11 + dim3] = avgPredError[dim3];
        }
        return performance;
    }

    private static String getHeader(boolean deviation) {
        String header = "#" + HEADER[0];
        for (int i = 1; i < HEADER.length; ++i) {
            header = header + "\t" + HEADER[i];
            if (!deviation) continue;
            header = header + "[mean]\t[deviation]";
        }
        return header;
    }

    private static String performanceToString(int iteration, double[] performance) {
        return String.format(SYSO_FORMAT, iteration, performance[0], (int)performance[1], (int)performance[2], (int)performance[3], (int)performance[4], performance[6], performance[7]);
    }

    private static String meanAndVarianceToString(int iteration, double[] mean, double[] variance) {
        String str = iteration + "";
        for (int i = 0; i < mean.length; ++i) {
            str = str + "\t" + mean[i] + "\t" + variance[i];
        }
        return str;
    }
}

