/*
 * Decompiled with CFR 0.152.
 */
package xcsf;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import xcsf.ClassifierSet;
import xcsf.Population;
import xcsf.StateDescriptor;
import xcsf.XCSFConstants;
import xcsf.XCSFUtils;
import xcsf.classifier.Classifier;

public class MatchSet
extends ClassifierSet {
    private int adaptationAccuracy;
    private boolean numClosestMatching;
    protected StateDescriptor state;
    protected Classifier[] popElements;
    protected int popSize;
    private int threadingThreshold;
    private boolean adaptiveThreading = true;
    private long serialMatchingTime = 0L;
    private long parallelMatchingTime = 0L;
    private int lastCheckSize = 0;
    private WorkerThread[] workers;
    protected int frequency;
    protected CyclicBarrier barrierStart;
    protected CyclicBarrier barrierEnd;

    public MatchSet(boolean doNumClosestMatch, boolean multithreaded) {
        this.numClosestMatching = doNumClosestMatch;
        int n = Runtime.getRuntime().availableProcessors();
        if (multithreaded && n > 1) {
            this.initWorkers(n);
            this.adaptationAccuracy = Math.max(1, XCSFConstants.maxPopSize / 25);
            if (XCSFConstants.threadingThreshold < 0) {
                this.adaptiveThreading = true;
                this.threadingThreshold = this.adaptationAccuracy;
            } else {
                this.threadingThreshold = XCSFConstants.threadingThreshold;
                this.adaptiveThreading = false;
            }
        } else {
            this.threadingThreshold = Integer.MAX_VALUE;
            this.adaptiveThreading = false;
        }
    }

    public MatchSet(boolean doNumClosestMatch) {
        this(doNumClosestMatch, false);
    }

    private void initWorkers(int n) {
        this.barrierStart = new CyclicBarrier(n);
        this.barrierEnd = new CyclicBarrier(n);
        this.frequency = n;
        this.workers = new WorkerThread[n - 1];
        for (int i = 1; i < n; ++i) {
            this.workers[i - 1] = new WorkerThread(i);
            this.workers[i - 1].start();
        }
    }

    public void setNumClosestMatching(boolean numClosestMatching) {
        this.numClosestMatching = numClosestMatching;
    }

    public void match(StateDescriptor currentState, Population population) {
        super.clear();
        this.state = currentState;
        this.popSize = population.size;
        this.popElements = population.elements;
        if (this.numClosestMatching) {
            this.serialClostestClassifierMatching();
        } else if (this.adaptiveThreading && this.popSize - this.lastCheckSize >= this.adaptationAccuracy) {
            if (this.serialMatchingTime == 0L) {
                this.serialMatchingTime = -System.nanoTime();
                this.serialMatching();
                this.serialMatchingTime += System.nanoTime();
            } else {
                this.parallelMatchingTime = -System.nanoTime();
                this.parallelMatching();
                this.parallelMatchingTime += System.nanoTime();
                if (this.serialMatchingTime < this.parallelMatchingTime) {
                    this.threadingThreshold = this.popSize + this.adaptationAccuracy;
                    this.lastCheckSize = this.popSize;
                    this.parallelMatchingTime = 0L;
                    this.serialMatchingTime = 0L;
                } else {
                    if (XCSFConstants.numberOfExperiments == 1) {
                        XCSFUtils.println("! parallel matching, if number of macro classifiers > " + this.threadingThreshold);
                    }
                    this.adaptiveThreading = false;
                }
            }
        } else if (this.popSize < this.threadingThreshold) {
            this.serialMatching();
        } else {
            this.parallelMatching();
        }
    }

    public double[] getWeightedPrediction() {
        int j;
        double clFitness;
        int i = 0;
        double[] clPrediction = this.elements[i].predict(this.state);
        int n = clPrediction.length;
        double fitnessSum = clFitness = this.elements[i].getFitness();
        double[] avgPrediction = new double[n];
        for (j = 0; j < n; ++j) {
            avgPrediction[j] = clPrediction[j] * clFitness;
        }
        for (i = 1; i < this.size; ++i) {
            clPrediction = this.elements[i].predict(this.state);
            clFitness = this.elements[i].getFitness();
            fitnessSum += clFitness;
            for (j = 0; j < n; ++j) {
                int n2 = j;
                avgPrediction[n2] = avgPrediction[n2] + clPrediction[j] * clFitness;
            }
        }
        i = 0;
        while (i < n) {
            int n3 = i++;
            avgPrediction[n3] = avgPrediction[n3] / fitnessSum;
        }
        return avgPrediction;
    }

    void ensureStateCoverage(Population population, int iteration) {
        if (this.size == 0) {
            Classifier newCl = new Classifier(this.state, iteration);
            this.add(newCl);
            int numerositySum = 0;
            for (int i = 0; i < population.size; ++i) {
                numerositySum += population.elements[i].getNumerosity();
            }
            int toDelete = numerositySum + 1 - XCSFConstants.maxPopSize;
            if (toDelete > 0) {
                population.deleteWorstClassifiers(toDelete);
                if (XCSFConstants.numberOfExperiments == 1) {
                    XCSFUtils.println("Covering, although population is full @ " + iteration + ": " + this.state);
                }
            }
            population.add(newCl);
        }
    }

    void updateClassifiers() {
        int i;
        double accuracySum = 0.0;
        int numerositySum = 0;
        for (i = 0; i < this.size; ++i) {
            Classifier cl = this.elements[i];
            cl.update1(this.state);
            accuracySum += cl.getAccuracy() * (double)cl.getNumerosity();
            numerositySum += cl.getNumerosity();
        }
        for (i = 0; i < this.size; ++i) {
            this.elements[i].update2(accuracySum, numerositySum);
        }
    }

    private void serialMatching() {
        for (int i = 0; i < this.popSize; ++i) {
            Classifier cl = this.popElements[i];
            if (!cl.doesMatch(this.state)) continue;
            this.add(cl);
        }
    }

    private void serialClostestClassifierMatching() {
        Object[] clSetHelp = new Classifier[this.popSize];
        int[] nums = new int[this.popSize];
        double[] votes = new double[this.popSize];
        for (int i = 0; i < this.popSize; ++i) {
            clSetHelp[i] = this.popElements[i];
            votes[i] = ((Classifier)clSetHelp[i]).getActivity(this.state);
            nums[i] = ((Classifier)clSetHelp[i]).getNumerosity();
        }
        int firstNum = XCSFUtils.putNumFirstObjectsFirst(votes, nums, clSetHelp, this.popSize, XCSFConstants.numClosestMatch);
        for (int i = 0; i < firstNum; ++i) {
            this.add((Classifier)clSetHelp[i]);
        }
    }

    private void parallelMatching() {
        try {
            this.barrierStart.await();
            for (int i = 0; i < this.popSize; i += this.frequency) {
                if (!this.popElements[i].doesMatch(this.state)) continue;
                this.add(this.popElements[i]);
            }
            this.barrierEnd.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (BrokenBarrierException e) {
            e.printStackTrace();
        }
    }

    void shutDownThreads() throws InterruptedException {
        for (WorkerThread w : this.workers) {
            w.interrupt();
            w.join();
            w = null;
        }
        this.workers = null;
        this.barrierStart = null;
        this.barrierEnd = null;
        this.threadingThreshold = Integer.MAX_VALUE;
        this.adaptiveThreading = false;
    }

    class WorkerThread
    extends Thread {
        private int offset;

        public WorkerThread(int offset) {
            super("MatchingWorker-" + offset);
            this.offset = offset;
            this.setDaemon(true);
        }

        public void run() {
            try {
                while (true) {
                    MatchSet.this.barrierStart.await();
                    for (int i = this.offset; i < MatchSet.this.popSize; i += MatchSet.this.frequency) {
                        if (!MatchSet.this.popElements[i].doesMatch(MatchSet.this.state)) continue;
                        MatchSet.this.add(MatchSet.this.popElements[i]);
                    }
                    MatchSet.this.barrierEnd.await();
                }
            }
            catch (InterruptedException e) {
                return;
            }
            catch (BrokenBarrierException e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

