/*
 * Decompiled with CFR 0.152.
 */
package xcsf;

import java.util.concurrent.LinkedBlockingQueue;
import xcsf.StateDescriptor;
import xcsf.XCSFUtils;

public interface Function {
    public StateDescriptor nextProblemInstance();

    public double[] getNoiselessFunctionValue();

    public int getConditionInputDimension();

    public int getPredictionInputDimension();

    public int getOutputDimension();

    public static abstract class BlockingFunction
    implements Function {
        private LinkedBlockingQueue<StateDescriptor> states = new LinkedBlockingQueue();

        public synchronized void addProblemInstance(StateDescriptor state) {
            try {
                this.states.put(state);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.notify();
        }

        public synchronized StateDescriptor nextProblemInstance() {
            while (this.states.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            return this.states.poll();
        }

        public abstract double[] getNoiselessFunctionValue();

        public abstract int getConditionInputDimension();

        public abstract int getOutputDimension();

        public abstract int getPredictionInputDimension();
    }

    public static abstract class SimpleFunction
    implements Function {
        protected double[] input;
        protected double modifier;
        protected int dim;
        private double scale;
        private double noiseDeviation;
        private double noiseless;

        public SimpleFunction(double scale, double modifier, double noiseDeviation, int dim) {
            this.scale = scale;
            this.noiseDeviation = noiseDeviation;
            this.modifier = modifier;
            this.dim = dim;
            this.input = new double[dim];
        }

        public StateDescriptor nextProblemInstance() {
            this.generateInput();
            this.noiseless = this.scale * this.evaluate();
            double[] output = new double[]{this.noiseless};
            if (this.noiseDeviation != 0.0) {
                output[0] = output[0] + this.noiseDeviation * XCSFUtils.Random.normRand();
            }
            return new StateDescriptor((double[])this.input.clone(), output);
        }

        public double[] getNoiselessFunctionValue() {
            return new double[]{this.noiseless};
        }

        public int getConditionInputDimension() {
            return this.dim;
        }

        public int getPredictionInputDimension() {
            return this.dim;
        }

        public int getOutputDimension() {
            return 1;
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        protected void generateInput() {
            for (int i = 0; i < this.dim; ++i) {
                this.input[i] = XCSFUtils.Random.uniRand();
            }
        }

        protected abstract double evaluate();
    }
}

