/*
 * Decompiled with CFR 0.152.
 */
package xcsf;

import java.util.ArrayList;
import xcsf.MatchSet;
import xcsf.Population;
import xcsf.StateDescriptor;
import xcsf.XCSFConstants;
import xcsf.XCSFUtils;
import xcsf.classifier.Classifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EvolutionaryComp {
    private static final int SELECTION_SIZE = 2;
    private boolean condensation = false;

    EvolutionaryComp() {
    }

    void evolve(Population population, MatchSet matchSet, StateDescriptor state, int iteration) {
        int i;
        double avgTimestampSum = 0.0;
        double fitnessSum = 0.0;
        int numerositySum = 0;
        for (i = 0; i < matchSet.size; ++i) {
            Classifier cl = matchSet.elements[i];
            fitnessSum += cl.getFitness();
            avgTimestampSum += (double)(cl.getTimestamp() * cl.getNumerosity());
            numerositySum += cl.getNumerosity();
        }
        if ((double)iteration - (avgTimestampSum /= (double)numerositySum) < (double)XCSFConstants.theta_GA) {
            return;
        }
        for (i = 0; i < matchSet.size; ++i) {
            matchSet.elements[i].setTimestamp(iteration);
        }
        ArrayList<Classifier> parents = this.selection(matchSet, fitnessSum);
        ArrayList<Classifier> offspring = new ArrayList<Classifier>(parents.size());
        for (Classifier cl : parents) {
            offspring.add(cl.reproduce());
        }
        if (!this.condensation) {
            int index = offspring.size() - 1;
            while (index > 0) {
                Classifier cl1 = offspring.get(index--);
                Classifier cl2 = offspring.get(index--);
                cl1.crossover(cl2);
                cl1.mutation();
                cl2.mutation();
            }
            if (index == 0) {
                offspring.get(0).mutation();
            }
        }
        this.insertion(offspring, parents, matchSet, population, state);
    }

    void setCondensation(boolean value) {
        this.condensation = value;
    }

    ArrayList<Classifier> selection(MatchSet matchset, double fitnessSum) {
        ArrayList<Classifier> selection = new ArrayList<Classifier>(2);
        if (XCSFConstants.selectionType == 0.0) {
            for (int i = 0; i < 2; ++i) {
                Classifier cl = EvolutionaryComp.selectClassifierRW(matchset, fitnessSum);
                selection.add(cl);
            }
        } else {
            for (int i = 0; i < 2; ++i) {
                Classifier cl = EvolutionaryComp.selectClassifierTS(matchset);
                selection.add(cl);
            }
        }
        return selection;
    }

    void insertion(ArrayList<Classifier> offspring, ArrayList<Classifier> parents, MatchSet matchSet, Population population, StateDescriptor state) {
        int numerositySum = 0;
        for (int i = 0; i < population.size; ++i) {
            numerositySum += population.elements[i].getNumerosity();
        }
        int toDelete = numerositySum + offspring.size() - XCSFConstants.maxPopSize;
        if (toDelete > 0) {
            population.deleteWorstClassifiers(toDelete);
        }
        if (XCSFConstants.doGASubsumption) {
            for (int i = 0; i < offspring.size(); ++i) {
                Classifier cl = offspring.get(i);
                if (cl.doesMatch(state)) {
                    EvolutionaryComp.subsumeClassifier(cl, parents, population, matchSet);
                    continue;
                }
                EvolutionaryComp.insertClassifier(cl, population, matchSet, false);
            }
        } else {
            for (Classifier cl : offspring) {
                EvolutionaryComp.insertClassifier(cl, population, matchSet, cl.doesMatch(state));
            }
        }
    }

    private static void subsumeClassifier(Classifier offspring, ArrayList<Classifier> parents, Population population, MatchSet matchSet) {
        for (Classifier clP : parents) {
            if (!clP.canSubsume() || !clP.isMoreGeneral(offspring)) continue;
            clP.addNumerosity(1);
            return;
        }
        ArrayList<Classifier> choices = new ArrayList<Classifier>();
        for (int i = 0; i < matchSet.size; ++i) {
            Classifier cl = matchSet.elements[i];
            if (!cl.canSubsume() || !cl.isMoreGeneral(offspring)) continue;
            choices.add(cl);
        }
        if (choices.size() > 0) {
            int index = (int)(XCSFUtils.Random.uniRand() * (double)choices.size());
            ((Classifier)choices.get(index)).addNumerosity(1);
            return;
        }
        EvolutionaryComp.insertClassifier(offspring, population, matchSet, true);
    }

    private static void insertClassifier(Classifier cl, Population population, MatchSet matchSet, boolean doesMatch) {
        if (doesMatch) {
            Classifier identical = matchSet.findIdenticalCondition(cl.getCondition());
            if (identical != null) {
                identical.addNumerosity(1);
                return;
            }
        } else {
            Classifier identical = population.findIdenticalCondition(cl.getCondition());
            if (identical != null) {
                identical.addNumerosity(1);
                return;
            }
        }
        population.add(cl);
    }

    private static Classifier selectClassifierRW(MatchSet matchSet, double fitSum) {
        double choiceP = XCSFUtils.Random.uniRand() * fitSum;
        int i = 0;
        Classifier cl = matchSet.elements[i];
        for (double sum = cl.getFitness(); choiceP > sum; sum += cl.getFitness()) {
            cl = matchSet.elements[++i];
        }
        return cl;
    }

    private static Classifier selectClassifierTS(MatchSet matchSet) {
        Classifier selected = null;
        double bestFitness = 0.0;
        while (selected == null) {
            block1: for (int i = 0; i < matchSet.size; ++i) {
                Classifier cl = matchSet.elements[i];
                double microFitness = cl.getFitness() / (double)cl.getNumerosity();
                for (int j = 0; j < cl.getNumerosity(); ++j) {
                    if (!(XCSFUtils.Random.uniRand() < XCSFConstants.selectionType) || selected != null && !(microFitness > bestFitness)) continue;
                    selected = cl;
                    bestFitness = microFitness;
                    continue block1;
                }
            }
        }
        return selected;
    }
}

