/*
 * Decompiled with CFR 0.152.
 */
package xcsf;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import xcsf.XCSFConstants;
import xcsf.classifier.Classifier;
import xcsf.classifier.Condition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ClassifierSet
implements Iterable<Classifier> {
    int size = 0;
    Classifier[] elements = new Classifier[XCSFConstants.maxPopSize];

    ClassifierSet() {
    }

    @Override
    public Iterator<Classifier> iterator() {
        return new Itr();
    }

    public Classifier get(int index) {
        this.rangeCheck(index);
        return this.elements[index];
    }

    public int size() {
        return this.size;
    }

    Classifier findIdenticalCondition(Condition condition) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.elements[i].getCondition().equals(condition)) continue;
            return this.elements[i];
        }
        return null;
    }

    void sort(Comparator<Classifier> comparator) {
        Arrays.sort(this.elements, 0, this.size, comparator);
    }

    void clear() {
        this.size = 0;
    }

    synchronized void add(Classifier classifier) {
        this.elements[this.size++] = classifier;
    }

    void remove(int index) {
        this.rangeCheck(index);
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elements, index + 1, this.elements, index, numMoved);
        }
        --this.size;
    }

    void remove(int[] indices) {
        int numMoved;
        int i;
        Arrays.sort(indices);
        this.rangeCheck(indices[indices.length - 1]);
        for (i = 0; i < indices.length - 1; ++i) {
            numMoved = indices[i + 1] - indices[i] - 1;
            System.arraycopy(this.elements, indices[i] + 1, this.elements, indices[i] - i, numMoved);
        }
        numMoved = this.size - indices[i] - 1;
        System.arraycopy(this.elements, indices[i] + 1, this.elements, indices[i] - i, numMoved);
        this.size -= indices.length;
    }

    private void rangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Itr
    implements Iterator<Classifier> {
        private int cursor = 0;
        private boolean preventRemoval = true;

        Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ClassifierSet.this.size();
        }

        @Override
        public Classifier next() {
            this.preventRemoval = false;
            return ClassifierSet.this.elements[this.cursor++];
        }

        @Override
        public void remove() {
            if (this.preventRemoval) {
                return;
            }
            --this.cursor;
            this.preventRemoval = true;
            ClassifierSet.this.remove(this.cursor);
        }
    }
}

