/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.similarity.cache;

import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.gui.DataObjectLabelProvider;
import de.uni_trier.wi2.procake.gui.similarity.cache.MonitorFrame;
import de.uni_trier.wi2.procake.similarity.impl.SimCacheListener;
import de.uni_trier.wi2.procake.similarity.impl.SimilarityCacheKey;
import de.uni_trier.wi2.procake.similarity.impl.SimilarityCacheValue;
import de.uni_trier.wi2.procake.similarity.wf.AbstractSimilarityCache;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimilarityCacheMonitor
extends DataObjectLabelProvider
implements SimCacheListener {
    private static final Logger logger = LoggerFactory.getLogger(SimilarityCacheMonitor.class);
    public MonitorFrame monitor;
    private static final Object windowCloseLock = new Object();

    public SimilarityCacheMonitor(AbstractSimilarityCache similarityCache) {
        if (similarityCache == null) {
            throw new IllegalArgumentException("SimilarityCache must not be null");
        }
        this.monitor = new MonitorFrame(similarityCache);
        similarityCache.addListener((SimCacheListener)this);
        this.monitor.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosing(WindowEvent e) {
                Object object = windowCloseLock;
                synchronized (object) {
                    JFrame frame = (JFrame)e.getComponent();
                    frame.setDefaultCloseOperation(2);
                    SimilarityCacheMonitor.this.monitor.setVisible(false);
                    SimilarityCacheMonitor.this.monitor.dispose();
                    windowCloseLock.notify();
                }
            }
        });
    }

    public void update(SimilarityCacheKey key, SimilarityCacheValue value, SimCacheListener.NotificationType notificationType) {
        switch (notificationType) {
            case ADD: {
                this.monitor.insertRow(key, value);
                break;
            }
            case UPDATE: 
            case READ: {
                this.monitor.updateRow(key, value, notificationType);
                break;
            }
            case CLEAR: {
                this.monitor.clearTable();
                break;
            }
            case REMOVE: {
                this.monitor.removeRow(key);
            }
        }
    }

    @Override
    public String getLabel(Object object) {
        if (object instanceof DataObject) {
            return ((DataObject)object).getDataClass().getName() + ": " + super.getLabel(object);
        }
        return super.getLabel(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilWindowClosed() {
        try {
            while (!this.monitor.isVisible()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            logger.error("Exception: ", (Throwable)e);
        }
        Object object = windowCloseLock;
        synchronized (object) {
            while (this.monitor.isVisible()) {
                try {
                    windowCloseLock.wait();
                }
                catch (InterruptedException e) {
                    logger.error("Exception: ", (Throwable)e);
                }
            }
        }
    }
}

