/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.similarity.cache;

import de.uni_trier.wi2.procake.similarity.Similarity;
import de.uni_trier.wi2.procake.similarity.SimilarityCache;
import de.uni_trier.wi2.procake.similarity.impl.SimCacheListener;
import de.uni_trier.wi2.procake.similarity.impl.SimilarityCacheKey;
import de.uni_trier.wi2.procake.similarity.impl.SimilarityCacheValue;
import de.uni_trier.wi2.procake.similarity.wf.AbstractSimilarityCache;
import de.uni_trier.wi2.procake.utils.Formatter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.collections4.map.ListOrderedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorFrame
extends JFrame {
    private final SimilarityCache similarityCache;
    private static final Logger logger = LoggerFactory.getLogger(MonitorFrame.class);
    private final JTable monitorTable;
    private final JLabel showSizeLabel;
    private final JLabel showLastTimeReadSimilarityValueLabel;
    public final ListOrderedMap<SimilarityCacheKey, Integer> indexMap;
    private final DefaultTableModel model;
    private final DateFormat df = new SimpleDateFormat("HH:mm:ss:SSS yyyy-MM-dd");

    public MonitorFrame(AbstractSimilarityCache similarityCache) throws HeadlessException {
        this.similarityCache = similarityCache;
        this.indexMap = new ListOrderedMap();
        this.model = new DefaultTableModel(0, 0){
            final Class<?>[] columnClass;
            {
                this.columnClass = new Class[]{Integer.class, String.class, String.class, Similarity.class, Long.class, String.class, Integer.class, String.class};
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.columnClass[columnIndex];
            }
        };
        List<String> columnHeaderNames = List.of("index", "query", "case", "similarity", "comp. time", "added", "hits", "last time read");
        for (String s2 : columnHeaderNames) {
            this.model.addColumn(s2);
        }
        this.monitorTable = new JTable(this.model);
        columnHeaderNames.forEach(s -> this.monitorTable.getColumn(s).setPreferredWidth(110));
        this.monitorTable.getColumnModel().getColumn(4).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component result = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value instanceof Long) {
                    this.setText(Formatter.nsToDetailedString((long)((Long)value)));
                }
                return result;
            }
        });
        this.monitorTable.setAutoCreateRowSorter(true);
        this.setTitle("SimilarityCacheMonitor");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/images/ProCAKE_Icon.png")));
        JScrollPane monitorScrollPane = new JScrollPane(this.monitorTable);
        monitorScrollPane.setVerticalScrollBarPolicy(22);
        monitorScrollPane.setHorizontalScrollBarPolicy(31);
        monitorScrollPane.setViewportView(this.monitorTable);
        this.getContentPane().add((Component)monitorScrollPane, "Center");
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new FlowLayout(2));
        this.showSizeLabel = new JLabel("0");
        infoPanel.add(new JLabel("Size: "));
        infoPanel.add(this.showSizeLabel);
        this.showLastTimeReadSimilarityValueLabel = new JLabel("-");
        infoPanel.add(new JLabel("Last time read similarity:"));
        infoPanel.add(this.showLastTimeReadSimilarityValueLabel);
        this.getContentPane().add((Component)infoPanel, "South");
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(770, 48));
        this.setLocationRelativeTo(null);
        this.pack();
        this.setVisible(true);
        this.monitorTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                Point clickedPoint = e.getPoint();
                int column = MonitorFrame.this.monitorTable.columnAtPoint(clickedPoint);
                if (column != 3) {
                    return;
                }
                int row = MonitorFrame.this.monitorTable.rowAtPoint(clickedPoint);
                JFrame dialog = new JFrame();
                dialog.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/images/ProCAKE_Icon.png")));
                dialog.setTitle("Similarity");
                dialog.setLocationRelativeTo(null);
                dialog.setDefaultCloseOperation(2);
                dialog.getContentPane().add(new JScrollPane(new JTextArea(((Similarity)MonitorFrame.this.monitorTable.getValueAt(row, column)).toDetailedString())));
                dialog.setMinimumSize(new Dimension(600, 600));
                dialog.pack();
                dialog.setVisible(true);
            }
        });
        this.tableInit(similarityCache);
    }

    private void updateVisualSize() {
        this.showSizeLabel.setText(this.model.getRowCount() + "  ");
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tableInit(AbstractSimilarityCache similarityCache) {
        MonitorFrame monitorFrame = this;
        synchronized (monitorFrame) {
            SwingUtilities.invokeLater(() -> {
                Collection keys = similarityCache.getKeys();
                for (SimilarityCacheKey key : keys) {
                    SimilarityCacheValue value = similarityCache.get(key);
                    this.model.insertRow(0, this.buildRow(key, value));
                    this.indexMap.put((Object)key, (Object)-1);
                    for (int i = this.indexMap.size() - 1; i >= 0; --i) {
                        this.indexMap.setValue(i, (Object)(this.indexMap.size() - i - 1));
                        this.model.setValueAt(i, i, 0);
                    }
                }
                this.updateVisualSize();
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertRow(SimilarityCacheKey key, SimilarityCacheValue value) {
        MonitorFrame monitorFrame = this;
        synchronized (monitorFrame) {
            SwingUtilities.invokeLater(() -> {
                this.model.insertRow(0, this.buildRow(key, value));
                this.indexMap.put((Object)key, (Object)-1);
                for (int i = this.indexMap.size() - 1; i >= 0; --i) {
                    this.indexMap.setValue(i, (Object)(this.indexMap.size() - i - 1));
                    this.model.setValueAt(i, i, 0);
                }
                this.updateVisualSize();
            });
        }
    }

    private Vector<Object> buildRow(SimilarityCacheKey key, SimilarityCacheValue value) {
        Vector<Object> row = new Vector<Object>(8);
        row.add(0);
        row.add(key.getQueryId());
        row.add(key.getCaseId());
        row.add(value.getSimilarity());
        row.add(value.getSimilarity() != null ? Long.valueOf(value.getSimilarity().getComputationTimeNanos()) : null);
        row.add(value.getAdded() != null ? this.df.format(value.getAdded()) : "");
        row.add(value.getHits());
        row.add(value.getLastTimeRead() != null ? this.df.format(value.getLastTimeRead()) : "");
        return row;
    }

    private int locateRow(SimilarityCacheKey key) {
        return this.indexMap.get((Object)key) != null ? (Integer)this.indexMap.get((Object)key) : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRow(SimilarityCacheKey key) {
        MonitorFrame monitorFrame = this;
        synchronized (monitorFrame) {
            SwingUtilities.invokeLater(() -> {
                if (!this.indexMap.containsKey((Object)key)) {
                    logger.warn("key not found in indexMap");
                    return;
                }
                int targetRowIndex = (Integer)this.indexMap.remove((Object)key);
                this.model.removeRow(targetRowIndex);
                for (int i = this.indexMap.size() - 1; i >= 0; --i) {
                    this.indexMap.setValue(i, (Object)(this.indexMap.size() - i - 1));
                    this.model.setValueAt(i, i, 0);
                }
                this.updateVisualSize();
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRow(SimilarityCacheKey key, SimilarityCacheValue value, SimCacheListener.NotificationType notificationType) {
        MonitorFrame monitorFrame = this;
        synchronized (monitorFrame) {
            SwingUtilities.invokeLater(() -> {
                if (notificationType == SimCacheListener.NotificationType.READ) {
                    this.showLastTimeReadSimilarityValueLabel.setText(Formatter.nsToDetailedString((long)this.similarityCache.getLastTimeNanosForGetSimilarity()));
                }
                logger.trace("UpdateRow(" + notificationType.toString() + ") @ " + this.locateRow(key) + " \n");
                if (!this.indexMap.containsKey((Object)key)) {
                    logger.warn("No key found in indexMap ");
                    return;
                }
                Integer rowLocation = (Integer)this.indexMap.remove((Object)key);
                if (rowLocation != null) {
                    this.model.removeRow(rowLocation);
                    for (int i = this.indexMap.size() - 1; i >= 0; --i) {
                        this.indexMap.setValue(i, (Object)(this.indexMap.size() - i));
                        this.model.setValueAt(i + 1, i, 0);
                    }
                    this.model.insertRow(0, this.buildRow(key, value));
                    this.indexMap.put(this.indexMap.size(), (Object)key, (Object)0);
                    this.updateVisualSize();
                } else {
                    logger.warn("Called updateRow(): Key not found in indexMap.\n locateRow(key)= " + this.locateRow(key) + "\n indexMap.get(key)= " + this.indexMap.get((Object)key));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTable() {
        MonitorFrame monitorFrame = this;
        synchronized (monitorFrame) {
            SwingUtilities.invokeLater(() -> {
                if (this.model.getRowCount() > 0) {
                    for (int i = this.model.getRowCount() - 1; i >= 0; --i) {
                        this.model.removeRow(i);
                        this.updateVisualSize();
                    }
                    this.indexMap.clear();
                    this.updateVisualSize();
                    logger.trace("Table cleared");
                }
            });
        }
    }

    public DefaultTableModel getModel() {
        return this.model;
    }

    public String getSizeLabelValue() {
        return this.showSizeLabel.getText();
    }

    public String getLastTimeReadSimilarityValueLabel() {
        return this.showLastTimeReadSimilarityValueLabel.getText();
    }
}

