/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.utils;

import de.uni_trier.wi2.procake.data.model.DataClass;
import de.uni_trier.wi2.procake.data.model.ModelFactory;
import de.uni_trier.wi2.procake.data.model.nest.NESTWorkflowClass;
import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.data.object.base.AggregateObject;
import de.uni_trier.wi2.procake.data.object.base.AtomicObject;
import de.uni_trier.wi2.procake.data.object.base.CollectionObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTEdgeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTGraphItemObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTWorkflowObject;
import de.uni_trier.wi2.procake.data.object.nest.controlflowNode.NESTControlflowNodeObject;
import de.uni_trier.wi2.procake.data.objectpool.ReadableObjectPool;
import java.awt.Font;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.UIManager;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class Utils {
    public static String aggregateToPaddedTable(AggregateObject aggregateObject, boolean includeNullAttributes) {
        return Utils.aggregateToPaddedTable(aggregateObject, includeNullAttributes, 0);
    }

    public static String aggregateToPaddedTable(AggregateObject aggregateObject, boolean includeNullAttributes, int offset) {
        List attributeNames = aggregateObject.getAggregateClass().getAttributeNames().stream().filter(attributeName -> includeNullAttributes || aggregateObject.getAttributeValue(attributeName) != null).collect(Collectors.toList());
        int maxAttributeNameLength = attributeNames.stream().max(Comparator.comparing(String::length)).orElse("").length();
        int paddingLength = maxAttributeNameLength + offset;
        List lines = IntStream.range(0, attributeNames.size()).mapToObj(i -> {
            String attributeName = (String)attributeNames.get(i);
            DataObject attributeValue = aggregateObject.getAttributeValue(attributeName);
            String line = StringUtils.leftPad((String)attributeName, (int)(i == 0 ? maxAttributeNameLength : paddingLength)) + ": ";
            line = attributeValue == null ? line + "null" : (attributeValue.isAggregate() ? line + Utils.aggregateToPaddedTable((AggregateObject)attributeValue, includeNullAttributes, paddingLength + 2) : (attributeValue.isAtomic() ? line + ((AtomicObject)attributeValue).getNativeObject().toString() : line + Objects.toString(attributeValue)));
            return line;
        }).collect(Collectors.toList());
        return lines.stream().collect(Collectors.joining("\n"));
    }

    public static String getEdgeClassForNodeConnection(NESTNodeObject startNode, NESTNodeObject endNode) {
        List<ImmutablePair> rules = Arrays.asList(new ImmutablePair((a, b) -> a.isNESTSubWorkflowNode() && b.isNESTWorkflowNode(), (Object)"NESTPartOfEdge"), new ImmutablePair((a, b) -> a.isNESTSubWorkflowNode() && b.isNESTSubWorkflowNode(), (Object)"NESTPartOfEdge"), new ImmutablePair((a, b) -> a.isNESTTaskNode() && b.isNESTWorkflowNode(), (Object)"NESTPartOfEdge"), new ImmutablePair((a, b) -> a.isNESTTaskNode() && b.isNESTSubWorkflowNode(), (Object)"NESTPartOfEdge"), new ImmutablePair((a, b) -> a.isNESTTaskNode() && b.isNESTTaskNode(), (Object)"NESTControlflowEdge"), new ImmutablePair((a, b) -> a.isNESTTaskNode() && b.isNESTControlflowNode(), (Object)"NESTControlflowEdge"), new ImmutablePair((a, b) -> a.isNESTTaskNode() && b.isNESTDataNode(), (Object)"NESTDataflowEdge"), new ImmutablePair((a, b) -> a.isNESTDataNode() && b.isNESTWorkflowNode(), (Object)"NESTPartOfEdge"), new ImmutablePair((a, b) -> a.isNESTDataNode() && b.isNESTSubWorkflowNode(), (Object)"NESTPartOfEdge"), new ImmutablePair((a, b) -> a.isNESTDataNode() && b.isNESTTaskNode(), (Object)"NESTDataflowEdge"), new ImmutablePair((a, b) -> a.isNESTDataNode() && b.isNESTDataNode(), (Object)"NESTConstraintEdge"), new ImmutablePair((a, b) -> a.isNESTControlflowNode() && b.isNESTWorkflowNode(), (Object)"NESTPartOfEdge"), new ImmutablePair((a, b) -> a.isNESTControlflowNode() && b.isNESTSubWorkflowNode(), (Object)"NESTPartOfEdge"), new ImmutablePair((a, b) -> a.isNESTControlflowNode() && b.isNESTTaskNode(), (Object)"NESTControlflowEdge"), new ImmutablePair((a, b) -> a.isNESTControlflowNode() && b.isNESTControlflowNode(), (Object)"NESTControlflowEdge"));
        Optional<ImmutablePair> result = rules.stream().filter(rule -> ((BiPredicate)rule.getLeft()).test(startNode, endNode)).findAny();
        return result.map(ImmutablePair::getRight).orElse(null);
    }

    public static boolean isEdgeLoopReturnEdge(NESTEdgeObject edge) {
        if (edge.isNESTControlflowEdge() && edge.getPre() != null && edge.getPre().isNESTControlflowNode()) {
            NESTControlflowNodeObject pre = (NESTControlflowNodeObject)edge.getPre();
            return pre.isLoopNode() && pre.isEndControlflowNode() && edge.getPost() == pre.getMatchingBlockControlflowNode();
        }
        return false;
    }

    public static List<DataClass> getSubClassesDeep(DataClass dataClass) {
        LinkedList<DataClass> subClasses = new LinkedList<DataClass>(dataClass.getSubClasses());
        LinkedList subSubClasses = new LinkedList();
        subClasses.forEach(subClass -> subSubClasses.addAll(Utils.getSubClassesDeep(subClass)));
        subClasses.addAll(subSubClasses);
        return subClasses;
    }

    public static List<NESTWorkflowClass> getNESTWorkflowClasses() {
        return ModelFactory.getDefaultModel().getClasses().stream().filter(DataClass::isNESTWorkflow).map(NESTWorkflowClass.class::cast).collect(Collectors.toList());
    }

    public static Set<NESTWorkflowObject> extractNESTWorkflowObjectsFromPool(ReadableObjectPool<? extends DataObject> pool) {
        HashSet<NESTWorkflowObject> result = new HashSet<NESTWorkflowObject>();
        pool.forEach(dataObject -> result.addAll(Utils.extractNESTWorkflowObjectsFromPool(dataObject)));
        return result;
    }

    private static Set<NESTWorkflowObject> extractNESTWorkflowObjectsFromPool(DataObject dataObject) {
        HashSet<NESTWorkflowObject> result = new HashSet<NESTWorkflowObject>();
        if (dataObject == null) {
            return result;
        }
        if (dataObject.isNESTWorkflow()) {
            result.add((NESTWorkflowObject)dataObject);
        } else if (dataObject.isCollection()) {
            ((CollectionObject)dataObject).iterator().forEachRemaining(collectionDataObject -> result.addAll(Utils.extractNESTWorkflowObjectsFromPool((DataObject)collectionDataObject)));
        } else if (dataObject.isAggregate()) {
            ((AggregateObject)dataObject).getAttributeMap().forEach((attributeName, attributeDataObject) -> result.addAll(Utils.extractNESTWorkflowObjectsFromPool(attributeDataObject)));
        }
        return result;
    }

    public static boolean containsChild(DataObject parent, DataObject child) {
        if (parent == child) {
            return true;
        }
        if (parent.isNESTEdge() || parent.isNESTNode()) {
            return Utils.containsChild(((NESTGraphItemObject)parent).getSemanticDescriptor(), child);
        }
        if (parent.isNESTWorkflow()) {
            NESTWorkflowObject nestWorkflow = (NESTWorkflowObject)parent;
            return Stream.concat(nestWorkflow.getGraphNodes().stream(), nestWorkflow.getGraphEdges().stream()).anyMatch(graphElement -> graphElement == child || Utils.containsChild((DataObject)graphElement, child));
        }
        if (parent.isCollection()) {
            boolean[] contains = new boolean[]{false};
            ((CollectionObject)parent).iterator().forEachRemaining(collectionDataObject -> {
                contains[0] = Utils.containsChild((DataObject)collectionDataObject, child) || contains[0];
            });
            return contains[0];
        }
        if (parent.isAggregate()) {
            return ((AggregateObject)parent).getAttributeMap().values().stream().anyMatch(attributeValue -> Utils.containsChild(attributeValue, child));
        }
        return false;
    }

    public static void setDefaultFontSize(float size) {
        Object[] keys;
        Set keySet = UIManager.getLookAndFeelDefaults().keySet();
        for (Object key : keys = keySet.toArray(new Object[keySet.size()])) {
            Font font;
            if (key == null || !key.toString().toLowerCase().contains("font") || (font = UIManager.getDefaults().getFont(key)) == null) continue;
            font = font.deriveFont(size);
            UIManager.put(key, font);
        }
    }
}

