/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldCopier {
    private static final Logger log = LoggerFactory.getLogger(FieldCopier.class);
    private static final FieldCopier instance = new FieldCopier();
    private final Map<Map.Entry<Class<?>, Class<?>>, Map<Field, Field>> PAIRED_FIELDS = new ConcurrentHashMap();
    private final Map<Class<?>, Field[]> FIELDS = new ConcurrentHashMap();

    private FieldCopier() {
    }

    public static FieldCopier instance() {
        return instance;
    }

    public <S, T> T copyFields(S source, T target) {
        Map<Field, Field> pairedFields = this.getPairedFields(source, target);
        for (Field sourceField : pairedFields.keySet()) {
            Field targetField = pairedFields.get(sourceField);
            try {
                Object value = this.getValue(source, sourceField);
                this.setValue(target, targetField, value);
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to copy field value", t);
            }
        }
        return target;
    }

    private <S, T> Map<Field, Field> getPairedFields(S source, T target) {
        Class<?> sourceClass = source.getClass();
        Class<?> targetClass = target.getClass();
        AbstractMap.SimpleImmutableEntry sourceToTarget = new AbstractMap.SimpleImmutableEntry(sourceClass, targetClass);
        this.PAIRED_FIELDS.computeIfAbsent(sourceToTarget, st -> this.mapSourceFieldsToTargetFields(sourceClass, targetClass));
        Map<Field, Field> pairedFields = this.PAIRED_FIELDS.get(sourceToTarget);
        return pairedFields;
    }

    private Map<Field, Field> mapSourceFieldsToTargetFields(Class<?> sourceClass, Class<?> targetClass) {
        HashMap<Field, Field> sourceFieldsToTargetFields = new HashMap<Field, Field>();
        Field[] sourceFields = this.getDeclaredFields(sourceClass);
        Field[] targetFields = this.getDeclaredFields(targetClass);
        for (Field sourceField : sourceFields) {
            if (sourceField.getName().equals("serialVersionUID")) continue;
            Field targetField = this.findCorrespondingField(targetFields, sourceField);
            if (targetField == null) {
                log.warn("No target field found for " + sourceField.getName());
                continue;
            }
            if (Modifier.isFinal(targetField.getModifiers())) {
                log.warn("The target field " + targetField.getName() + " is final, and so cannot be written to");
                continue;
            }
            sourceFieldsToTargetFields.put(sourceField, targetField);
        }
        return Collections.unmodifiableMap(sourceFieldsToTargetFields);
    }

    private Field[] getDeclaredFields(Class<?> clazz) {
        this.FIELDS.computeIfAbsent(clazz, Class::getDeclaredFields);
        return this.FIELDS.get(clazz);
    }

    private <S> Object getValue(S source, Field sourceField) throws IllegalArgumentException, IllegalAccessException {
        sourceField.setAccessible(true);
        return sourceField.get(source);
    }

    private <T> void setValue(T target, Field targetField, Object value) throws IllegalArgumentException, IllegalAccessException {
        targetField.setAccessible(true);
        targetField.set(target, value);
    }

    private Field findCorrespondingField(Field[] targetFields, Field sourceField) {
        for (Field targetField : targetFields) {
            if (!sourceField.getName().equals(targetField.getName())) continue;
            if (sourceField.getType().equals(targetField.getType())) {
                return targetField;
            }
            log.warn("Different types for field " + sourceField.getName() + " source " + sourceField.getType() + " and target " + targetField.getType());
            return null;
        }
        return null;
    }
}

