/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.swing.misc;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoCompletion
extends PlainDocument {
    protected static final Logger logger = LoggerFactory.getLogger(AutoCompletion.class);
    JComboBox comboBox;
    ComboBoxModel model;
    JTextComponent editor;
    boolean selecting = false;
    boolean hidePopupOnFocusLoss;
    boolean hitBackspace = false;
    boolean hitBackspaceOnSelection;
    KeyListener editorKeyListener;
    FocusListener editorFocusListener;

    public AutoCompletion(final JComboBox comboBox) {
        this.comboBox = comboBox;
        this.model = comboBox.getModel();
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!AutoCompletion.this.selecting) {
                    AutoCompletion.this.highlightCompletedText(0);
                }
            }
        });
        comboBox.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("editor")) {
                    AutoCompletion.this.configureEditor((ComboBoxEditor)e.getNewValue());
                }
                if (e.getPropertyName().equals("model")) {
                    AutoCompletion.this.model = (ComboBoxModel)e.getNewValue();
                }
            }
        });
        this.editorKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (comboBox.isDisplayable()) {
                    comboBox.setPopupVisible(true);
                }
                AutoCompletion.this.hitBackspace = false;
                switch (e.getKeyCode()) {
                    case 8: {
                        AutoCompletion.this.hitBackspace = true;
                        AutoCompletion.this.hitBackspaceOnSelection = AutoCompletion.this.editor.getSelectionStart() != AutoCompletion.this.editor.getSelectionEnd();
                        break;
                    }
                    case 127: {
                        e.consume();
                        comboBox.getToolkit().beep();
                        break;
                    }
                    default: {
                        logger.info("Unhandled statement caught in default branch of switch case.");
                        logger.info(String.valueOf(e.getKeyCode()));
                    }
                }
            }
        };
        this.hidePopupOnFocusLoss = System.getProperty("java.version").startsWith("1.5");
        this.editorFocusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AutoCompletion.this.highlightCompletedText(0);
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (AutoCompletion.this.hidePopupOnFocusLoss) {
                    comboBox.setPopupVisible(false);
                }
            }
        };
        this.configureEditor(comboBox.getEditor());
        Object selected = comboBox.getSelectedItem();
        if (selected != null) {
            this.setText(selected.toString());
        }
        this.highlightCompletedText(0);
    }

    public static void enable(JComboBox comboBox) {
        comboBox.setEditable(true);
        new AutoCompletion(comboBox);
    }

    private static void createAndShowGUI() {
        JComboBox<Object> comboBox = new JComboBox<Object>(new Object[]{"Ester", "Jordi", "Jordina", "Jorge", "Sergi"});
        AutoCompletion.enable(comboBox);
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(comboBox);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AutoCompletion.createAndShowGUI();
            }
        });
    }

    void configureEditor(ComboBoxEditor newEditor) {
        if (this.editor != null) {
            this.editor.removeKeyListener(this.editorKeyListener);
            this.editor.removeFocusListener(this.editorFocusListener);
        }
        if (newEditor != null) {
            this.editor = (JTextComponent)newEditor.getEditorComponent();
            this.editor.addKeyListener(this.editorKeyListener);
            this.editor.addFocusListener(this.editorFocusListener);
            this.editor.setDocument(this);
        }
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        if (this.hitBackspace) {
            if (offs > 0) {
                if (this.hitBackspaceOnSelection) {
                    --offs;
                }
            } else {
                this.comboBox.getToolkit().beep();
            }
            this.highlightCompletedText(offs);
        } else {
            super.remove(offs, len);
        }
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        super.insertString(offs, str, a);
        Object item = this.lookupItem(this.getText(0, this.getLength()));
        if (item != null) {
            this.setSelectedItem(item);
        } else {
            item = this.comboBox.getSelectedItem();
            offs -= str.length();
            this.comboBox.getToolkit().beep();
        }
        this.setText(item.toString());
        this.highlightCompletedText(offs + str.length());
    }

    private void setText(String text) {
        try {
            super.remove(0, this.getLength());
            super.insertString(0, text, null);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private void highlightCompletedText(int start) {
        this.editor.setCaretPosition(this.getLength());
        this.editor.moveCaretPosition(start);
    }

    private void setSelectedItem(Object item) {
        this.selecting = true;
        this.model.setSelectedItem(item);
        this.selecting = false;
    }

    private Object lookupItem(String pattern) {
        Object selectedItem = this.model.getSelectedItem();
        if (selectedItem != null && this.startsWithIgnoreCase(selectedItem.toString(), pattern)) {
            return selectedItem;
        }
        int n = this.model.getSize();
        for (int i = 0; i < n; ++i) {
            Object currentItem = this.model.getElementAt(i);
            if (currentItem == null || !this.startsWithIgnoreCase(currentItem.toString(), pattern)) continue;
            return currentItem;
        }
        return null;
    }

    private boolean startsWithIgnoreCase(String str1, String str2) {
        return str1.toUpperCase().startsWith(str2.toUpperCase());
    }
}

