/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.swing.layouts;

import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.swing.layouts.Alignment;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.swing.layouts.ConstraintLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;

public class BasicGridLayout
extends ConstraintLayout {
    protected int hGap;
    protected int vGap;
    protected int rows;
    protected int cols;
    protected int reqRows;
    protected int reqCols;
    protected int[] rowHeights;
    protected int[] colWidths;
    protected int alignment = 8;
    protected int fill = 3;
    protected int colWeight = 0;
    protected int rowWeight = 0;

    public BasicGridLayout() {
        this(0, 1, 2, 2);
    }

    public BasicGridLayout(int rows, int cols) {
        this(rows, cols, 2, 2);
    }

    public BasicGridLayout(int rows, int cols, int hGap, int vGap) {
        this(rows, cols, hGap, vGap, 0, 0);
    }

    public BasicGridLayout(int rows, int cols, int hGap, int vGap, int hMargin, int vMargin) {
        this.reqRows = rows;
        this.reqCols = cols;
        this.hGap = hGap;
        this.vGap = vGap;
        this.hMargin = hMargin;
        this.vMargin = vMargin;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        if (rows < 1) {
            rows = 1;
        }
        this.rows = rows;
    }

    public int getColumns() {
        return this.cols;
    }

    public void setColumns(int cols) {
        if (cols < 1) {
            cols = 1;
        }
        this.cols = cols;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int a) {
        this.alignment = a;
    }

    public int getFill() {
        return this.fill;
    }

    public void setFill(int f) {
        this.fill = f;
    }

    public int getColWeight() {
        return this.colWeight;
    }

    public void setColWeight(int colWeight) {
        this.colWeight = colWeight;
    }

    public int getRowWeight() {
        return this.rowWeight;
    }

    public void setRowWeight(int rowWeight) {
        this.rowWeight = rowWeight;
    }

    protected int alignmentFor(Component c, int row, int col) {
        return this.alignment;
    }

    protected int fillFor(Component c, int row, int col) {
        return this.fill;
    }

    protected int getRowWeight(int row) {
        return this.getRowWeight();
    }

    protected int getColWeight(int col) {
        return this.getColWeight();
    }

    protected int sumArray(int[] array, int spacing, int size) {
        int total = 0;
        for (int i = 0; i < size; ++i) {
            total += array[i];
        }
        if (size > 1) {
            total += (size - 1) * spacing;
        }
        return total;
    }

    protected void calcCellSizes(Container target, int type) {
        int remainder;
        int i;
        int count = target.getComponentCount();
        if (this.reqCols <= 0) {
            this.rows = this.reqRows;
            this.cols = (count + this.reqRows - 1) / this.reqRows;
        } else {
            this.rows = (count + this.reqCols - 1) / this.reqCols;
            this.cols = this.reqCols;
        }
        this.colWidths = new int[this.cols];
        for (i = 0; i < this.cols; ++i) {
            this.colWidths[i] = 0;
        }
        this.rowHeights = new int[this.rows];
        for (i = 0; i < this.rows; ++i) {
            this.rowHeights[i] = 0;
        }
        int index = 0;
        for (i = 0; i < count; ++i) {
            Component c = target.getComponent(i);
            if (!this.includeComponent(c)) continue;
            Dimension size = this.getComponentSize(c, type);
            int row = index / this.cols;
            int col = index % this.cols;
            if (this.colWidths[col] < size.width) {
                this.colWidths[col] = size.width;
            }
            if (this.rowHeights[row] < size.height) {
                this.rowHeights[row] = size.height;
            }
            ++index;
        }
        Dimension size = target.getSize();
        Insets insets = target.getInsets();
        size.width -= insets.left + insets.right + 2 * this.hMargin;
        size.height -= insets.top + insets.bottom + 2 * this.vMargin;
        int totalSize = 0;
        int totalWeight = 0;
        for (i = 0; i < this.cols; ++i) {
            totalWeight += this.getColWeight(i);
            totalSize += this.colWidths[i];
            if (i == 0) continue;
            totalSize += this.hGap;
        }
        if (totalWeight != 0) {
            remainder = size.width - totalSize;
            for (i = 0; i < this.cols; ++i) {
                int n = i;
                this.colWidths[n] = this.colWidths[n] + remainder * this.getColWeight(i) / totalWeight;
            }
        }
        totalSize = 0;
        totalWeight = 0;
        for (i = 0; i < this.rows; ++i) {
            totalWeight += this.getRowWeight(i);
            totalSize += this.rowHeights[i];
            if (i == 0) continue;
            totalSize += this.vGap;
        }
        if (totalWeight != 0) {
            remainder = size.height - totalSize;
            for (i = 0; i < this.rows; ++i) {
                int n = i;
                this.rowHeights[n] = this.rowHeights[n] + remainder * this.getRowWeight(i) / totalWeight;
            }
        }
    }

    @Override
    public void measureLayout(Container target, Dimension dimension, int type) {
        if (dimension != null) {
            this.calcCellSizes(target, type);
            dimension.width = this.sumArray(this.colWidths, this.hGap, this.cols);
            dimension.height = this.sumArray(this.rowHeights, this.vGap, this.rows);
            this.colWidths = null;
            this.rowHeights = null;
        } else {
            int count = target.getComponentCount();
            if (count > 0) {
                Insets insets = target.getInsets();
                Dimension size = target.getSize();
                int index = 0;
                this.calcCellSizes(target, type);
                for (int i = 0; i < count; ++i) {
                    Component c = target.getComponent(i);
                    if (!this.includeComponent(c)) continue;
                    Dimension d = this.getComponentSize(c, type);
                    Rectangle r = new Rectangle(0, 0, d.width, d.height);
                    int row = index / this.cols;
                    int col = index % this.cols;
                    int x = insets.left + this.sumArray(this.colWidths, this.hGap, col) + this.hMargin;
                    int y = insets.top + this.sumArray(this.rowHeights, this.vGap, row) + this.vMargin;
                    if (col > 0) {
                        x += this.hGap;
                    }
                    if (row > 0) {
                        y += this.vGap;
                    }
                    Rectangle cell = new Rectangle(x, y, this.colWidths[col], this.rowHeights[row]);
                    Alignment.alignInCell(r, cell, this.alignmentFor(c, row, col), this.fillFor(c, row, col));
                    c.setBounds(r.x, r.y, r.width, r.height);
                    ++index;
                }
            }
            this.colWidths = null;
            this.rowHeights = null;
        }
    }
}

