/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxGraph;
import de.uni_trier.wi2.procake.data.object.nest.NESTGraphItemObject;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.swing.layouts.BasicGridLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Label;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class EditorSizeEdit
extends JDialog {
    private TextField width;
    private TextField height;

    EditorSizeEdit(mxGraph graph) {
        this.setTitle("Edit Size");
        this.setLayout(new BorderLayout());
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/objecteditor/nestworkfloweditor/images/ProCAKE_Icon.png")));
        this.setAlwaysOnTop(true);
        this.addEditingTextFields(graph);
        this.add((Component)this.createSaveButton(graph), "Last");
        this.pack();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(this.getPreferredSize());
        if (graph.getSelectionCells().length > 1) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((int)(screenSize.getWidth() / 2.0 - (double)this.getWidth() / 2.0), (int)(screenSize.getHeight() / 2.0 - (double)this.getHeight() / 2.0));
        } else {
            Point mouseLocation = MouseInfo.getPointerInfo().getLocation();
            this.setLocation(Math.max(0, (int)(mouseLocation.getX() - (double)(this.getWidth() / 2))), Math.max(0, (int)(mouseLocation.getY() - (double)(this.getHeight() / 2))));
        }
        this.revalidate();
        this.setVisible(true);
    }

    private void addEditingTextFields(mxGraph graph) {
        Object[] cell = graph.getSelectionCells();
        JPanel panel = new JPanel(new BasicGridLayout(2, 2));
        boolean hasDataNode = false;
        for (int i = 0; i < cell.length; ++i) {
            if (((NESTGraphItemObject)((mxCell)graph.getSelectionCells()[i]).getValue()).isNESTControlflowNode()) continue;
            hasDataNode = true;
        }
        this.width = new TextField(String.valueOf((int)((mxCell)cell[cell.length - 1]).getGeometry().getWidth()));
        if (hasDataNode) {
            this.height = new TextField(String.valueOf((int)((mxCell)cell[cell.length - 1]).getGeometry().getHeight()));
            this.height.addTextListener(e -> {
                if (!this.height.getText().matches("[0-9]+")) {
                    this.height.setBackground(Color.PINK);
                } else {
                    this.height.setBackground(Color.WHITE);
                }
            });
        }
        this.width.addTextListener(e -> {
            if (!this.width.getText().matches("[0-9]+")) {
                this.width.setBackground(Color.PINK);
            } else {
                this.width.setBackground(Color.WHITE);
            }
        });
        panel.setAlignmentX(0.5f);
        panel.setAlignmentY(0.5f);
        int borderWidth = 10;
        panel.setBorder(BorderFactory.createEmptyBorder(borderWidth, borderWidth, borderWidth, borderWidth));
        if (hasDataNode) {
            panel.add(new Label("Width"));
            panel.add((Component)this.width, "Center");
            panel.add(new Label("Height"));
            panel.add((Component)this.height, "Center");
        } else {
            panel.add(new Label("Width/Length"));
            panel.add((Component)this.width, "Center");
        }
        this.add((Component)panel, "Center");
    }

    private JButton createSaveButton(mxGraph graph) {
        JButton saveButton = new JButton("Save Changes");
        saveButton.setMargin(new Insets(2, 2, 2, 2));
        saveButton.addActionListener(e -> this.handleSaveButton(graph));
        this.getRootPane().setDefaultButton(saveButton);
        return saveButton;
    }

    private void handleSaveButton(mxGraph graph) {
        try {
            Object[] cells = graph.getSelectionCells();
            mxGeometry[] geometry = new mxGeometry[cells.length];
            for (int i = 0; i < cells.length; ++i) {
                geometry[i] = graph.getModel().getGeometry(cells[i]);
            }
            mxRectangle[] rect = new mxRectangle[geometry.length];
            for (int j = 0; j < geometry.length; ++j) {
                double h;
                rect[j] = new mxRectangle((Rectangle2D)geometry[j].getRectangle());
                double w = Double.parseDouble(this.width.getText());
                double d = h = this.height != null ? Double.parseDouble(this.height.getText()) : 0.0;
                if (((NESTGraphItemObject)((mxCell)graph.getSelectionCells()[j]).getValue()).isNESTControlflowNode()) {
                    double l = Math.max(w, h);
                    rect[j].setWidth(l);
                    rect[j].setHeight(l);
                    continue;
                }
                rect[j].setWidth(w);
                rect[j].setHeight(h);
            }
            for (int k = 0; k < graph.getSelectionCells().length; ++k) {
                graph.resizeCell(graph.getSelectionCells()[k], rect[k]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        this.setVisible(true);
        this.setAlwaysOnTop(true);
    }
}

