/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor;

import com.mxgraph.model.mxICell;
import com.mxgraph.swing.util.mxGraphActions;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxResources;
import com.mxgraph.view.mxGraph;
import de.uni_trier.wi2.procake.data.model.DataClass;
import de.uni_trier.wi2.procake.data.model.ModelFactory;
import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTGraphItemObject;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.LabelMode;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.NESTWorkflowEditor;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor.BasicGraphEditor;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor.EditorActions;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor.EditorMenuBar;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.utils.Utils;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.TransferHandler;

public class EditorPopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = -3132749140550242191L;

    public EditorPopupMenu(BasicGraphEditor editor) {
        mxGraph graph = editor.getGraphComponent().getGraph();
        boolean selected = !graph.isSelectionEmpty();
        boolean oneSelected = graph.getSelectionCount() <= 1;
        this.add(new EditorActions.AddSemanticDescriptorNodeAction(this.getSelectedCells(editor))).setEnabled(selected && this.getSelectedGraphItems(editor).size() > 0);
        this.add(this.createClassSelectionMenu(editor));
        this.add(this.createLabelModeSelectionMenu(editor));
        this.addSeparator();
        this.add(editor.bind(mxResources.get((String)"copy"), TransferHandler.getCopyAction(), "/objecteditor/nestworkfloweditor/images/copy.gif")).setEnabled(selected);
        this.add(editor.bind(mxResources.get((String)"paste"), TransferHandler.getPasteAction(), "/objecteditor/nestworkfloweditor/images/paste.gif"));
        this.addSeparator();
        this.add(editor.bind(mxResources.get((String)"delete"), mxGraphActions.getDeleteAction(), "/objecteditor/nestworkfloweditor/images/delete.gif")).setEnabled(selected);
        this.addSeparator();
        JMenu menu = (JMenu)this.add(new JMenu(mxResources.get((String)"format")));
        EditorMenuBar.populateFormatMenu(menu, editor, selected && this.getSelectedGraphItems(editor).size() > 0 && this.getSelectedGraphItems(editor).stream().allMatch(DataObject::isNESTNode));
        this.addSeparator();
        this.add(editor.bind(mxResources.get((String)"edit"), mxGraphActions.getEditAction())).setEnabled(oneSelected && selected);
        this.addSeparator();
        this.add(this.createGraphItemSelectionMenu(editor, (DataClass)ModelFactory.getDefaultModel().getNESTNodeClass(), mxResources.get((String)"selectVertices")));
        this.add(this.createGraphItemSelectionMenu(editor, (DataClass)ModelFactory.getDefaultModel().getNESTEdgeClass(), mxResources.get((String)"selectEdges")));
        this.addSeparator();
        this.add(editor.bind(mxResources.get((String)"selectAll"), mxGraphActions.getSelectAllAction()));
    }

    private JMenu createLabelModeSelectionMenu(BasicGraphEditor editor) {
        JMenu menu = new JMenu("Label");
        menu.setEnabled(false);
        List<NESTGraphItemObject> selectedGraphItems = this.getSelectedGraphItems(editor);
        if (selectedGraphItems.size() > 0) {
            for (LabelMode mode : LabelMode.values()) {
                JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(mode.name());
                menuItem.addActionListener(e -> {
                    selectedGraphItems.forEach(graphItemObject -> ((NESTWorkflowEditor.CustomGraph)editor.getGraphComponent().getGraph()).getCellLabelGenerator().setLabelModeForItem((NESTGraphItemObject)graphItemObject, mode));
                    if (mode == LabelMode.NORMAL) {
                        new EditorActions.KeyValueAction(mxConstants.STYLE_ALIGN, "center").actionPerformed(new ActionEvent(editor.getGraphComponent(), 0, null));
                    } else {
                        new EditorActions.KeyValueAction(mxConstants.STYLE_ALIGN, "left").actionPerformed(new ActionEvent(editor.getGraphComponent(), 0, null));
                    }
                    ((NESTWorkflowEditor.CustomGraphComponent)editor.getGraphComponent()).updateAllCellLabels();
                    ((NESTWorkflowEditor.CustomGraph)editor.getGraphComponent().getGraph()).executeLayout();
                });
                menu.add(menuItem);
            }
            menu.setEnabled(true);
        }
        return menu;
    }

    private JMenu createGraphItemSelectionMenu(BasicGraphEditor editor, DataClass parentClass, String title) {
        JMenu menu = new JMenu(title);
        List<DataClass> selectableClasses = Utils.getSubClassesDeep(parentClass);
        selectableClasses.add(0, parentClass);
        selectableClasses.forEach(dataClass -> {
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(dataClass.getName());
            menuItem.addActionListener(e -> ((NESTWorkflowEditor.CustomGraph)editor.getGraphComponent().getGraph()).selectGraphItemsOfClass((DataClass)dataClass));
            menu.add(menuItem);
        });
        return menu;
    }

    private JMenu createClassSelectionMenu(BasicGraphEditor editor) {
        JMenu menu = new JMenu(mxResources.get((String)"setClass"));
        menu.setEnabled(false);
        List<NESTGraphItemObject> selectedGraphItems = this.getSelectedGraphItems(editor);
        if (selectedGraphItems.size() > 0) {
            DataClass commonSystemSuperClass;
            DataClass firstItemDataClass = selectedGraphItems.get(0).getDataClass();
            DataClass dataClass2 = commonSystemSuperClass = firstItemDataClass.isSystemClass() ? firstItemDataClass : firstItemDataClass.getSystemSuperClass();
            if (selectedGraphItems.stream().allMatch(graphItem -> graphItem.getDataClass() == commonSystemSuperClass || graphItem.getDataClass().getSystemSuperClass() == commonSystemSuperClass)) {
                List<Object> selectableClasses = new LinkedList<DataClass>();
                selectableClasses.add(commonSystemSuperClass);
                selectableClasses.addAll(Utils.getSubClassesDeep(commonSystemSuperClass));
                selectableClasses = selectableClasses.stream().filter(DataClass::isInstantiable).collect(Collectors.toList());
                selectableClasses.forEach(dataClass -> {
                    JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(dataClass.getName());
                    menuItem.addActionListener(e -> selectedGraphItems.forEach(graphItem -> graphItem.setDataClass(dataClass)));
                    if (selectedGraphItems.size() == 1 && firstItemDataClass == dataClass) {
                        menuItem.setSelected(true);
                    }
                    menu.add(menuItem);
                });
                menu.setEnabled(true);
            }
        }
        return menu;
    }

    private List<NESTGraphItemObject> getSelectedGraphItems(BasicGraphEditor editor) {
        return this.getSelectedCells(editor).stream().map(mxICell::getValue).filter(cellValue -> cellValue instanceof NESTGraphItemObject).map(NESTGraphItemObject.class::cast).collect(Collectors.toList());
    }

    private List<mxICell> getSelectedCells(BasicGraphEditor editor) {
        return Arrays.stream(editor.getGraphComponent().getGraph().getSelectionCells()).map(mxICell.class::cast).collect(Collectors.toList());
    }
}

