/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor;

import com.mxgraph.analysis.mxAnalysisGraph;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxGraphActions;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxResources;
import com.mxgraph.view.mxGraph;
import de.uni_trier.wi2.procake.data.model.nest.NESTWorkflowClass;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.NESTWorkflowEditor;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor.BasicGraphEditor;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor.EditorActions;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.utils.Utils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;

public class EditorMenuBar
extends JMenuBar {
    private static final long serialVersionUID = 4060203894740766714L;
    private NESTWorkflowEditor editor;

    public EditorMenuBar(final NESTWorkflowEditor editor) {
        this.editor = editor;
        final mxGraphComponent graphComponent = editor.getGraphComponent();
        mxGraph graph = graphComponent.getGraph();
        mxAnalysisGraph aGraph = new mxAnalysisGraph();
        JMenu menu = null;
        JMenu submenu = null;
        menu = this.add(new JMenu(mxResources.get((String)"file")));
        JMenu nestWorkflowClassSelectionMenu = new JMenu(mxResources.get((String)"new"));
        nestWorkflowClassSelectionMenu.setIcon(new ImageIcon(BasicGraphEditor.class.getResource("/objecteditor/nestworkfloweditor/images/new.gif")));
        Utils.getNESTWorkflowClasses().forEach(nestWorkflowClass -> nestWorkflowClassSelectionMenu.add(editor.bind(nestWorkflowClass.getName(), new EditorActions.NewNESTWorkflowAction((NESTWorkflowClass)nestWorkflowClass))));
        menu.add(nestWorkflowClassSelectionMenu);
        menu.add(editor.bind(mxResources.get((String)"openFile"), new EditorActions.OpenAction(), "/objecteditor/nestworkfloweditor/images/open.gif"));
        menu.add(editor.bind(mxResources.get((String)"save"), new EditorActions.SaveInObjectAction(), "/objecteditor/nestworkfloweditor/images/save.gif"));
        menu.add(editor.bind(mxResources.get((String)"exportAs"), new EditorActions.ExportAsAction(true), "/objecteditor/nestworkfloweditor/images/saveas.gif"));
        menu.addSeparator();
        menu.add(new JCheckBoxMenuItem(EditorActions.getActionFor(EditorActions.ToggleAutoImportExportConfigAction.class)));
        menu.addSeparator();
        menu.add(editor.bind(mxResources.get((String)"pageSetup"), new EditorActions.PageSetupAction(), "/objecteditor/nestworkfloweditor/images/pagesetup.gif"));
        menu.add(editor.bind(mxResources.get((String)"print"), new EditorActions.PrintAction(), "/objecteditor/nestworkfloweditor/images/print.gif"));
        menu.addSeparator();
        menu.add(editor.bind(mxResources.get((String)"exit"), new EditorActions.ExitAction()));
        menu = this.add(new JMenu(mxResources.get((String)"edit")));
        menu.add(editor.bind(mxResources.get((String)"copy"), TransferHandler.getCopyAction(), "/objecteditor/nestworkfloweditor/images/copy.gif"));
        menu.add(editor.bind(mxResources.get((String)"paste"), TransferHandler.getPasteAction(), "/objecteditor/nestworkfloweditor/images/paste.gif"));
        menu.addSeparator();
        menu.add(editor.bind(mxResources.get((String)"delete"), mxGraphActions.getDeleteAction(), "/objecteditor/nestworkfloweditor/images/delete.gif"));
        menu.addSeparator();
        menu.add(editor.bind(mxResources.get((String)"selectAll"), mxGraphActions.getSelectAllAction()));
        menu.add(editor.bind(mxResources.get((String)"selectNone"), mxGraphActions.getSelectNoneAction()));
        menu.addSeparator();
        menu.add(editor.bind(mxResources.get((String)"edit"), mxGraphActions.getEditAction()));
        menu = this.add(new JMenu(mxResources.get((String)"view")));
        menu.add(new EditorActions.LayoutNESTWorkflowAction());
        menu.addSeparator();
        menu.add(new JCheckBoxMenuItem(EditorActions.getActionFor(EditorActions.ToggleWorkflowNodeVisibilityAction.class)));
        menu.add(new JCheckBoxMenuItem(EditorActions.getActionFor(EditorActions.ToggleDataNodeVisibilityAction.class)));
        menu.add(new JCheckBoxMenuItem(EditorActions.getActionFor(EditorActions.ToggleSequenceNodeVisibilityAction.class)));
        menu.addSeparator();
        menu.add(new JCheckBoxMenuItem(EditorActions.getActionFor(EditorActions.ToggleIdVisibilityAction.class)));
        menu.add(new JCheckBoxMenuItem(EditorActions.getActionFor(EditorActions.ToggleEdgeLabelVisibilityAction.class)));
        menu.add(new JCheckBoxMenuItem(EditorActions.getActionFor(EditorActions.ToggleCellTooltipVisibilityAction.class)));
        menu.addSeparator();
        JMenuItem item = menu.add(new EditorActions.TogglePropertyItem(graphComponent, mxResources.get((String)"pageLayout"), "PageVisible", true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (graphComponent.isPageVisible() && graphComponent.isCenterPage()) {
                    graphComponent.zoomAndCenter();
                } else {
                    graphComponent.getGraphControl().updatePreferredSize();
                }
            }
        }));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof EditorActions.TogglePropertyItem) {
                    final mxGraphComponent graphComponent = editor.getGraphComponent();
                    EditorActions.TogglePropertyItem toggleItem = (EditorActions.TogglePropertyItem)e.getSource();
                    if (toggleItem.isSelected()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                graphComponent.scrollToCenter(true);
                                graphComponent.scrollToCenter(false);
                            }
                        });
                    } else {
                        mxPoint tr = graphComponent.getGraph().getView().getTranslate();
                        if (tr.getX() != 0.0 || tr.getY() != 0.0) {
                            graphComponent.getGraph().getView().setTranslate(new mxPoint());
                        }
                    }
                }
            }
        });
        menu.add(new EditorActions.TogglePropertyItem(graphComponent, mxResources.get((String)"antialias"), "AntiAlias", true));
        menu.addSeparator();
        submenu = (JMenu)menu.add(new JMenu(mxResources.get((String)"grid")));
        submenu.add(new EditorActions.ToggleGridItem(editor, mxResources.get((String)"showGrid")));
        submenu.addSeparator();
        submenu.add(editor.bind(mxResources.get((String)"gridSize"), new EditorActions.PromptPropertyAction(graph, "Grid Size", "GridSize")));
        submenu.add(editor.bind(mxResources.get((String)"gridColor"), new EditorActions.GridColorAction()));
        submenu.addSeparator();
        submenu.add(editor.bind(mxResources.get((String)"dashed"), new EditorActions.GridStyleAction(3)));
        submenu.add(editor.bind(mxResources.get((String)"dot"), new EditorActions.GridStyleAction(0)));
        submenu.add(editor.bind(mxResources.get((String)"line"), new EditorActions.GridStyleAction(2)));
        submenu.add(editor.bind(mxResources.get((String)"cross"), new EditorActions.GridStyleAction(1)));
        menu.add(submenu);
        menu.add(new EditorActions.ToggleRulersItem(editor, mxResources.get((String)"rulers")));
        menu.addSeparator();
        submenu = (JMenu)menu.add(new JMenu(mxResources.get((String)"zoom")));
        submenu.add(editor.bind("400%", new EditorActions.ScaleAction(4.0)));
        submenu.add(editor.bind("200%", new EditorActions.ScaleAction(2.0)));
        submenu.add(editor.bind("150%", new EditorActions.ScaleAction(1.5)));
        submenu.add(editor.bind("100%", new EditorActions.ScaleAction(1.0)));
        submenu.add(editor.bind("75%", new EditorActions.ScaleAction(0.75)));
        submenu.add(editor.bind("50%", new EditorActions.ScaleAction(0.5)));
        submenu.addSeparator();
        submenu.add(editor.bind(mxResources.get((String)"custom"), new EditorActions.ScaleAction(0.0)));
        menu.addSeparator();
        menu.add(editor.bind(mxResources.get((String)"zoomIn"), mxGraphActions.getZoomInAction()));
        menu.add(editor.bind(mxResources.get((String)"zoomOut"), mxGraphActions.getZoomOutAction()));
        menu.addSeparator();
        menu.add(editor.bind(mxResources.get((String)"page"), new EditorActions.ZoomPolicyAction(1)));
        menu.addSeparator();
        menu.add(editor.bind(mxResources.get((String)"actualSize"), mxGraphActions.getZoomActualAction()));
        menu = this.add(new JMenu(mxResources.get((String)"format")));
        EditorMenuBar.populateFormatMenu(menu, editor);
        menu = this.add(new JMenu(mxResources.get((String)"diagram")));
        menu.add(new EditorActions.ToggleOutlineItem(editor, mxResources.get((String)"outline")));
        menu.addSeparator();
        submenu = (JMenu)menu.add(new JMenu(mxResources.get((String)"background")));
        submenu.add(editor.bind(mxResources.get((String)"backgroundColor"), new EditorActions.BackgroundAction()));
        submenu.add(editor.bind(mxResources.get((String)"backgroundImage"), new EditorActions.BackgroundImageAction()));
        submenu.addSeparator();
        submenu.add(editor.bind(mxResources.get((String)"pageBackground"), new EditorActions.PageBackgroundAction()));
        menu.addSeparator();
        submenu = (JMenu)menu.add(new JMenu(mxResources.get((String)"layout")));
        submenu.add(editor.graphLayout("verticalHierarchical", true));
        submenu.add(editor.graphLayout("horizontalHierarchical", true));
        menu = this.add(new JMenu(mxResources.get((String)"options")));
        submenu = (JMenu)menu.add(new JMenu(mxResources.get((String)"display")));
        submenu.add(editor.bind(mxResources.get((String)"tolerance"), new EditorActions.PromptPropertyAction(graphComponent, "Tolerance")));
        submenu = (JMenu)menu.add(new JMenu(mxResources.get((String)"zoom")));
        submenu.add(new EditorActions.TogglePropertyItem(graphComponent, mxResources.get((String)"centerZoom"), "CenterZoom", true));
        submenu.add(new EditorActions.TogglePropertyItem(graphComponent, mxResources.get((String)"zoomToSelection"), "KeepSelectionVisibleOnZoom", true));
        submenu.addSeparator();
        submenu.add(new EditorActions.TogglePropertyItem(graphComponent, mxResources.get((String)"centerPage"), "CenterPage", true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (graphComponent.isPageVisible() && graphComponent.isCenterPage()) {
                    graphComponent.zoomAndCenter();
                }
            }
        }));
        menu.addSeparator();
        submenu = (JMenu)menu.add(new JMenu(mxResources.get((String)"labels")));
        submenu.add(new EditorActions.TogglePropertyItem(graph, mxResources.get((String)"htmlLabels"), "HtmlLabels", true));
        submenu.add(new EditorActions.TogglePropertyItem(graph, mxResources.get((String)"showLabels"), "LabelsVisible", true));
        submenu.addSeparator();
        submenu.add(new EditorActions.TogglePropertyItem(graph, mxResources.get((String)"moveEdgeLabels"), "EdgeLabelsMovable"));
        submenu.add(new EditorActions.TogglePropertyItem(graph, mxResources.get((String)"moveVertexLabels"), "VertexLabelsMovable"));
        menu = this.add(new JMenu("Analyze"));
        menu.add(editor.bind("Validate NESTWorkflow", new EditorActions.ValidateNESTWorkflowAction()));
        this.add(menu);
    }

    public static void populateShapeMenu(JMenu menu, BasicGraphEditor editor) {
        menu.add(editor.bind(mxResources.get((String)"home"), mxGraphActions.getHomeAction(), "/objecteditor/nestworkfloweditor/images/house.gif"));
        menu.addSeparator();
        menu.add(editor.bind(mxResources.get((String)"exitGroup"), mxGraphActions.getExitGroupAction(), "/objecteditor/nestworkfloweditor/images/up.gif"));
        menu.add(editor.bind(mxResources.get((String)"enterGroup"), mxGraphActions.getEnterGroupAction(), "/objecteditor/nestworkfloweditor/images/down.gif"));
        menu.addSeparator();
        menu.add(editor.bind(mxResources.get((String)"group"), mxGraphActions.getGroupAction(), "/objecteditor/nestworkfloweditor/images/group.gif"));
        menu.add(editor.bind(mxResources.get((String)"ungroup"), mxGraphActions.getUngroupAction(), "/objecteditor/nestworkfloweditor/images/ungroup.gif"));
        menu.addSeparator();
        menu.add(editor.bind(mxResources.get((String)"removeFromGroup"), mxGraphActions.getRemoveFromParentAction()));
        menu.add(editor.bind(mxResources.get((String)"updateGroupBounds"), mxGraphActions.getUpdateGroupBoundsAction()));
        menu.addSeparator();
        menu.add(editor.bind(mxResources.get((String)"collapse"), mxGraphActions.getCollapseAction(), "/objecteditor/nestworkfloweditor/images/collapse.gif"));
        menu.add(editor.bind(mxResources.get((String)"expand"), mxGraphActions.getExpandAction(), "/objecteditor/nestworkfloweditor/images/expand.gif"));
        menu.addSeparator();
        menu.add(editor.bind(mxResources.get((String)"toBack"), mxGraphActions.getToBackAction(), "/objecteditor/nestworkfloweditor/images/toback.gif"));
        menu.add(editor.bind(mxResources.get((String)"toFront"), mxGraphActions.getToFrontAction(), "/objecteditor/nestworkfloweditor/images/tofront.gif"));
        menu.addSeparator();
        JMenu submenu = (JMenu)menu.add(new JMenu(mxResources.get((String)"align")));
        submenu.add(editor.bind(mxResources.get((String)"left"), new EditorActions.AlignCellsAction("left"), "/objecteditor/nestworkfloweditor/images/alignleft.gif"));
        submenu.add(editor.bind(mxResources.get((String)"center"), new EditorActions.AlignCellsAction("center"), "/objecteditor/nestworkfloweditor/images/aligncenter.gif"));
        submenu.add(editor.bind(mxResources.get((String)"right"), new EditorActions.AlignCellsAction("right"), "/objecteditor/nestworkfloweditor/images/alignright.gif"));
        submenu.addSeparator();
        submenu.add(editor.bind(mxResources.get((String)"top"), new EditorActions.AlignCellsAction("top"), "/objecteditor/nestworkfloweditor/images/aligntop.gif"));
        submenu.add(editor.bind(mxResources.get((String)"middle"), new EditorActions.AlignCellsAction("middle"), "/objecteditor/nestworkfloweditor/images/alignmiddle.gif"));
        submenu.add(editor.bind(mxResources.get((String)"bottom"), new EditorActions.AlignCellsAction("bottom"), "/objecteditor/nestworkfloweditor/images/alignbottom.gif"));
        menu.addSeparator();
        menu.add(editor.bind(mxResources.get((String)"autosize"), new EditorActions.AutosizeAction()));
    }

    public static void populateFormatMenu(JMenu menu, BasicGraphEditor editor) {
        JMenu submenu = (JMenu)menu.add(new JMenu(mxResources.get((String)"background")));
        submenu.add(editor.bind(mxResources.get((String)"fillcolor"), new EditorActions.ColorAction("Fillcolor", mxConstants.STYLE_FILLCOLOR), "/objecteditor/nestworkfloweditor/images/fillcolor.gif"));
        submenu.add(editor.bind(mxResources.get((String)"gradient"), new EditorActions.ColorAction("Gradient", mxConstants.STYLE_GRADIENTCOLOR)));
        submenu.addSeparator();
        submenu.add(editor.bind(mxResources.get((String)"image"), new EditorActions.PromptValueAction(mxConstants.STYLE_IMAGE, "Image")));
        submenu.add(editor.bind(mxResources.get((String)"shadow"), new EditorActions.ToggleAction(mxConstants.STYLE_SHADOW)));
        submenu.addSeparator();
        submenu.add(editor.bind(mxResources.get((String)"opacity"), new EditorActions.PromptValueAction(mxConstants.STYLE_OPACITY, "Opacity (0-100)")));
        submenu = (JMenu)menu.add(new JMenu(mxResources.get((String)"label")));
        submenu.add(editor.bind(mxResources.get((String)"fontcolor"), new EditorActions.ColorAction("Fontcolor", mxConstants.STYLE_FONTCOLOR), "/objecteditor/nestworkfloweditor/images/fontcolor.gif"));
        submenu.addSeparator();
        submenu.add(editor.bind(mxResources.get((String)"labelFill"), new EditorActions.ColorAction("Label Fill", mxConstants.STYLE_LABEL_BACKGROUNDCOLOR)));
        submenu.add(editor.bind(mxResources.get((String)"labelBorder"), new EditorActions.ColorAction("Label Border", mxConstants.STYLE_LABEL_BORDERCOLOR)));
        submenu.addSeparator();
        submenu.add(editor.bind(mxResources.get((String)"rotateLabel"), new EditorActions.ToggleAction(mxConstants.STYLE_HORIZONTAL, true)));
        submenu.add(editor.bind(mxResources.get((String)"textOpacity"), new EditorActions.PromptValueAction(mxConstants.STYLE_TEXT_OPACITY, "Opacity (0-100)")));
        submenu.addSeparator();
        JMenu subsubmenu = (JMenu)submenu.add(new JMenu(mxResources.get((String)"position")));
        subsubmenu.add(editor.bind(mxResources.get((String)"top"), new EditorActions.SetLabelPositionAction("top", "bottom")));
        subsubmenu.add(editor.bind(mxResources.get((String)"middle"), new EditorActions.SetLabelPositionAction("middle", "middle")));
        subsubmenu.add(editor.bind(mxResources.get((String)"bottom"), new EditorActions.SetLabelPositionAction("bottom", "top")));
        subsubmenu.addSeparator();
        subsubmenu.add(editor.bind(mxResources.get((String)"left"), new EditorActions.SetLabelPositionAction("left", "right")));
        subsubmenu.add(editor.bind(mxResources.get((String)"center"), new EditorActions.SetLabelPositionAction("center", "center")));
        subsubmenu.add(editor.bind(mxResources.get((String)"right"), new EditorActions.SetLabelPositionAction("right", "left")));
        submenu.addSeparator();
        submenu.add(editor.bind(mxResources.get((String)"wordWrap"), new EditorActions.KeyValueAction(mxConstants.STYLE_WHITE_SPACE, "wrap")));
        submenu.add(editor.bind(mxResources.get((String)"noWordWrap"), new EditorActions.KeyValueAction(mxConstants.STYLE_WHITE_SPACE, null)));
        submenu.addSeparator();
        submenu.add(editor.bind(mxResources.get((String)"hide"), new EditorActions.ToggleAction(mxConstants.STYLE_NOLABEL)));
        menu.addSeparator();
        submenu = (JMenu)menu.add(new JMenu(mxResources.get((String)"line")));
        submenu.add(editor.bind(mxResources.get((String)"linecolor"), new EditorActions.ColorAction("Linecolor", mxConstants.STYLE_STROKECOLOR), "/objecteditor/nestworkfloweditor/images/linecolor.gif"));
        submenu.addSeparator();
        submenu.add(editor.bind(mxResources.get((String)"orthogonal"), new EditorActions.ToggleAction(mxConstants.STYLE_ORTHOGONAL)));
        submenu.add(editor.bind(mxResources.get((String)"dashed"), new EditorActions.ToggleAction(mxConstants.STYLE_DASHED)));
        submenu.addSeparator();
        submenu.add(editor.bind(mxResources.get((String)"linewidth"), new EditorActions.PromptValueAction(mxConstants.STYLE_STROKEWIDTH, "Linewidth")));
        menu.addSeparator();
        submenu = (JMenu)menu.add(new JMenu(mxResources.get((String)"linestart")));
        submenu.add(editor.bind(mxResources.get((String)"open"), new EditorActions.KeyValueAction(mxConstants.STYLE_STARTARROW, "open"), "/objecteditor/nestworkfloweditor/images/open_start.gif"));
        submenu.add(editor.bind(mxResources.get((String)"classic"), new EditorActions.KeyValueAction(mxConstants.STYLE_STARTARROW, "classic"), "/objecteditor/nestworkfloweditor/images/classic_start.gif"));
        submenu.add(editor.bind(mxResources.get((String)"block"), new EditorActions.KeyValueAction(mxConstants.STYLE_STARTARROW, "block"), "/objecteditor/nestworkfloweditor/images/block_start.gif"));
        submenu.addSeparator();
        submenu.add(editor.bind(mxResources.get((String)"diamond"), new EditorActions.KeyValueAction(mxConstants.STYLE_STARTARROW, "diamond"), "/objecteditor/nestworkfloweditor/images/diamond_start.gif"));
        submenu.add(editor.bind(mxResources.get((String)"oval"), new EditorActions.KeyValueAction(mxConstants.STYLE_STARTARROW, "oval"), "/objecteditor/nestworkfloweditor/images/oval_start.gif"));
        submenu.addSeparator();
        submenu.add(editor.bind(mxResources.get((String)"none"), new EditorActions.KeyValueAction(mxConstants.STYLE_STARTARROW, mxConstants.NONE)));
        submenu.add(editor.bind(mxResources.get((String)"size"), new EditorActions.PromptValueAction(mxConstants.STYLE_STARTSIZE, "Linestart Size")));
        submenu = (JMenu)menu.add(new JMenu(mxResources.get((String)"lineend")));
        submenu.add(editor.bind(mxResources.get((String)"open"), new EditorActions.KeyValueAction(mxConstants.STYLE_ENDARROW, "open"), "/objecteditor/nestworkfloweditor/images/open_end.gif"));
        submenu.add(editor.bind(mxResources.get((String)"classic"), new EditorActions.KeyValueAction(mxConstants.STYLE_ENDARROW, "classic"), "/objecteditor/nestworkfloweditor/images/classic_end.gif"));
        submenu.add(editor.bind(mxResources.get((String)"block"), new EditorActions.KeyValueAction(mxConstants.STYLE_ENDARROW, "block"), "/objecteditor/nestworkfloweditor/images/block_end.gif"));
        submenu.addSeparator();
        submenu.add(editor.bind(mxResources.get((String)"diamond"), new EditorActions.KeyValueAction(mxConstants.STYLE_ENDARROW, "diamond"), "/objecteditor/nestworkfloweditor/images/diamond_end.gif"));
        submenu.add(editor.bind(mxResources.get((String)"oval"), new EditorActions.KeyValueAction(mxConstants.STYLE_ENDARROW, "oval"), "/objecteditor/nestworkfloweditor/images/oval_end.gif"));
        submenu.addSeparator();
        submenu.add(editor.bind(mxResources.get((String)"none"), new EditorActions.KeyValueAction(mxConstants.STYLE_ENDARROW, mxConstants.NONE)));
        submenu.add(editor.bind(mxResources.get((String)"size"), new EditorActions.PromptValueAction(mxConstants.STYLE_ENDSIZE, "Lineend Size")));
        menu.addSeparator();
        submenu = (JMenu)menu.add(new JMenu(mxResources.get((String)"alignment")));
        submenu.add(editor.bind(mxResources.get((String)"left"), new EditorActions.KeyValueAction(mxConstants.STYLE_ALIGN, "left"), "/objecteditor/nestworkfloweditor/images/left.gif"));
        submenu.add(editor.bind(mxResources.get((String)"center"), new EditorActions.KeyValueAction(mxConstants.STYLE_ALIGN, "center"), "/objecteditor/nestworkfloweditor/images/center.gif"));
        submenu.add(editor.bind(mxResources.get((String)"right"), new EditorActions.KeyValueAction(mxConstants.STYLE_ALIGN, "right"), "/objecteditor/nestworkfloweditor/images/right.gif"));
        submenu.addSeparator();
        submenu.add(editor.bind(mxResources.get((String)"top"), new EditorActions.KeyValueAction(mxConstants.STYLE_VERTICAL_ALIGN, "top"), "/objecteditor/nestworkfloweditor/images/top.gif"));
        submenu.add(editor.bind(mxResources.get((String)"middle"), new EditorActions.KeyValueAction(mxConstants.STYLE_VERTICAL_ALIGN, "middle"), "/objecteditor/nestworkfloweditor/images/middle.gif"));
        submenu.add(editor.bind(mxResources.get((String)"bottom"), new EditorActions.KeyValueAction(mxConstants.STYLE_VERTICAL_ALIGN, "bottom"), "/objecteditor/nestworkfloweditor/images/bottom.gif"));
    }

    public static void populateFormatMenu(JMenu menu, BasicGraphEditor editor, boolean enableEditSize) {
        EditorMenuBar.populateFormatMenu(menu, editor);
        menu.addSeparator();
        menu.add(editor.bind("Edit Size", new EditorActions.EditSizeAction(editor.getGraphComponent().getGraph()))).setEnabled(enableEditSize);
    }

    public BasicGraphEditor getEditor() {
        return this.editor;
    }
}

