/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.mxgraph.analysis.mxDistanceCostFunction;
import com.mxgraph.analysis.mxGraphAnalysis;
import com.mxgraph.analysis.mxICostFunction;
import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.canvas.mxICanvas;
import com.mxgraph.canvas.mxSvgCanvas;
import com.mxgraph.io.mxCodec;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxICell;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.shape.mxIShape;
import com.mxgraph.shape.mxStencilShape;
import com.mxgraph.swing.handler.mxConnectionHandler;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.mxGraphOutline;
import com.mxgraph.swing.util.mxGraphActions;
import com.mxgraph.swing.view.mxCellEditor;
import com.mxgraph.util.mxCellRenderer;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxDomUtils;
import com.mxgraph.util.mxResources;
import com.mxgraph.util.mxUtils;
import com.mxgraph.util.mxXmlUtils;
import com.mxgraph.view.mxGraph;
import de.uni_trier.wi2.procake.data.model.nest.NESTWorkflowClass;
import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.data.object.base.AggregateObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTAbstractWorkflowObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTGraphItemObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTWorkflowObject;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.NESTWorkflowEditor;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.NESTWorkflowLayout;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.StylesheetEditor;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor.BasicGraphEditor;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor.DefaultFileFilter;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor.EditorMenuBar;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor.EditorPalette;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor.EditorRuler;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor.EditorSizeEdit;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.mxgraph.mxSvgCanvasWithStencilSupport;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.utils.Utils;
import de.uni_trier.wi2.procake.utils.conversion.xml.JAXBUtil;
import de.uni_trier.wi2.procake.utils.io.IOUtil;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class EditorActions {
    private static final ClassToInstanceMap<Action> actionMap = new ImmutableClassToInstanceMap.Builder().put(ToggleAutoImportExportConfigAction.class, (Object)new ToggleAutoImportExportConfigAction()).put(ToggleWorkflowNodeVisibilityAction.class, (Object)new ToggleWorkflowNodeVisibilityAction()).put(ToggleSequenceNodeVisibilityAction.class, (Object)new ToggleSequenceNodeVisibilityAction()).put(ToggleDataNodeVisibilityAction.class, (Object)new ToggleDataNodeVisibilityAction()).put(ToggleIdVisibilityAction.class, (Object)new ToggleIdVisibilityAction()).put(ToggleEdgeLabelVisibilityAction.class, (Object)new ToggleEdgeLabelVisibilityAction()).put(ToggleCellTooltipVisibilityAction.class, (Object)new ToggleCellTooltipVisibilityAction()).put(ToggleDataFlowEdgeStyleAction.class, (Object)new ToggleDataFlowEdgeStyleAction()).put(ToggleReLayoutAction.class, (Object)new ToggleReLayoutAction()).build();

    public static final BasicGraphEditor getEditor(ActionEvent e) {
        if (e.getSource() instanceof Component) {
            Component component = (Component)e.getSource();
            while (component != null && !(component instanceof BasicGraphEditor)) {
                component = component instanceof JPopupMenu ? ((JPopupMenu)component).getInvoker() : (component instanceof EditorMenuBar ? ((EditorMenuBar)component).getEditor() : component.getParent());
            }
            return (BasicGraphEditor)component;
        }
        return null;
    }

    public static Action getActionFor(Class<? extends Action> actionClasss) {
        return (Action)actionMap.getInstance(actionClasss);
    }

    public static class ToggleAutoImportExportConfigAction
    extends AbstractAction {
        public ToggleAutoImportExportConfigAction() {
            super("Auto import/export layout & style");
            this.putValue("SwingSelectedKey", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    public static class ToggleWorkflowNodeVisibilityAction
    extends ToggleNodeVisibilityAction {
        public ToggleWorkflowNodeVisibilityAction() {
            super("(Sub)Workflow", (? super NESTNodeObject node) -> node.isNESTSubWorkflowNode() || node.isNESTWorkflowNode());
        }
    }

    public static class ToggleSequenceNodeVisibilityAction
    extends ToggleNodeVisibilityAction {
        public ToggleSequenceNodeVisibilityAction() {
            super("Sequence", DataObject::isNESTSequenceNode);
        }
    }

    public static class ToggleDataNodeVisibilityAction
    extends ToggleNodeVisibilityAction {
        public ToggleDataNodeVisibilityAction() {
            super("Data", DataObject::isNESTDataNode);
        }
    }

    public static class ToggleIdVisibilityAction
    extends AbstractAction {
        public ToggleIdVisibilityAction() {
            super("Show IDs");
            this.putValue("SwingSelectedKey", false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(() -> {
                BasicGraphEditor editor = EditorActions.getEditor(e);
                NESTWorkflowEditor.CustomGraph graph = (NESTWorkflowEditor.CustomGraph)editor.getGraphComponent().getGraph();
                graph.getCellLabelGenerator().setShowIds((Boolean)this.getValue("SwingSelectedKey"));
                ((NESTWorkflowEditor.CustomGraphComponent)editor.getGraphComponent()).updateAllCellLabels();
            });
        }
    }

    public static class ToggleEdgeLabelVisibilityAction
    extends AbstractAction {
        public ToggleEdgeLabelVisibilityAction() {
            super("Show edge labels");
            this.putValue("SwingSelectedKey", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(() -> {
                BasicGraphEditor editor = EditorActions.getEditor(e);
                NESTWorkflowEditor.CustomGraph graph = (NESTWorkflowEditor.CustomGraph)editor.getGraphComponent().getGraph();
                graph.getCellLabelGenerator().setShowEdgeLabels((Boolean)this.getValue("SwingSelectedKey"));
                ((NESTWorkflowEditor.CustomGraphComponent)editor.getGraphComponent()).updateAllCellLabels();
            });
        }
    }

    public static class ToggleCellTooltipVisibilityAction
    extends AbstractAction {
        public ToggleCellTooltipVisibilityAction() {
            super("Show cell tooltip on hover");
            this.putValue("SwingSelectedKey", false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(() -> {
                BasicGraphEditor editor = EditorActions.getEditor(e);
                editor.getGraphComponent().setToolTips(((Boolean)this.getValue("SwingSelectedKey")).booleanValue());
            });
        }
    }

    public static class ToggleDataFlowEdgeStyleAction
    extends AbstractAction {
        private Object originalStyle;

        public ToggleDataFlowEdgeStyleAction() {
            super("Direct dataflow edges");
            this.putValue("SwingSelectedKey", false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(() -> {
                mxGraph graph = EditorActions.getEditor(e).getGraphComponent().getGraph();
                Map dataflowEdgeStyle = (Map)graph.getStylesheet().getStyles().get(NESTWorkflowEditor.CellStyle.DATAFLOW_EDGE_STYLE.name());
                if (((Boolean)this.getValue("SwingSelectedKey")).booleanValue()) {
                    this.originalStyle = dataflowEdgeStyle.get(mxConstants.STYLE_EDGE);
                    dataflowEdgeStyle.put(mxConstants.STYLE_EDGE, mxConstants.NONE);
                } else {
                    dataflowEdgeStyle.put(mxConstants.STYLE_EDGE, this.originalStyle);
                }
                graph.refresh();
            });
        }
    }

    public static class ToggleReLayoutAction
    extends AbstractAction {
        public ToggleReLayoutAction() {
            super("Automatic re-layout on edge insertion");
            this.putValue("SwingSelectedKey", NESTWorkflowLayout.DEFAULT_EXECUTE_ON_EDGE_INSERTION);
            this.putValue("ShortDescription", mxResources.get((String)"toggleReLayoutActionToolTip"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(() -> {
                NESTWorkflowLayout layout = ((NESTWorkflowEditor.CustomGraph)EditorActions.getEditor(actionEvent).getGraphComponent().getGraph()).getLayout();
                layout.setExecuteOnEdgeInsertion((Boolean)this.getValue("SwingSelectedKey"));
            });
        }
    }

    public static class EditSizeAction
    extends AbstractAction {
        mxGraph graph;

        public EditSizeAction(mxGraph graph) {
            super("Edit");
            this.graph = graph;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new EditorSizeEdit(this.graph);
        }
    }

    public static class StyleAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                mxGraph graph = graphComponent.getGraph();
                String initial = graph.getModel().getStyle(graph.getSelectionCell());
                String value = (String)JOptionPane.showInputDialog((Component)graphComponent, mxResources.get((String)"style"), mxResources.get((String)"style"), -1, null, null, initial);
                if (value != null) {
                    graph.setCellStyle(value);
                }
            }
        }
    }

    public static class PageBackgroundAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                Color newColor = JColorChooser.showDialog((Component)graphComponent, mxResources.get((String)"pageBackground"), null);
                if (newColor != null) {
                    graphComponent.setPageBackgroundColor(newColor);
                }
                graphComponent.repaint();
            }
        }
    }

    public static class BackgroundAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                Color newColor = JColorChooser.showDialog((Component)graphComponent, mxResources.get((String)"background"), null);
                if (newColor != null) {
                    graphComponent.getViewport().setOpaque(true);
                    graphComponent.getViewport().setBackground(newColor);
                }
                graphComponent.getGraph().repaint();
            }
        }
    }

    public static class BackgroundImageAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            mxGraphComponent graphComponent;
            String value;
            if (e.getSource() instanceof mxGraphComponent && (value = (String)JOptionPane.showInputDialog((Component)(graphComponent = (mxGraphComponent)e.getSource()), mxResources.get((String)"backgroundImage"), "URL", -1, null, null, "http://www.callatecs.com/images/background2.JPG")) != null) {
                if (value.length() == 0) {
                    graphComponent.setBackgroundImage(null);
                } else {
                    BufferedImage background = mxUtils.loadImage((String)value);
                    if (background != null) {
                        graphComponent.setBackgroundImage(new ImageIcon(background));
                    }
                }
                graphComponent.getGraph().repaint();
            }
        }
    }

    public static class ColorAction
    extends AbstractAction {
        protected String name;
        protected String key;

        public ColorAction(String name, String key) {
            this.name = name;
            this.key = key;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Color newColor;
            mxGraphComponent graphComponent;
            mxGraph graph;
            if (e.getSource() instanceof mxGraphComponent && !(graph = (graphComponent = (mxGraphComponent)e.getSource()).getGraph()).isSelectionEmpty() && (newColor = JColorChooser.showDialog((Component)graphComponent, this.name, null)) != null) {
                graph.setCellStyles(this.key, mxUtils.hexString((Color)newColor));
            }
        }
    }

    public static class AutosizeAction
    extends AbstractAction {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            mxGraph graph = mxGraphActions.getGraph((ActionEvent)e);
            if (graph != null && !graph.isSelectionEmpty()) {
                Object[] cells = graph.getSelectionCells();
                mxIGraphModel model = graph.getModel();
                model.beginUpdate();
                try {
                    for (int i = 0; i < cells.length; ++i) {
                        graph.updateCellSize(cells[i]);
                    }
                }
                finally {
                    model.endUpdate();
                }
            }
        }
    }

    public static class AlignCellsAction
    extends AbstractAction {
        protected String align;

        public AlignCellsAction(String align) {
            this.align = align;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            mxGraph graph = mxGraphActions.getGraph((ActionEvent)e);
            if (graph != null && !graph.isSelectionEmpty()) {
                graph.alignCells(this.align);
            }
        }
    }

    public static class PromptValueAction
    extends AbstractAction {
        protected String key;
        protected String message;

        public PromptValueAction(String key, String message) {
            this.key = key;
            this.message = message;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String value;
            mxGraph graph;
            if (e.getSource() instanceof Component && (graph = mxGraphActions.getGraph((ActionEvent)e)) != null && !graph.isSelectionEmpty() && (value = (String)JOptionPane.showInputDialog((Component)e.getSource(), mxResources.get((String)"value"), this.message, -1, null, null, "")) != null) {
                if (value.equals(mxConstants.NONE)) {
                    value = null;
                }
                graph.setCellStyles(this.key, value);
            }
        }
    }

    public static class KeyValueAction
    extends AbstractAction {
        protected String key;
        protected String value;

        public KeyValueAction(String key) {
            this(key, (String)null);
        }

        public KeyValueAction(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            mxGraph graph = mxGraphActions.getGraph((ActionEvent)e);
            if (graph != null && !graph.isSelectionEmpty()) {
                graph.setCellStyles(this.key, this.value);
            }
        }
    }

    public static class SetStyleAction
    extends AbstractAction {
        protected String value;

        public SetStyleAction(String value) {
            this.value = value;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            mxGraph graph = mxGraphActions.getGraph((ActionEvent)e);
            if (graph != null && !graph.isSelectionEmpty()) {
                graph.setCellStyle(this.value);
            }
        }
    }

    public static class SetLabelPositionAction
    extends AbstractAction {
        protected String labelPosition;
        protected String alignment;

        public SetLabelPositionAction(String labelPosition, String alignment) {
            this.labelPosition = labelPosition;
            this.alignment = alignment;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            mxGraph graph = mxGraphActions.getGraph((ActionEvent)e);
            if (graph != null && !graph.isSelectionEmpty()) {
                graph.getModel().beginUpdate();
                try {
                    if (this.labelPosition.equals("left") || this.labelPosition.equals("center") || this.labelPosition.equals("right")) {
                        graph.setCellStyles(mxConstants.STYLE_LABEL_POSITION, this.labelPosition);
                        graph.setCellStyles(mxConstants.STYLE_ALIGN, this.alignment);
                    } else {
                        graph.setCellStyles(mxConstants.STYLE_VERTICAL_LABEL_POSITION, this.labelPosition);
                        graph.setCellStyles(mxConstants.STYLE_VERTICAL_ALIGN, this.alignment);
                    }
                }
                finally {
                    graph.getModel().endUpdate();
                }
            }
        }
    }

    public static class ToggleAction
    extends AbstractAction {
        protected String key;
        protected boolean defaultValue;

        public ToggleAction(String key) {
            this(key, false);
        }

        public ToggleAction(String key, boolean defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            mxGraph graph = mxGraphActions.getGraph((ActionEvent)e);
            if (graph != null) {
                graph.toggleCellStyles(this.key, this.defaultValue);
            }
        }
    }

    public static class OpenAction
    extends AbstractAction {
        protected String lastDir;

        public OpenAction() {
            this.putValue("ShortDescription", mxResources.get((String)"openFile"));
        }

        protected void resetEditor(BasicGraphEditor editor) {
            editor.setModified(false);
            editor.getUndoManager().clear();
            editor.getGraphComponent().zoomAndCenter();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            mxGraph graph;
            NESTWorkflowEditor editor = (NESTWorkflowEditor)EditorActions.getEditor(e);
            if (!(editor == null || editor.isModified() && JOptionPane.showConfirmDialog(editor, mxResources.get((String)"loseChanges"), UIManager.getString("OptionPane.titleText"), 0) != 0 || (graph = editor.getGraphComponent().getGraph()) == null)) {
                String wd = this.lastDir != null ? this.lastDir : System.getProperty("user.dir");
                JFileChooser fc = new JFileChooser(wd);
                DefaultFileFilter defaultFilter = new DefaultFileFilter(".xml", "Pool and NESTWorkflow XML definitions (.xml)");
                fc.addChoosableFileFilter(defaultFilter);
                fc.setFileFilter(defaultFilter);
                int rc = fc.showDialog(null, mxResources.get((String)"openFile"));
                if (rc == 0) {
                    this.lastDir = fc.getSelectedFile().getParent();
                    NESTWorkflowObject nestWorkflowFromFile = (NESTWorkflowObject)IOUtil.readFile((String)fc.getSelectedFile().getAbsolutePath(), NESTWorkflowObject.class);
                    if (nestWorkflowFromFile == null) {
                        JOptionPane.showMessageDialog((Component)editor.getGraphComponent(), mxResources.get((String)"invalidXMLContentError"), mxResources.get((String)"error"), 0);
                    } else {
                        editor.setCurrentFile(fc.getSelectedFile());
                        this.resetEditor(editor);
                        editor.open(nestWorkflowFromFile);
                        boolean isImportLayoutAndStyles = (Boolean)EditorActions.getActionFor(ToggleAutoImportExportConfigAction.class).getValue("SwingSelectedKey");
                        if (isImportLayoutAndStyles) {
                            this.importConfigFromFile(editor, fc.getSelectedFile());
                        }
                    }
                }
            }
        }

        private void importConfigFromFile(BasicGraphEditor editor, File workflowXMLFile) {
            int extensionDelimiterPosition;
            String workflowXMLFilePath = workflowXMLFile.getPath();
            String layoutXMLFilePath = workflowXMLFilePath.substring(0, extensionDelimiterPosition = workflowXMLFilePath.lastIndexOf(46)) + ".config" + workflowXMLFilePath.substring(extensionDelimiterPosition);
            File configFile = new File(layoutXMLFilePath);
            if (configFile.exists()) {
                try {
                    NESTWorkflowEditorConfig config = (NESTWorkflowEditorConfig)JAXBUtil.unmarshall((InputStream)new FileInputStream(configFile), (Class[])new Class[]{NESTWorkflowEditorConfig.class});
                    config.applyTo((NESTWorkflowEditor)editor);
                }
                catch (JAXBException e) {
                    JOptionPane.showMessageDialog((Component)editor.getGraphComponent(), mxResources.get((String)"invalidXMLContentError"), mxResources.get((String)"error"), 0);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }

        private void importGraphGeometry(mxGraph graph, Map<String, mxGeometry> geometry) {
            Map cells = ((mxGraphModel)graph.getModel()).getCells();
            geometry.forEach((id, mxGeometry2) -> {
                mxICell cell = (mxICell)cells.get(id);
                if (cell != null) {
                    graph.getModel().setGeometry((Object)cell, mxGeometry2);
                }
            });
        }

        private void importGraphStyle(mxGraph graph, Map<String, String> styles) {
            Map cells = ((mxGraphModel)graph.getModel()).getCells();
            styles.forEach((id, style) -> {
                mxICell cell = (mxICell)cells.get(id);
                if (cell != null) {
                    graph.getModel().setStyle((Object)cell, style);
                }
            });
        }
    }

    public static class ImportAction
    extends AbstractAction {
        protected String lastDir;

        public static String addStencilShape(EditorPalette palette, String nodeXml, String path, String style, Object cellValue) {
            int lessthanIndex = nodeXml.indexOf("<");
            nodeXml = nodeXml.substring(lessthanIndex);
            mxStencilShape newShape = new mxStencilShape(nodeXml);
            String name = newShape.getName();
            ImageIcon icon = null;
            if (path != null) {
                try {
                    icon = new ImageIcon(ImageIO.read(NESTWorkflowEditor.class.getResourceAsStream(path)));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            mxGraphics2DCanvas.putShape((String)name, (mxIShape)newShape);
            if (palette != null && icon != null) {
                palette.addTemplate(name, icon, style, 80, 80, cellValue);
            }
            return name;
        }

        public static String addStencilShape(EditorPalette palette, String nodeXml, String path, String style) {
            return ImportAction.addStencilShape(palette, nodeXml, path, style, "");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicGraphEditor editor = EditorActions.getEditor(e);
            if (editor != null) {
                String wd = this.lastDir != null ? this.lastDir : System.getProperty("user.dir");
                JFileChooser fc = new JFileChooser(wd);
                fc.setFileSelectionMode(2);
                fc.addChoosableFileFilter(new DefaultFileFilter(".shape", "Dia Shape " + mxResources.get((String)"file") + " (.shape)"));
                int rc = fc.showDialog(null, mxResources.get((String)"importStencil"));
                if (rc == 0) {
                    this.lastDir = fc.getSelectedFile().getParent();
                    try {
                        if (fc.getSelectedFile().isDirectory()) {
                            EditorPalette palette = editor.insertPalette(fc.getSelectedFile().getName());
                            for (File f : fc.getSelectedFile().listFiles(new FilenameFilter(){

                                @Override
                                public boolean accept(File dir, String name) {
                                    return name.toLowerCase().endsWith(".shape");
                                }
                            })) {
                                String nodeXml = mxUtils.readFile((String)f.getAbsolutePath());
                                ImportAction.addStencilShape(palette, nodeXml, f.getParent() + File.separator, "");
                            }
                            JComponent scrollPane = (JComponent)palette.getParent().getParent();
                            editor.getLibraryPane().setSelectedComponent(scrollPane);
                        } else {
                            String nodeXml = mxUtils.readFile((String)fc.getSelectedFile().getAbsolutePath());
                            String name = ImportAction.addStencilShape(null, nodeXml, null, "");
                            JOptionPane.showMessageDialog(editor, mxResources.get((String)"stencilImported", (String[])new String[]{name}));
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
    }

    public static class NewNESTWorkflowAction
    extends AbstractAction {
        private NESTWorkflowClass nestWorkflowClass;

        public NewNESTWorkflowAction(NESTWorkflowClass nestWorkflowClass) {
            this.nestWorkflowClass = nestWorkflowClass;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NESTWorkflowObject newNestWorkflow = (NESTWorkflowObject)this.nestWorkflowClass.newObject();
            newNestWorkflow.setId("New_NESTWorkflow");
            new NESTWorkflowEditor((NESTAbstractWorkflowObject)newNestWorkflow);
        }
    }

    public static class WarningAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                Object[] cells = graphComponent.getGraph().getSelectionCells();
                if (cells != null && cells.length > 0) {
                    String warning = JOptionPane.showInputDialog(mxResources.get((String)"enterWarningMessage"));
                    for (int i = 0; i < cells.length; ++i) {
                        graphComponent.setCellWarning(cells[i], warning);
                    }
                } else {
                    JOptionPane.showMessageDialog((Component)graphComponent, mxResources.get((String)"noCellSelected"));
                }
            }
        }
    }

    public static class FontStyleAction
    extends AbstractAction {
        protected boolean bold;

        public FontStyleAction(boolean bold) {
            this.bold = bold;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                Component editorComponent = null;
                if (graphComponent.getCellEditor() instanceof mxCellEditor) {
                    editorComponent = ((mxCellEditor)graphComponent.getCellEditor()).getEditor();
                }
                if (editorComponent instanceof JEditorPane) {
                    JEditorPane editorPane = (JEditorPane)editorComponent;
                    int start = editorPane.getSelectionStart();
                    int ende = editorPane.getSelectionEnd();
                    String text = editorPane.getSelectedText();
                    if (text == null) {
                        text = "";
                    }
                    try {
                        HTMLEditorKit editorKit = new HTMLEditorKit();
                        HTMLDocument document = (HTMLDocument)editorPane.getDocument();
                        document.remove(start, ende - start);
                        editorKit.insertHTML(document, start, (this.bold ? "<b>" : "<i>") + text + (this.bold ? "</b>" : "</i>"), 0, 0, this.bold ? HTML.Tag.B : HTML.Tag.I);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    editorPane.requestFocus();
                    editorPane.select(start, ende);
                } else {
                    mxIGraphModel model = graphComponent.getGraph().getModel();
                    model.beginUpdate();
                    try {
                        graphComponent.stopEditing(false);
                        graphComponent.getGraph().toggleCellStyleFlags(mxConstants.STYLE_FONTSTYLE, this.bold ? 1 : 2);
                    }
                    finally {
                        model.endUpdate();
                    }
                }
            }
        }
    }

    public static class HistoryAction
    extends AbstractAction {
        protected boolean undo;

        public HistoryAction(boolean undo) {
            this.undo = undo;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicGraphEditor editor = EditorActions.getEditor(e);
            if (editor != null) {
                if (this.undo) {
                    editor.getUndoManager().undo();
                } else {
                    editor.getUndoManager().redo();
                }
            }
        }
    }

    public static class TogglePropertyItem
    extends JCheckBoxMenuItem {
        public TogglePropertyItem(Object target, String name, String fieldname) {
            this(target, name, fieldname, false);
        }

        public TogglePropertyItem(Object target, String name, String fieldname, boolean refresh) {
            this(target, name, fieldname, refresh, null);
        }

        public TogglePropertyItem(final Object target, String name, final String fieldname, final boolean refresh, ActionListener listener) {
            super(name);
            if (listener != null) {
                this.addActionListener(listener);
            }
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.execute(target, fieldname, refresh);
                }
            });
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equalsIgnoreCase(fieldname)) {
                        this.update(target, fieldname);
                    }
                }
            };
            if (target instanceof mxGraphComponent) {
                ((mxGraphComponent)target).addPropertyChangeListener(propertyChangeListener);
            } else if (target instanceof mxGraph) {
                ((mxGraph)target).addPropertyChangeListener(propertyChangeListener);
            }
            this.update(target, fieldname);
        }

        public void update(Object target, String fieldname) {
            if (target != null && fieldname != null) {
                try {
                    Object current;
                    Method getter = target.getClass().getMethod("is" + fieldname, new Class[0]);
                    if (getter != null && (current = getter.invoke(target, new Object[0])) instanceof Boolean) {
                        this.setSelected((Boolean)current);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void execute(Object target, String fieldname, boolean refresh) {
            if (target != null && fieldname != null) {
                try {
                    Method getter = target.getClass().getMethod("is" + fieldname, new Class[0]);
                    Method setter = target.getClass().getMethod("set" + fieldname, Boolean.TYPE);
                    Object current = getter.invoke(target, new Object[0]);
                    if (current instanceof Boolean) {
                        boolean value = (Boolean)current == false;
                        setter.invoke(target, value);
                        this.setSelected(value);
                    }
                    if (refresh) {
                        mxGraph graph = null;
                        if (target instanceof mxGraph) {
                            graph = (mxGraph)target;
                        } else if (target instanceof mxGraphComponent) {
                            graph = ((mxGraphComponent)target).getGraph();
                        }
                        graph.refresh();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static class PromptPropertyAction
    extends AbstractAction {
        protected Object target;
        protected String fieldname;
        protected String message;

        public PromptPropertyAction(Object target, String message) {
            this(target, message, message);
        }

        public PromptPropertyAction(Object target, String message, String fieldname) {
            this.target = target;
            this.message = message;
            this.fieldname = fieldname;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof Component) {
                try {
                    Method getter = this.target.getClass().getMethod("get" + this.fieldname, new Class[0]);
                    Object current = getter.invoke(this.target, new Object[0]);
                    if (current instanceof Integer) {
                        Method setter = this.target.getClass().getMethod("set" + this.fieldname, Integer.TYPE);
                        String value = (String)JOptionPane.showInputDialog((Component)e.getSource(), "Value", this.message, -1, null, null, current);
                        if (value != null) {
                            setter.invoke(this.target, Integer.parseInt(value));
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                graphComponent.repaint();
            }
        }
    }

    public static class ToggleCreateTargetItem
    extends JCheckBoxMenuItem {
        public ToggleCreateTargetItem(final BasicGraphEditor editor, String name) {
            super(name);
            this.setSelected(true);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    mxGraphComponent graphComponent = editor.getGraphComponent();
                    if (graphComponent != null) {
                        mxConnectionHandler handler;
                        handler.setCreateTarget(!(handler = graphComponent.getConnectionHandler()).isCreateTarget());
                        this.setSelected(handler.isCreateTarget());
                    }
                }
            });
        }
    }

    public static class ToggleConnectModeAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxConnectionHandler handler;
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                handler.setHandleEnabled(!(handler = graphComponent.getConnectionHandler()).isHandleEnabled());
            }
        }
    }

    public static class ToggleDirtyAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                graphComponent.showDirtyRectangle = !graphComponent.showDirtyRectangle;
            }
        }
    }

    public static class SelectSpanningTreeAction
    extends AbstractAction {
        protected boolean directed;

        public SelectSpanningTreeAction(boolean directed) {
            this.directed = directed;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                mxGraph graph = graphComponent.getGraph();
                mxIGraphModel model = graph.getModel();
                Object parent = graph.getDefaultParent();
                Object[] cells = graph.getSelectionCells();
                for (int i = 0; i < cells.length; ++i) {
                    if (model.getChildCount(cells[i]) <= 0) continue;
                    parent = cells[i];
                    break;
                }
                Object[] v = graph.getChildVertices(parent);
                Object[] mst = mxGraphAnalysis.getInstance().getMinimumSpanningTree(graph, v, (mxICostFunction)new mxDistanceCostFunction(), this.directed);
                graph.setSelectionCells(mst);
            }
        }
    }

    public static class SelectShortestPathAction
    extends AbstractAction {
        protected boolean directed;

        public SelectShortestPathAction(boolean directed) {
            this.directed = directed;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                mxGraph graph = graphComponent.getGraph();
                mxIGraphModel model = graph.getModel();
                Object source = null;
                Object target = null;
                Object[] cells = graph.getSelectionCells();
                for (int i = 0; i < cells.length; ++i) {
                    if (model.isVertex(cells[i])) {
                        if (source == null) {
                            source = cells[i];
                        } else if (target == null) {
                            target = cells[i];
                        }
                    }
                    if (source != null && target != null) break;
                }
                if (source != null && target != null) {
                    int steps = graph.getChildEdges(graph.getDefaultParent()).length;
                    Object[] path = mxGraphAnalysis.getInstance().getShortestPath(graph, source, target, (mxICostFunction)new mxDistanceCostFunction(), steps, this.directed);
                    graph.setSelectionCells(path);
                } else {
                    JOptionPane.showMessageDialog((Component)graphComponent, mxResources.get((String)"noSourceAndTargetSelected"));
                }
            }
        }
    }

    @XmlRootElement(name="GraphAppearance")
    public static class GraphAppearance
    implements Serializable {
        @XmlElementWrapper(name="Cells")
        @XmlElement(name="Cell")
        List<Cell> cells = new LinkedList<Cell>();
        @XmlElement(name="mxStylesheet")
        mxStylesheet stylesheet;

        public GraphAppearance() {
        }

        public GraphAppearance(NESTWorkflowEditor.CustomGraphComponent graphComponent) {
            mxGraph graph = graphComponent.getGraph();
            Map cells = ((mxGraphModel)graph.getModel()).getCells();
            cells.values().stream().map(mxICell.class::cast).forEach(mxCell2 -> {
                Cell cell = new Cell();
                cell.id = mxCell2.getId();
                cell.geometry = mxCell2.getGeometry();
                cell.style = mxCell2.getStyle();
                this.handleSemanticDescriptorNodeConnectorCell(cell, (mxICell)mxCell2);
                this.handleSemanticDescriptorNodeCell(cell, (mxICell)mxCell2);
                this.cells.add(cell);
            });
            try {
                this.stylesheet = (mxStylesheet)JAXBUtil.unmarshall((String)graphComponent.getStylesheet(), mxStylesheet.class);
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
        }

        private void handleSemanticDescriptorNodeConnectorCell(Cell cell, mxICell mxCell2) {
            boolean isSDNConnector = mxCell2.getId().startsWith("SDNC/");
            if (isSDNConnector) {
                cell.sourceId = mxCell2.getTerminal(true).getId();
                cell.targetId = mxCell2.getTerminal(false).getId();
            }
        }

        private void handleSemanticDescriptorNodeCell(Cell cell, mxICell mxCell2) {
            boolean isSDN = mxCell2.getId().startsWith("SDN/");
            if (isSDN) {
                cell.value = mxCell2.getValue().toString();
            }
        }

        public void applyTo(mxGraph graph) {
            Map mxCells = ((mxGraphModel)graph.getModel()).getCells();
            try {
                graph.getModel().beginUpdate();
                this.cells.stream().filter(cell -> mxCells.containsKey(cell.id)).forEach(cell -> this.applyCellAppearance(graph, (Cell)cell, (mxICell)mxCells.get(cell.id)));
                this.cells.stream().filter(cell -> !mxCells.containsKey(cell.id) && cell.id.startsWith("SDN/")).forEach(cell -> this.insertSemanticDescriptorVertex(graph, (Cell)cell));
                this.cells.stream().filter(cell -> !mxCells.containsKey(cell.id) && cell.id.startsWith("SDNC/")).forEach(cell -> this.insertSemanticDescriptorNodeConnector(graph, (Cell)cell));
            }
            finally {
                graph.getModel().endUpdate();
            }
        }

        private void applyCellAppearance(mxGraph graph, Cell cellAppearance, mxICell mxCell2) {
            if (cellAppearance.geometry != null) {
                graph.getModel().setGeometry((Object)mxCell2, cellAppearance.geometry);
            }
            if (cellAppearance.style != null) {
                graph.getModel().setStyle((Object)mxCell2, cellAppearance.style);
            }
        }

        private void insertSemanticDescriptorVertex(mxGraph graph, Cell cellAppearance) {
            Object test = graph.insertVertex(graph.getDefaultParent(), cellAppearance.id, (Object)cellAppearance.value, cellAppearance.geometry.getX(), cellAppearance.geometry.getY(), cellAppearance.geometry.getWidth(), cellAppearance.geometry.getHeight(), cellAppearance.style);
        }

        private void insertSemanticDescriptorNodeConnector(mxGraph graph, Cell cellAppearance) {
            Map mxCells = ((mxGraphModel)graph.getModel()).getCells();
            mxICell sourceCell = (mxICell)mxCells.get(cellAppearance.sourceId);
            mxICell targetCell = (mxICell)mxCells.get(cellAppearance.targetId);
            graph.insertEdge(graph.getDefaultParent(), cellAppearance.id, null, (Object)sourceCell, (Object)targetCell, cellAppearance.style);
        }

        public mxStylesheet getStylesheet() {
            return this.stylesheet;
        }

        @XmlRootElement(name="mxStylesheet")
        public static class mxStylesheet {
            @XmlElement(name="add")
            List<add> adds;

            static class add {
                @XmlElement(name="add")
                List<add> adds;
                @XmlAttribute(name="as")
                String as;
                @XmlAttribute(name="value")
                String value;
                @XmlAttribute(name="extend")
                String extend;

                add() {
                }
            }
        }

        static class Cell {
            @XmlElement(name="id")
            String id;
            @XmlElement(name="sourceId")
            String sourceId;
            @XmlElement(name="targetId")
            String targetId;
            @XmlElement(name="value")
            String value;
            @XmlElement(name="geometry")
            mxGeometry geometry;
            @XmlElement(name="style")
            String style;

            Cell() {
            }
        }
    }

    @XmlRootElement(name="NESTWorkflowEditorConfig")
    public static class NESTWorkflowEditorConfig {
        private NESTWorkflowEditor nestWorkflowEditor;
        @XmlElement(name="GraphAppearance")
        GraphAppearance graphAppearance;
        @XmlElement(name="LayoutConfig")
        NESTWorkflowLayout.LayoutConfig layoutConfig;

        public NESTWorkflowEditorConfig(NESTWorkflowEditor nestWorkflowEditor) {
            this.nestWorkflowEditor = nestWorkflowEditor;
            this.layoutConfig = ((NESTWorkflowEditor.CustomGraph)nestWorkflowEditor.getGraphComponent().getGraph()).getLayout().getLayoutConfig();
            this.graphAppearance = new GraphAppearance((NESTWorkflowEditor.CustomGraphComponent)nestWorkflowEditor.getGraphComponent());
        }

        public NESTWorkflowEditorConfig() {
        }

        public GraphAppearance getGraphAppearance() {
            return this.graphAppearance;
        }

        public void applyTo(NESTWorkflowEditor nestWorkflowEditor) throws JAXBException {
            mxGraph graph = nestWorkflowEditor.getGraphComponent().getGraph();
            this.getGraphAppearance().applyTo(graph);
            String stylesheetXml = JAXBUtil.marshall((Object)this.getGraphAppearance().getStylesheet());
            ((NESTWorkflowEditor.CustomGraphComponent)nestWorkflowEditor.getGraphComponent()).setStylesheet(stylesheetXml);
            NESTWorkflowLayout layout = ((NESTWorkflowEditor.CustomGraph)nestWorkflowEditor.getGraphComponent().getGraph()).getLayout();
            layout.setLayoutConfig(this.layoutConfig);
        }
    }

    public static class ExportAsAction
    extends AbstractAction {
        protected boolean showDialog;
        protected String lastDir = null;
        private List<DefaultFileFilter> fileFilters = new LinkedList<DefaultFileFilter>();

        public ExportAsAction(boolean showDialog) {
            this.showDialog = showDialog;
            this.fileFilters.add(new DefaultFileFilter(".xml", "XML " + mxResources.get((String)"file") + " (.xml)"));
            this.fileFilters.add(new DefaultFileFilter(".svg", "SVG " + mxResources.get((String)"file") + " (.svg)"));
            this.putValue("ShortDescription", mxResources.get((String)"exportAs"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NESTWorkflowEditor editor = (NESTWorkflowEditor)EditorActions.getEditor(e);
            if (editor != null) {
                mxGraphComponent graphComponent = editor.getGraphComponent();
                mxGraph graph = graphComponent.getGraph();
                if (!this.validateNESTWorkflow(editor)) {
                    return;
                }
                FileFilter selectedFilter = null;
                Object filename = null;
                boolean dialogShown = false;
                if (this.showDialog || editor.getCurrentFile() == null) {
                    String wd = this.lastDir != null ? this.lastDir : (editor.getCurrentFile() != null ? editor.getCurrentFile().getParent() : System.getProperty("user.dir"));
                    JFileChooser fc = new JFileChooser(wd);
                    this.fileFilters.forEach(fc::addChoosableFileFilter);
                    fc.setFileFilter(this.fileFilters.get(0));
                    int rc = fc.showDialog(null, mxResources.get((String)"save"));
                    dialogShown = true;
                    if (rc != 0) {
                        return;
                    }
                    this.lastDir = fc.getSelectedFile().getParent();
                    filename = fc.getSelectedFile().getAbsolutePath();
                    selectedFilter = fc.getFileFilter();
                    if (selectedFilter instanceof DefaultFileFilter) {
                        String ext = ((DefaultFileFilter)selectedFilter).getExtension();
                        if (!((String)filename).toLowerCase().endsWith(ext)) {
                            filename = (String)filename + ext;
                        }
                    }
                    if (new File((String)filename).exists() && JOptionPane.showConfirmDialog((Component)graphComponent, mxResources.get((String)"overwriteExistingFile")) != 0) {
                        return;
                    }
                } else {
                    filename = editor.getCurrentFile().getAbsolutePath();
                }
                try {
                    String ext = ((String)filename).substring(((String)filename).lastIndexOf(46) + 1);
                    if (ext.equalsIgnoreCase("svg")) {
                        mxSvgCanvas canvas = (mxSvgCanvas)mxCellRenderer.drawCells((mxGraph)graph, null, (double)1.0, null, (mxCellRenderer.CanvasFactory)new mxCellRenderer.CanvasFactory(){

                            public mxICanvas createCanvas(int width, int height) {
                                mxSvgCanvasWithStencilSupport canvas = new mxSvgCanvasWithStencilSupport(mxDomUtils.createSvgDocument((int)width, (int)height));
                                canvas.setEmbedded(true);
                                return canvas;
                            }
                        });
                        mxUtils.writeFile((String)mxXmlUtils.getXml((Node)canvas.getDocument()), (String)filename);
                    } else if (ext.equalsIgnoreCase("xml")) {
                        boolean writeSuccess;
                        boolean bl = writeSuccess = IOUtil.writeFile((Object)((NESTWorkflowEditor.CustomGraph)editor.getGraphComponent().getGraph()).getNestWorkflow(), (String)filename) != null;
                        if (!writeSuccess) {
                            throw new IOException("XML serialization failed. Check stacktrace for details.");
                        }
                        editor.setModified(false);
                        editor.setCurrentFile(new File((String)filename));
                        boolean isExportConfig = (Boolean)EditorActions.getActionFor(ToggleAutoImportExportConfigAction.class).getValue("SwingSelectedKey");
                        if (isExportConfig) {
                            NESTWorkflowEditorConfig config = new NESTWorkflowEditorConfig((NESTWorkflowEditor)EditorActions.getEditor(e));
                            int extensionDelimiterPosition = ((String)filename).lastIndexOf(46);
                            String filenameLayout = ((String)filename).substring(0, extensionDelimiterPosition) + ".config" + ((String)filename).substring(extensionDelimiterPosition);
                            FileUtils.writeStringToFile((File)new File(filenameLayout), (String)JAXBUtil.marshall((Object)config), (Charset)Charset.defaultCharset());
                        }
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog((Component)graphComponent, ex.toString(), mxResources.get((String)"error"), 0);
                }
            }
        }

        private boolean validateNESTWorkflow(NESTWorkflowEditor editor) {
            NESTWorkflowEditor.NESTWorkflowValidatorGUI validatorGUI = editor.getNestWorkflowValidatorGUI();
            if (!validatorGUI.validateNESTWorkflow()) {
                Object[] options = new Object[]{"Save anyway", "Show validator"};
                int userChoice = JOptionPane.showOptionDialog(null, "Graph is not a valid workflow!", "Invalid Workflow Graph", 0, 0, null, options, options[1]);
                if (userChoice == 0) {
                    validatorGUI.dispatchEvent(new WindowEvent(validatorGUI, 201));
                    return true;
                }
                if (userChoice == 1) {
                    validatorGUI.setVisible(true);
                    return false;
                }
                if (userChoice == -1) {
                    return false;
                }
            }
            return true;
        }

        public void setFileFilters(List<DefaultFileFilter> fileFilters) {
            this.fileFilters = fileFilters;
        }
    }

    public static class SaveInObjectAction
    extends AbstractAction {
        public SaveInObjectAction() {
            this.putValue("ShortDescription", mxResources.get((String)"saveChangesToObject"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NESTWorkflowEditor editor = (NESTWorkflowEditor)EditorActions.getEditor(e);
            assert (editor != null);
            editor.saveInObjectNESTWorkflow((NESTWorkflowObject)editor.getNESTWorkflow());
            editor.setModified(false);
            editor.fireGraphSaved();
        }
    }

    public static class PrintAction
    extends AbstractAction {
        public PrintAction() {
            this.putValue("ShortDescription", mxResources.get((String)"print"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                PrinterJob pj = PrinterJob.getPrinterJob();
                if (pj.printDialog()) {
                    PageFormat pf = graphComponent.getPageFormat();
                    Paper paper = new Paper();
                    double margin = 36.0;
                    paper.setImageableArea(margin, margin, paper.getWidth() - margin * 2.0, paper.getHeight() - margin * 2.0);
                    pf.setPaper(paper);
                    pj.setPrintable((Printable)graphComponent, pf);
                    try {
                        pj.print();
                    }
                    catch (PrinterException e2) {
                        System.out.println(e2);
                    }
                }
            }
        }
    }

    public static class PageSetupAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                PrinterJob pj = PrinterJob.getPrinterJob();
                PageFormat format = pj.pageDialog(graphComponent.getPageFormat());
                if (format != null) {
                    graphComponent.setPageFormat(format);
                    graphComponent.zoomAndCenter();
                }
            }
        }
    }

    public static class ScaleAction
    extends AbstractAction {
        protected double scale;

        public ScaleAction(double scale) {
            this.scale = scale;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                String value;
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                double scale = this.scale;
                if (scale == 0.0 && (value = (String)JOptionPane.showInputDialog((Component)graphComponent, mxResources.get((String)"value"), mxResources.get((String)"scale") + " (%)", -1, null, null, "")) != null) {
                    scale = Double.parseDouble(value.replace("%", "")) / 100.0;
                }
                if (scale > 0.0) {
                    graphComponent.zoomTo(scale, graphComponent.isCenterZoom());
                }
            }
        }
    }

    public static class GridColorAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            mxGraphComponent graphComponent;
            Color newColor;
            if (e.getSource() instanceof mxGraphComponent && (newColor = JColorChooser.showDialog((Component)(graphComponent = (mxGraphComponent)e.getSource()), mxResources.get((String)"gridColor"), graphComponent.getGridColor())) != null) {
                graphComponent.setGridColor(newColor);
                graphComponent.repaint();
            }
        }
    }

    public static class GridStyleAction
    extends AbstractAction {
        protected int style;

        public GridStyleAction(int style) {
            this.style = style;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                graphComponent.setGridStyle(this.style);
                graphComponent.repaint();
            }
        }
    }

    public static class ZoomPolicyAction
    extends AbstractAction {
        protected int zoomPolicy;

        public ZoomPolicyAction(int zoomPolicy) {
            this.zoomPolicy = zoomPolicy;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                graphComponent.setPageVisible(true);
                graphComponent.setZoomPolicy(this.zoomPolicy);
            }
        }
    }

    public static class StylesheetAction
    extends AbstractAction {
        protected String stylesheet;

        public StylesheetAction(String stylesheet) {
            this.stylesheet = stylesheet;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof mxGraphComponent) {
                mxGraphComponent graphComponent = (mxGraphComponent)e.getSource();
                mxGraph graph = graphComponent.getGraph();
                mxCodec codec = new mxCodec();
                Document doc = mxUtils.loadDocument((String)EditorActions.class.getResource(this.stylesheet).toString());
                if (doc != null) {
                    codec.decode((Node)doc.getDocumentElement(), (Object)graph.getStylesheet());
                    graph.refresh();
                }
            }
        }
    }

    public static class ExitAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            BasicGraphEditor editor = EditorActions.getEditor(e);
            if (editor != null) {
                editor.exit();
            }
        }
    }

    public static class ToggleOutlineItem
    extends JCheckBoxMenuItem {
        public ToggleOutlineItem(final BasicGraphEditor editor, String name) {
            super(name);
            this.setSelected(true);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    mxGraphOutline outline;
                    outline.setVisible(!(outline = editor.getGraphOutline()).isVisible());
                    outline.revalidate();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (outline.getParent() instanceof JSplitPane) {
                                if (outline.isVisible()) {
                                    ((JSplitPane)outline.getParent()).setDividerLocation(editor.getHeight() - 300);
                                    ((JSplitPane)outline.getParent()).setDividerSize(6);
                                } else {
                                    ((JSplitPane)outline.getParent()).setDividerSize(0);
                                }
                            }
                        }
                    });
                }
            });
        }
    }

    public static class ToggleGridItem
    extends JCheckBoxMenuItem {
        public ToggleGridItem(final BasicGraphEditor editor, String name) {
            super(name);
            this.setSelected(false);
            mxGraphComponent graphComponent = editor.getGraphComponent();
            mxGraph graph = graphComponent.getGraph();
            graph.setGridEnabled(false);
            graphComponent.setGridVisible(false);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    mxGraphComponent graphComponent = editor.getGraphComponent();
                    mxGraph graph = graphComponent.getGraph();
                    boolean enabled = !graph.isGridEnabled();
                    graph.setGridEnabled(enabled);
                    graphComponent.setGridVisible(enabled);
                    graphComponent.repaint();
                    this.setSelected(enabled);
                }
            });
        }
    }

    public static class ToggleRulersItem
    extends JCheckBoxMenuItem {
        public ToggleRulersItem(final BasicGraphEditor editor, String name) {
            super(name);
            this.setSelected(editor.getGraphComponent().getColumnHeader() != null);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    mxGraphComponent graphComponent = editor.getGraphComponent();
                    if (graphComponent.getColumnHeader() != null) {
                        graphComponent.setColumnHeader(null);
                        graphComponent.setRowHeader(null);
                    } else {
                        graphComponent.setColumnHeaderView((Component)new EditorRuler(graphComponent, EditorRuler.ORIENTATION_HORIZONTAL));
                        graphComponent.setRowHeaderView((Component)new EditorRuler(graphComponent, EditorRuler.ORIENTATION_VERTICAL));
                    }
                }
            });
        }
    }

    public static class LayoutNESTWorkflowAction
    extends AbstractAction {
        NESTWorkflowEditor.CustomGraph customGraph;

        public LayoutNESTWorkflowAction() {
            super("Execute layout");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            mxGraphComponent graphComponent = EditorActions.getEditor(actionEvent).getGraphComponent();
            ((NESTWorkflowEditor.CustomGraph)graphComponent.getGraph()).executeLayout();
            graphComponent.refresh();
        }
    }

    public static class ValidateNESTWorkflowAction
    extends AbstractAction {
        public ValidateNESTWorkflowAction() {
            super("Validate NESTWorkflow");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NESTWorkflowEditor.NESTWorkflowValidatorGUI nestWorkflowValidatorGUI = ((NESTWorkflowEditor)EditorActions.getEditor(actionEvent)).getNestWorkflowValidatorGUI();
            nestWorkflowValidatorGUI.validateNESTWorkflow();
            nestWorkflowValidatorGUI.setVisible(true);
        }
    }

    public static class EditStylesheetAction
    extends AbstractAction {
        public EditStylesheetAction() {
            super("Edit stylesheet");
            this.putValue("ShortDescription", "<html><p width='300'>Opens an editor for the stylesheet XML</p></html>");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(() -> new StylesheetEditor((NESTWorkflowEditor.CustomGraphComponent)EditorActions.getEditor(actionEvent).getGraphComponent()));
        }
    }

    private static class ToggleNodeVisibilityAction
    extends AbstractAction {
        private Predicate<? super NESTNodeObject> nodeFilter;

        public ToggleNodeVisibilityAction(String name, Predicate<? super NESTNodeObject> nodeFilter) {
            super(name);
            this.putValue("SwingSelectedKey", true);
            this.nodeFilter = nodeFilter;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(() -> {
                BasicGraphEditor editor = EditorActions.getEditor(e);
                mxGraph graph = editor.getGraphComponent().getGraph();
                Collection cells = ((mxGraphModel)graph.getModel()).getCells().values().stream().map(mxICell.class::cast).collect(Collectors.toList());
                List<mxICell> cellsToToggle = cells.stream().filter(nodeCell -> nodeCell.getValue() instanceof NESTNodeObject && this.nodeFilter.test((NESTNodeObject)((NESTNodeObject)nodeCell.getValue()))).collect(Collectors.toList());
                graph.getModel().beginUpdate();
                try {
                    cellsToToggle.forEach(cell -> graph.getModel().setVisible(cell, ((Boolean)this.getValue("SwingSelectedKey")).booleanValue()));
                }
                finally {
                    graph.getModel().endUpdate();
                }
            });
        }
    }

    public static class AddSemanticDescriptorNodeAction
    extends AbstractAction {
        public static final String SEMANTIC_DESCRIPTOR_NODE_ID_PREFIX = "SDN/";
        public static final String SEMANTIC_DESCRIPTOR_NODE_CONNECTOR_ID_PREFIX = "SDNC/";
        private List<mxICell> cells;
        private NESTWorkflowEditor editor;

        public AddSemanticDescriptorNodeAction(List<mxICell> cells) {
            super("Add semantic descriptor node");
            this.cells = cells;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(() -> {
                this.editor = (NESTWorkflowEditor)EditorActions.getEditor(e);
                mxGraph graph = this.editor.getGraphComponent().getGraph();
                graph.getModel().beginUpdate();
                try {
                    this.cells.forEach(cell -> this.addSemanticDescriptorNode((mxICell)cell, graph));
                }
                finally {
                    graph.getModel().endUpdate();
                }
            });
        }

        private void addSemanticDescriptorNode(mxICell cell, mxGraph graph) {
            DataObject semanticDescriptor = ((NESTGraphItemObject)cell.getValue()).getSemanticDescriptor();
            String semanticDescriptorVertexContent = "null";
            if (semanticDescriptor != null) {
                semanticDescriptorVertexContent = semanticDescriptor.isAggregate() ? Utils.aggregateToPaddedTable((AggregateObject)semanticDescriptor, false) : semanticDescriptor.toString();
            }
            double semanticDescriptorVertexX = cell.getGeometry().getX();
            double semanticDescriptorVertexY = cell.getGeometry().getY();
            if (cell.isEdge()) {
                double sourceCenterX = cell.getTerminal(true).getGeometry().getCenterX();
                double sourceCenterY = cell.getTerminal(true).getGeometry().getCenterY();
                double targetCenterX = cell.getTerminal(false).getGeometry().getCenterX();
                double targetCenterY = cell.getTerminal(false).getGeometry().getCenterY();
                semanticDescriptorVertexX = sourceCenterX - (sourceCenterX - targetCenterX) / 2.0;
                semanticDescriptorVertexY = sourceCenterY - (sourceCenterY - targetCenterY) / 2.0;
            }
            String semanticDescriptorCellsID = UUID.randomUUID().toString();
            mxICell semanticDescriptorVertex = (mxICell)graph.insertVertex(graph.getDefaultParent(), SEMANTIC_DESCRIPTOR_NODE_ID_PREFIX + semanticDescriptorCellsID, (Object)semanticDescriptorVertexContent, semanticDescriptorVertexX, semanticDescriptorVertexY, 50.0, 50.0, "SEMANTIC_DESCRIPTOR_NODE_STYLE");
            this.editor.getGraphComponent().labelChanged((Object)semanticDescriptorVertex, semanticDescriptorVertex.getValue(), null);
            graph.insertEdge(graph.getDefaultParent(), SEMANTIC_DESCRIPTOR_NODE_CONNECTOR_ID_PREFIX + semanticDescriptorCellsID, null, (Object)cell, (Object)semanticDescriptorVertex, "SEMANTIC_DESCRIPTOR_NODE_CONNECTOR_STYLE");
        }
    }
}

