/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor;

import com.mxgraph.model.mxICell;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.view.mxICellEditor;
import com.mxgraph.view.mxCellState;
import de.uni_trier.wi2.procake.data.model.DataClass;
import de.uni_trier.wi2.procake.data.model.nest.NESTGraphItemClass;
import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTGraphItemObject;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.DataObjectEditor;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.swing.layouts.BasicGridLayout;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.swing.misc.AutoCompletion;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

public class SemanticDescriptorEditor
implements mxICellEditor {
    public static final String[] SEMANTIC_DESCRIPTOR_CLASS_SELECTOR_BLACKLIST = new String[]{"NESTGraphElement", "AbstractWorkflowItem"};
    static String SEMANTIC_DESCRIPTOR_EDITOR_COMPONENT_NAME = "SemanticDescriptorEditorComponent";
    private mxGraphComponent graphComponent;
    private transient Object editingCell;

    SemanticDescriptorEditor(mxGraphComponent graphComponent) {
        this.graphComponent = graphComponent;
    }

    public Object getEditingCell() {
        return this.editingCell;
    }

    public void startEditing(Object cell, EventObject eventObject) {
        if (this.editingCell != null) {
            this.stopEditing(true);
        }
        new EditorWindow((mxICell)cell);
    }

    public void stopEditing(boolean cancel) {
        this.editingCell = null;
    }

    class EditorWindow
    extends JDialog {
        private DataObjectEditor dataObjectEditor;
        private NESTGraphItemObject graphItem;
        private DataObject modifiedSemanticDescriptor;

        public EditorWindow(final mxICell cell) {
            super((JFrame)SwingUtilities.getWindowAncestor((Component)SemanticDescriptorEditor.this.graphComponent));
            this.dataObjectEditor = new DataObjectEditor(null);
            this.setName(SEMANTIC_DESCRIPTOR_EDITOR_COMPONENT_NAME);
            this.graphItem = (NESTGraphItemObject)cell.getValue();
            this.modifiedSemanticDescriptor = this.graphItem.getSemanticDescriptor() != null ? this.graphItem.getSemanticDescriptor().copy() : null;
            this.setLayout(new BorderLayout());
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    SemanticDescriptorEditor.this.graphComponent.labelChanged((Object)cell, (Object)EditorWindow.this.graphItem, null);
                    SemanticDescriptorEditor.this.graphComponent.requestFocusInWindow();
                }

                @Override
                public void windowClosing(WindowEvent e) {
                }
            });
            this.init();
            this.pack();
            Point mouseLocation = MouseInfo.getPointerInfo().getLocation();
            this.setLocation(Math.max(0, (int)(mouseLocation.getX() - (double)(this.getWidth() / 2))), Math.max(0, (int)(mouseLocation.getY() - (double)(this.getHeight() / 2))));
            this.setDefaultCloseOperation(2);
            this.setVisible(true);
        }

        private void init() {
            this.getContentPane().removeAll();
            this.setTitle("ID: " + this.graphItem.getId() + " (" + this.graphItem.getDataClass() + ")");
            this.addSemanticDescriptorSelectorAndSaveButton(this.graphItem);
            this.addDataObjectEditor(this.modifiedSemanticDescriptor);
            this.revalidate();
        }

        private void addDataObjectEditor(DataObject dataObject) {
            this.dataObjectEditor.setDataObject(dataObject);
            this.dataObjectEditor.setAlignmentX(0.0f);
            int borderWidth = 20;
            this.dataObjectEditor.setBorder(BorderFactory.createEmptyBorder(borderWidth, borderWidth, borderWidth, borderWidth));
            JScrollPane scrollPane = new JScrollPane(this.dataObjectEditor);
            scrollPane.setHorizontalScrollBarPolicy(30);
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.add((Component)scrollPane, "Center");
            this.dataObjectEditor.reload();
        }

        private JButton createSemanticDescriptorSaveButton(NESTGraphItemObject graphItem) {
            JButton saveButton = new JButton("Save Changes");
            saveButton.setMargin(new Insets(2, 2, 2, 2));
            saveButton.addActionListener(e -> {
                graphItem.setSemanticDescriptor(this.modifiedSemanticDescriptor);
                this.dispose();
            });
            return saveButton;
        }

        private void addSemanticDescriptorSelectorAndSaveButton(NESTGraphItemObject graphItem) {
            JPanel panel = new JPanel(new BasicGridLayout(1, 2));
            panel.add(this.createSemanticDescriptorSelector(graphItem));
            panel.add(this.createSemanticDescriptorSaveButton(graphItem));
            this.add((Component)panel, "First");
        }

        private JComboBox createSemanticDescriptorSelector(NESTGraphItemObject graphItem) {
            List<Object> possibleSemanticDescriptorClasses = new ArrayList<DataClass>();
            DataClass semanticDescriptorClass = ((NESTGraphItemClass)graphItem.getDataClass()).getSemanticDescriptorClass();
            if (semanticDescriptorClass != null && semanticDescriptorClass.getSuperClass() != null) {
                possibleSemanticDescriptorClasses.add(semanticDescriptorClass);
                possibleSemanticDescriptorClasses.addAll(Utils.getSubClassesDeep(semanticDescriptorClass));
            } else {
                Set semanticDescriptorClassSelectorBlacklist = Arrays.stream(SEMANTIC_DESCRIPTOR_CLASS_SELECTOR_BLACKLIST).map(className -> graphItem.getModel().getClass(className)).collect(Collectors.toSet());
                possibleSemanticDescriptorClasses.addAll(graphItem.getModel().getClasses().stream().filter(dataClass -> !semanticDescriptorClassSelectorBlacklist.contains(dataClass)).filter(dataClass -> semanticDescriptorClassSelectorBlacklist.stream().noneMatch(arg_0 -> ((DataClass)dataClass).isSubclassOf(arg_0))).toList());
            }
            possibleSemanticDescriptorClasses = possibleSemanticDescriptorClasses.stream().filter(dataClass -> dataClass.isInstantiable() && !dataClass.isUnion()).sorted(Comparator.comparing(DataClass::getName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
            possibleSemanticDescriptorClasses.add(0, null);
            JComboBox semanticDescriptorSelector = new JComboBox(possibleSemanticDescriptorClasses.toArray(DataClass[]::new));
            ListCellRenderer originalRenderer = semanticDescriptorSelector.getRenderer();
            semanticDescriptorSelector.setRenderer((list, value, index, isSelected, cellHasFocus) -> originalRenderer.getListCellRendererComponent(list, value == null ? "null" : value, index, isSelected, cellHasFocus));
            DataClass selectedSemanticDescriptorClass = possibleSemanticDescriptorClasses.stream().filter(dataClass -> this.modifiedSemanticDescriptor != null && this.modifiedSemanticDescriptor.getDataClass() == dataClass).findAny().orElse((DataClass)possibleSemanticDescriptorClasses.get(0));
            semanticDescriptorSelector.setSelectedItem(selectedSemanticDescriptorClass);
            semanticDescriptorSelector.addActionListener(e -> {
                DataClass selectedDataClass = (DataClass)semanticDescriptorSelector.getSelectedItem();
                if (selectedDataClass == null) {
                    this.modifiedSemanticDescriptor = null;
                    this.dataObjectEditor.setDataObject(null);
                    this.dataObjectEditor.reload();
                } else if (this.modifiedSemanticDescriptor == null || !this.modifiedSemanticDescriptor.getDataClass().getName().equals(selectedDataClass.getName())) {
                    DataObject newSemanticDescriptorObject;
                    this.modifiedSemanticDescriptor = newSemanticDescriptorObject = selectedDataClass.newObject();
                    this.dataObjectEditor.setDataObject(newSemanticDescriptorObject);
                    this.dataObjectEditor.reload();
                }
            });
            AutoCompletion.enable(semanticDescriptorSelector);
            semanticDescriptorSelector.setAlignmentX(0.0f);
            return semanticDescriptorSelector;
        }

        private Rectangle getEditorBounds(mxCellState state) {
            int positionX = (int)state.getBoundingBox().getX();
            int positionY = (int)state.getBoundingBox().getY();
            int cellWidth = (int)state.getBoundingBox().getWidth();
            int cellHeight = (int)state.getBoundingBox().getHeight();
            Dimension editorSize = this.getPreferredSize();
            return new Rectangle(positionX, positionY, Math.max((int)editorSize.getWidth(), cellWidth), Math.max((int)editorSize.getHeight(), cellHeight));
        }

        public mxGraphComponent getGraphComponent() {
            return SemanticDescriptorEditor.this.graphComponent;
        }
    }
}

