/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor;

import com.mxgraph.model.mxICell;
import com.mxgraph.util.mxPoint;
import com.mxgraph.view.mxGraph;
import de.uni_trier.wi2.procake.data.model.DataClass;
import de.uni_trier.wi2.procake.data.model.nest.NESTGraphItemClass;
import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTAbstractWorkflowObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTEdgeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTGraphItemObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTSequenceNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTWorkflowNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTWorkflowObject;
import de.uni_trier.wi2.procake.data.object.nest.controlflowNode.NESTControlflowNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.utils.NESTWorkflowModifier;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.NESTWorkflowEditor;
import java.util.Collections;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum NodeInsertType {
    TASK{

        @Override
        NESTGraphItemObject insertNewNESTNode(NESTAbstractWorkflowObject nestWorkflow, mxGraph mxGraph2, mxICell cell) {
            return nestWorkflow.getModifier().insertNewTaskNode(null);
        }
    }
    ,
    DATA{

        @Override
        NESTGraphItemObject insertNewNESTNode(NESTAbstractWorkflowObject nestWorkflow, mxGraph mxGraph2, mxICell cell) {
            return nestWorkflow.getModifier().insertNewDataNode(null);
        }
    }
    ,
    SUBWORKFLOW{

        @Override
        NESTGraphItemObject insertNewNESTNode(NESTAbstractWorkflowObject nestWorkflow, mxGraph mxGraph2, mxICell cell) {
            return nestWorkflow.getModifier().insertNewSubWorkflowNode((NESTNodeObject)nestWorkflow.getWorkflowNode(), null);
        }
    }
    ,
    WORKFLOW{

        @Override
        NESTGraphItemObject insertNewNESTNode(NESTAbstractWorkflowObject nestWorkflow, mxGraph mxGraph2, mxICell cell) {
            NESTWorkflowNodeObject workflowNode = (NESTWorkflowNodeObject)nestWorkflow.getModel().createObject("NESTWorkflowNode");
            workflowNode = (NESTWorkflowNodeObject)nestWorkflow.getIDManager().assignUniqueNodeId((NESTNodeObject)workflowNode);
            nestWorkflow.addGraphNode((NESTNodeObject)workflowNode);
            return workflowNode;
        }
    }
    ,
    AND_BLOCK{

        @Override
        NESTGraphItemObject insertNewNESTNode(NESTAbstractWorkflowObject nestWorkflow, mxGraph mxGraph2, mxICell startCell) {
            return this.insertAndBlock((NESTWorkflowObject)nestWorkflow, mxGraph2, startCell);
        }
    }
    ,
    XOR_BLOCK{

        @Override
        NESTGraphItemObject insertNewNESTNode(NESTAbstractWorkflowObject nestWorkflow, mxGraph mxGraph2, mxICell startCell) {
            return this.insertXorBlock((NESTWorkflowObject)nestWorkflow, mxGraph2, startCell);
        }
    }
    ,
    OR_BLOCK{

        @Override
        NESTGraphItemObject insertNewNESTNode(NESTAbstractWorkflowObject nestWorkflow, mxGraph mxGraph2, mxICell startCell) {
            return this.insertOrBlock((NESTWorkflowObject)nestWorkflow, mxGraph2, startCell);
        }
    }
    ,
    LOOP_BLOCK{

        @Override
        NESTGraphItemObject insertNewNESTNode(NESTAbstractWorkflowObject nestWorkflow, mxGraph mxGraph2, mxICell startCell) {
            return this.insertLoopBlock((NESTWorkflowObject)nestWorkflow, mxGraph2, startCell);
        }
    };


    public static NodeInsertType get(NESTNodeObject node) throws Exception {
        if (node.isNESTTaskNode()) {
            return TASK;
        }
        if (node.isNESTDataNode()) {
            return DATA;
        }
        if (node.isNESTSubWorkflowNode()) {
            return SUBWORKFLOW;
        }
        if (node.isNESTWorkflowNode()) {
            return WORKFLOW;
        }
        if (node.isNESTControlflowNode()) {
            NESTControlflowNodeObject controlflowNode = (NESTControlflowNodeObject)node;
            if (controlflowNode.isAndEndNode()) {
                return AND_BLOCK;
            }
            if (controlflowNode.isXorEndNode()) {
                return XOR_BLOCK;
            }
            if (controlflowNode.isLoopStartNode()) {
                return LOOP_BLOCK;
            }
        }
        throw new Exception("Unsupported node type: " + node.getDataClass());
    }

    abstract NESTGraphItemObject insertNewNESTNode(NESTAbstractWorkflowObject var1, mxGraph var2, mxICell var3);

    public NESTGraphItemObject doInsertion(NESTAbstractWorkflowObject nestWorkflow, mxGraph mxGraph2, mxICell cell) {
        NESTGraphItemObject insertedNode;
        NESTWorkflowEditor.CustomGraph customGraph = (NESTWorkflowEditor.CustomGraph)mxGraph2;
        DataClass semanticDescriptorClass = ((NESTGraphItemClass)(insertedNode = this.insertNewNESTNode(nestWorkflow, mxGraph2, cell)).getDataClass()).getSemanticDescriptorClass();
        insertedNode.setSemanticDescriptor(semanticDescriptorClass == null || !semanticDescriptorClass.isInstantiable() ? null : semanticDescriptorClass.newObject());
        customGraph.setCellId(cell, insertedNode.getId());
        customGraph.syncOutgoingEdges((NESTNodeObject)insertedNode);
        cell.getGeometry().setHeight((double)customGraph.getLayout().getLayoutConfig().getNodeHeight());
        mxGraph2.cellLabelChanged((Object)cell, (Object)insertedNode, true);
        return insertedNode;
    }

    public NESTGraphItemObject insertXorBlock(NESTWorkflowObject nestWorkflow, mxGraph mxGraph2, mxICell startCell) {
        NESTWorkflowModifier modifier = nestWorkflow.getModifier();
        NESTWorkflowModifier.NESTControlflowNodePair pair = modifier.insertNewXorSequence(null, null);
        return this.insertControlflowBlock(nestWorkflow, mxGraph2, startCell, pair);
    }

    public NESTGraphItemObject insertOrBlock(NESTWorkflowObject nestWorkflow, mxGraph mxGraph2, mxICell startCell) {
        NESTWorkflowModifier modifier = nestWorkflow.getModifier();
        NESTWorkflowModifier.NESTControlflowNodePair pair = modifier.insertNewOrSequence(null, null);
        return this.insertControlflowBlock(nestWorkflow, mxGraph2, startCell, pair);
    }

    public NESTGraphItemObject insertAndBlock(NESTWorkflowObject nestWorkflow, mxGraph mxGraph2, mxICell startCell) {
        NESTWorkflowModifier modifier = nestWorkflow.getModifier();
        NESTWorkflowModifier.NESTControlflowNodePair pair = modifier.insertNewAndSequence(null, null);
        return this.insertControlflowBlock(nestWorkflow, mxGraph2, startCell, pair);
    }

    public NESTGraphItemObject insertLoopBlock(NESTWorkflowObject nestWorkflow, mxGraph mxGraph2, mxICell startCell) {
        NESTWorkflowModifier modifier = nestWorkflow.getModifier();
        NESTWorkflowModifier.NESTControlflowNodePair pair = modifier.insertNewLoopSequence(null, null);
        return this.insertControlflowBlock(nestWorkflow, mxGraph2, startCell, pair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NESTGraphItemObject insertControlflowBlock(NESTWorkflowObject nestWorkflow, mxGraph mxGraph2, mxICell startCell, NESTWorkflowModifier.NESTControlflowNodePair pair) {
        NESTWorkflowModifier modifier = nestWorkflow.getModifier();
        mxGraph2.getModel().beginUpdate();
        try {
            ((NESTWorkflowEditor.CustomGraph)mxGraph2).setCellId(startCell, pair.getStartNode().getId());
            mxICell endCell = (mxICell)mxGraph2.insertVertex(mxGraph2.getDefaultParent(), pair.getEndNode().getId(), (Object)pair.getEndNode(), startCell.getGeometry().getX() + 250.0, startCell.getGeometry().getY(), (double)((NESTWorkflowEditor.CustomGraph)mxGraph2).getLayout().getLayoutConfig().getNodeWidth(), (double)((NESTWorkflowEditor.CustomGraph)mxGraph2).getLayout().getLayoutConfig().getNodeHeight(), NESTWorkflowEditor.CellStyle.get((NESTNodeObject)pair.getEndNode()));
            pair.getEndNode().getOutgoingEdges().stream().filter(DataObject::isNESTPartOfEdge).forEach(((NESTWorkflowEditor.CustomGraph)mxGraph2)::syncEdge);
            NESTEdgeObject newNESTEdge = modifier.insertNewControlflowEdge((NESTSequenceNodeObject)pair.getStartNode(), (NESTSequenceNodeObject)pair.getEndNode(), null);
            mxICell mxEdge = ((NESTWorkflowEditor.CustomGraph)mxGraph2).syncEdge(newNESTEdge);
            double centerX = startCell.getGeometry().getX() + (endCell.getGeometry().getX() - startCell.getGeometry().getX()) / 2.0 + startCell.getGeometry().getWidth() / 2.0;
            if (!pair.getStartNode().isLoopNode()) {
                mxEdge.getGeometry().setPoints(Collections.singletonList(new mxPoint(centerX, startCell.getGeometry().getY() - startCell.getGeometry().getHeight())));
            }
            newNESTEdge = pair.getStartNode().isLoopNode() ? modifier.insertNewControlflowEdge((NESTSequenceNodeObject)pair.getEndNode(), (NESTSequenceNodeObject)pair.getStartNode(), null) : modifier.insertNewControlflowEdge((NESTSequenceNodeObject)pair.getStartNode(), (NESTSequenceNodeObject)pair.getEndNode(), null);
            mxEdge = ((NESTWorkflowEditor.CustomGraph)mxGraph2).syncEdge(newNESTEdge);
            if (!pair.getStartNode().isLoopNode()) {
                mxEdge.getGeometry().setPoints(Collections.singletonList(new mxPoint(centerX, startCell.getGeometry().getY() + startCell.getGeometry().getHeight() * 2.0)));
            } else {
                mxEdge.getGeometry().setPoints(Collections.singletonList(new mxPoint(centerX, startCell.getGeometry().getY() - startCell.getGeometry().getHeight())));
            }
        }
        finally {
            mxGraph2.getModel().endUpdate();
        }
        return pair.getStartNode();
    }
}

