/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor;

import com.mxgraph.io.mxCodec;
import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxICell;
import com.mxgraph.swing.handler.mxCellHandler;
import com.mxgraph.swing.handler.mxConnectionHandler;
import com.mxgraph.swing.handler.mxEdgeHandler;
import com.mxgraph.swing.handler.mxElbowEdgeHandler;
import com.mxgraph.swing.handler.mxVertexHandler;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxGraphTransferable;
import com.mxgraph.swing.util.mxSwingConstants;
import com.mxgraph.swing.view.mxICellEditor;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxEvent;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxResources;
import com.mxgraph.util.mxUtils;
import com.mxgraph.util.mxXmlUtils;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxEdgeStyle;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxStylesheet;
import de.uni_trier.wi2.procake.data.model.DataClass;
import de.uni_trier.wi2.procake.data.model.nest.NESTGraphClass;
import de.uni_trier.wi2.procake.data.model.nest.controlflowNode.NESTControlflowNodeClass;
import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.data.object.base.AggregateObject;
import de.uni_trier.wi2.procake.data.object.base.AtomicObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTAbstractWorkflowObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTControlflowEdgeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTEdgeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTGraphItemObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTSubWorkflowNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTTaskNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTWorkflowObject;
import de.uni_trier.wi2.procake.data.object.nest.controlflowNode.NESTControlflowNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.utils.impl.NESTSequentialWorkflowValidatorImpl;
import de.uni_trier.wi2.procake.data.object.nest.utils.impl.NESTWorkflowValidatorImpl;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.CellAddListener;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.CellLabelGenerator;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.CellRemoveListener;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.EdgeCreationListener;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.EdgeSplitListener;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.EdgeTerminalModificationListener;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.NESTWorkflowLayout;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.NESTWorkflowLayoutForMxGraph;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.NodeInsertType;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.SemanticDescriptorEditor;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.StringCellEditor;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor.BasicGraphEditor;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor.EditorActions;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor.EditorMenuBar;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor.EditorPalette;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.swing.layouts.BasicGridLayout;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.utils.Utils;
import de.uni_trier.wi2.procake.utils.io.IOUtil;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class NESTWorkflowEditor
extends BasicGraphEditor {
    public static final String DEFAULT_STYLE_XML_PATH = "/objecteditor/nestworkfloweditor/default-style.xml";
    private static final long serialVersionUID = -4601740824088314699L;
    private static final Object windowCloseLock = new Object();
    private NESTAbstractWorkflowObject nestWorkflow;
    private JFrame editorFrame;
    private JSplitPane mainSplitPane;
    protected NESTWorkflowValidatorGUI nestWorkflowValidatorGUI;
    private Set<GraphSaveListener> graphSaveListeners = new HashSet<GraphSaveListener>();

    public NESTWorkflowEditor(NESTAbstractWorkflowObject nestWorkflow) {
        this(nestWorkflow, false, false);
    }

    public NESTWorkflowEditor(NESTAbstractWorkflowObject nestWorkflow, boolean blockThreadUntilEditorWindowClosed) {
        this(nestWorkflow, false, blockThreadUntilEditorWindowClosed);
    }

    public NESTWorkflowEditor(NESTAbstractWorkflowObject nestWorkflow, boolean frameless, boolean blockThreadUntilEditorWindowClosed) {
        this("NESTWorkflow Editor", new CustomGraphComponent(new CustomGraph()), frameless, true, (NESTGraphClass)nestWorkflow.getDataClass());
        this.nestWorkflow = nestWorkflow;
        try {
            SwingUtilities.invokeLater(this::initEditor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.nestWorkflowValidatorGUI = new NESTWorkflowValidatorGUI(this);
        if (!frameless && blockThreadUntilEditorWindowClosed) {
            this.waitUntilEditorWindowClosed();
        }
    }

    public NESTWorkflowEditor(NESTAbstractWorkflowObject nestWorkflow, boolean frameless, boolean blockThreadUntilEditorWindowClosed, boolean useWorkingCopy, boolean generateToolbar) {
        this("NESTWorkflow Editor", new CustomGraphComponent(new CustomGraph()), frameless, generateToolbar, (NESTGraphClass)nestWorkflow.getDataClass());
        this.nestWorkflow = useWorkingCopy ? nestWorkflow : (NESTAbstractWorkflowObject)nestWorkflow.copy();
        try {
            SwingUtilities.invokeLater(this::initEditor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.nestWorkflowValidatorGUI = new NESTWorkflowValidatorGUI(this);
        if (!frameless && blockThreadUntilEditorWindowClosed) {
            this.waitUntilEditorWindowClosed();
        }
    }

    public NESTWorkflowEditor(String appTitle, mxGraphComponent component, boolean frameless, boolean generateToolbar, NESTGraphClass nestClass) {
        super(appTitle, component, frameless, generateToolbar);
        final mxGraph graph = this.graphComponent.getGraph();
        EditorPalette shapesPalette = this.insertPalette(mxResources.get((String)"shapes"));
        shapesPalette.addListener("select", new mxEventSource.mxIEventListener(){

            public void invoke(Object sender, mxEventObject evt) {
                Object tmp = evt.getProperty("transferable");
                if (tmp instanceof mxGraphTransferable) {
                    mxGraphTransferable t = (mxGraphTransferable)tmp;
                    Object cell = t.getCells()[0];
                    if (graph.getModel().isEdge(cell)) {
                        ((CustomGraph)graph).setEdgeTemplate(cell);
                    }
                }
            }
        });
        Collection itemClasses = nestClass.getNESTGraphItemClasses();
        try {
            if (itemClasses.stream().anyMatch(DataClass::isNESTWorkflowNode)) {
                shapesPalette.addTemplate("Workflow", new ImageIcon(ImageIO.read(NESTWorkflowEditor.class.getResourceAsStream("/objecteditor/nestworkfloweditor/images/rhombus.png"))), CellStyle.WORKFLOW_NODE_STYLE.name(), 50, 50, (Object)NodeInsertType.WORKFLOW);
            }
            if (itemClasses.stream().anyMatch(DataClass::isNESTSubWorkflowNode)) {
                shapesPalette.addTemplate("Subworkflow", new ImageIcon(ImageIO.read(NESTWorkflowEditor.class.getResourceAsStream("/objecteditor/nestworkfloweditor/images/rhombus.png"))), CellStyle.SUB_WORKFLOW_NODE_STYLE.name(), 50, 50, (Object)NodeInsertType.SUBWORKFLOW);
            }
        }
        catch (IOException e) {
            System.err.println("Error while loading template");
            e.printStackTrace();
        }
        try {
            String nodeXml;
            if (itemClasses.stream().anyMatch(DataClass::isNESTTaskNode)) {
                nodeXml = mxUtils.readInputStream((InputStream)NESTWorkflowEditor.class.getResourceAsStream("/objecteditor/nestworkfloweditor/stencils/Task.shape"));
                EditorActions.ImportAction.addStencilShape(shapesPalette, nodeXml, "/objecteditor/nestworkfloweditor/stencils/Task.png", CellStyle.TASK_NODE_STYLE.name(), (Object)NodeInsertType.TASK);
            }
            if (itemClasses.stream().anyMatch(DataClass::isNESTDataNode)) {
                shapesPalette.addTemplate("Data", new ImageIcon(ImageIO.read(NESTWorkflowEditor.class.getResourceAsStream("/objecteditor/nestworkfloweditor/images/ellipse.png"))), CellStyle.DATA_NODE_STYLE.name(), 80, 50, (Object)NodeInsertType.DATA);
            }
            if (itemClasses.stream().anyMatch(n -> n.isNESTControlflowNode() && ((NESTControlflowNodeClass)n).isAndNode())) {
                nodeXml = mxUtils.readInputStream((InputStream)NESTWorkflowEditor.class.getResourceAsStream("/objecteditor/nestworkfloweditor/stencils/AND.shape"));
                EditorActions.ImportAction.addStencilShape(shapesPalette, nodeXml, "/objecteditor/nestworkfloweditor/stencils/AND.png", CellStyle.AND_SPLIT_NODE_STYLE.name(), (Object)NodeInsertType.AND_BLOCK);
            }
            if (itemClasses.stream().anyMatch(n -> n.isNESTControlflowNode() && ((NESTControlflowNodeClass)n).isXorNode())) {
                nodeXml = mxUtils.readInputStream((InputStream)NESTWorkflowEditor.class.getResourceAsStream("/objecteditor/nestworkfloweditor/stencils/XOR.shape"));
                EditorActions.ImportAction.addStencilShape(shapesPalette, nodeXml, "/objecteditor/nestworkfloweditor/stencils/XOR.png", CellStyle.XOR_SPLIT_NODE_STYLE.name(), (Object)NodeInsertType.XOR_BLOCK);
            }
            if (itemClasses.stream().anyMatch(n -> n.isNESTControlflowNode() && ((NESTControlflowNodeClass)n).isOrNode())) {
                nodeXml = mxUtils.readInputStream((InputStream)NESTWorkflowEditor.class.getResourceAsStream("/objecteditor/nestworkfloweditor/stencils/OR.shape"));
                EditorActions.ImportAction.addStencilShape(shapesPalette, nodeXml, "/objecteditor/nestworkfloweditor/stencils/OR.png", CellStyle.OR_SPLIT_NODE_STYLE.name(), (Object)NodeInsertType.OR_BLOCK);
            }
            if (itemClasses.stream().anyMatch(n -> n.isNESTControlflowNode() && ((NESTControlflowNodeClass)n).isLoopNode())) {
                nodeXml = mxUtils.readInputStream((InputStream)NESTWorkflowEditor.class.getResourceAsStream("/objecteditor/nestworkfloweditor/stencils/LOOP.shape"));
                EditorActions.ImportAction.addStencilShape(shapesPalette, nodeXml, "/objecteditor/nestworkfloweditor/stencils/LOOP.png", CellStyle.LOOP_SPLIT_NODE_STYLE.name(), (Object)NodeInsertType.LOOP_BLOCK);
            }
        }
        catch (IOException e) {
            System.err.println("Error while loading stencil");
            e.printStackTrace();
        }
    }

    private void initEditor() {
        this.getGraphComponent().getConnectionHandler().getMarker().setHotspot(0.95);
        mxSwingConstants.SHADOW_COLOR = Color.LIGHT_GRAY;
        mxConstants.W3C_SHADOWCOLOR = "#D3D3D3";
        CustomGraph customGraph = (CustomGraph)super.getGraphComponent().getGraph();
        customGraph.loadNESTWorkflow(this.nestWorkflow);
        this.applyNodeVisibilitySettings();
        if (!this.frameless) {
            this.mainSplitPane = new JSplitPane(1);
            this.editorFrame = this.createFrame(new EditorMenuBar(this), this.mainSplitPane);
            this.editorFrame.addWindowListener(new WindowAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void windowClosing(WindowEvent arg0) {
                    Object object = windowCloseLock;
                    synchronized (object) {
                        NESTWorkflowEditor.this.editorFrame.setVisible(false);
                        windowCloseLock.notify();
                        NESTWorkflowEditor.this.getNestWorkflowValidatorGUI().dispose();
                    }
                }
            });
            super.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            this.editorFrame.setSize(800, 600);
            this.editorFrame.setVisible(true);
            this.editorFrame.toFront();
            this.editorFrame.repaint();
        }
        this.graphComponent.zoomTo(1.0, this.graphComponent.isCenterZoom());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilEditorWindowClosed() {
        try {
            while (this.editorFrame == null || !this.editorFrame.isVisible()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Object object = windowCloseLock;
        synchronized (object) {
            while (this.editorFrame.isVisible()) {
                try {
                    windowCloseLock.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void open(Object parsedObject) {
        if (parsedObject instanceof NESTWorkflowObject) {
            CustomGraph customGraph = (CustomGraph)super.getGraphComponent().getGraph();
            customGraph.clearWithoutEvents();
            this.nestWorkflow = (NESTWorkflowObject)parsedObject;
            customGraph.loadNESTWorkflow(this.nestWorkflow);
            this.applyNodeVisibilitySettings();
            this.graphComponent.zoomTo(1.0, this.graphComponent.isCenterZoom());
            super.updateTitle();
        }
    }

    public void saveInObjectNESTWorkflow(NESTWorkflowObject nestWorkflow) {
    }

    public void applyNodeVisibilitySettings() {
        ActionEvent e = new ActionEvent(this, 0, "applyNodeVisibilitySettings");
        EditorActions.getActionFor(EditorActions.ToggleWorkflowNodeVisibilityAction.class).actionPerformed(e);
        EditorActions.getActionFor(EditorActions.ToggleDataNodeVisibilityAction.class).actionPerformed(e);
        EditorActions.getActionFor(EditorActions.ToggleSequenceNodeVisibilityAction.class).actionPerformed(e);
        EditorActions.getActionFor(EditorActions.ToggleIdVisibilityAction.class).actionPerformed(e);
        EditorActions.getActionFor(EditorActions.ToggleEdgeLabelVisibilityAction.class).actionPerformed(e);
        EditorActions.getActionFor(EditorActions.ToggleCellTooltipVisibilityAction.class).actionPerformed(e);
    }

    public NESTAbstractWorkflowObject getNESTWorkflow() {
        return ((CustomGraph)this.getGraphComponent().getGraph()).getNestWorkflow();
    }

    public void setNestWorkflow(NESTWorkflowObject nestWorkflow) {
        this.nestWorkflow = nestWorkflow;
    }

    public JFrame getEditorFrame() {
        return this.editorFrame;
    }

    public NESTWorkflowValidatorGUI getNestWorkflowValidatorGUI() {
        return this.nestWorkflowValidatorGUI;
    }

    public void addGraphSaveListener(GraphSaveListener listener) {
        this.graphSaveListeners.add(listener);
    }

    public void removeGraphSaveListener(GraphSaveListener listener) {
        this.graphSaveListeners.remove(listener);
    }

    public void fireGraphSaved() {
        this.graphSaveListeners.forEach(listener -> listener.graphSaved(this.nestWorkflow));
    }

    public static class CustomGraphComponent
    extends mxGraphComponent {
        private static final long serialVersionUID = -6833603133512882012L;
        static String NAME = "CustomGraphComponent";
        private String stylesheet;

        public CustomGraphComponent(mxGraph graph) {
            super(graph);
            this.setName(NAME);
            this.setTolerance(10);
            this.getConnectionHandler().addListener("connect", (mxEventSource.mxIEventListener)new EdgeCreationListener(graph));
            graph.addListener("cellsRemoved", (mxEventSource.mxIEventListener)new CellRemoveListener());
            graph.addListener("cellsAdded", (mxEventSource.mxIEventListener)new CellAddListener());
            graph.addListener("splitEdge", (mxEventSource.mxIEventListener)new EdgeSplitListener());
            this.setToolTips(false);
            ToolTipManager.sharedInstance().setDismissDelay(30000);
            this.getConnectionHandler().setCreateTarget(false);
            try {
                String defaultStyle = new String(IOUtil.getInputStream((String)NESTWorkflowEditor.DEFAULT_STYLE_XML_PATH).readAllBytes(), StandardCharsets.UTF_8);
                this.setStylesheet(defaultStyle);
            }
            catch (IOException e) {
                System.err.println("Default style could not be loaded from /objecteditor/nestworkfloweditor/default-style.xml");
                e.printStackTrace();
            }
            this.getViewport().setOpaque(true);
            this.getViewport().setBackground(Color.WHITE);
            this.getConnectionHandler().getMarker().addListener(mxEvent.MARK, (mxEventSource.mxIEventListener)new Highlighter());
        }

        public void setStylesheet(String xml) {
            this.stylesheet = xml;
            mxStylesheet newStylesheet = new mxStylesheet();
            mxCodec codec = new mxCodec();
            Document doc = mxXmlUtils.parseXml((String)xml);
            codec.decode((Node)doc.getDocumentElement(), (Object)newStylesheet);
            this.graph.setStylesheet(newStylesheet);
        }

        public String getStylesheet() {
            return this.stylesheet;
        }

        public mxCellHandler createHandler(mxCellState state) {
            if (this.graph.getModel().isVertex(state.getCell())) {
                return new CustomVertexHandler(this, state);
            }
            if (this.graph.getModel().isEdge(state.getCell())) {
                mxEdgeStyle.mxEdgeStyleFunction style = this.graph.getView().getEdgeStyle(state, null, null, null);
                if (this.graph.isLoop(state) || style == mxEdgeStyle.ElbowConnector || style == mxEdgeStyle.SideToSide || style == mxEdgeStyle.TopToBottom) {
                    return new mxElbowEdgeHandler((mxGraphComponent)this, state);
                }
                return new mxEdgeHandler((mxGraphComponent)this, state);
            }
            return new mxCellHandler((mxGraphComponent)this, state);
        }

        protected mxICellEditor createCellEditor() {
            return new mxICellEditor(){
                SemanticDescriptorEditor semanticDescriptorEditor;
                {
                    this.semanticDescriptorEditor = new SemanticDescriptorEditor(this);
                }

                public Object getEditingCell() {
                    return null;
                }

                public void startEditing(Object cell, EventObject trigger) {
                    Object valueToEdit = ((mxICell)cell).getValue();
                    if (valueToEdit instanceof NESTGraphItemObject) {
                        this.semanticDescriptorEditor.startEditing(cell, trigger);
                    } else if (valueToEdit instanceof String) {
                        new StringCellEditor((mxICell)cell, this);
                    }
                }

                public void stopEditing(boolean cancel) {
                }
            };
        }

        public void updateAllCellLabels() {
            Object[] cells = this.getGraph().getChildCells(this.getGraph().getDefaultParent(), true, true);
            Arrays.stream(cells).forEach(cell -> this.labelChanged(cell, ((mxICell)cell).getValue(), null));
        }

        protected mxConnectionHandler createConnectionHandler() {
            return new mxConnectionHandler(this){

                public void mousePressed(MouseEvent e) {
                    if (!SwingUtilities.isLeftMouseButton(e)) {
                        super.mousePressed(e);
                    }
                }
            };
        }

        static {
            try {
                mxGraphTransferable.dataFlavor = new DataFlavor("application/x-java-jvm-local-objectref; class=com.mxgraph.swing.util.mxGraphTransferable");
            }
            catch (ClassNotFoundException cnfe) {
                System.err.println(cnfe);
            }
        }

        class Highlighter
        implements mxEventSource.mxIEventListener {
            final int OPACITY_HIGH = 100;
            final int OPACITY_LOW = 20;

            Highlighter() {
            }

            public void invoke(Object connectionHandler, mxEventObject event) {
                Object[] allCells = CustomGraphComponent.this.graph.getChildCells(CustomGraphComponent.this.graph.getDefaultParent());
                mxCellState cellState = (mxCellState)event.getProperty("state");
                if (cellState != null) {
                    mxICell markedCell = (mxICell)cellState.getCell();
                    if (!(markedCell.getValue() instanceof NESTGraphItemObject)) {
                        return;
                    }
                    Arrays.asList(allCells).forEach(cell -> this.setCellOpacity(cell, 20));
                    this.setCellOpacity(markedCell, 100);
                    this.highlightPartOfEdgeAndWorkflowNode((NESTNodeObject)markedCell.getValue());
                    this.highlightFor((NESTNodeObject)markedCell.getValue());
                } else {
                    Arrays.asList(allCells).forEach(cell -> this.setCellOpacity(cell, 100));
                }
                mxRectangle bounds = CustomGraphComponent.this.graph.getBoundsForCells(allCells, true, true, true);
                CustomGraphComponent.this.graph.repaint(bounds);
            }

            private void highlightPartOfEdgeAndWorkflowNode(NESTNodeObject nestNode) {
                mxGraphModel model = (mxGraphModel)CustomGraphComponent.this.graph.getModel();
                nestNode.getOutgoingEdges(DataObject::isNESTPartOfEdge).forEach(edge -> {
                    this.setCellOpacity(model.getCell(edge.getId()), 100);
                    if (edge.getPost() != null) {
                        this.setCellOpacity(model.getCell(edge.getPost().getId()), 100);
                    }
                });
            }

            private void highlightFor(NESTNodeObject nestNode) {
                if (nestNode.isNESTSubWorkflowNode() || nestNode.isNESTWorkflowNode()) {
                    this.highlightForWorkflowNodeAndSubworkflowNode(nestNode);
                } else if (nestNode.isNESTTaskNode()) {
                    this.highlightForTaskNode(nestNode);
                } else if (nestNode.isNESTDataNode()) {
                    this.highlightForDataNode(nestNode);
                } else if (nestNode.isNESTControlflowNode()) {
                    this.highlightForControlflowNode(nestNode);
                }
            }

            private void setCellOpacity(Object cell, int opacity) {
                if (CustomGraphComponent.this.graph.getView().getState(cell) != null) {
                    CustomGraphComponent.this.graph.getView().getState(cell).getStyle().put(mxConstants.STYLE_OPACITY, opacity);
                    CustomGraphComponent.this.graph.getView().getState(cell).getStyle().put(mxConstants.STYLE_TEXT_OPACITY, opacity);
                }
            }

            private void highlightForControlflowNode(NESTNodeObject nestNode) {
                Set innerBlockElements;
                mxGraphModel model = (mxGraphModel)CustomGraphComponent.this.graph.getModel();
                NESTControlflowNodeObject controlflowNode = (NESTControlflowNodeObject)nestNode;
                if (controlflowNode.getMatchingBlockControlflowNode() != null) {
                    this.setCellOpacity(model.getCell(controlflowNode.getMatchingBlockControlflowNode().getId()), 100);
                }
                if ((innerBlockElements = controlflowNode.getInnerBlockElements()) == null) {
                    return;
                }
                innerBlockElements.forEach(node -> this.setCellOpacity(model.getCell(node.getId()), 100));
                innerBlockElements.stream().flatMap(node -> node.getEdges(DataObject::isNESTControlflowEdge).stream()).forEach(edge -> this.setCellOpacity(model.getCell(edge.getId()), 100));
                controlflowNode.getEdges().forEach(edge -> this.setCellOpacity(model.getCell(edge.getId()), 100));
            }

            private void highlightForTaskNode(NESTNodeObject nestNode) {
                mxGraphModel model = (mxGraphModel)CustomGraphComponent.this.graph.getModel();
                Set dataflowEdges = nestNode.getEdges(DataObject::isNESTDataflowEdge);
                dataflowEdges.forEach(edge -> this.setCellOpacity(model.getCell(edge.getId()), 100));
                dataflowEdges.stream().filter(edge -> edge.getPre() != null && edge.getPost() != null).map(edge -> Stream.of(edge.getPost(), edge.getPre()).filter(DataObject::isNESTDataNode).findFirst().get()).forEach(dataNode -> this.setCellOpacity(model.getCell(dataNode.getId()), 100));
            }

            private void highlightForDataNode(NESTNodeObject nestNode) {
                mxGraphModel model = (mxGraphModel)CustomGraphComponent.this.graph.getModel();
                Set dataflowEdges = nestNode.getEdges(DataObject::isNESTDataflowEdge);
                dataflowEdges.forEach(edge -> this.setCellOpacity(model.getCell(edge.getId()), 100));
                dataflowEdges.stream().filter(edge -> edge.getPre() != null && edge.getPost() != null).map(edge -> Stream.of(edge.getPost(), edge.getPre()).filter(DataObject::isNESTTaskNode).findFirst().get()).forEach(taskNode -> this.setCellOpacity(model.getCell(taskNode.getId()), 100));
            }

            private void highlightForWorkflowNodeAndSubworkflowNode(NESTNodeObject nestNode) {
                Set ingoingPartOfEdges = nestNode.getIngoingEdges(DataObject::isNESTPartOfEdge);
                mxGraphModel model = (mxGraphModel)CustomGraphComponent.this.graph.getModel();
                ingoingPartOfEdges.forEach(partOfEdge -> {
                    Object partOfEdgeCell = model.getCell(partOfEdge.getId());
                    this.setCellOpacity(partOfEdgeCell, 100);
                    if (partOfEdge.getPre() == null) {
                        return;
                    }
                    mxICell connectedCell = (mxICell)model.getCell(partOfEdge.getPre().getId());
                    this.setCellOpacity(connectedCell, 100);
                    Set containedEdges = partOfEdge.getPre().getEdges(edge -> Stream.of(edge.getPost(), edge.getPre()).filter(Objects::nonNull).allMatch(node -> node.getOutgoingEdges(adjacentEdge -> adjacentEdge.isNESTPartOfEdge() && adjacentEdge.getPost() == nestNode).size() >= 1));
                    containedEdges.forEach(edge -> this.setCellOpacity(model.getCell(edge.getId()), 100));
                    partOfEdge.getPre().getOutgoingEdges().forEach(edge -> this.setCellOpacity(model.getCell(edge.getId()), 100));
                    NESTNodeObject connectedNESTNode = (NESTNodeObject)connectedCell.getValue();
                    if (connectedNESTNode.isNESTSubWorkflowNode()) {
                        this.highlightForWorkflowNodeAndSubworkflowNode(connectedNESTNode);
                    }
                });
            }
        }
    }

    public static class CustomGraph
    extends mxGraph {
        protected Object edgeTemplate;
        private CellLabelGenerator cellLabelGenerator = new CellLabelGenerator();
        private NESTAbstractWorkflowObject nestWorkflow;
        private NESTWorkflowLayout layout;

        public CustomGraph() {
            this.setAlternateEdgeStyle("edgeStyle=mxEdgeStyle.ElbowConnector;elbow=vertical");
            this.setAllowDanglingEdges(false);
            this.layout = new NESTWorkflowLayoutForMxGraph(this, this.nestWorkflow);
            this.addListener("connectCell", new EdgeTerminalModificationListener());
        }

        public void setEdgeTemplate(Object template) {
            this.edgeTemplate = template;
        }

        public String getToolTipForCell(Object cell) {
            NESTGraphItemObject item = (NESTGraphItemObject)((mxICell)cell).getValue();
            DataObject semanticDescriptor = item.getSemanticDescriptor();
            String heading = "ID: " + item.getId() + " (" + item.getDataClass().getName() + ")";
            FontMetrics metrics = new Canvas().getFontMetrics((Font)UIManager.get("ToolTip.font"));
            int headingWidth = metrics.stringWidth(heading);
            String tooltip = "<html><p width=" + headingWidth + ">ID: " + item.getId() + " (" + item.getDataClass().getName() + ")</p><hr>";
            tooltip = semanticDescriptor != null && semanticDescriptor.isAggregate() ? tooltip + this.aggregateToHtmlTable((AggregateObject)semanticDescriptor, true) : tooltip + Objects.toString(semanticDescriptor);
            return tooltip + "<br></html>";
        }

        public String aggregateToHtmlTable(AggregateObject aggregateObject, boolean includeDataClassNames, boolean includeNullAttributes) {
            StringBuilder sb = new StringBuilder("<table cellpadding='0' border='0' cellspacing='0'>");
            for (String attributeName : aggregateObject.getAggregateClass().getAttributeNames()) {
                DataObject dataObject = aggregateObject.getAttributeValue(attributeName);
                if (dataObject == null && !includeNullAttributes) continue;
                sb.append("<tr><td align='right' valign='top'><b>").append(attributeName).append(": </b></td><td>");
                if (dataObject == null) {
                    sb.append("null");
                } else if (dataObject.isAggregate()) {
                    sb.append(this.aggregateToHtmlTable((AggregateObject)dataObject, includeDataClassNames));
                } else if (dataObject.isAtomic()) {
                    sb.append(includeDataClassNames ? dataObject.toString() : ((AtomicObject)dataObject).getNativeObject().toString());
                } else {
                    sb.append(dataObject.toString());
                }
                sb.append("</td></tr>");
            }
            sb.append("</table>");
            return sb.toString();
        }

        public String aggregateToHtmlTable(AggregateObject aggregateObject, boolean includeDataClassNames) {
            return this.aggregateToHtmlTable(aggregateObject, includeDataClassNames, true);
        }

        public Object createEdge(Object parent, String id, Object value, Object source, Object target, String style) {
            if (this.edgeTemplate != null) {
                mxCell edge = (mxCell)this.cloneCells(new Object[]{this.edgeTemplate})[0];
                edge.setId(id);
                return edge;
            }
            return super.createEdge(parent, id, value, source, target, style);
        }

        public Object splitEdge(Object edge, Object[] cells, double dx, double dy) {
            if (Arrays.stream(cells).anyMatch(cell -> ((mxICell)cell).getValue() instanceof NodeInsertType)) {
                cells = this.cloneCells(cells);
            }
            return super.splitEdge(edge, cells, dx, dy);
        }

        public String convertValueToString(Object cell) {
            Object value;
            if (cell instanceof mxCell && (value = ((mxCell)cell).getValue()) instanceof NESTGraphItemObject) {
                String label = this.cellLabelGenerator.getLabelFor((NESTGraphItemObject)value);
                this.setHtmlLabels(true);
                label = label.replace("\n", "<br>");
                return "<html>" + label + "</html>";
            }
            return super.convertValueToString(cell);
        }

        public String getEdgeValidationError(Object edge, Object source, Object target) {
            if (source != null && target != null && ((mxICell)source).getValue() instanceof NESTNodeObject && ((mxICell)target).getValue() instanceof NESTNodeObject) {
                boolean changingSource;
                boolean changingTarget;
                final NESTNodeObject sourceNode = (NESTNodeObject)((mxICell)source).getValue();
                final NESTNodeObject targetNode = (NESTNodeObject)((mxICell)target).getValue();
                String sourceDataClassName = sourceNode.getDataClass().getName();
                String targetDataClassName = targetNode.getDataClass().getName();
                String validEdgeClassName = Utils.getEdgeClassForNodeConnection(sourceNode, targetNode);
                mxCell edgeCell = (mxCell)edge;
                if (validEdgeClassName == null || edgeCell.getId() != null && !((NESTEdgeObject)edgeCell.getValue()).getDataClass().getName().equals(validEdgeClassName)) {
                    return "No suitable edge class for node connection of type " + sourceDataClassName + " -> " + targetDataClassName + " found.";
                }
                final NESTEdgeObject edgeToCheck = edgeCell.getId() == null ? (NESTEdgeObject)sourceNode.getGraph().getModel().createObject(validEdgeClassName) : (NESTEdgeObject)edgeCell.getValue();
                abstract class ValidationRule {
                    NESTNodeObject sourceNode;
                    NESTNodeObject targetNode;
                    NESTEdgeObject edge;
                    String constraintDescription;
                    boolean changingSource;
                    boolean changingTarget;

                    public ValidationRule(NESTNodeObject sourceNode, NESTNodeObject targetNode, NESTEdgeObject edge, String constraintDescription) {
                        this(sourceNode, targetNode, edge, constraintDescription, false, false);
                    }

                    public ValidationRule(NESTNodeObject sourceNode, NESTNodeObject targetNode, NESTEdgeObject edge, String constraintDescription, boolean changingSource, boolean changingTarget) {
                        this.sourceNode = sourceNode;
                        this.targetNode = targetNode;
                        this.edge = edge;
                        this.constraintDescription = constraintDescription;
                        this.changingSource = changingSource;
                        this.changingTarget = changingTarget;
                    }

                    public String getConstraintDescription() {
                        return this.constraintDescription;
                    }

                    abstract boolean isApplicable();

                    abstract boolean isViolated();
                }
                HashSet<ValidationRule> rulesToCheck = new HashSet<ValidationRule>(changingTarget = edgeCell.getTarget() != null && edgeCell.getTarget() != target, changingSource = edgeCell.getSource() != null && edgeCell.getSource() != source){
                    final /* synthetic */ boolean val$changingTarget;
                    final /* synthetic */ boolean val$changingSource;
                    {
                        this.val$changingTarget = bl;
                        this.val$changingSource = bl2;
                        class 1MaxOneOutgoingPartOfEdge
                        extends ValidationRule {
                            public 1MaxOneOutgoingPartOfEdge(NESTNodeObject sourceNode, NESTNodeObject targetNode, NESTEdgeObject edge, boolean changingTarget) {
                                super(sourceNode, targetNode, edge, "Only one outgoing partOf edge for this source node allowed.", false, changingTarget);
                            }

                            @Override
                            boolean isApplicable() {
                                return this.edge.isNESTPartOfEdge() && (this.sourceNode.isNESTTaskNode() || this.sourceNode.isNESTControlflowNode() || this.sourceNode.isNESTDataNode() || this.sourceNode.isNESTSubWorkflowNode());
                            }

                            @Override
                            boolean isViolated() {
                                return this.sourceNode.getOutgoingEdges(DataObject::isNESTPartOfEdge).size() - (this.changingTarget ? 1 : 0) >= 1;
                            }
                        }
                        this.add(new 1MaxOneOutgoingPartOfEdge(sourceNode, targetNode, edgeToCheck, this.val$changingTarget));
                        class 1MaxOneOutgoingControlflowEdge
                        extends ValidationRule {
                            public 1MaxOneOutgoingControlflowEdge(NESTNodeObject sourceNode, NESTNodeObject targetNode, NESTEdgeObject edge, boolean changingTarget) {
                                super(sourceNode, targetNode, edge, "Only one outgoing controlflow edge for this source node allowed.", false, changingTarget);
                            }

                            @Override
                            boolean isApplicable() {
                                if (!this.edge.isNESTControlflowEdge() || !this.sourceNode.isNESTControlflowNode() && !this.sourceNode.isNESTTaskNode()) {
                                    return false;
                                }
                                if (this.sourceNode.isNESTTaskNode()) {
                                    return true;
                                }
                                NESTControlflowNodeObject controlflowNode = (NESTControlflowNodeObject)this.sourceNode;
                                return controlflowNode.isLoopStartNode() || controlflowNode.isXorEndNode() || controlflowNode.isAndEndNode() || controlflowNode.isOrEndNode();
                            }

                            @Override
                            boolean isViolated() {
                                return this.sourceNode.getOutgoingEdges(DataObject::isNESTControlflowEdge).size() - (this.changingTarget ? 1 : 0) >= 1;
                            }
                        }
                        this.add(new 1MaxOneOutgoingControlflowEdge(sourceNode, targetNode, edgeToCheck, this.val$changingTarget));
                        class 1MaxTwoOutgoingControlflowEdges
                        extends ValidationRule {
                            public 1MaxTwoOutgoingControlflowEdges(NESTNodeObject sourceNode, NESTNodeObject targetNode, NESTEdgeObject edge, boolean changingTarget) {
                                super(sourceNode, targetNode, edge, "Only two outgoing controlflow edges for this source node allowed.", false, changingTarget);
                            }

                            @Override
                            boolean isApplicable() {
                                if (!this.edge.isNESTControlflowEdge() || !this.sourceNode.isNESTControlflowNode()) {
                                    return false;
                                }
                                NESTControlflowNodeObject controlflowNode = (NESTControlflowNodeObject)this.sourceNode;
                                return controlflowNode.isAndStartNode() || controlflowNode.isXorStartNode() || controlflowNode.isLoopEndNode() || controlflowNode.isOrStartNode();
                            }

                            @Override
                            boolean isViolated() {
                                return this.sourceNode.getOutgoingEdges(DataObject::isNESTControlflowEdge).size() - (this.changingTarget ? 1 : 0) >= 2;
                            }
                        }
                        this.add(new 1MaxTwoOutgoingControlflowEdges(sourceNode, targetNode, edgeToCheck, this.val$changingTarget));
                        class 1MaxOneIngoingControlflowEdge
                        extends ValidationRule {
                            public 1MaxOneIngoingControlflowEdge(NESTNodeObject sourceNode, NESTNodeObject targetNode, NESTEdgeObject edge, boolean changingSource) {
                                super(sourceNode, targetNode, edge, "Only one ingoing controlflow edge for this target node allowed.", changingSource, false);
                            }

                            @Override
                            boolean isApplicable() {
                                if (!this.edge.isNESTControlflowEdge() || !this.targetNode.isNESTControlflowNode() && !this.targetNode.isNESTTaskNode()) {
                                    return false;
                                }
                                if (this.targetNode.isNESTTaskNode()) {
                                    return true;
                                }
                                NESTControlflowNodeObject controlflowNode = (NESTControlflowNodeObject)this.targetNode;
                                return controlflowNode.isAndStartNode() || controlflowNode.isXorStartNode() || controlflowNode.isLoopEndNode() || controlflowNode.isOrStartNode();
                            }

                            @Override
                            boolean isViolated() {
                                return this.targetNode.getIngoingEdges(DataObject::isNESTControlflowEdge).size() - (this.changingSource ? 1 : 0) >= 1;
                            }
                        }
                        this.add(new 1MaxOneIngoingControlflowEdge(sourceNode, targetNode, edgeToCheck, this.val$changingSource));
                        class 1MaxTwoIngoingControlflowEdges
                        extends ValidationRule {
                            public 1MaxTwoIngoingControlflowEdges(NESTNodeObject sourceNode, NESTNodeObject targetNode, NESTEdgeObject edge, boolean changingSource) {
                                super(sourceNode, targetNode, edge, "Only two ingoing controlflow edge for this target node allowed.", changingSource, false);
                            }

                            @Override
                            boolean isApplicable() {
                                if (!this.edge.isNESTControlflowEdge() || !this.targetNode.isNESTControlflowNode()) {
                                    return false;
                                }
                                NESTControlflowNodeObject controlflowNode = (NESTControlflowNodeObject)this.targetNode;
                                return controlflowNode.isLoopStartNode() || controlflowNode.isXorEndNode() || controlflowNode.isAndEndNode() || controlflowNode.isOrEndNode();
                            }

                            @Override
                            boolean isViolated() {
                                return this.targetNode.getIngoingEdges(DataObject::isNESTControlflowEdge).size() - (this.changingSource ? 1 : 0) >= 2;
                            }
                        }
                        this.add(new 1MaxTwoIngoingControlflowEdges(sourceNode, targetNode, edgeToCheck, this.val$changingSource));
                        class 1NoDuplicateDataflowEdges
                        extends ValidationRule {
                            public 1NoDuplicateDataflowEdges(NESTNodeObject sourceNode, NESTNodeObject targetNode, NESTEdgeObject edge) {
                                super(sourceNode, targetNode, edge, "No duplicate dataflow edges allowed.");
                            }

                            @Override
                            boolean isApplicable() {
                                return this.edge.isNESTDataflowEdge();
                            }

                            @Override
                            boolean isViolated() {
                                return this.sourceNode.getOutgoingEdges(DataObject::isNESTDataflowEdge).stream().anyMatch(edge -> edge.getPost() == this.targetNode);
                            }
                        }
                        this.add(new 1NoDuplicateDataflowEdges(sourceNode, targetNode, edgeToCheck));
                        class 1NoDuplicateLoopReturnEdges
                        extends ValidationRule {
                            public 1NoDuplicateLoopReturnEdges(NESTNodeObject sourceNode, NESTNodeObject targetNode, NESTEdgeObject edge) {
                                super(sourceNode, targetNode, edge, "No duplicate loop return edges allowed.");
                            }

                            @Override
                            boolean isApplicable() {
                                return this.edge.isNESTControlflowEdge() && this.sourceNode.isNESTControlflowNode() && ((NESTControlflowNodeObject)this.sourceNode).isLoopEndNode() && ((NESTControlflowNodeObject)this.sourceNode).getMatchingBlockControlflowNode() == this.targetNode;
                            }

                            @Override
                            boolean isViolated() {
                                return this.sourceNode.getOutgoingEdges(Utils::isEdgeLoopReturnEdge).size() >= 1;
                            }
                        }
                        this.add(new 1NoDuplicateLoopReturnEdges(sourceNode, targetNode, edgeToCheck));
                        class 1NoDirectEndToStartControlflowEdges
                        extends ValidationRule {
                            public 1NoDirectEndToStartControlflowEdges(NESTNodeObject sourceNode, NESTNodeObject targetNode, NESTEdgeObject edge) {
                                super(sourceNode, targetNode, edge, "Invalid edge.");
                            }

                            @Override
                            boolean isApplicable() {
                                return this.edge.isNESTControlflowEdge() && this.sourceNode.isNESTControlflowNode() && (((NESTControlflowNodeObject)this.sourceNode).isXorEndNode() || ((NESTControlflowNodeObject)this.sourceNode).isOrEndNode() || ((NESTControlflowNodeObject)this.sourceNode).isAndEndNode()) && ((NESTControlflowNodeObject)this.sourceNode).getMatchingBlockControlflowNode() == this.targetNode;
                            }

                            @Override
                            boolean isViolated() {
                                return true;
                            }
                        }
                        this.add(new 1NoDirectEndToStartControlflowEdges(sourceNode, targetNode, edgeToCheck));
                    }
                };
                Optional<ValidationRule> violatedRule = rulesToCheck.stream().filter(ValidationRule::isApplicable).filter(ValidationRule::isViolated).findAny();
                if (violatedRule.isPresent()) {
                    return "Rule violated: " + violatedRule.get().getConstraintDescription();
                }
            }
            return super.getEdgeValidationError(edge, source, target);
        }

        public mxRectangle getLabelSize(Object cell) {
            mxCellState state = this.getView().getState(cell);
            return mxUtils.getLabelSize((String)this.getLabel(cell), (Map)(state != null ? state.getStyle() : this.getCellStyle(cell)), (boolean)this.isHtmlLabel(cell), (double)1.0);
        }

        public NESTWorkflowLayout getLayout() {
            return this.layout;
        }

        public void selectGraphItemsOfClass(DataClass targetDataClass) {
            super.setSelectionCells((Collection)Arrays.stream(super.getChildCells(super.getDefaultParent())).map(mxICell.class::cast).filter(cell -> {
                if (!(cell.getValue() instanceof NESTGraphItemObject)) {
                    return false;
                }
                DataClass dataClass = ((NESTGraphItemObject)cell.getValue()).getDataClass();
                return targetDataClass == dataClass || dataClass.isSubclassOf(targetDataClass);
            }).collect(Collectors.toList()));
        }

        public NESTAbstractWorkflowObject getNestWorkflow() {
            return this.nestWorkflow;
        }

        public void loadNESTWorkflow(NESTAbstractWorkflowObject nestWorkflow) {
            this.nestWorkflow = nestWorkflow;
            this.layout.setNestWorkflow(nestWorkflow);
            mxICell parent = (mxICell)this.getDefaultParent();
            this.setCellId(parent, "7c7bc177-cfc7-45fb-9d1b-5b29ebfb8570");
            try {
                this.setEventsEnabled(false);
                nestWorkflow.getGraphNodes().forEach(node -> {
                    mxICell insertedCell = (mxICell)this.insertVertex(parent, node.getId(), node, 80.0, 30.0, this.layout.getLayoutConfig().getNodeWidth(), this.layout.getLayoutConfig().getNodeHeight(), CellStyle.get(node));
                    if (!node.isNESTControlflowNode()) {
                        this.updateCellSize(insertedCell);
                    }
                });
                this.loadNESTEdges();
            }
            finally {
                this.setEventsEnabled(true);
            }
            this.executeLayout();
        }

        private void loadNESTEdges() {
            Set edges = this.nestWorkflow.getGraphEdges();
            Map graphCells = ((mxGraphModel)this.getModel()).getCells();
            LinkedList<Object> insertedEdges = new LinkedList<Object>();
            for (NESTEdgeObject edge2 : edges) {
                mxICell parentCell = (mxICell)this.getDefaultParent();
                mxICell tempConnectVertex = (mxICell)this.insertVertex(parentCell, "temp", "null", 0.0, 0.0, 0.0, 0.0);
                insertedEdges.add(this.insertEdge(parentCell, edge2.getId(), edge2, edge2.getPre() == null ? tempConnectVertex : graphCells.get(edge2.getPre().getId()), edge2.getPost() == null ? tempConnectVertex : graphCells.get(edge2.getPost().getId()), CellStyle.get(edge2) + (edge2.getPre() == null || edge2.getPost() == null ? ";strokeColor=red" : "")));
                this.removeCells(new Object[]{tempConnectVertex}, false);
            }
            this.orderCells(true, insertedEdges.toArray());
            List insertedPartOfEdges = insertedEdges.stream().filter(edge -> ((NESTEdgeObject)((mxICell)edge).getValue()).isNESTPartOfEdge()).collect(Collectors.toList());
            this.orderCells(true, insertedPartOfEdges.toArray());
        }

        private Set<NESTSubWorkflowNodeObject> getTopLevelSubworkflowNodes(Set<NESTSubWorkflowNodeObject> subworkflowNodes) {
            return subworkflowNodes.stream().filter(node -> node.getOutgoingEdges().stream().noneMatch(edge -> edge.isNESTPartOfEdge() && edge.getPost().isNESTSubWorkflowNode())).collect(Collectors.toSet());
        }

        private void groupSubworkflows() {
            Set<NESTSubWorkflowNodeObject> topLevelSubWorkflows = this.getTopLevelSubworkflowNodes(this.nestWorkflow.getSubWorkflowNodes());
            topLevelSubWorkflows.forEach(subworkflowNode -> this.groupSubworkflow((NESTSubWorkflowNodeObject)subworkflowNode, (mxICell)this.getDefaultParent()));
        }

        private mxICell groupSubworkflow(NESTSubWorkflowNodeObject subWorkflowNode, mxICell parent) {
            Map graphCells = ((mxGraphModel)this.getModel()).getCells();
            mxICell groupingCell = (mxICell)this.insertVertex(parent, subWorkflowNode.getId() + "_GROUPING_CELL", null, 0.0, 0.0, 80.0, 80.0);
            Set<NESTSubWorkflowNodeObject> childSubWorkflowNodes = subWorkflowNode.getIngoingEdges().stream().filter(edge -> edge.isNESTPartOfEdge() && edge.getPre().isNESTSubWorkflowNode()).map(NESTEdgeObject::getPre).map(NESTSubWorkflowNodeObject.class::cast).collect(Collectors.toSet());
            childSubWorkflowNodes.forEach(childSubWorkflowNode -> {
                mxICell childSubWorkflowGroupingCell = this.groupSubworkflow((NESTSubWorkflowNodeObject)childSubWorkflowNode, groupingCell);
                this.groupCells(groupingCell, 20.0, new Object[]{childSubWorkflowGroupingCell});
            });
            Set<NESTNodeObject> childNodes = subWorkflowNode.getIngoingEdges().stream().filter(edge -> edge.isNESTPartOfEdge() && !edge.getPre().isNESTSubWorkflowNode()).map(NESTEdgeObject::getPre).collect(Collectors.toSet());
            childNodes.forEach(childNode -> {
                mxICell childNodeCell = (mxICell)graphCells.get(childNode.getId());
                this.groupCells(groupingCell, 200.0, new Object[]{childNodeCell});
            });
            mxICell subWorkflowNodeCell = (mxICell)graphCells.get(subWorkflowNode.getId());
            this.groupCells(groupingCell, 200.0, new Object[]{subWorkflowNodeCell});
            return groupingCell;
        }

        private void executeLayout(mxICell parent) {
            if (this.layout.isApplicable()) {
                this.layout.execute();
            } else {
                mxHierarchicalLayout layout = new mxHierarchicalLayout((mxGraph)this, 7);
                layout.setInterRankCellSpacing(30.0);
                layout.setIntraCellSpacing(30.0);
                layout.setParallelEdgeSpacing(15.0);
                layout.setFineTuning(true);
                layout.setDisableEdgeStyle(true);
                layout.execute((Object)parent);
            }
            this.refresh();
        }

        public void executeLayout() {
            this.executeLayout((mxICell)this.getDefaultParent());
        }

        public mxICell syncEdge(NESTEdgeObject nestEdge) {
            mxGraphModel graphModel = (mxGraphModel)this.getModel();
            mxICell preCell = (mxICell)graphModel.getCell(nestEdge.getPre().getId());
            mxICell postCell = (mxICell)graphModel.getCell(nestEdge.getPost().getId());
            mxICell edgeCell = (mxICell)graphModel.getCell(nestEdge.getId());
            if (edgeCell == null) {
                edgeCell = (mxICell)this.insertEdge(this.getDefaultParent(), nestEdge.getId(), nestEdge, preCell, postCell, CellStyle.get(nestEdge));
            }
            return edgeCell;
        }

        public void syncOutgoingEdges(NESTNodeObject nestNode) {
            nestNode.getOutgoingEdges().forEach(this::syncEdge);
        }

        public void setCellId(mxICell cell, String newId) {
            Map cells = ((mxGraphModel)this.getModel()).getCells();
            cells.remove(cell.getId());
            cell.setId(newId);
            cells.put(newId, cell);
        }

        public mxICell getCellById(String id) {
            return (mxICell)((mxGraphModel)this.getModel()).getCells().get(id);
        }

        public void clearWithoutEvents() {
            boolean eventsEnabled = this.isEventsEnabled();
            this.setEventsEnabled(false);
            Object[] cells = ((mxGraphModel)this.getModel()).getCells().values().stream().filter(cell -> cell != this.getDefaultParent() && cell != ((mxICell)this.getDefaultParent()).getParent()).map(mxICell.class::cast).toArray(Object[]::new);
            this.removeCells(cells);
            this.setEventsEnabled(eventsEnabled);
        }

        public mxRectangle getPreferredSizeForCell(Object cell) {
            int MIN_WIDTH = 50;
            int MIN_HEIGHT = 50;
            boolean previousGridEnabled = this.gridEnabled;
            this.gridEnabled = false;
            Object cellValue = ((mxCell)cell).getValue();
            if (cellValue instanceof NESTGraphItemObject) {
                // empty if block
            }
            mxRectangle result = super.getPreferredSizeForCell(cell);
            this.gridEnabled = previousGridEnabled;
            if (result != null) {
                result.setWidth(result.getWidth() < 50.0 ? 50.0 : result.getWidth());
                result.setHeight(result.getHeight() < 50.0 ? 50.0 : result.getHeight());
            }
            return result;
        }

        public boolean isSplitTarget(Object target, Object[] cells) {
            return super.isSplitTarget(target, cells) && ((mxICell)target).getValue() instanceof NESTControlflowEdgeObject && !Utils.isEdgeLoopReturnEdge((NESTEdgeObject)((mxICell)target).getValue()) && (((mxICell)cells[0]).getValue() instanceof NodeInsertType && Stream.of(NodeInsertType.TASK, NodeInsertType.AND_BLOCK, NodeInsertType.XOR_BLOCK, NodeInsertType.LOOP_BLOCK).anyMatch(type -> type == ((mxICell)cells[0]).getValue()) || ((mxICell)cells[0]).getValue() instanceof NESTTaskNodeObject);
        }

        public CellLabelGenerator getCellLabelGenerator() {
            return this.cellLabelGenerator;
        }
    }

    public static class NESTWorkflowValidatorGUI
    extends JDialog {
        protected NESTWorkflowEditor editor;
        protected JTextArea errorLogArea = new JTextArea();
        protected JLabel validationResultLabel = new JLabel();

        public NESTWorkflowValidatorGUI(NESTWorkflowEditor editor) {
            super((Frame)editor.getEditorFrame(), "NESTWorkflow Validator");
            this.editor = editor;
            this.setDefaultCloseOperation(1);
            this.setLayout(new BorderLayout());
            JPanel validationResultPanel = new JPanel();
            validationResultPanel.setLayout(new BasicGridLayout(1, 2, 5, 5, 2, 10));
            JButton validateButton = new JButton("Validate:");
            validateButton.addActionListener(e -> this.validateNESTWorkflow());
            validationResultPanel.add(validateButton);
            validationResultPanel.add(this.validationResultLabel);
            this.add((Component)validationResultPanel, "North");
            JScrollPane scrollPane = new JScrollPane(this.errorLogArea);
            this.add((Component)scrollPane, "Center");
            this.setPreferredSize(new Dimension(500, 200));
            this.pack();
        }

        public boolean validateNESTWorkflow() {
            if (this.editor.getNESTWorkflow().isNESTSequentialWorkflow()) {
                boolean isValid = new NESTSequentialWorkflowValidatorImpl(this.editor.getNESTWorkflow()).isValidSequentialWorkflow();
                if (!isValid) {
                    this.errorLogArea.setText("INVALID sequential workflow");
                }
                this.validationResultLabel.setText("<html>" + (isValid ? "<font color='green'><b>VALID sequential workflow</b></font>" : "<font color='red'><b>INVALID sequential workflow</b></font>") + "</html>");
                return isValid;
            }
            if (this.editor.getNESTWorkflow().isNESTWorkflow()) {
                NESTWorkflowValidatorImpl validator = new NESTWorkflowValidatorImpl((NESTWorkflowObject)this.editor.getNESTWorkflow());
                validator.isBlockOrientedWorkflow();
                this.errorLogArea.setText(validator.getErrorMessage());
                this.validationResultLabel.setText("<html>" + (validator.isValidGraph() ? "<font color='green'><b>VALID graph</b></font>" : "<font color='red'><b>INVALID graph</b></font>") + (validator.isValidWorkflow() ? ", <font color='green'><b>VALID workflow</b></font>" : ", <font color='red'><b>INVALID workflow</b></font>") + (validator.isBlockOrientedWorkflow() ? ", <font color='green'><b>VALID block-oriented workflow</b></font>" : ", <font color='red'><b>INVALID block-oriented workflow</b></font>") + "</html>");
                return validator.isValidWorkflow();
            }
            return false;
        }
    }

    public static enum CellStyle {
        WORKFLOW_NODE_STYLE,
        SUB_WORKFLOW_NODE_STYLE,
        TASK_NODE_STYLE,
        DATA_NODE_STYLE,
        AND_JOIN_NODE_STYLE,
        AND_SPLIT_NODE_STYLE,
        XOR_JOIN_NODE_STYLE,
        XOR_SPLIT_NODE_STYLE,
        OR_JOIN_NODE_STYLE,
        OR_SPLIT_NODE_STYLE,
        LOOP_JOIN_NODE_STYLE,
        LOOP_SPLIT_NODE_STYLE,
        UNKNOWN_NODE_STYLE,
        CONTROLFLOW_EDGE_STYLE,
        DATAFLOW_EDGE_STYLE,
        PART_OF_EDGE_STYLE,
        CONSTRAINT_EDGE_STYLE,
        UNKNOWN_EDGE_STYLE;


        public static String get(NESTEdgeObject edge) {
            if (edge.isNESTControlflowEdge()) {
                return CONTROLFLOW_EDGE_STYLE.name();
            }
            if (edge.isNESTDataflowEdge()) {
                return DATAFLOW_EDGE_STYLE.name();
            }
            if (edge.isNESTPartOfEdge()) {
                return PART_OF_EDGE_STYLE.name();
            }
            if (edge.isNESTConstraintEdge()) {
                return CONSTRAINT_EDGE_STYLE.name();
            }
            return UNKNOWN_EDGE_STYLE.name();
        }

        public static String get(NESTNodeObject node) {
            if (node.isNESTTaskNode()) {
                return TASK_NODE_STYLE.name();
            }
            if (node.isNESTDataNode()) {
                return DATA_NODE_STYLE.name();
            }
            if (node.isNESTWorkflowNode()) {
                return WORKFLOW_NODE_STYLE.name();
            }
            if (node.isNESTSubWorkflowNode()) {
                return SUB_WORKFLOW_NODE_STYLE.name();
            }
            if (node.isNESTControlflowNode()) {
                NESTControlflowNodeObject cfNode = (NESTControlflowNodeObject)node;
                if (cfNode.isAndNode()) {
                    return cfNode.isEndControlflowNode() ? AND_JOIN_NODE_STYLE.name() : AND_SPLIT_NODE_STYLE.name();
                }
                if (cfNode.isXorNode()) {
                    return cfNode.isEndControlflowNode() ? XOR_JOIN_NODE_STYLE.name() : XOR_SPLIT_NODE_STYLE.name();
                }
                if (cfNode.isOrNode()) {
                    return cfNode.isEndControlflowNode() ? OR_JOIN_NODE_STYLE.name() : OR_SPLIT_NODE_STYLE.name();
                }
                if (cfNode.isLoopNode()) {
                    return cfNode.isEndControlflowNode() ? LOOP_JOIN_NODE_STYLE.name() : LOOP_SPLIT_NODE_STYLE.name();
                }
                return UNKNOWN_NODE_STYLE.name();
            }
            return UNKNOWN_NODE_STYLE.name();
        }
    }

    public static interface GraphSaveListener {
        public void graphSaved(NESTAbstractWorkflowObject var1);
    }

    private static class CustomVertexHandler
    extends mxVertexHandler {
        public CustomVertexHandler(mxGraphComponent graphComponent, mxCellState state) {
            super(graphComponent, state);
        }

        public void mouseDragged(MouseEvent e) {
            if (!e.isConsumed() && this.first != null) {
                this.gridEnabledEvent = this.graphComponent.isGridEnabledEvent(e);
                this.constrainedEvent = this.graphComponent.isConstrainedEvent(e);
                double dx = e.getX() - this.first.x;
                double dy = e.getY() - this.first.y;
                if (this.isLabel(this.index)) {
                    mxPoint pt = new mxPoint((Point2D)e.getPoint());
                    int idx = (int)Math.round(pt.getX() - (double)this.first.x);
                    int idy = (int)Math.round(pt.getY() - (double)this.first.y);
                    if (this.constrainedEvent) {
                        if (Math.abs(idx) > Math.abs(idy)) {
                            idy = 0;
                        } else {
                            idx = 0;
                        }
                    }
                    Rectangle rect = this.state.getLabelBounds().getRectangle();
                    rect.translate(idx, idy);
                    this.preview.setBounds(rect);
                } else {
                    mxGraph graph = this.graphComponent.getGraph();
                    double scale = graph.getView().getScale();
                    mxRectangle bounds = this.union((mxRectangle)this.getState(), dx, dy, this.index);
                    bounds.setWidth(bounds.getWidth() + 1.0);
                    bounds.setHeight(bounds.getHeight() + 1.0);
                    this.preview.setBounds(bounds.getRectangle());
                }
                if (!this.preview.isVisible() && this.graphComponent.isSignificant(dx, dy)) {
                    this.preview.setVisible(true);
                }
                e.consume();
            }
        }

        protected void resizeCell(MouseEvent e) {
            mxGraph graph = this.graphComponent.getGraph();
            double scale = graph.getView().getScale();
            Object cell = this.state.getCell();
            mxGeometry geometry = graph.getModel().getGeometry(cell);
            if (geometry != null) {
                double dx = (double)(e.getX() - this.first.x) / scale;
                double dy = (double)(e.getY() - this.first.y) / scale;
                if (this.isLabel(this.index)) {
                    if ((geometry = (mxGeometry)geometry.clone()).getOffset() != null) {
                        dx += geometry.getOffset().getX();
                        dy += geometry.getOffset().getY();
                    }
                    geometry.setOffset(new mxPoint(dx, dy));
                    graph.getModel().setGeometry(cell, geometry);
                } else {
                    mxRectangle bounds = this.union((mxRectangle)geometry, dx, dy, this.index);
                    Rectangle rect = bounds.getRectangle();
                    graph.resizeCell(cell, new mxRectangle((Rectangle2D)rect));
                }
            }
        }
    }
}

