/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor;

import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.data.object.base.AggregateObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTGraphItemObject;
import de.uni_trier.wi2.procake.gui.objecteditor.label.AggregateObjectLabelProvider;
import de.uni_trier.wi2.procake.gui.objecteditor.label.LabelProvider;
import de.uni_trier.wi2.procake.gui.objecteditor.label.LabelProviderFactory;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.LabelMode;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellLabelGenerator {
    private final Logger logger = LoggerFactory.getLogger(CellLabelGenerator.class);
    private final Map<String, Queue<String>> dataClassNameToLabelPathMapping = new HashMap<String, Queue<String>>();
    private final Map<NESTGraphItemObject, LabelMode> graphItemToLabelModeMapping = new HashMap<NESTGraphItemObject, LabelMode>();
    private boolean showIds = false;
    private boolean showEdgeLabels = true;

    public String getLabelFor(NESTGraphItemObject nestGraphItemObject) {
        StringBuilder label = new StringBuilder((String)(this.showIds ? "ID: " + nestGraphItemObject.getId() + "\n" : ""));
        boolean generatedLabel = false;
        DataObject semanticDescriptor = nestGraphItemObject.getSemanticDescriptor();
        if (semanticDescriptor != null && semanticDescriptor.isAggregate()) {
            Object labelProvider = LabelProviderFactory.getProvider(semanticDescriptor.getDataClass());
            if (labelProvider == null) {
                this.logger.warn("No label provider configured in composition for data class \"{}\"", (Object)semanticDescriptor.getDataClass().getName());
            } else {
                LabelMode labelMode = this.graphItemToLabelModeMapping.get(nestGraphItemObject);
                if (!(labelProvider instanceof AggregateObjectLabelProvider)) {
                    label.append(Objects.requireNonNullElse(((LabelProvider)((Object)labelProvider)).getLabel((DataObject)nestGraphItemObject), ""));
                    generatedLabel = true;
                } else if (labelMode == LabelMode.FULL_SEMANTIC_DESCRIPTOR || labelMode == LabelMode.FULL_SEMANTIC_DESCRIPTOR_EXCLUDE_NULL) {
                    AggregateObjectLabelProvider aggregateObjectLabelProvider = (AggregateObjectLabelProvider)((Object)labelProvider);
                    aggregateObjectLabelProvider.setIncludeNullAttributes(labelMode != LabelMode.FULL_SEMANTIC_DESCRIPTOR_EXCLUDE_NULL);
                    aggregateObjectLabelProvider.setIncludeAllAttributes(true);
                    label.append(aggregateObjectLabelProvider.getLabel(semanticDescriptor));
                    generatedLabel = true;
                    aggregateObjectLabelProvider.setIncludeNullAttributes(false);
                    aggregateObjectLabelProvider.setIncludeAllAttributes(false);
                } else {
                    Queue<String> labelPath = this.dataClassNameToLabelPathMapping.get(semanticDescriptor.getDataClass().getName());
                    if (labelPath != null) {
                        LinkedList<String> copy = new LinkedList<String>(labelPath);
                        DataObject labelObject = this.resolveAttributePath((AggregateObject)semanticDescriptor, copy);
                        if (labelObject != null) {
                            label.append(LabelProviderFactory.getLabel(labelObject));
                            generatedLabel = true;
                        } else {
                            label.append("null");
                            generatedLabel = true;
                        }
                    }
                }
            }
        }
        if (!generatedLabel) {
            label.append(LabelProviderFactory.getLabel((DataObject)nestGraphItemObject));
        }
        if (!nestGraphItemObject.isNESTEdge() || nestGraphItemObject.isNESTEdge() && this.showEdgeLabels) {
            return label.toString();
        }
        return "";
    }

    private DataObject resolveAttributePath(AggregateObject aggregateObject, Queue<String> attributePath) {
        DataObject attributeValue = aggregateObject.getAttributeValue(attributePath.remove());
        if (attributePath.size() == 0 || attributeValue == null || attributeValue.isVoid()) {
            return attributeValue;
        }
        return this.resolveAttributePath((AggregateObject)attributeValue, attributePath);
    }

    public Map<String, Queue<String>> getDataClassNameToLabelPathMapping() {
        return this.dataClassNameToLabelPathMapping;
    }

    public boolean isShowIds() {
        return this.showIds;
    }

    public void setShowIds(boolean showIds) {
        this.showIds = showIds;
    }

    public boolean isShowEdgeLabels() {
        return this.showEdgeLabels;
    }

    public void setShowEdgeLabels(boolean showEdgeLabels) {
        this.showEdgeLabels = showEdgeLabels;
    }

    public void setLabelModeForItem(NESTGraphItemObject graphItemObject, LabelMode mode) {
        this.graphItemToLabelModeMapping.put(graphItemObject, mode);
    }
}

