/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor.label;

import de.uni_trier.wi2.procake.data.model.DataClass;
import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.gui.objecteditor.label.AggregateObjectLabelProvider;
import de.uni_trier.wi2.procake.gui.objecteditor.label.AtomicObjectLabelProvider;
import de.uni_trier.wi2.procake.gui.objecteditor.label.LabelProvider;
import de.uni_trier.wi2.procake.gui.objecteditor.label.NESTGraphItemObjectLabelProvider;
import de.uni_trier.wi2.procake.utils.composition.Factory;
import java.util.HashMap;
import java.util.Map;

public class LabelProviderFactory
implements Factory {
    private static final Map<String, LabelProvider> providers = new HashMap<String, LabelProvider>();

    public static <T extends LabelProvider> T getProvider(DataClass dataClass) {
        for (DataClass tmp = dataClass; tmp != null; tmp = tmp.getSuperClass()) {
            LabelProvider provider = providers.get(tmp.getName());
            if (provider == null) continue;
            return (T)((Object)provider);
        }
        return null;
    }

    public static String getLabel(DataObject dataObject) {
        if (dataObject == null) {
            return "";
        }
        Object provider = LabelProviderFactory.getProvider(dataObject.getDataClass());
        if (provider == null) {
            return "";
        }
        return ((LabelProvider)((Object)provider)).getLabel(dataObject);
    }

    public boolean bind(Object implementation) {
        if (implementation instanceof LabelProvider) {
            LabelProvider provider = (LabelProvider)((Object)implementation);
            providers.put(provider.getDataClassName(), provider);
            return true;
        }
        return false;
    }

    public boolean unbind(Object implementation) {
        LabelProvider provider;
        if (implementation instanceof LabelProvider && providers.containsKey((provider = (LabelProvider)((Object)implementation)).getDataClassName())) {
            providers.remove(provider.getDataClassName());
            return true;
        }
        return false;
    }

    public void reset() {
        providers.clear();
    }

    static {
        providers.put("NESTGraphElement", new NESTGraphItemObjectLabelProvider());
        providers.put("Atomic", new AtomicObjectLabelProvider());
        providers.put("Aggregate", new AggregateObjectLabelProvider());
    }
}

