/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor.label;

import de.uni_trier.wi2.procake.data.PropertyTreeNode;
import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.utils.composition.FactoryObjectImplementation;
import de.uni_trier.wi2.procake.utils.composition.Parameter;
import de.uni_trier.wi2.procake.utils.composition.XMLConfiguration.AbstractParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class LabelProvider
extends FactoryObjectImplementation {
    protected final Parameter DATA_CLASS_NAME = new Parameter("dataClassName", false, null);
    private final String MULTI_LABEL_DELIMITER_NEW_LINE_VALUE = "newline";
    protected final Parameter MULTI_LABEL_DELIMITER = new Parameter("multiLabelDelimiter", false, "newline");
    protected final Parameter DISPLAY_PROPERTIES = new Parameter("displayProperties", false, null);
    protected List<Parameter> parameterList = new ArrayList<Parameter>();

    public List<Parameter> getParameters() {
        return new ArrayList<Parameter>(this.parameterList);
    }

    public void preInit(AbstractParameter[] parameters) {
        for (AbstractParameter parameter : parameters) {
            if (parameter.getKey().equals(this.DATA_CLASS_NAME.getName())) {
                this.DATA_CLASS_NAME.setValues(parameter.getValue());
                this.parameterList.add(this.DATA_CLASS_NAME);
                continue;
            }
            if (parameter.getKey().equals(this.MULTI_LABEL_DELIMITER.getName())) {
                if (parameter.getValue().equals("newline")) {
                    this.MULTI_LABEL_DELIMITER.setValue("\n");
                } else {
                    this.MULTI_LABEL_DELIMITER.setValue(parameter.getValue());
                }
                this.parameterList.add(this.MULTI_LABEL_DELIMITER);
                continue;
            }
            if (!parameter.getKey().equals(this.DISPLAY_PROPERTIES.getName())) continue;
            this.DISPLAY_PROPERTIES.setValues(parameter.getValue());
            this.parameterList.add(this.DISPLAY_PROPERTIES);
        }
    }

    public void postInit() {
    }

    public String getLabel(DataObject dataObject) {
        if (dataObject == null) {
            return null;
        }
        if (this.DISPLAY_PROPERTIES.getValue() != null && dataObject.getPropertyRootNode() != null) {
            return this.DISPLAY_PROPERTIES.getValues().stream().map(propName -> {
                for (PropertyTreeNode property : dataObject.getPropertyRootNode()) {
                    if (!property.getName().equals(propName)) continue;
                    return property.getValue();
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.joining(this.MULTI_LABEL_DELIMITER.getValue()));
        }
        return null;
    }

    public String getDataClassName() {
        return this.DATA_CLASS_NAME.getValue();
    }
}

