/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor.label;

import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.data.object.base.AggregateObject;
import de.uni_trier.wi2.procake.gui.objecteditor.label.LabelProvider;
import de.uni_trier.wi2.procake.gui.objecteditor.label.LabelProviderFactory;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.utils.Utils;
import de.uni_trier.wi2.procake.utils.composition.Parameter;
import de.uni_trier.wi2.procake.utils.composition.XMLConfiguration.AbstractParameter;
import de.uni_trier.wi2.procake.utils.exception.InvalidParameterException;
import java.util.Objects;
import java.util.stream.Collectors;

public class AggregateObjectLabelProvider
extends LabelProvider {
    private final Parameter DISPLAY_ATTRIBUTE_NAME = new Parameter("displayAttributeName", false, "true");
    private final String DISPLAY_ATTRIBUTES_ALL_VALUE = "**all**";
    private final Parameter DISPLAY_ATTRIBUTES = new Parameter("displayAttributes", false, "**all**");
    private boolean includeNullAttributes = false;
    private boolean includeAllAttributes = false;

    @Override
    public void preInit(AbstractParameter[] parameters) {
        super.preInit(parameters);
        if (this.DATA_CLASS_NAME.getValue() == null) {
            this.DATA_CLASS_NAME.setValue("Aggregate");
        }
        for (AbstractParameter parameter : parameters) {
            if (parameter.getKey().equals(this.DISPLAY_ATTRIBUTE_NAME.getName())) {
                if (!parameter.getValue().equals("true") && !parameter.getValue().equals("false")) {
                    throw new InvalidParameterException("Invalid parameter value \"" + parameter.getValue() + "\". Boolean expected.", new String[0]);
                }
                this.DISPLAY_ATTRIBUTE_NAME.setValue(parameter.getValue());
                this.parameterList.add(this.DISPLAY_ATTRIBUTE_NAME);
                continue;
            }
            if (!parameter.getKey().equals(this.DISPLAY_ATTRIBUTES.getName())) continue;
            this.DISPLAY_ATTRIBUTES.setValues(parameter.getValue());
            this.parameterList.add(this.DISPLAY_ATTRIBUTES);
        }
    }

    @Override
    public String getLabel(DataObject dataObject) {
        String label = super.getLabel(dataObject);
        if (label != null) {
            return label;
        }
        if (dataObject == null) {
            return "";
        }
        AggregateObject aggregateObject = (AggregateObject)dataObject;
        if (this.DISPLAY_ATTRIBUTES.getValue() != null) {
            if (this.DISPLAY_ATTRIBUTES.getValue().equals("**all**") || this.includeAllAttributes) {
                return Utils.aggregateToPaddedTable(aggregateObject, this.includeNullAttributes);
            }
            if (this.DISPLAY_ATTRIBUTES.getValues().size() > 0) {
                return this.DISPLAY_ATTRIBUTES.getValues().stream().map(attributeName -> {
                    DataObject attributeValue = aggregateObject.getAttributeValue(attributeName);
                    if (attributeValue != null) {
                        return (String)(Boolean.parseBoolean(this.DISPLAY_ATTRIBUTE_NAME.getValue()) ? attributeName + ": " : "") + LabelProviderFactory.getLabel(attributeValue);
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.joining(this.MULTI_LABEL_DELIMITER.getValue()));
            }
        }
        return Objects.toString(aggregateObject);
    }

    public boolean isIncludeNullAttributes() {
        return this.includeNullAttributes;
    }

    public void setIncludeNullAttributes(boolean includeNullAttributes) {
        this.includeNullAttributes = includeNullAttributes;
    }

    public boolean isIncludeAllAttributes() {
        return this.includeAllAttributes;
    }

    public void setIncludeAllAttributes(boolean includeAllAttributes) {
        this.includeAllAttributes = includeAllAttributes;
    }
}

