/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor;

import de.uni_trier.wi2.procake.gui.objecteditor.ObjectEditor;
import de.uni_trier.wi2.procake.gui.objecteditor.ObjectJTree;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

class TreeSelectionPathBar
extends JPanel
implements TreeSelectionListener {
    private final ObjectEditor objectEditor;
    private ObjectJTree tree;

    public TreeSelectionPathBar(ObjectEditor objectEditor, ObjectJTree tree) {
        this.objectEditor = objectEditor;
        this.tree = tree;
        this.setLayout(new FlowLayout(3));
        tree.getTree().addTreeSelectionListener(this);
        this.add(new JLabel(" "));
        JButton dummy = new JButton(" ");
        dummy.setMargin(new Insets(5, 2, 5, 2));
        dummy.setBorderPainted(false);
        dummy.setFocusPainted(false);
        this.add(dummy);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath selectionPath = this.tree.getTree().getSelectionPath();
        if (selectionPath == null) {
            return;
        }
        this.removeAll();
        for (int i = 0; i < selectionPath.getPathCount(); ++i) {
            JButton clickableLabel = new JButton(this.objectEditor.getLabel(selectionPath.getPathComponent(i)));
            clickableLabel.setMargin(new Insets(5, 2, 5, 2));
            clickableLabel.setFocusPainted(false);
            clickableLabel.setBorderPainted(false);
            int finalI = i;
            clickableLabel.addActionListener(e -> {
                TreePath path = new TreePath(Arrays.copyOfRange(selectionPath.getPath(), 0, finalI + 1));
                this.tree.getTree().setSelectionPath(path);
                this.tree.getTree().scrollPathToVisible(path);
            });
            this.add(clickableLabel);
            if (i >= selectionPath.getPathCount() - 1) continue;
            JLabel bracket = new JLabel("\u232a");
            Font font = bracket.getFont();
            bracket.setFont(font.deriveFont(font.getStyle() | 1));
            this.add(bracket);
        }
        this.revalidate();
        this.repaint();
    }
}

