/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor;

import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.gui.objecteditor.FilterableObjectPoolTreeModel;
import de.uni_trier.wi2.procake.gui.objecteditor.ObjectEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

class PoolFilterBar
extends JPanel {
    private final ObjectEditor editor;
    JTextField filterInput = new JTextField();
    JPanel functionalityButtons = new JPanel(new BorderLayout());
    JCheckBox filterCheckbox = new JCheckBox("in context");
    JButton filterButton = new JButton("Filter");
    JPanel nextPathButtons = new JPanel(new BorderLayout());
    JButton nextBtn = new JButton("Next");
    JButton backBtn = new JButton("Back");
    JTextField counterPaths = new JTextField("0/0");

    public PoolFilterBar(ObjectEditor editor) {
        this.editor = editor;
        this.setLayout(new BorderLayout());
        this.buildFilterLayout();
        this.addActionListeners();
    }

    private void buildFilterLayout() {
        this.counterPaths.setEditable(false);
        this.nextPathButtons.add((Component)this.backBtn, "Before");
        this.nextPathButtons.add((Component)this.nextBtn, "Center");
        this.nextPathButtons.add((Component)this.counterPaths, "After");
        this.functionalityButtons.add((Component)this.filterButton, "Before");
        this.functionalityButtons.add((Component)this.filterCheckbox, "Center");
        this.functionalityButtons.add((Component)this.nextPathButtons, "After");
        this.add((Component)this.functionalityButtons, "Before");
        this.add((Component)this.filterInput, "Center");
    }

    private <T extends DataObject> void addActionListeners() {
        ActionListener filterAction = e -> {
            String filterOptions = "Filter";
            Object source = e.getSource();
            if (source instanceof JButton) {
                JButton clickedButton = (JButton)source;
                filterOptions = clickedButton.getText();
            }
            FilterableObjectPoolTreeModel.FilterStatus procFilterInput = ((FilterableObjectPoolTreeModel)this.editor.getTree().getModel()).setFilter(this.filterInput.getText(), this.filterCheckbox.isSelected(), filterOptions);
            this.updateFilterTextField(procFilterInput);
        };
        this.filterInput.addActionListener(filterAction);
        this.filterButton.addActionListener(filterAction);
        this.nextBtn.addActionListener(filterAction);
        this.backBtn.addActionListener(filterAction);
    }

    private void updateFilterTextField(FilterableObjectPoolTreeModel.FilterStatus procFilterInput) {
        if (procFilterInput.isFilterSuccess()) {
            this.filterInput.setBackground(Color.WHITE);
            this.editor.updateTreeView();
            this.counterPaths.setText((String)(procFilterInput.getFilteredPaths() == null || procFilterInput.getFilteredPaths().size() == 0 ? "0/0" : procFilterInput.getOldFilterPos() + 1 + "/" + procFilterInput.getFilteredPaths().size()));
        } else {
            this.filterInput.setBackground(new Color(255, 170, 166));
            this.counterPaths.setText("0/" + procFilterInput.getFilteredPaths().size());
        }
        this.filterInput.setText(procFilterInput.getProcTargetText());
    }
}

