/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor;

import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.data.object.base.AggregateObject;
import de.uni_trier.wi2.procake.data.object.base.CollectionObject;
import de.uni_trier.wi2.procake.data.object.base.ListObject;
import de.uni_trier.wi2.procake.data.object.base.SetObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTEdgeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTGraphItemObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTWorkflowObject;
import de.uni_trier.wi2.procake.data.objectpool.ReadableObjectPool;
import de.uni_trier.wi2.procake.data.objectpool.WriteableObjectPool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectPoolTreeModel<T extends DataObject>
implements TreeModel {
    public static final String NODES_CATEGORY_LABEL = "Nodes";
    public static final String EDGES_CATEGORY_LABEL = "Edges";
    protected static final Logger logger = LoggerFactory.getLogger(ObjectPoolTreeModel.class);
    WriteableObjectPool<T> pool;
    private Vector<TreeModelListener> treeModelListeners = new Vector();

    public ObjectPoolTreeModel(WriteableObjectPool<T> pool) {
        this.pool = pool;
    }

    public WriteableObjectPool<T> getRoot() {
        return this.pool;
    }

    @Override
    public Object getChild(Object o, int i) {
        if (o instanceof DataObject) {
            DataObject dataObject = (DataObject)o;
            if (dataObject.isAggregate()) {
                AggregateObject aggregateObject = (AggregateObject)dataObject;
                ArrayList attributeNames = new ArrayList(aggregateObject.getAggregateClass().getAttributeNames());
                Collections.sort(attributeNames);
                return new ImmutablePair((Object)((String)attributeNames.get(i)), (Object)aggregateObject.getAttributeValue((String)attributeNames.get(i)));
            }
            if (dataObject.isList()) {
                return ((ListObject)dataObject).elementAt(i);
            }
            if (dataObject.isSet()) {
                SetObject setObject = (SetObject)dataObject;
                ArrayList collectionList = new ArrayList(setObject.size());
                setObject.iterator().forEachRemaining(setElement -> collectionList.add((DataObject)setElement));
                return collectionList.stream().sorted(new DataObjectComparator()).collect(Collectors.toList()).get(i);
            }
            if (dataObject.isNESTEdge() || dataObject.isNESTNode()) {
                return this.getChild(((NESTGraphItemObject)dataObject).getSemanticDescriptor(), i);
            }
            if (dataObject.isNESTWorkflow()) {
                switch (i) {
                    case 0: {
                        Set graphNodes = ((NESTWorkflowObject)dataObject).getGraphNodes();
                        return graphNodes.size() == 0 ? NODES_CATEGORY_LABEL : new HashSet<NESTNodeObject>((Collection)graphNodes){

                            @Override
                            public String toString() {
                                return ObjectPoolTreeModel.NODES_CATEGORY_LABEL;
                            }
                        };
                    }
                    case 1: {
                        return new HashSet<NESTEdgeObject>((Collection)((NESTWorkflowObject)dataObject).getGraphEdges()){

                            @Override
                            public String toString() {
                                return ObjectPoolTreeModel.EDGES_CATEGORY_LABEL;
                            }
                        };
                    }
                }
                logger.info("Unhandled statement caught in default branch of switch case.");
                logger.info(String.valueOf(i));
                return i;
            }
        } else {
            if (o instanceof Pair) {
                return this.getChild(((Pair)o).getValue(), i);
            }
            if (o instanceof Set) {
                return ((Set)o).stream().sorted(Comparator.comparing(graphItem -> ((NESTGraphItemObject)graphItem).getDataClass().getName()).thenComparing(graphItem -> ((NESTGraphItemObject)graphItem).getId())).collect(Collectors.toList()).get(i);
            }
            if (o instanceof ReadableObjectPool) {
                return new ArrayList(((ReadableObjectPool)o).getCollection()).stream().sorted(new DataObjectComparator()).collect(Collectors.toList()).get(i);
            }
        }
        return null;
    }

    @Override
    public int getChildCount(Object o) {
        if (o instanceof DataObject) {
            DataObject dataObject = (DataObject)o;
            if (dataObject.isAggregate()) {
                return ((AggregateObject)dataObject).getAggregateClass().getAttributeNames().size();
            }
            if (dataObject.isCollection()) {
                return ((CollectionObject)dataObject).size();
            }
            if (dataObject.isNESTEdge() || dataObject.isNESTNode()) {
                return this.getChildCount(((NESTGraphItemObject)dataObject).getSemanticDescriptor());
            }
            if (dataObject.isNESTWorkflow()) {
                return 2;
            }
        } else {
            if (o instanceof Pair) {
                return this.getChildCount(((Pair)o).getValue());
            }
            if (o instanceof Set) {
                return ((Set)o).size();
            }
            if (o instanceof ReadableObjectPool) {
                return ((ReadableObjectPool)o).size();
            }
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object o) {
        if (o instanceof DataObject) {
            DataObject dataObject = (DataObject)o;
            if (dataObject.isAggregate()) {
                return ((AggregateObject)dataObject).getAggregateClass().getAttributeNames().size() <= 0;
            }
            if (dataObject.isCollection()) {
                return ((CollectionObject)dataObject).size() <= 0;
            }
            if (dataObject.isNESTEdge() || dataObject.isNESTNode()) {
                return this.getChildCount(((NESTGraphItemObject)dataObject).getSemanticDescriptor()) <= 0;
            }
            if (dataObject.isNESTWorkflow()) {
                return false;
            }
        } else {
            if (o instanceof Pair) {
                return this.isLeaf(((Pair)o).getValue());
            }
            if (o instanceof Set) {
                return ((Set)o).size() <= 0;
            }
            if (o instanceof ReadableObjectPool) {
                return ((ReadableObjectPool)o).size() <= 0;
            }
        }
        return true;
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object o) {
        System.out.println("valueForPathChanged: " + treePath + " -> " + o);
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.treeModelListeners.addElement(treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.treeModelListeners.removeElement(treeModelListener);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int i;
        int max = this.getChildCount(parent);
        if (child instanceof NESTWorkflowObject) {
            for (i = 0; i < max; ++i) {
                if (((NESTWorkflowObject)this.getChild(parent, i)).getId().compareTo(((NESTWorkflowObject)child).getId()) != 0) continue;
                return i;
            }
        }
        for (i = 0; i < max; ++i) {
            if (!this.getChild(parent, i).equals(child)) continue;
            return i;
        }
        return -1;
    }

    public void fireTreeStructureChanged(Object[] path) {
        TreeModelEvent e = new TreeModelEvent((Object)this, path);
        this.treeModelListeners.forEach(listener -> listener.treeStructureChanged(e));
    }

    public static class DataObjectComparator<T extends DataObject>
    implements Comparator<T> {
        @Override
        public int compare(T a, T b) {
            return a.getId() == null || b.getId() == null ? -1 : a.getId().compareTo(b.getId());
        }
    }
}

