/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor;

import de.uni_trier.wi2.procake.data.model.DataClass;
import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTAbstractWorkflowObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTGraphItemObject;
import de.uni_trier.wi2.procake.data.objectpool.WriteableObjectPool;
import de.uni_trier.wi2.procake.gui.DataObjectLabelProvider;
import de.uni_trier.wi2.procake.gui.objecteditor.AddDataPanel;
import de.uni_trier.wi2.procake.gui.objecteditor.FilterableObjectPoolTreeModel;
import de.uni_trier.wi2.procake.gui.objecteditor.ObjectEditorActions;
import de.uni_trier.wi2.procake.gui.objecteditor.ObjectEditorMenuBar;
import de.uni_trier.wi2.procake.gui.objecteditor.ObjectEditorTreeModel;
import de.uni_trier.wi2.procake.gui.objecteditor.ObjectJTree;
import de.uni_trier.wi2.procake.gui.objecteditor.ObjectPoolTreeModel;
import de.uni_trier.wi2.procake.gui.objecteditor.PoolFilterBar;
import de.uni_trier.wi2.procake.gui.objecteditor.TreeModelListenerAdapter;
import de.uni_trier.wi2.procake.gui.objecteditor.TreeSelectionPathBar;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.DataObjectEditorSaveable;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.NESTWorkflowEditor;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor.EditorToolBar;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectEditor<T extends DataObject>
extends DataObjectLabelProvider {
    protected static final Logger logger = LoggerFactory.getLogger(ObjectEditor.class);
    private static final Object windowCloseLock = new Object();
    JComboBox<DataClass> newDataObjectClassSelector;
    JScrollPane treeScrollPane;
    private JFrame Jframe = new JFrame();
    private T originalDataObject;
    private T dataObject;
    private WriteableObjectPool<T> pool;
    private WriteableObjectPool<T> originalPool;
    private ObjectJTree tree;
    TreeModelListener treeModelListener = new TreeModelListenerAdapter(){

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            ObjectEditor.this.tree.getTree().scrollPathToVisible(e.getTreePath());
        }
    };
    private File currentFile;
    private JSplitPane mainSplitPane;
    private JButton saveButton;
    private boolean changesInObject = false;
    private DataObjectEditorSaveable activeDataObjectEditor;
    private NESTWorkflowEditor activeNestGraphEditor;
    private EditorToolBar extraToolBar = null;

    public ObjectEditor(T dataObject, boolean blockThreadUntilEditorWindowClosed) {
        this.loadObject(dataObject);
        this.setUpApp(blockThreadUntilEditorWindowClosed);
    }

    public ObjectEditor(T dataObject) {
        this(dataObject, false);
    }

    public ObjectEditor(WriteableObjectPool<T> pool, boolean blockThreadUntilEditorWindowClosed) {
        this.loadObject(pool);
        this.setUpApp(blockThreadUntilEditorWindowClosed);
    }

    public ObjectEditor(WriteableObjectPool<T> pool) {
        this(pool, false);
    }

    private void setUpApp(boolean blockThreadUntilEditorWindowClosed) {
        this.setUpFrame();
        this.Jframe.setVisible(true);
        this.tree = this.setUpTree();
        JPanel leftPanel = this.setUpLeftPane();
        JPanel rightPanel = this.setUpRightPane();
        this.mainSplitPane = this.setUpSplitPane(leftPanel, rightPanel);
        this.Jframe.add(this.mainSplitPane);
        this.Jframe.setJMenuBar(new ObjectEditorMenuBar(this));
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)new TreeSelectionPathBar(this, this.tree), "First");
        topPanel.add((Component)new PoolFilterBar(this), "Last");
        this.Jframe.add((Component)topPanel, "First");
        this.Jframe.setMinimumSize(new Dimension(1366, 768));
        if (this.pool == null && this.dataObject != null) {
            this.tree.getTree().setSelectionRow(0);
        } else if (this.pool != null && this.dataObject == null) {
            this.tree.getTree().setSelectionRow(1);
        }
        if (blockThreadUntilEditorWindowClosed) {
            this.waitUntilEditorWindowClosed();
        }
    }

    ObjectJTree setUpTree() {
        final ObjectJTree tree = new ObjectJTree(this);
        if (this.pool == null) {
            tree.getTree().setModel(new ObjectEditorTreeModel((DataObject)this.dataObject));
        } else if (this.dataObject == null) {
            tree.getTree().setModel(new FilterableObjectPoolTreeModel<T>(this.pool, this));
        }
        tree.getTree().getModel().addTreeModelListener(this.treeModelListener);
        tree.getTree().addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    int selRow = tree.getTree().getRowForLocation(e.getX(), e.getY());
                    TreePath selPath = tree.getTree().getPathForLocation(e.getX(), e.getY());
                    tree.getTree().setSelectionPath(selPath);
                    if (selRow > -1) {
                        tree.getTree().setSelectionRow(selRow);
                    }
                    Point pt = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), ObjectEditor.this.Jframe);
                    JPopupMenu menu = new JPopupMenu();
                    menu.add(new ObjectEditorActions.AddNewDataAction(ObjectEditor.this, ObjectEditor.this.newDataObjectClassSelector));
                    menu.add(new ObjectEditorActions.DeleteDataAction(ObjectEditor.this));
                    if (tree.getTree().getSelectionPath() == null) {
                        for (Component element : menu.getComponents()) {
                            element.setEnabled(false);
                        }
                    }
                    menu.show(ObjectEditor.this.Jframe, pt.x, pt.y);
                }
            }
        });
        tree.getTree().getSelectionModel().setSelectionMode(1);
        tree.getTree().addTreeSelectionListener(e -> {
            TreePath selectionPath = tree.getTree().getSelectionPath();
            if (selectionPath == null) {
                return;
            }
            Object[] path = selectionPath.getPath();
            Object selectedElement = path[path.length - 1];
            if (this.extraToolBar != null) {
                this.Jframe.remove(this.extraToolBar);
                this.extraToolBar = new EditorToolBar(0);
                this.Jframe.add((Component)this.extraToolBar, "North");
            }
            DataObject dataObject = null;
            if (selectedElement instanceof DataObject) {
                dataObject = (DataObject)selectedElement;
            } else if (selectedElement instanceof Map.Entry && (dataObject = (DataObject)((Map.Entry)selectedElement).getValue()) == null) {
                this.mainSplitPane.setRightComponent(new JLabel("Creation and deletion of aggregate attributes have to be done in the editor of the corresponding aggregate object."));
                return;
            }
            if (dataObject != null) {
                if (dataObject.isNESTWorkflow() || dataObject.isNESTSequentialWorkflow()) {
                    this.activeNestGraphEditor = new NESTWorkflowEditor((NESTAbstractWorkflowObject)dataObject, true, true, true, true);
                    this.activeNestGraphEditor.addGraphSaveListener(this::updateForNESTGraphEditorSave);
                    this.mainSplitPane.setRightComponent(this.activeNestGraphEditor);
                    this.extraToolBar = new EditorToolBar(this.activeNestGraphEditor, 0);
                    this.Jframe.add((Component)this.extraToolBar, "North");
                } else if (dataObject.isNESTEdge() || dataObject.isNESTNode()) {
                    NESTGraphItemObject graphItemObject = (NESTGraphItemObject)dataObject;
                    if (graphItemObject.getSemanticDescriptor() != null) {
                        this.mainSplitPane.setRightComponent(new JScrollPane(this.createSaveableDataObjectEditorPanel(graphItemObject.getSemanticDescriptor())));
                    }
                } else {
                    this.mainSplitPane.setRightComponent(new JScrollPane(this.createSaveableDataObjectEditorPanel(dataObject)));
                }
            } else {
                this.mainSplitPane.setRightComponent(new JLabel(""));
            }
            Object[] oldPath = e.getOldLeadSelectionPath() != null ? e.getOldLeadSelectionPath().getPath() : null;
            SwingUtilities.invokeLater(() -> SwingUtilities.updateComponentTreeUI(this.Jframe));
            if (oldPath == null) {
                return;
            }
            this.updateTreeView(oldPath);
        });
        return tree;
    }

    private JPanel createSaveableDataObjectEditorPanel(DataObject dataObject) {
        JPanel panel = new JPanel(new BorderLayout());
        this.activeDataObjectEditor = new DataObjectEditorSaveable(dataObject, true);
        panel.add((Component)this.activeDataObjectEditor, "Center");
        if (!dataObject.isCollection() && this.dataObject != null && !this.dataObject.isCollection() && this.pool == null) {
            this.saveButton = new JButton("Save changes");
            this.saveButton.addActionListener(e -> {
                this.setCurrentFile(null);
                if (!this.Jframe.getTitle().endsWith(" *")) {
                    this.Jframe.setTitle(this.Jframe.getTitle() + " *");
                    this.activeDataObjectEditor.saveChanges();
                    this.updateTreeView(Objects.requireNonNull(this.tree.getTree().getSelectionPath()).getPath());
                }
            });
            JPanel buttonPanel = new JPanel(new FlowLayout(0));
            buttonPanel.add(this.saveButton);
            panel.add((Component)buttonPanel, "First");
        }
        return panel;
    }

    void updateTreeView(Object[] path) {
        TreePath selectionPath = this.tree.getTree().getSelectionPath();
        if (this.pool == null) {
            ((ObjectEditorTreeModel)this.tree.getTree().getModel()).fireTreeStructureChanged(path);
        } else if (this.dataObject == null) {
            ((FilterableObjectPoolTreeModel)this.tree.getTree().getModel()).fireTreeStructureChanged(path);
        }
        this.tree.getTree().scrollPathToVisible(selectionPath);
        this.tree.getTree().setSelectionPath(selectionPath);
    }

    void updateTreeView() {
        TreePath selectionPath = this.tree.getTree().getSelectionPath();
        if (this.pool == null) {
            ((ObjectEditorTreeModel)this.tree.getTree().getModel()).fireTreeStructureChanged(new Object[]{this.dataObject});
        } else if (this.dataObject == null) {
            ((ObjectPoolTreeModel)this.tree.getTree().getModel()).fireTreeStructureChanged(new Object[]{this.getPool()});
            this.tree.getTree().scrollPathToVisible(selectionPath);
            this.tree.getTree().setSelectionPath(selectionPath);
        }
        this.tree.getTree().scrollPathToVisible(selectionPath);
        this.tree.getTree().setSelectionPath(selectionPath);
    }

    JPanel setUpRightPane() {
        return new JPanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilEditorWindowClosed() {
        try {
            while (!this.Jframe.isVisible()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            logger.error("Exception: ", (Throwable)e);
        }
        Object object = windowCloseLock;
        synchronized (object) {
            while (this.Jframe.isVisible()) {
                try {
                    windowCloseLock.wait();
                }
                catch (InterruptedException e) {
                    logger.error("Exception: ", (Throwable)e);
                }
            }
        }
    }

    JPanel setUpLeftPane() {
        JPanel leftPanel = new JPanel(new BorderLayout());
        this.treeScrollPane = new JScrollPane();
        leftPanel.add((Component)this.treeScrollPane, "Center");
        leftPanel.setMinimumSize(new Dimension(250, 250));
        this.treeScrollPane.setViewportView(this.tree.getTree());
        leftPanel.add(new AddDataPanel(this), "Last");
        return leftPanel;
    }

    private void setUpFrame() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            Utils.setDefaultFontSize(11.5f);
            SwingUtilities.updateComponentTreeUI(this.getJframe());
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        this.Jframe.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/images/ProCAKE_Icon.png")));
        this.Jframe.setDefaultCloseOperation(2);
        this.Jframe.setLayout(new BorderLayout());
        this.Jframe.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosing(WindowEvent e) {
                Object object = windowCloseLock;
                synchronized (object) {
                    JFrame frame = (JFrame)e.getComponent();
                    if (ObjectEditor.this.changesInObject) {
                        frame.setDefaultCloseOperation(0);
                        int n = JOptionPane.showConfirmDialog(ObjectEditor.this.getJframe(), "You may have unsaved changes. Do you want to continue closing the window?", "Unsaved Changes", 0, 2);
                        if (n == 1 || n == -1) {
                            frame.setVisible(true);
                            return;
                        }
                    }
                    frame.setDefaultCloseOperation(2);
                    ObjectEditor.this.Jframe.setVisible(false);
                    ObjectEditor.this.Jframe.dispose();
                    windowCloseLock.notify();
                }
            }
        });
        this.Jframe.pack();
    }

    void loadObject(T dataObject) {
        this.pool = null;
        this.originalPool = null;
        this.originalDataObject = dataObject;
        this.dataObject = this.originalDataObject.copy();
        this.Jframe.setTitle(dataObject.getId());
    }

    void loadObject(WriteableObjectPool<T> pool) {
        this.dataObject = null;
        this.originalDataObject = null;
        this.originalPool = pool;
        this.pool = pool.copy();
        this.Jframe.setTitle(this.pool.getId());
    }

    private JSplitPane setUpSplitPane(JPanel leftPanel, JPanel rightPanel) {
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setOneTouchExpandable(true);
        splitPane.setLeftComponent(leftPanel);
        splitPane.setRightComponent(rightPanel);
        splitPane.setDividerSize(12);
        this.Jframe.add((Component)splitPane, "Center");
        return splitPane;
    }

    protected DataObject getOriginalDataObject() {
        return this.originalDataObject;
    }

    protected void setOriginalDataObject(T dataObject) {
        this.originalDataObject = dataObject;
    }

    protected File getCurrentFile() {
        return this.currentFile;
    }

    protected void setCurrentFile(File file) {
        this.currentFile = file;
        this.updateTitle();
    }

    private void updateTitle() {
        String ID = this.dataObject == null ? this.pool.getId() : this.dataObject.getId();
        this.Jframe.setTitle(ID + (String)(this.currentFile != null ? " - file: " + this.currentFile.getAbsolutePath() : ""));
    }

    protected DataObject getDataObject() {
        return this.dataObject;
    }

    protected void setDataObject(T dataObject) {
        this.dataObject = dataObject;
    }

    protected void writeChangesToOriginalObject() {
        if (this.saveButton != null) {
            this.saveButton.doClick();
        }
        try {
            if (this.dataObject != null && this.pool == null) {
                this.originalDataObject = this.dataObject.copy();
            } else if (this.pool != null && this.dataObject == null) {
                this.originalPool = this.pool.copy();
            }
            this.Jframe.setTitle(this.Jframe.getTitle().replace("*", " ").trim());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.getJframe(), "Error in saving, please refer to the stack trace", "Error", 0);
            throw new RuntimeException(e);
        }
    }

    public JFrame getJframe() {
        return this.Jframe;
    }

    protected JTree getTree() {
        return this.tree.getTree();
    }

    protected void setTree(ObjectJTree setUpTree) {
        this.tree = setUpTree;
    }

    protected TreeModelListener getTreeModelListener() {
        return this.treeModelListener;
    }

    protected WriteableObjectPool<T> getPool() {
        return this.pool;
    }

    protected void setPool(WriteableObjectPool<T> pool) {
        this.pool = pool;
    }

    protected WriteableObjectPool<T> getOriginalPool() {
        return this.originalPool;
    }

    protected void setOriginalPool(WriteableObjectPool<T> pool) {
        this.originalPool = pool;
    }

    protected void setTreeModel(ObjectEditorTreeModel model) {
        this.tree.getTree().setModel(model);
    }

    protected void setTreeModel(FilterableObjectPoolTreeModel<?> model) {
        this.tree.getTree().setModel(model);
    }

    void setNewMainSplitPane(Component l, Component r) {
        this.mainSplitPane.setLeftComponent(l);
        this.mainSplitPane.setRightComponent(r);
    }

    private void updateForNESTGraphEditorSave(NESTAbstractWorkflowObject nestWorkflowObject) {
        Object[] path = this.tree.getTree().getSelectionPath().getPath();
        this.writeChangesToOriginalObject();
        SwingUtilities.invokeLater(() -> this.updateTreeView(path));
    }
}

