/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor;

import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.data.objectpool.ReadableObjectPool;
import de.uni_trier.wi2.procake.data.objectpool.WriteableObjectPool;
import de.uni_trier.wi2.procake.gui.objecteditor.ObjectEditor;
import de.uni_trier.wi2.procake.gui.objecteditor.ObjectPoolTreeModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.tree.TreePath;

public class FilterableObjectPoolTreeModel<T extends DataObject>
extends ObjectPoolTreeModel<T> {
    private FilterStatus filterStatus = new FilterStatus();
    private List<Object[]> listOfPaths;
    private ObjectEditor editor;

    public FilterableObjectPoolTreeModel(WriteableObjectPool<T> pool, ObjectEditor editor) {
        super(pool);
        this.listOfPaths = this.getAllPaths(pool);
        this.editor = editor;
    }

    @Override
    public Object getChild(Object o, int i) {
        if (o instanceof ReadableObjectPool) {
            return new ArrayList(((ReadableObjectPool)o).getCollection()).stream().collect(Collectors.toList()).get(i);
        }
        return super.getChild(o, i);
    }

    @Override
    public int getChildCount(Object o) {
        if (o instanceof ReadableObjectPool) {
            return (int)new ArrayList(((ReadableObjectPool)o).getCollection()).stream().count();
        }
        return super.getChildCount(o);
    }

    @Override
    public boolean isLeaf(Object o) {
        if (o instanceof ReadableObjectPool) {
            return this.getChildCount(o) <= 0;
        }
        return super.isLeaf(o);
    }

    public FilterStatus setFilter(String targetText, boolean contextChecked, String filterOptions) {
        String[] targetFilters = targetText.split("&");
        targetFilters = (String[])Arrays.stream(targetFilters).map(x -> FilterableObjectPoolTreeModel.convertStringToFormat(x)).toArray(String[]::new);
        TreePath currentPath = this.editor.getTree().getSelectionPath();
        if (targetText.isBlank()) {
            this.filterStatus.resetData(targetText, contextChecked);
            this.filterStatus.setFilterSuccess(true);
            TreePath root = new TreePath(currentPath.getPathComponent(0));
            this.editor.getTree().setSelectionPath(root);
            return this.filterStatus;
        }
        if (this.isSameFilterFunction(targetText) && this.isSameInContext(contextChecked) && this.isSameContextPath(currentPath)) {
            this.getNextFilteredPath(filterOptions);
            return this.filterStatus;
        }
        this.filterStatus.resetData(targetText, contextChecked);
        for (int arrPos = 0; arrPos < this.listOfPaths.size(); ++arrPos) {
            String[] pathStringsSemantics;
            String[] pathStringsIds;
            int index;
            Object[] path = this.listOfPaths.get(arrPos);
            if (contextChecked && !this.checkInContext(path, currentPath) || (index = FilterableObjectPoolTreeModel.findMatchingFoundedElementIndex(pathStringsIds = (String[])Arrays.stream(path).map(elem -> FilterableObjectPoolTreeModel.convertStringToFormat(elem.toString())).toArray(String[]::new), pathStringsSemantics = (String[])Arrays.stream(path).map(elem -> FilterableObjectPoolTreeModel.convertStringToFormat(this.editor.getLabel(elem))).toArray(String[]::new), targetFilters)) == -1) continue;
            this.filterStatus.getFilteredPaths().add(Arrays.copyOf(this.listOfPaths.get(arrPos), index + 1));
        }
        if (this.checkIfFilteredPathExist()) {
            this.editor.getTree().setSelectionPath(new TreePath(this.filterStatus.getFilteredPaths().get(0)));
            this.filterStatus.setOldContextPath(this.editor.getTree().getSelectionPath());
        }
        return this.filterStatus;
    }

    private static int findMatchingFoundedElementIndex(String[] pathIds, String[] pathSemantics, String[] filterList) {
        int maxIndex = -1;
        boolean pathContainAllFilters = Arrays.stream(filterList).allMatch(filter -> Arrays.stream(pathSemantics).anyMatch(pathElement -> pathElement.contains((CharSequence)filter)) || Arrays.stream(pathIds).anyMatch(pathElement -> pathElement.contains((CharSequence)filter)));
        if (pathContainAllFilters) {
            for (int i = 0; i < pathIds.length; ++i) {
                int finalI = i;
                boolean containsInPathId = Arrays.stream(filterList).anyMatch(filter -> pathIds[finalI].contains((CharSequence)filter));
                boolean containsInPathSemantics = Arrays.stream(filterList).anyMatch(filter -> pathSemantics[finalI].contains((CharSequence)filter));
                if (!containsInPathId && !containsInPathSemantics) continue;
                maxIndex = finalI;
            }
        }
        return maxIndex;
    }

    private List<Object[]> getAllPaths(Object parent) {
        ArrayList<Object[]> listOfObjectIDs = new ArrayList<Object[]>();
        this.getDeepPaths(parent, new ArrayList<Object>(), listOfObjectIDs);
        return listOfObjectIDs;
    }

    private void getDeepPaths(Object parent, ArrayList<Object> currentPath, List<Object[]> listOfObjectIDs) {
        if (parent == null) {
            return;
        }
        currentPath.add(parent);
        if (this.getChildCount(parent) == 0) {
            listOfObjectIDs.add(currentPath.toArray());
        } else {
            for (int i = 0; i < this.getChildCount(parent); ++i) {
                this.getDeepPaths(this.getChild(parent, i), new ArrayList<Object>(currentPath), listOfObjectIDs);
            }
        }
    }

    private boolean isSameFilterFunction(String newTargetText) {
        if (this.filterStatus.getProcTargetText() == null) {
            return false;
        }
        String oldFilterText = this.filterStatus.getProcTargetText();
        return oldFilterText.equals(FilterableObjectPoolTreeModel.convertStringToFormat(newTargetText));
    }

    private boolean isSameInContext(boolean newContextChecked) {
        return newContextChecked == this.filterStatus.isOldCheckboxStatus();
    }

    private boolean isSameContextPath(TreePath newPath) {
        if (this.filterStatus.getOldContextPath() == null) {
            return false;
        }
        return newPath == this.filterStatus.getOldContextPath();
    }

    private void getNextFilteredPath(String backOrNext) {
        int oldIndex = this.filterStatus.getOldFilterPos();
        int filteredPathsSize = this.filterStatus.getFilteredPaths().size();
        int nextPos = backOrNext.equals("Back") ? ((oldIndex - 1) % filteredPathsSize + filteredPathsSize) % filteredPathsSize : (oldIndex + 1) % filteredPathsSize;
        if (this.checkIfFilteredPathExist()) {
            this.editor.getTree().setSelectionPath(new TreePath(this.filterStatus.getFilteredPaths().get(nextPos)));
            this.filterStatus.setOldFilterPos(nextPos);
            this.filterStatus.setOldContextPath(this.editor.getTree().getSelectionPath());
        }
    }

    private boolean checkIfFilteredPathExist() {
        if (this.filterStatus.getFilteredPaths().size() == 0) {
            this.filterStatus.setFilterSuccess(false);
            return false;
        }
        this.filterStatus.setFilterSuccess(true);
        return true;
    }

    private boolean checkInContext(Object[] path, TreePath currentPath) {
        for (int i = 0; i < currentPath.getPathCount(); ++i) {
            if (path[i] == currentPath.getPathComponent(i) || this.editor.getLabel(path[i]) == this.editor.getLabel(currentPath.getPathComponent(i))) continue;
            return false;
        }
        return true;
    }

    private static String convertStringToFormat(String text) {
        return text.replaceAll("\\s+", "").trim().toLowerCase();
    }

    protected class FilterStatus {
        private boolean filterSuccess;
        private String procTargetText;
        private int oldFilterPos;
        private boolean oldCheckboxStatus = false;
        private TreePath oldContextPath;
        private List<Object[]> filteredPaths;

        protected FilterStatus() {
        }

        public List<Object[]> getFilteredPaths() {
            return this.filteredPaths;
        }

        public void setFilteredPaths(List<Object[]> filteredPaths) {
            this.filteredPaths = filteredPaths;
        }

        public void setFilterSuccess(boolean filterSuccess) {
            this.filterSuccess = filterSuccess;
        }

        public boolean isFilterSuccess() {
            return this.filterSuccess;
        }

        public String getProcTargetText() {
            return this.procTargetText;
        }

        public boolean isOldCheckboxStatus() {
            return this.oldCheckboxStatus;
        }

        public int getOldFilterPos() {
            return this.oldFilterPos;
        }

        public void setOldFilterPos(int oldFilterPos) {
            this.oldFilterPos = oldFilterPos;
        }

        public TreePath getOldContextPath() {
            return this.oldContextPath;
        }

        public void setOldContextPath(TreePath currentContextPath) {
            this.oldContextPath = currentContextPath;
        }

        public void resetData(String targetText, boolean contextChecked) {
            this.procTargetText = FilterableObjectPoolTreeModel.convertStringToFormat(targetText);
            this.oldFilterPos = 0;
            this.oldCheckboxStatus = contextChecked;
            this.oldContextPath = null;
            this.filterSuccess = false;
            this.filteredPaths = new ArrayList<Object[]>();
        }
    }
}

