/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.objecteditor;

import de.uni_trier.wi2.procake.data.model.DataClass;
import de.uni_trier.wi2.procake.data.model.Model;
import de.uni_trier.wi2.procake.data.model.ModelFactory;
import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.data.objectpool.WriteableObjectPool;
import de.uni_trier.wi2.procake.gui.objecteditor.ObjectEditor;
import de.uni_trier.wi2.procake.gui.objecteditor.ObjectEditorActions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

class AddDataPanel<T>
extends JPanel {
    private final ObjectEditor objectEditor;

    public AddDataPanel(ObjectEditor objectEditor) {
        super(new BorderLayout());
        WriteableObjectPool pool;
        Stream poolCollection;
        Map<DataClass, List<DataObject>> groupedPool;
        List mostTypeObjects;
        this.objectEditor = objectEditor;
        if (objectEditor.getDataObject() != null && !objectEditor.getDataObject().isCollection()) {
            return;
        }
        Model model = ModelFactory.getDefaultModel();
        List possibleClasses = model.getClasses().stream().filter(DataClass::isInstantiable).collect(Collectors.toList());
        objectEditor.newDataObjectClassSelector = new JComboBox<DataClass>((DataClass[])possibleClasses.toArray(DataClass[]::new));
        if (objectEditor.getPool() != null && (mostTypeObjects = (List)(groupedPool = (poolCollection = (pool = objectEditor.getPool()).getCollection().stream()).collect(Collectors.groupingBy(DataObject::getDataClass))).values().stream().max(Comparator.comparing(List::size)).orElse(new ArrayList())).size() > 0) {
            objectEditor.newDataObjectClassSelector.setSelectedItem(mostTypeObjects.iterator().next().getClass());
        }
        objectEditor.newDataObjectClassSelector.setMinimumSize(new Dimension(0, objectEditor.newDataObjectClassSelector.getHeight()));
        this.add(objectEditor.newDataObjectClassSelector, "Center");
        JButton addButton = new JButton(new ObjectEditorActions.AddNewDataAction(objectEditor, objectEditor.newDataObjectClassSelector));
        JButton deleteButton = new JButton(new ObjectEditorActions.DeleteDataAction(objectEditor));
        deleteButton.setMnemonic(127);
        this.add((Component)addButton, "After");
        this.add((Component)deleteButton, "Last");
    }
}

