/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui.nestworkflow;

import com.mxgraph.canvas.mxICanvas;
import com.mxgraph.canvas.mxSvgCanvas;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxCellRenderer;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxDomUtils;
import com.mxgraph.util.mxXmlUtils;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxStylesheet;
import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.data.object.base.AggregateObject;
import de.uni_trier.wi2.procake.data.object.base.AtomicObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTDataNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTEdgeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTGraphItemObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTSequenceNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTWorkflowObject;
import de.uni_trier.wi2.procake.data.object.nest.controlflowNode.NESTControlflowNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.utils.impl.NESTWorkflowVisualizerImpl;
import de.uni_trier.wi2.procake.data.objectpool.WriteableObjectPool;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputAdapter;
import org.w3c.dom.Node;

public class MxGraphPanel
extends JPanel {
    public static final String DATA_NODE_STYLE = "DATA_NODE_STYLE";
    public static final String TASK_NODE_STYLE = "TASK_NODE_STYLE";
    public static final String CONTROL_FLOW_NODE_STYLE = "CONTROL_FLOW_NODE_STYLE";
    public static final String DATA_FLOW_EDGE_STYLE = "DATA_FLOW_EDGE_STYLE";
    public static final String CONTROL_FLOW_EDGE_STYLE = "CONTROL_FLOW_EDGE_STYLE";
    protected static final int VERTEX_WIDTH = 90;
    protected static final int VERTEX_HEIGHT = 40;
    protected static final int X_SPACING = 130;
    protected static final int Y_SPACING = 80;
    private final NESTWorkflowVisualizerImpl visualizer;
    protected JPanel menubar;
    protected float fSizeTextArea = ((Font)UIManager.get("TextArea.font")).getSize2D();
    protected WriteableObjectPool<NESTWorkflowObject> graphPool;
    protected NESTWorkflowObject originalGraph;
    protected JPanel sbPanel;
    protected JLabel sbPanelTopLabel;
    protected JPanel sbPanelBottom;
    protected JScrollPane sbScrollPane;
    protected JPanel sbPanelCenter;
    protected boolean sidebarWritable = true;
    protected boolean sidebarEnabled = true;
    protected boolean showNodeIDs = false;
    protected boolean showDataNodes = true;
    protected mxGraph mxGraph;
    protected mxGraphComponent graphComponent;
    protected Object parent;
    protected HashMap<String, Object> vertices = new HashMap();
    protected HashMap<Object, NESTGraphItemObject> mapCellToNESTItem = new HashMap();
    protected Set<Object> dataVertices = new HashSet<Object>();
    protected Set<Object> dataFlowEdges = new HashSet<Object>();
    protected int x;
    protected int xMax = this.x = -130;
    protected int y;
    protected int yMax = this.y = 0;
    protected Stack<readMode> modes = new Stack();
    protected NESTWorkflowObject queryGraph;
    protected MxGraphPanel mxGraphPanel;
    protected NESTWorkflowObject graph;

    public MxGraphPanel(NESTWorkflowVisualizerImpl visualizer) {
        this.visualizer = visualizer;
    }

    public MxGraphPanel getMxGraphPanel() {
        return this.mxGraphPanel;
    }

    public void setMxGraphPanel(MxGraphPanel mxGraphPanel) {
        this.mxGraphPanel = mxGraphPanel;
    }

    public NESTWorkflowObject getGraph() {
        return this.graph;
    }

    public void setGraph(NESTWorkflowObject graph) {
        this.graph = graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createGraph() {
        this.resetGraph();
        this.setStyleSheet();
        this.mxGraph.setKeepEdgesInBackground(true);
        this.mxGraph.getModel().beginUpdate();
        try {
            Set startNodes = this.graph.getStartNodes();
            for (NESTSequenceNodeObject startNode : startNodes) {
                this.modes.clear();
                this.modes.push(readMode.SEQ);
                this.drawNode(startNode);
            }
            this.y = this.yMax + 160;
            this.x = 0;
            for (NESTDataNodeObject dataNode : this.graph.getExtractor().extractOrderedDataNodes()) {
                this.insertNode((NESTNodeObject)dataNode);
                this.x += 130;
            }
            this.y += 80;
            this.x = 0;
            for (NESTEdgeObject edge : this.graph.getGraphEdges()) {
                Object addedEdge;
                if (edge.isNESTPartOfEdge()) continue;
                String preNodeId = edge.getPre().getId();
                String postNodeId = edge.getPost().getId();
                if (!this.vertices.containsKey(preNodeId)) {
                    this.vertices.put(preNodeId, this.mxGraph.insertVertex(this.parent, null, (Object)this.getNodeLabel(edge.getPre()), (double)(this.x += 130), (double)this.y, 90.0, 40.0));
                }
                if (!this.vertices.containsKey(postNodeId)) {
                    this.vertices.put(postNodeId, this.mxGraph.insertVertex(this.parent, null, (Object)this.getNodeLabel(edge.getPost()), (double)(this.x += 130), (double)this.y, 90.0, 40.0));
                }
                if (edge.isNESTControlflowEdge()) {
                    addedEdge = this.mxGraph.insertEdge(this.parent, null, (Object)"", this.vertices.get(preNodeId), this.vertices.get(postNodeId), CONTROL_FLOW_EDGE_STYLE);
                } else if (edge.isNESTDataflowEdge()) {
                    Object[] edges = this.mxGraph.getEdgesBetween(this.vertices.get(postNodeId), this.vertices.get(preNodeId));
                    if (edges.length > 0) {
                        this.mxGraph.getModel().remove(edges[0]);
                        addedEdge = this.mxGraph.insertEdge(this.parent, null, (Object)"", this.vertices.get(preNodeId), this.vertices.get(postNodeId), "DATA_FLOW_EDGE_STYLE;startArrow=classic");
                        this.dataFlowEdges.add(addedEdge);
                    } else {
                        addedEdge = this.mxGraph.insertEdge(this.parent, null, (Object)"", this.vertices.get(preNodeId), this.vertices.get(postNodeId), DATA_FLOW_EDGE_STYLE);
                        this.dataFlowEdges.add(addedEdge);
                    }
                } else {
                    addedEdge = this.mxGraph.insertEdge(this.parent, null, (Object)"", this.vertices.get(preNodeId), this.vertices.get(postNodeId));
                }
                if (addedEdge == null) continue;
                this.mapCellToNESTItem.put(addedEdge, (NESTGraphItemObject)edge);
            }
        }
        finally {
            this.mxGraph.getModel().endUpdate();
        }
        this.showDataNodes(this.showDataNodes);
    }

    protected void showDataNodes(boolean showDataNodes) {
        for (Object object : this.dataVertices) {
            this.mxGraph.getModel().setVisible(object, showDataNodes);
        }
        for (Object object : this.dataFlowEdges) {
            this.mxGraph.getModel().setVisible(object, showDataNodes);
        }
    }

    protected void resetGraph() {
        this.xMax = this.x = -130;
        this.yMax = this.y = 0;
        this.mxGraph = new mxGraph();
        this.parent = this.mxGraph.getDefaultParent();
        this.vertices.clear();
        this.dataVertices.clear();
        this.dataFlowEdges.clear();
        this.mapCellToNESTItem.clear();
        this.mxGraph.setCellsEditable(false);
        this.mxGraph.setCellsBendable(false);
        this.mxGraph.setCellsDisconnectable(false);
        this.mxGraph.setCellsMovable(false);
        this.mxGraph.setCellsResizable(false);
    }

    protected void drawNode(NESTSequenceNodeObject node) {
        block11: {
            NESTControlflowNodeObject controlflow;
            block14: {
                block13: {
                    block12: {
                        block10: {
                            this.x += 130;
                            if (!node.isNESTTaskNode()) break block10;
                            this.insertNode((NESTNodeObject)node);
                            for (NESTSequenceNodeObject currNode : node.getNextNodes()) {
                                this.drawNode(currNode);
                            }
                            break block11;
                        }
                        if (!node.isNESTControlflowNode()) break block11;
                        controlflow = (NESTControlflowNodeObject)node;
                        if (!controlflow.isAndStartNode() && !controlflow.isXorStartNode()) break block12;
                        this.insertNode((NESTNodeObject)node);
                        int seqCnt = 1;
                        int numOfSeq = controlflow.getNextNodes().size();
                        for (NESTSequenceNodeObject currNode : controlflow.getNextNodes()) {
                            if (seqCnt == numOfSeq) {
                                this.modes.push(readMode.SEQ);
                            } else {
                                this.modes.push(readMode.AND_OR);
                            }
                            int currX = this.x;
                            this.drawNode(currNode);
                            this.x = currX;
                            if (seqCnt++ >= numOfSeq) continue;
                            this.y += 80;
                        }
                        break block11;
                    }
                    if (!controlflow.isLoopStartNode()) break block13;
                    this.insertNode((NESTNodeObject)node);
                    for (NESTSequenceNodeObject currNode : controlflow.getNextNodes()) {
                        this.drawNode(currNode);
                    }
                    break block11;
                }
                if (!controlflow.isAndEndNode() && !controlflow.isXorEndNode()) break block14;
                if (this.x > this.xMax) {
                    this.xMax = this.x;
                }
                if (this.modes.pop() != readMode.SEQ) break block11;
                this.x = this.xMax;
                this.yMax = this.y;
                this.insertNode((NESTNodeObject)node, "CONTROL_FLOW_NODE_STYLE;portConstraint=eastwestsouthnorth");
                for (NESTSequenceNodeObject currNode : node.getNextNodes()) {
                    this.drawNode(currNode);
                }
                break block11;
            }
            if (controlflow.isLoopEndNode()) {
                this.insertNode((NESTNodeObject)node);
                for (NESTSequenceNodeObject currNode : node.getNextNodes()) {
                    if (currNode.isNESTControlflowNode()) {
                        if (node.getId().contains(currNode.getId())) continue;
                        this.drawNode(currNode);
                        continue;
                    }
                    this.drawNode(currNode);
                }
            }
        }
    }

    protected void insertNode(NESTNodeObject node) {
        if (node.isNESTDataNode()) {
            this.insertNode(node, DATA_NODE_STYLE);
            this.dataVertices.add(this.vertices.get(node.getId()));
        } else if (node.isNESTControlflowNode()) {
            this.insertNode(node, CONTROL_FLOW_NODE_STYLE);
        } else {
            this.insertNode(node, TASK_NODE_STYLE);
        }
    }

    protected void insertNode(NESTNodeObject node, String style) {
        Object cell = this.mxGraph.insertVertex(this.parent, null, (Object)this.getNodeLabel(node), (double)this.x, (double)this.y, 90.0, 40.0, style);
        this.vertices.put(node.getId(), cell);
        this.mapCellToNESTItem.put(cell, (NESTGraphItemObject)node);
    }

    protected void setStyleSheet() {
        mxStylesheet stylesheet = this.mxGraph.getStylesheet();
        Map defaultEdgeStyle = this.mxGraph.getStylesheet().getDefaultEdgeStyle();
        Map defaultVertexStyle = this.mxGraph.getStylesheet().getDefaultVertexStyle();
        defaultVertexStyle.put("HTML", 1);
        HashMap<String, Object> style = new HashMap<String, Object>(defaultVertexStyle);
        style.put(mxConstants.STYLE_PORT_CONSTRAINT, "eastwest");
        style.put(mxConstants.STYLE_STROKEWIDTH, 0);
        style.put(mxConstants.STYLE_FILLCOLOR, "#0074d9");
        style.put(mxConstants.STYLE_FONTCOLOR, "#ffffff");
        style.put(mxConstants.STYLE_FONTSTYLE, 1);
        style.put(mxConstants.STYLE_WHITE_SPACE, "wrap");
        stylesheet.putCellStyle(TASK_NODE_STYLE, style);
        style = new HashMap(defaultVertexStyle);
        style.put(mxConstants.STYLE_SHAPE, "ellipse");
        style.put(mxConstants.STYLE_STROKEWIDTH, 0);
        style.put(mxConstants.STYLE_FILLCOLOR, "#ff851b");
        style.put(mxConstants.STYLE_FONTCOLOR, "#ffffff");
        style.put(mxConstants.STYLE_FONTSTYLE, 1);
        style.put(mxConstants.STYLE_WHITE_SPACE, "wrap");
        stylesheet.putCellStyle(DATA_NODE_STYLE, style);
        style = new HashMap(defaultVertexStyle);
        style.put(mxConstants.STYLE_SHAPE, "rhombus");
        style.put(mxConstants.STYLE_STROKEWIDTH, 0);
        style.put(mxConstants.STYLE_FILLCOLOR, "#2ecc40");
        style.put(mxConstants.STYLE_FONTCOLOR, "#ffffff");
        style.put(mxConstants.STYLE_FONTSTYLE, 1);
        style.put(mxConstants.STYLE_WHITE_SPACE, "wrap");
        stylesheet.putCellStyle(CONTROL_FLOW_NODE_STYLE, style);
        style = new HashMap(defaultEdgeStyle);
        style.put(mxConstants.STYLE_DASHED, "1");
        style.put(mxConstants.STYLE_STROKEWIDTH, 2);
        style.put(mxConstants.STYLE_STROKECOLOR, "#cecece");
        stylesheet.putCellStyle(DATA_FLOW_EDGE_STYLE, style);
        style = new HashMap(defaultEdgeStyle);
        style.put(mxConstants.STYLE_STROKEWIDTH, 2);
        style.put(mxConstants.STYLE_STROKECOLOR, "#000000");
        style.put(mxConstants.STYLE_ROUNDED, true);
        style.put(mxConstants.STYLE_EDGE, "orthogonalEdgeStyle");
        stylesheet.putCellStyle(CONTROL_FLOW_EDGE_STYLE, style);
    }

    protected String getNodeLabel(NESTNodeObject node) {
        return this.visualizer.getLabel((NESTGraphItemObject)node) + (String)(this.showNodeIDs ? " (" + node.getId() + ")" : "");
    }

    public void init() {
        this.originalGraph = (NESTWorkflowObject)this.graph.copy();
        this.createGraph();
        this.removeAll();
        this.revalidate();
        this.setLayout(new BorderLayout());
        this.graphComponent = new mxGraphComponent(this.mxGraph);
        this.graphComponent.setConnectable(false);
        this.graphComponent.setBorder((Border)new EmptyBorder(20, 20, 20, 20));
        this.graphComponent.getGraphControl().addMouseListener((MouseListener)new MouseInputAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Object cell = MxGraphPanel.this.graphComponent.getCellAt(e.getX(), e.getY());
                if (cell != null) {
                    NESTGraphItemObject item = MxGraphPanel.this.mapCellToNESTItem.get(cell);
                    MxGraphPanel.this.showAggregateValuesOfItem(item);
                }
            }
        });
        this.graphComponent.setAutoscrolls(true);
        this.add((Component)this.graphComponent, "Center");
        this.sbPanel = new JPanel();
        this.sbPanel.setLayout(new BorderLayout());
        this.sbPanelTopLabel = new JLabel();
        this.sbPanel.add((Component)this.sbPanelTopLabel, "First");
        this.sbScrollPane = new JScrollPane();
        this.sbPanel.add((Component)this.sbScrollPane, "Center");
        this.sbPanelCenter = new JPanel();
        GridBagLayout sbGridBagLayout = new GridBagLayout();
        this.sbPanelCenter.setLayout(sbGridBagLayout);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(this.sbPanelCenter);
        this.sbScrollPane.setViewportView(jPanel);
        this.sbPanelBottom = new JPanel();
        this.sbPanelBottom.add(new JButton("[SAVE]"));
        this.sbPanelBottom.add(new JButton("[RESET]"));
        this.sbPanel.add((Component)this.sbPanelBottom, "Last");
        this.add((Component)this.sbPanel, "After");
        this.menubar = new JPanel(new FlowLayout(0));
        JCheckBox chkBoxShowData = new JCheckBox("show data objects", this.showDataNodes);
        chkBoxShowData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MxGraphPanel.this.showDataNodes = !MxGraphPanel.this.showDataNodes;
                MxGraphPanel.this.mxGraph.getModel().beginUpdate();
                try {
                    MxGraphPanel.this.showDataNodes(MxGraphPanel.this.showDataNodes);
                }
                finally {
                    MxGraphPanel.this.mxGraph.getModel().endUpdate();
                }
                MxGraphPanel.this.mxGraph.repaint();
            }
        });
        this.menubar.add(chkBoxShowData);
        JCheckBox chkBoxShowNodeIds = new JCheckBox("show node ids", this.showNodeIDs);
        chkBoxShowNodeIds.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                MxGraphPanel.this.showNodeIDs = !MxGraphPanel.this.showNodeIDs;
                try {
                    MxGraphPanel.this.mxGraph.getModel().beginUpdate();
                    for (String key : MxGraphPanel.this.vertices.keySet()) {
                        mxCellState state = MxGraphPanel.this.mxGraph.getView().getState(MxGraphPanel.this.vertices.get(key));
                        if (state == null) continue;
                        state.setLabel(MxGraphPanel.this.getNodeLabel(MxGraphPanel.this.graph.getGraphNode(key)));
                    }
                }
                finally {
                    MxGraphPanel.this.mxGraph.getModel().endUpdate();
                }
                MxGraphPanel.this.mxGraph.repaint();
            }
        });
        this.menubar.add(chkBoxShowNodeIds);
        this.add((Component)this.menubar, "North");
        JButton jbZoomPlusGraph = new JButton("+");
        jbZoomPlusGraph.addActionListener(e -> {
            double oldScale = this.mxGraph.getView().getScale();
            this.mxGraph.getView().setScale(oldScale + 0.2);
            this.graphComponent.refresh();
        });
        this.menubar.add(jbZoomPlusGraph);
        JButton jbZoomMinusGraph = new JButton("-");
        jbZoomMinusGraph.addActionListener(e -> {
            double oldScale = this.mxGraph.getView().getScale();
            this.mxGraph.getView().setScale(oldScale - 0.2);
            this.graphComponent.refresh();
        });
        this.menubar.add(jbZoomMinusGraph);
        JButton jbWorkflowNodeInfo = new JButton("Workflow node info");
        jbWorkflowNodeInfo.addActionListener(e -> this.showAggregateValuesOfItem((NESTGraphItemObject)this.graph.getWorkflowNode()));
        this.menubar.add(jbWorkflowNodeInfo);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(521, 128), "zoomPlus");
        this.getActionMap().put("zoomPlus", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double oldScale = MxGraphPanel.this.mxGraph.getView().getScale();
                MxGraphPanel.this.mxGraph.getView().setScale(oldScale + 0.2);
                MxGraphPanel.this.graphComponent.refresh();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(45, 128), "zoomMinus");
        this.getActionMap().put("zoomMinus", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double oldScale = MxGraphPanel.this.mxGraph.getView().getScale();
                MxGraphPanel.this.mxGraph.getView().setScale(oldScale - 0.2);
                MxGraphPanel.this.graphComponent.refresh();
            }
        });
        this.setEnableSidebar(this.sidebarEnabled);
        this.setSidebarWriteable(this.sidebarWritable);
        this.showAggregateValuesOfItem((NESTGraphItemObject)this.graph.getWorkflowNode());
    }

    protected void showAggregateValuesOfItem(NESTGraphItemObject item) {
        boolean hasSemanticDescription;
        if (item == null) {
            return;
        }
        this.sbPanelTopLabel.setText("graphItemId: " + item.getId());
        boolean bl = hasSemanticDescription = item.getSemanticDescriptor() != null;
        if (hasSemanticDescription) {
            int gridY = 0;
            this.sbPanelCenter.removeAll();
            this.showAggregateKeyValue((AggregateObject)item.getSemanticDescriptor(), gridY, 0);
            this.sbPanelCenter.revalidate();
            this.sbPanelCenter.repaint();
        }
    }

    protected int showAggregateKeyValue(AggregateObject aggregateObject, int gridY, int recDepth) {
        for (String attributeName : aggregateObject.getAggregateClass().getAttributeNames()) {
            StringBuffer blankSpacePrefix = new StringBuffer(recDepth);
            for (int i = 0; i < recDepth; ++i) {
                blankSpacePrefix.append("    ");
            }
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.insets = new Insets(1, 2, 2, 2);
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 17;
            constraints.gridx = 0;
            constraints.gridy = gridY++;
            JLabel keyLabel = new JLabel(blankSpacePrefix + attributeName);
            Font oldFont = keyLabel.getFont();
            Font newFont = oldFont.deriveFont(this.fSizeTextArea);
            keyLabel.setFont(newFont);
            this.sbPanelCenter.add((Component)keyLabel, constraints);
            if (aggregateObject.hasAttributeValue(attributeName)) {
                DataObject dObject = aggregateObject.getAttributeValue(attributeName);
                if (dObject.isAggregate()) {
                    this.showAggregateKeyValue((AggregateObject)dObject, gridY, ++recDepth);
                } else {
                    constraints.anchor = 13;
                    constraints.gridx = 1;
                    constraints.gridy = gridY;
                    JTextArea valueTextArea = dObject.isAtomic() ? new JTextArea(((AtomicObject)dObject).getNativeObject().toString()) : new JTextArea(dObject.toString());
                    oldFont = valueTextArea.getFont();
                    newFont = oldFont.deriveFont(this.fSizeTextArea);
                    valueTextArea.setFont(newFont);
                    valueTextArea.setEditable(this.sidebarWritable);
                    if (valueTextArea.getText().length() > 20) {
                        valueTextArea.setColumns(20);
                        valueTextArea.setLineWrap(true);
                    }
                    this.sbPanelCenter.add((Component)valueTextArea, constraints);
                }
            } else {
                constraints.anchor = 13;
                constraints.gridx = 1;
                constraints.gridy = gridY;
                JTextArea valueTextArea = new JTextArea("<null>");
                oldFont = valueTextArea.getFont();
                newFont = oldFont.deriveFont(this.fSizeTextArea);
                valueTextArea.setFont(newFont);
                valueTextArea.setEditable(this.sidebarWritable);
                this.sbPanelCenter.add((Component)valueTextArea, constraints);
            }
            ++gridY;
        }
        return gridY;
    }

    protected void changeFontZoom(Component component, float deltaFontSize) {
        this.fSizeTextArea += deltaFontSize;
        this.changeFontZoomRecursively(component, deltaFontSize);
    }

    protected void changeFontZoomRecursively(Component component, float deltaFontSize) {
        Font oldFont = component.getFont();
        Font newFont = oldFont.deriveFont(oldFont.getSize2D() + deltaFontSize);
        component.setFont(newFont);
        if (component instanceof Container) {
            Container container = (Container)component;
            for (Component c : container.getComponents()) {
                this.changeFontZoomRecursively(c, deltaFontSize);
            }
        }
    }

    public String getVisualization() {
        this.createGraph();
        mxSvgCanvas canvas = (mxSvgCanvas)mxCellRenderer.drawCells((mxGraph)this.mxGraph, null, (double)1.0, null, (mxCellRenderer.CanvasFactory)new mxCellRenderer.CanvasFactory(){

            public mxICanvas createCanvas(int width, int height) {
                mxSvgCanvas canvas = new mxSvgCanvas(mxDomUtils.createSvgDocument((int)width, (int)height));
                canvas.setEmbedded(true);
                return canvas;
            }
        });
        return mxXmlUtils.getXml((Node)canvas.getDocument());
    }

    public void setQueryGraph(NESTWorkflowObject graph) {
    }

    public void setEnableSidebar(boolean enable) {
        this.sbPanel.setVisible(enable);
    }

    public void setSidebarWriteable(boolean enable) {
        this.sidebarWritable = enable;
        for (Component component : this.sbPanelCenter.getComponents()) {
            if (!(component instanceof JTextArea)) continue;
            ((JTextArea)component).setEditable(this.sidebarWritable);
        }
        this.sbPanelBottom.setVisible(this.sidebarWritable);
    }

    public WriteableObjectPool<NESTWorkflowObject> getGraphPool() {
        return this.graphPool;
    }

    public void setGraphPool(WriteableObjectPool<NESTWorkflowObject> graphPool) {
        this.graphPool = graphPool;
    }

    protected static enum readMode {
        SEQ,
        AND_OR;

    }
}

