/*
 * Decompiled with CFR 0.152.
 */
package de.uni_trier.wi2.procake.gui;

import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.data.object.base.AggregateObject;
import de.uni_trier.wi2.procake.data.object.base.AtomicObject;
import de.uni_trier.wi2.procake.data.object.base.CollectionObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTEdgeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTGraphObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTWorkflowObject;
import de.uni_trier.wi2.procake.data.objectpool.ReadableObjectPool;
import de.uni_trier.wi2.procake.gui.objecteditor.label.AggregateObjectLabelProvider;
import de.uni_trier.wi2.procake.gui.objecteditor.label.LabelProviderFactory;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataObjectLabelProvider {
    private final Logger logger = LoggerFactory.getLogger(DataObjectLabelProvider.class);

    public String getLabel(Object object) {
        try {
            if (object == null) {
                return "null";
            }
            if (object instanceof AtomicObject) {
                return this.getLabel((AtomicObject)object);
            }
            if (object instanceof AggregateObject) {
                return this.getLabel((AggregateObject)object);
            }
            if (object instanceof NESTWorkflowObject) {
                return this.getLabel((NESTWorkflowObject)object);
            }
            if (object instanceof NESTGraphObject) {
                return this.getLabel((NESTGraphObject)object);
            }
            if (object instanceof Map.Entry) {
                return this.getLabel((Map.Entry)object);
            }
            if (object instanceof CollectionObject) {
                return this.getLabel((CollectionObject)object);
            }
            if (object instanceof NESTEdgeObject) {
                return this.getLabel((NESTEdgeObject)object);
            }
            if (object instanceof NESTNodeObject) {
                return this.getLabel((NESTNodeObject)object);
            }
            if (object instanceof ReadableObjectPool) {
                return this.getLabel((ReadableObjectPool<DataObject>)((ReadableObjectPool)object));
            }
            if (object instanceof DataObject) {
                return this.getLabel((DataObject)object);
            }
        }
        catch (RuntimeException e) {
            this.logger.error("Could not get label for object: {}", object);
            this.logger.error("Exception: ", (Throwable)e);
        }
        return Objects.toString(object);
    }

    protected String getLabel(DataObject dataObject) {
        return dataObject.getId();
    }

    protected String getLabel(ReadableObjectPool<DataObject> pool) {
        return pool.getId();
    }

    protected String getLabel(Map.Entry<String, Object> attribute) {
        return attribute.getKey() + " = " + this.getLabel(attribute.getValue());
    }

    protected String getLabel(AtomicObject atomicObject) {
        return atomicObject.getNativeObject().toString();
    }

    protected String getLabel(AggregateObject aggregateObject) {
        AggregateObjectLabelProvider labelProvider = (AggregateObjectLabelProvider)((Object)LabelProviderFactory.getProvider(aggregateObject.getDataClass()));
        return labelProvider == null ? aggregateObject.getId() : labelProvider.getLabel((DataObject)aggregateObject);
    }

    protected String getLabel(CollectionObject collectionObject) {
        return collectionObject.getDataClass() + " of " + collectionObject.size() + " " + collectionObject.getCollectionClass().getElementClass().getName();
    }

    protected String getLabel(NESTEdgeObject nestEdgeObject) {
        return nestEdgeObject.getDataClass().getName() + ": " + nestEdgeObject;
    }

    protected String getLabel(NESTNodeObject nestNodeObject) {
        return nestNodeObject.getDataClass().getName() + ": " + nestNodeObject.getId();
    }

    protected String getLabel(NESTGraphObject nestGraphObject) {
        return nestGraphObject.getId();
    }

    protected String getLabel(NESTWorkflowObject nestWorkflowObject) {
        return nestWorkflowObject.getId();
    }
}

