package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.swing.layouts;

import java.awt.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Alignment implements Direction {

  public static final int FILL_NONE = 0;
  public static final int FILL_HORIZONTAL = 1;
  public static final int FILL_VERTICAL = 2;
  public static final int FILL_BOTH = 3;
  protected static final Logger logger = LoggerFactory.getLogger(Alignment.class);

  public static void alignInCell(Rectangle r, Rectangle cell, int alignment, int fill) {
    r.x = cell.x;
    r.y = cell.y;

    /* Horizontal fill */
    switch (fill) {
      case FILL_BOTH:
      case FILL_HORIZONTAL:
        r.width = cell.width;
        break;
      default:
        logger.info("Unhandled statement caught in default branch of switch case.");
        logger.info(String.valueOf(fill));
        break;
    }

    /* Vertical fill */
    switch (fill) {
      case FILL_BOTH:
      case FILL_VERTICAL:
        r.height = cell.height;
        break;
      default:
        logger.info("Unhandled statement caught in default branch of switch case.");
        logger.info(String.valueOf(fill));
        break;
    }

    /* Horizontal alignment */
    switch (alignment) {
      case CENTER:
      case NORTH:
      case SOUTH:
        r.x += (cell.width - r.width) / 2;
        break;
      case WEST:
      case NORTHWEST:
      case SOUTHWEST:
        break;
      case EAST:
      case NORTHEAST:
      case SOUTHEAST:
        r.x += cell.width - r.width;
        break;
      default:
        logger.info("Unhandled statement caught in default branch of switch case.");
        logger.info(String.valueOf(fill));
        break;
    }

    /* Vertical alignment */
    switch (alignment) {
      case CENTER:
      case WEST:
      case EAST:
        r.y += (cell.height - r.height) / 2;
        break;
      case NORTH:
      case NORTHWEST:
      case NORTHEAST:
        break;
      case SOUTH:
      case SOUTHWEST:
      case SOUTHEAST:
        r.y += cell.height - r.height;
        break;
      default:
        logger.info("Unhandled statement caught in default branch of switch case.");
        logger.info(String.valueOf(fill));
        break;
    }
  }
}
