package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.mxgraph;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.canvas.mxSvgCanvas;
import com.mxgraph.shape.mxIShape;
import com.mxgraph.shape.mxStencilShape;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxUtils;
import java.awt.*;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class mxSvgCanvasWithStencilSupport extends mxSvgCanvas {

  public mxSvgCanvasWithStencilSupport(Document svgDocument) {
    super(svgDocument);
  }

  @Override
  public Element drawShape(int x, int y, int w, int h, Map<String, Object> style) {
    mxIShape shape = (new mxGraphics2DCanvas()).getShape(style);
    if (shape instanceof mxStencilShape) {
      String fillColor = mxUtils.getString(style, mxConstants.STYLE_FILLCOLOR, "none");
      String gradientColor = mxUtils.getString(style, mxConstants.STYLE_GRADIENTCOLOR, "none");
      // disabled due to being bugged: causes very thick strokes (at least for Task.shape), maybe
      // sth. wrong in the svg definition of the shape
      //            String strokeColor = mxUtils.getString(style, mxConstants.STYLE_STROKECOLOR,
      // "none");
      //            float strokeWidth = (float) (mxUtils.getFloat(style,
      // mxConstants.STYLE_STROKEWIDTH, 1) * scale);
      float opacity = mxUtils.getFloat(style, mxConstants.STYLE_OPACITY, 100);
      float fillOpacity = mxUtils.getFloat(style, mxConstants.STYLE_FILL_OPACITY, 100);
      float strokeOpacity = mxUtils.getFloat(style, mxConstants.STYLE_STROKE_OPACITY, 100);

      mxStencilShape stencilShape = (mxStencilShape) shape;
      double widthRatio = w / stencilShape.getBoundingBox().getWidth();
      double heightRatio = h / stencilShape.getBoundingBox().getHeight();

      try {
        Field rootField = mxStencilShape.class.getDeclaredField("root");
        rootField.setAccessible(true);
        Node root = (Node) rootField.get(shape);

        Element elem = document.createElement("g");
        Node backgroundNode = getBackgroundElement(root);
        Element background = null;
        elem.setAttribute(
            "transform",
            "translate(" + x + ", " + y + ") scale(" + widthRatio + ", " + heightRatio + ")");
        NodeList childNodes = root.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); i++) {
          Node childNode = super.document.importNode(childNodes.item(i), true);
          if (childNodes.item(i) == backgroundNode) {
            background = (Element) childNode;
          }
          elem.appendChild(childNode);
        }

        // <editor-fold desc="code duplicated from mxSvgCanvas.drawShape ">
        double rotation = mxUtils.getDouble(style, mxConstants.STYLE_ROTATION);
        int cx = x + w / 2;
        int cy = y + h / 2;

        Element bg = background;

        if (bg == null) {
          bg = elem;
        }

        if (!bg.getNodeName().equalsIgnoreCase("use")
            && !bg.getNodeName().equalsIgnoreCase("image")) {
          if (!fillColor.equalsIgnoreCase("none") && !gradientColor.equalsIgnoreCase("none")) {
            String direction = mxUtils.getString(style, mxConstants.STYLE_GRADIENT_DIRECTION);
            Element gradient = getGradientElement(fillColor, gradientColor, direction);

            if (gradient != null) {
              bg.setAttribute("fill", "url(#" + gradient.getAttribute("id") + ")");
            }
          } else {
            bg.setAttribute("fill", fillColor);
          }

          //                    bg.setAttribute("stroke", strokeColor);
          //                    bg.setAttribute("stroke-width", String.valueOf(strokeWidth));

          // Adds the shadow element
          Element shadowElement = null;

          if (mxUtils.isTrue(style, mxConstants.STYLE_SHADOW, false) && !fillColor.equals("none")) {
            shadowElement = (Element) bg.cloneNode(true);

            shadowElement.setAttribute("transform", mxConstants.SVG_SHADOWTRANSFORM);
            shadowElement.setAttribute("fill", mxConstants.W3C_SHADOWCOLOR);
            shadowElement.setAttribute("stroke", mxConstants.W3C_SHADOWCOLOR);
            //                        shadowElement.setAttribute("stroke-width",
            //                                String.valueOf(strokeWidth));

            if (rotation != 0) {
              shadowElement.setAttribute(
                  "transform",
                  "rotate("
                      + rotation
                      + ","
                      + cx
                      + ","
                      + cy
                      + ") "
                      + mxConstants.SVG_SHADOWTRANSFORM);
            }

            if (opacity != 100) {
              String value = String.valueOf(opacity / 100);
              shadowElement.setAttribute("fill-opacity", value);
              shadowElement.setAttribute("stroke-opacity", value);
            }

            appendSvgElement(shadowElement);
          }
        }

        if (rotation != 0) {
          elem.setAttribute(
              "transform",
              elem.getAttribute("transform") + " rotate(" + rotation + "," + cx + "," + cy + ")");
        }

        if (opacity != 100 || fillOpacity != 100 || strokeOpacity != 100) {
          String fillValue = String.valueOf(opacity * fillOpacity / 10000);
          String strokeValue = String.valueOf(opacity * strokeOpacity / 10000);
          elem.setAttribute("fill-opacity", fillValue);
          elem.setAttribute("stroke-opacity", strokeValue);
        }

        if (mxUtils.isTrue(style, mxConstants.STYLE_DASHED)) {
          String pattern = mxUtils.getString(style, mxConstants.STYLE_DASH_PATTERN, "3, 3");
          elem.setAttribute("stroke-dasharray", pattern);
        }
        // </editor-fold>

        appendSvgElement(elem);
        return elem;
      } catch (NoSuchFieldException | IllegalAccessException e) {
        e.printStackTrace();
      }
    }
    return super.drawShape(x, y, w, h, style);
  }

  private Node getBackgroundElement(Node root) {
    Node child = root.getFirstChild();
    while (child != null) {
      if (child.getNodeName().equals("svg:path")
          || child.getNodeName().equals("path")
          || child.getNodeName().equals("svg:polygon")
          || child
          .getNodeName()
          .equals(
              "polygon")) { // We assume the first "path" or "polygon" element defines the base
        // shape and thus can be used for background style application
        return child;
      }
      child = child.getNextSibling();
    }
    return null;
  }

  @Override
  public Element drawLine(List<mxPoint> pts, Map<String, Object> style) {
    // workaround for very small (and thus effectively invisible) arrow endpoints with orthogonal
    // edge routing
    if (pts.size() >= 2) {
      mxPoint firstPoint = pts.get(0);
      mxPoint secondPoint = pts.get(1);
      if (((int) firstPoint.getX()) == ((int) secondPoint.getX())
          && ((int) firstPoint.getY()) == ((int) secondPoint.getY())) {
        pts.remove(1);
      }
    }
    if (pts.size() >= 2) {
      mxPoint lastPoint = pts.get(pts.size() - 1);
      mxPoint nextToLastPoint = pts.get(pts.size() - 2);
      if (((int) lastPoint.getX()) == ((int) nextToLastPoint.getX())
          && ((int) lastPoint.getY()) == ((int) nextToLastPoint.getY())) {
        pts.remove(pts.size() - 2);
      }
    }
    return super.drawLine(pts, style);
  }

  /**
   * duplicated from superclass to add "tspan.setAttribute("xml:space", "preserve");"
   */
  public Object drawText(String text, int x, int y, int w, int h, Map<String, Object> style) {
    Element elem = null;
    String fontColor = mxUtils.getString(style, mxConstants.STYLE_FONTCOLOR, "black");
    String fontFamily =
        mxUtils.getString(style, mxConstants.STYLE_FONTFAMILY, mxConstants.DEFAULT_FONTFAMILIES);
    int fontSize =
        (int)
            (mxUtils.getInt(style, mxConstants.STYLE_FONTSIZE, mxConstants.DEFAULT_FONTSIZE)
                * scale);

    if (text != null && text.length() > 0) {
      float strokeWidth =
          (float) (mxUtils.getFloat(style, mxConstants.STYLE_STROKEWIDTH, 1) * scale);

      // Applies the opacity
      float opacity = mxUtils.getFloat(style, mxConstants.STYLE_TEXT_OPACITY, 100);

      // Draws the label background and border
      String bg = mxUtils.getString(style, mxConstants.STYLE_LABEL_BACKGROUNDCOLOR);
      String border = mxUtils.getString(style, mxConstants.STYLE_LABEL_BORDERCOLOR);

      String transform = null;

      if (!mxUtils.isTrue(style, mxConstants.STYLE_HORIZONTAL, true)) {
        double cx = x + w / 2;
        double cy = y + h / 2;
        transform = "rotate(270 " + cx + " " + cy + ")";
      }

      if (bg != null || border != null) {
        Element background = document.createElement("rect");

        background.setAttribute("x", String.valueOf(x));
        background.setAttribute("y", String.valueOf(y));
        background.setAttribute("width", String.valueOf(w));
        background.setAttribute("height", String.valueOf(h));

        if (bg != null) {
          background.setAttribute("fill", bg);
        } else {
          background.setAttribute("fill", "none");
        }

        if (border != null) {
          background.setAttribute("stroke", border);
        } else {
          background.setAttribute("stroke", "none");
        }

        background.setAttribute("stroke-width", String.valueOf(strokeWidth));

        if (opacity != 100) {
          String value = String.valueOf(opacity / 100);
          background.setAttribute("fill-opacity", value);
          background.setAttribute("stroke-opacity", value);
        }

        if (transform != null) {
          background.setAttribute("transform", transform);
        }

        appendSvgElement(background);
      }

      elem = document.createElement("text");

      int fontStyle = mxUtils.getInt(style, mxConstants.STYLE_FONTSTYLE);
      String weight =
          ((fontStyle & mxConstants.FONT_BOLD) == mxConstants.FONT_BOLD) ? "bold" : "normal";
      elem.setAttribute("font-weight", weight);
      String uline =
          ((fontStyle & mxConstants.FONT_UNDERLINE) == mxConstants.FONT_UNDERLINE)
              ? "underline"
              : "none";
      elem.setAttribute("font-decoration", uline);

      if ((fontStyle & mxConstants.FONT_ITALIC) == mxConstants.FONT_ITALIC) {
        elem.setAttribute("font-style", "italic");
      }

      elem.setAttribute("font-size", String.valueOf(fontSize));
      elem.setAttribute("font-family", fontFamily);
      elem.setAttribute("fill", fontColor);

      if (opacity != 100) {
        String value = String.valueOf(opacity / 100);
        elem.setAttribute("fill-opacity", value);
        elem.setAttribute("stroke-opacity", value);
      }

      int swingFontStyle =
          ((fontStyle & mxConstants.FONT_BOLD) == mxConstants.FONT_BOLD) ? Font.BOLD : Font.PLAIN;
      swingFontStyle +=
          ((fontStyle & mxConstants.FONT_ITALIC) == mxConstants.FONT_ITALIC)
              ? Font.ITALIC
              : Font.PLAIN;

      String[] lines = text.split("\n");
      y += fontSize + (h - lines.length * (fontSize + mxConstants.LINESPACING)) / 2 - 2;

      String align = mxUtils.getString(style, mxConstants.STYLE_ALIGN, mxConstants.ALIGN_CENTER);
      String anchor = "start";

      if (align.equals(mxConstants.ALIGN_RIGHT)) {
        anchor = "end";
        x += w - mxConstants.LABEL_INSET * scale;
      } else if (align.equals(mxConstants.ALIGN_CENTER)) {
        anchor = "middle";
        x += w / 2;
      } else {
        x += mxConstants.LABEL_INSET * scale;
      }

      elem.setAttribute("text-anchor", anchor);

      for (int i = 0; i < lines.length; i++) {
        Element tspan = document.createElement("tspan");

        tspan.setAttribute("x", String.valueOf(x));
        tspan.setAttribute("y", String.valueOf(y));
        tspan.setAttribute("xml:space", "preserve");

        tspan.appendChild(document.createTextNode(lines[i]));
        elem.appendChild(tspan);

        y += fontSize + mxConstants.LINESPACING;
      }

      if (transform != null) {
        elem.setAttribute("transform", transform);
      }

      appendSvgElement(elem);
    }

    return elem;
  }
}
