package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor;

import com.mxgraph.model.mxICell;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxGraphActions;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxEvent;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource.mxIEventListener;
import com.mxgraph.util.mxResources;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import de.uni_trier.wi2.procake.data.object.nest.NESTGraphItemObject;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.utils.Utils;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.*;

import static de.uni_trier.wi2.procake.gui.Constants.NESTWORKFLOW_RESOURCES;

public class EditorToolBar extends JToolBar {

  /**
   *
   */
  private static final long serialVersionUID = -8015443128436394471L;

  private boolean ignoreZoomChange = false;

  /**
   *
   */

  public EditorToolBar(int orientation) {
    super(orientation);
    setBorder(
        BorderFactory.createCompoundBorder(
            BorderFactory.createEmptyBorder(15, 15, 15, 15), getBorder()));
    setFloatable(false);
  }

  public EditorToolBar(final BasicGraphEditor editor, int orientation) {
    super(orientation);
    setBorder(
        BorderFactory.createCompoundBorder(
            BorderFactory.createEmptyBorder(3, 3, 4, 3), getBorder()));
    setFloatable(false);

    if (!editor.frameless) {
      Action newAction = editor.bind("New", new AbstractAction() {
        public void actionPerformed(ActionEvent e) {
        }
      }, NESTWORKFLOW_RESOURCES + "images/new.gif");
      newAction.putValue(Action.SHORT_DESCRIPTION, mxResources.get("newNESTWorkflow"));
      JButton newNESTWorkflowButton = add(newAction);
      newNESTWorkflowButton.addActionListener(e -> {
        JPopupMenu nestWorkflowClassSelectionMenu = new JPopupMenu();
        Utils.getNESTWorkflowClasses()
            .forEach(nestWorkflowClass -> nestWorkflowClassSelectionMenu.add(
                editor.bind(nestWorkflowClass.getName(),
                    new EditorActions.NewNESTWorkflowAction((nestWorkflowClass)))));
        nestWorkflowClassSelectionMenu
            .show(newNESTWorkflowButton, newNESTWorkflowButton.getWidth(), 0);
      });

      add(
          editor.bind(
              "Open", new EditorActions.OpenAction(), NESTWORKFLOW_RESOURCES + "images/open.gif"));
    }

    add(
        editor.bind(
            "Save", new EditorActions.SaveInObjectAction(), NESTWORKFLOW_RESOURCES + "images/save.gif"));
    add(
        editor.bind(
            mxResources.get("exportAs"),
            new EditorActions.ExportAsAction(true),
            NESTWORKFLOW_RESOURCES + "images/saveas.gif"));

    addSeparator();

    add(
        editor.bind(
            "Print", new EditorActions.PrintAction(), NESTWORKFLOW_RESOURCES + "images/print.gif"));

    addSeparator();

    //		add(editor.bind("Cut", TransferHandler.getCutAction(),
    //                NESTWORKFLOW_RESOURCES + "images/cut.gif"));
    Action copyAction =
        editor.bind(
            "Copy",
            TransferHandler.getCopyAction(),
            NESTWORKFLOW_RESOURCES + "images/copy.gif");
    copyAction.putValue(Action.SHORT_DESCRIPTION, mxResources.get("copy"));
    JButton copyButton = add(copyAction);
    copyButton.setEnabled(false);

    // only enable copy button when at least one cell representing a NESTNode is selected
    editor
        .getGraphComponent()
        .getGraph()
        .getSelectionModel()
        .addListener(
            mxEvent.CHANGE,
            new mxIEventListener() {
              @Override
              public void invoke(Object sender, mxEventObject evt) {
                copyButton.setEnabled(
                    Arrays.stream(
                            editor.getGraphComponent().getGraph().getSelectionModel().getCells())
                        .map(mxICell.class::cast)
                        .map(mxICell::getValue)
                        .filter(NESTGraphItemObject.class::isInstance)
                        .map(NESTGraphItemObject.class::cast)
                        .anyMatch(NESTGraphItemObject::isNESTNode));
              }
            });

    Action pasteAction =
        editor.bind(
            "Paste",
            TransferHandler.getPasteAction(),
            NESTWORKFLOW_RESOURCES + "images/paste.gif");
    pasteAction.putValue(Action.SHORT_DESCRIPTION, mxResources.get("paste"));
    add(pasteAction);

    addSeparator();

    Action deleteAction =
        editor.bind(
            "Delete",
            mxGraphActions.getDeleteAction(),
            NESTWORKFLOW_RESOURCES + "images/delete.gif");
    deleteAction.putValue(Action.SHORT_DESCRIPTION, mxResources.get("delete"));
    add(deleteAction);

    //		addSeparator();
    //
    //		add(editor.bind("Undo", new HistoryAction(true),
    //                NESTWORKFLOW_RESOURCES + "images/undo.gif"));
    //		add(editor.bind("Redo", new HistoryAction(false),
    //                NESTWORKFLOW_RESOURCES + "images/redo.gif"));

    addSeparator();

    // Gets the list of available fonts from the local graphics environment
    // and adds some frequently used fonts at the beginning of the list
    GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
    List<String> fonts = new ArrayList<String>();
    fonts.addAll(
        Arrays.asList(
            new String[]{
                "Helvetica", "Verdana", "Times New Roman", "Garamond", "Courier New", "-"
            }));
    fonts.addAll(Arrays.asList(env.getAvailableFontFamilyNames()));

    final JComboBox fontCombo = new JComboBox(fonts.toArray());
    fontCombo.setEditable(true);
    fontCombo.setMinimumSize(new Dimension(120, 0));
    fontCombo.setPreferredSize(new Dimension(120, 0));
    fontCombo.setMaximumSize(new Dimension(120, 100));
    add(fontCombo);

    fontCombo.addActionListener(
        new ActionListener() {
          /** */
          public void actionPerformed(ActionEvent e) {
            String font = fontCombo.getSelectedItem().toString();

            if (font != null && !font.equals("-")) {
              mxGraph graph = editor.getGraphComponent().getGraph();
              graph.setCellStyles(mxConstants.STYLE_FONTFAMILY, font);
            }
          }
        });

    final JComboBox sizeCombo =
        new JComboBox(
            new Object[]{
                "6pt", "8pt", "9pt", "10pt", "12pt", "14pt", "18pt", "24pt", "30pt", "36pt", "48pt",
                "60pt"
            });
    sizeCombo.setEditable(true);
    sizeCombo.setMinimumSize(new Dimension(65, 0));
    sizeCombo.setPreferredSize(new Dimension(65, 0));
    sizeCombo.setMaximumSize(new Dimension(65, 100));
    add(sizeCombo);

    sizeCombo.addActionListener(
        new ActionListener() {
          /** */
          public void actionPerformed(ActionEvent e) {
            mxGraph graph = editor.getGraphComponent().getGraph();
            graph.setCellStyles(
                mxConstants.STYLE_FONTSIZE,
                sizeCombo.getSelectedItem().toString().replace("pt", ""));
          }
        });

    addSeparator();

    add(
        editor.bind(
            "Bold",
            new EditorActions.FontStyleAction(true),
            NESTWORKFLOW_RESOURCES + "images/bold.gif"));
    add(
        editor.bind(
            "Italic",
            new EditorActions.FontStyleAction(false),
            NESTWORKFLOW_RESOURCES + "images/italic.gif"));

    addSeparator();

    add(
        editor.bind(
            "Left",
            new EditorActions.KeyValueAction(mxConstants.STYLE_ALIGN, mxConstants.ALIGN_LEFT),
            NESTWORKFLOW_RESOURCES + "images/left.gif"));
    add(
        editor.bind(
            "Center",
            new EditorActions.KeyValueAction(mxConstants.STYLE_ALIGN, mxConstants.ALIGN_CENTER),
            NESTWORKFLOW_RESOURCES + "images/center.gif"));
    add(
        editor.bind(
            "Right",
            new EditorActions.KeyValueAction(mxConstants.STYLE_ALIGN, mxConstants.ALIGN_RIGHT),
            NESTWORKFLOW_RESOURCES + "images/right.gif"));

    addSeparator();

    add(
        editor.bind(
            "Font",
            new EditorActions.ColorAction("Font", mxConstants.STYLE_FONTCOLOR),
            NESTWORKFLOW_RESOURCES + "images/fontcolor.gif"));
    add(
        editor.bind(
            "Stroke",
            new EditorActions.ColorAction("Stroke", mxConstants.STYLE_STROKECOLOR),
            NESTWORKFLOW_RESOURCES + "images/linecolor.gif"));
    add(
        editor.bind(
            "Fill",
            new EditorActions.ColorAction("Fill", mxConstants.STYLE_FILLCOLOR),
            NESTWORKFLOW_RESOURCES + "images/fillcolor.gif"));

    addSeparator();

    final mxGraphView view = editor.getGraphComponent().getGraph().getView();
    final JComboBox zoomCombo =
        new JComboBox(
            new Object[]{
                "400%",
                "200%",
                "150%",
                "100%",
                "75%",
                "50%",
                mxResources.get("page"),
                mxResources.get("width"),
                mxResources.get("actualSize")
            });
    zoomCombo.setEditable(true);
    zoomCombo.setMinimumSize(new Dimension(75, 0));
    zoomCombo.setPreferredSize(new Dimension(75, 0));
    zoomCombo.setMaximumSize(new Dimension(75, 100));
    zoomCombo.setMaximumRowCount(9);
    add(zoomCombo);

    // Sets the zoom in the zoom combo the current value
    mxIEventListener scaleTracker =
        new mxIEventListener() {
          /** */
          public void invoke(Object sender, mxEventObject evt) {
            ignoreZoomChange = true;

            try {
              zoomCombo.setSelectedItem((int) Math.round(100 * view.getScale()) + "%");
            } finally {
              ignoreZoomChange = false;
            }
          }
        };

    // Installs the scale tracker to update the value in the combo box
    // if the zoom is changed from outside the combo box
    view.getGraph().getView().addListener(mxEvent.SCALE, scaleTracker);
    view.getGraph().getView().addListener(mxEvent.SCALE_AND_TRANSLATE, scaleTracker);

    // Invokes once to sync with the actual zoom value
    scaleTracker.invoke(null, null);

    zoomCombo.addActionListener(
        new ActionListener() {
          /** */
          public void actionPerformed(ActionEvent e) {
            mxGraphComponent graphComponent = editor.getGraphComponent();

            // Zoomcombo is changed when the scale is changed in the diagram
            // but the change is ignored here
            if (!ignoreZoomChange) {
              String zoom = zoomCombo.getSelectedItem().toString();

              if (zoom.equals(mxResources.get("page"))) {
                graphComponent.setPageVisible(true);
                graphComponent.setZoomPolicy(mxGraphComponent.ZOOM_POLICY_PAGE);
              } else if (zoom.equals(mxResources.get("width"))) {
                graphComponent.setPageVisible(true);
                graphComponent.setZoomPolicy(mxGraphComponent.ZOOM_POLICY_WIDTH);
              } else if (zoom.equals(mxResources.get("actualSize"))) {
                graphComponent.zoomActual();
              } else {
                try {
                  zoom = zoom.replace("%", "");
                  double scale = Math.min(16, Math.max(0.01, Double.parseDouble(zoom) / 100));
                  graphComponent.zoomTo(scale, graphComponent.isCenterZoom());
                } catch (Exception ex) {
                  JOptionPane.showMessageDialog(editor, ex.getMessage());
                }
              }
            }
          }
        });
  }
}
