package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxGraph;
import de.uni_trier.wi2.procake.data.object.nest.NESTGraphItemObject;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.swing.layouts.BasicGridLayout;

import java.awt.*;
import javax.swing.*;

import static de.uni_trier.wi2.procake.gui.Constants.NESTWORKFLOW_RESOURCES;

/**
 * {@link JDialog} to change the size of one/multiple {@link mxCell} that are selected in the given
 * {@link mxGraph}.
 *
 * @author osobaa
 */
public class EditorSizeEdit extends JDialog {

  /**
   * TextField to enter the new Width of the selected {@link mxCell}
   */
  private TextField width;
  /**
   * TextField to enter the new Height of the selected {@link mxCell}
   */
  private TextField height;

  /**
   * Constructor for a {@link JDialog} to resize selected {@link mxCell} in the {@link mxGraph}
   *
   * @param graph The active {@link mxGraph}, where {@link mxCell} are selected
   */
  EditorSizeEdit(mxGraph graph) {
    this.setTitle("Edit Size");
    this.setLayout(new BorderLayout());
    this.setIconImage(Toolkit.getDefaultToolkit()
        .getImage(getClass().getResource(NESTWORKFLOW_RESOURCES + "images/ProCAKE_Icon.png")));
    this.setAlwaysOnTop(true);
    this.addEditingTextFields(graph);
    this.add(createSaveButton(graph), BorderLayout.PAGE_END);

    this.pack();
    this.setDefaultCloseOperation(DISPOSE_ON_CLOSE);

    this.setMinimumSize(getPreferredSize());

    if (graph.getSelectionCells().length > 1) {
      Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
      // System.out.println(screenSize);
      this.setLocation((int) ((screenSize.getWidth() / 2.0) - (this.getWidth() / 2.0)),
          (int) ((screenSize.getHeight() / 2.0) - (this.getHeight() / 2.0)));
    } else {
      Point mouseLocation = MouseInfo.getPointerInfo().getLocation();
      this.setLocation(
          Math.max(0, (int) (mouseLocation.getX() - this.getWidth() / 2)),
          Math.max(0, (int) (mouseLocation.getY() - this.getHeight() / 2)));
    }

    this.revalidate();
    this.setVisible(true);
  }

  /**
   * Adds {@link TextField}'s for Width/Height of the {@link EditorSizeEdit} {@link JDialog}
   *
   * @param graph {@link mxGraph} where the {@link TextField}'s get their initial value for the
   *              width/height
   */
  private void addEditingTextFields(mxGraph graph) {
    Object[] cell = graph.getSelectionCells();

    JPanel panel = new JPanel(new BasicGridLayout(2, 2));

    boolean hasDataNode = false;
    for (int i = 0; i < cell.length; ++i) {
      if (!((NESTGraphItemObject) (((mxCell) graph.getSelectionCells()[i]).getValue()))
          .isNESTControlflowNode()) {
        hasDataNode = true;
      }
    }

    width = new TextField(
        String.valueOf((int) ((mxCell) cell[cell.length - 1]).getGeometry().getWidth()));
    if (hasDataNode) {
      height = new TextField(
          String.valueOf((int) ((mxCell) cell[cell.length - 1]).getGeometry().getHeight()));

      height.addTextListener(e -> {
        if (!height.getText().matches("[0-9]+")) {
          height.setBackground(Color.PINK);
        } else {
          height.setBackground(Color.WHITE);
        }
      });
    }

    width.addTextListener(e -> {
      if (!width.getText().matches("[0-9]+")) {
        width.setBackground(Color.PINK);
      } else {
        width.setBackground(Color.WHITE);
      }
    });

    panel.setAlignmentX(JPanel.CENTER_ALIGNMENT);
    panel.setAlignmentY(JPanel.CENTER_ALIGNMENT);
    int borderWidth = 10;
    panel.setBorder(
        BorderFactory.createEmptyBorder(borderWidth, borderWidth, borderWidth, borderWidth));
    if (hasDataNode) {
      panel.add(new Label("Width"));
      panel.add(width, BorderLayout.CENTER);
      panel.add(new Label(("Height")));
      panel.add(height, BorderLayout.CENTER);
    } else {
      panel.add(new Label("Width/Length"));
      panel.add(width, BorderLayout.CENTER);
    }

    this.add(panel, BorderLayout.CENTER);
  }

  /**
   * Adds {@link JButton}'s for saving changes of the {@link EditorSizeEdit} {@link JDialog}
   *
   * @param graph {@link mxGraph}, where the changes will be made
   * @return {@link JButton} where changes will be processed and saved
   */
  private JButton createSaveButton(mxGraph graph) {
    JButton saveButton = new JButton("Save Changes");
    saveButton.setMargin(new Insets(2, 2, 2, 2));
    saveButton.addActionListener(e -> handleSaveButton(graph));
    this.getRootPane().setDefaultButton(saveButton);
    return saveButton;
  }

  /**
   * Action for the activation of save button
   *
   * @param graph {@link mxGraph}, where the changes will be made
   */
  private void handleSaveButton(mxGraph graph) {
    try {
      Object[] cells = graph.getSelectionCells();
      mxGeometry[] geometry = new mxGeometry[cells.length];
      for (int i = 0; i < cells.length; ++i) {
        geometry[i] = graph.getModel().getGeometry(cells[i]);
      }
      mxRectangle[] rect = new mxRectangle[geometry.length];
      for (int j = 0; j < geometry.length; ++j) {
        rect[j] = new mxRectangle(geometry[j].getRectangle());

        double w = Double.parseDouble(width.getText());
        double h = height != null ? Double.parseDouble(height.getText()) : 0.0;

        if (((NESTGraphItemObject) (((mxCell) graph.getSelectionCells()[j]).getValue()))
            .isNESTControlflowNode()) {
          double l = Math.max(w, h);
          rect[j].setWidth(l);
          rect[j].setHeight(l);
        } else {
          rect[j].setWidth(w);
          rect[j].setHeight(h);
        }
      }

      for (int k = 0; k < graph.getSelectionCells().length; ++k) {
        graph.resizeCell(graph.getSelectionCells()[k], rect[k]);
      }

    } catch (NumberFormatException numberFormatException) {
      return;
    }
    //this.dispose();
    this.setVisible(true);
    this.setAlwaysOnTop(true);
  }
}
