package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor;

import com.mxgraph.swing.handler.mxRubberband;
import com.mxgraph.swing.mxGraphComponent;
import java.awt.event.MouseEvent;
import javax.swing.*;

/**
 * Custom {@link mxRubberband} to prevent rubberband-selection with right-mouse-click-dragging
 *
 * @author osobaa
 */
public class EditorRubberband extends mxRubberband {

  /**
   * Constructs a new rubberband selection for the given {@link mxGraphComponent}. This Rubberband
   * prevents rubberband selection on right mouse click in only activating it, when left mouse
   * button is used
   *
   * @param graphComponent Component that contains the ative standard {@link mxRubberband}.
   */
  public EditorRubberband(mxGraphComponent graphComponent) {
    super(graphComponent);
    super.setEnabled(false);
  }

  /**
   * Enable {@link mxRubberband} selection only on left-click
   *
   * @param e Standard {@link MouseEvent}
   */
  @Override
  public void mousePressed(MouseEvent e) {
    if (SwingUtilities.isLeftMouseButton(e)) {
      setEnabled(true);
      super.mousePressed(e);
    }
    e.consume();
  }

  /**
   * Invokes standard {@link mxRubberband} behavior on left-click
   *
   * @param e Standard {@link MouseEvent}
   */
  @Override
  public void mouseDragged(MouseEvent e) {
    if (SwingUtilities.isLeftMouseButton(e)) {
      super.mouseDragged(e);
    }
    e.consume();
  }

  /**
   * Disables {@link mxRubberband} selection when mouse is released
   *
   * @param e Standard {@link MouseEvent}
   */
  @Override
  public void mouseReleased(MouseEvent e) {
    super.mouseReleased(e);
    setEnabled(false);
  }

}
