package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor;

import com.mxgraph.model.mxICell;
import com.mxgraph.swing.util.mxGraphActions;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxResources;
import com.mxgraph.view.mxGraph;
import de.uni_trier.wi2.procake.data.model.DataClass;
import de.uni_trier.wi2.procake.data.model.ModelFactory;
import de.uni_trier.wi2.procake.data.object.DataObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTGraphItemObject;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.NESTWorkflowEditor;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.LabelMode;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.utils.Utils;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.*;

import static de.uni_trier.wi2.procake.gui.Constants.NESTWORKFLOW_RESOURCES;

public class EditorPopupMenu extends JPopupMenu {

  private static final long serialVersionUID = -3132749140550242191L;

  public EditorPopupMenu(BasicGraphEditor editor) {

    mxGraph graph = editor.getGraphComponent().getGraph();
    boolean selected = !graph.isSelectionEmpty();
    boolean oneSelected = graph.getSelectionCount() <= 1;

    add(new EditorActions.AddSemanticDescriptorNodeAction(this.getSelectedCells(editor)))
        .setEnabled(selected && getSelectedGraphItems(editor).size() > 0);
    add(createClassSelectionMenu(editor));
    add(createLabelModeSelectionMenu(editor));

    addSeparator();

    //		add(editor.bind(mxResources.get("undo"), new EditorActions.HistoryAction(true),
    //                NESTWORKFLOW_RESOURCES + "images/undo.gif"));
    //
    //		addSeparator();
    //
    //		add(
    //				editor.bind(mxResources.get("cut"), TransferHandler
    //						.getCutAction(),
    //                        NESTWORKFLOW_RESOURCES + "images/cut.gif"))
    //				.setEnabled(selected);
    add(editor.bind(
        mxResources.get("copy"),
        TransferHandler.getCopyAction(),
        NESTWORKFLOW_RESOURCES + "images/copy.gif"))
        .setEnabled(selected);
    add(
        editor.bind(
            mxResources.get("paste"),
            TransferHandler.getPasteAction(),
            NESTWORKFLOW_RESOURCES + "images/paste.gif"));

    addSeparator();

    add(editor.bind(
        mxResources.get("delete"),
        mxGraphActions.getDeleteAction(),
        NESTWORKFLOW_RESOURCES + "images/delete.gif"))
        .setEnabled(selected);

    addSeparator();

    // Creates the format menu
    JMenu menu = (JMenu) add(new JMenu(mxResources.get("format")));

    EditorMenuBar.populateFormatMenu(menu, editor,
        (selected && getSelectedGraphItems(editor).size() > 0 && getSelectedGraphItems(editor)
            .stream().allMatch(DataObject::isNESTNode)));

//    /**
//     * Creates Menu for Editing Cell Size
//     */
//    add(
//        editor.bind("Edit Size", new EditorActions.
//            EditSizeAction(graph))).setEnabled(
//        selected && getSelectedGraphItems(editor).size() > 0 && getSelectedGraphItems(editor)
//            .stream().allMatch(DataObject::isNESTNode));

    // Creates the shape menu
    //		menu = (JMenu) add(new JMenu(mxResources.get("shape")));
    //
    //		EditorMenuBar.populateShapeMenu(menu, editor);

    addSeparator();

    add(
        editor.bind(mxResources.get("edit"), mxGraphActions
            .getEditAction())).setEnabled(oneSelected && selected);

    addSeparator();

    add(
        createGraphItemSelectionMenu(
            editor,
            ModelFactory.getDefaultModel().getNESTNodeClass(),
            mxResources.get("selectVertices")));
    add(
        createGraphItemSelectionMenu(
            editor,
            ModelFactory.getDefaultModel().getNESTEdgeClass(),
            mxResources.get("selectEdges")));

    addSeparator();

    add(editor.bind(mxResources.get("selectAll"), mxGraphActions.getSelectAllAction()));
  }

  private JMenu createLabelModeSelectionMenu(BasicGraphEditor editor) {
    JMenu menu = new JMenu("Label");
    menu.setEnabled(false);
    List<NESTGraphItemObject> selectedGraphItems = getSelectedGraphItems(editor);
    if (selectedGraphItems.size() > 0) {
      for (LabelMode mode :
          LabelMode.values()) {
        JMenuItem menuItem = new JCheckBoxMenuItem(mode.name());
        menuItem.addActionListener(
            e -> {
              selectedGraphItems.forEach(
                  graphItemObject ->
                      ((NESTWorkflowEditor.CustomGraph) editor.getGraphComponent().getGraph())
                          .getCellLabelGenerator()
                          .setLabelModeForItem(graphItemObject, mode));
              if (mode == LabelMode.NORMAL) {
                new EditorActions.KeyValueAction(mxConstants.STYLE_ALIGN, mxConstants.ALIGN_CENTER)
                    .actionPerformed(new ActionEvent(editor.getGraphComponent(), 0, null));
              } else {
                new EditorActions.KeyValueAction(mxConstants.STYLE_ALIGN, mxConstants.ALIGN_LEFT)
                    .actionPerformed(new ActionEvent(editor.getGraphComponent(), 0, null));
              }
              ((NESTWorkflowEditor.CustomGraphComponent) editor.getGraphComponent())
                  .updateAllCellLabels();
              ((NESTWorkflowEditor.CustomGraph) editor.getGraphComponent().getGraph())
                  .executeLayout();
            });
        menu.add(menuItem);
      }
      menu.setEnabled(true);
    }
    return menu;
  }

  private JMenu createGraphItemSelectionMenu(
      BasicGraphEditor editor, DataClass parentClass, String title) {
    JMenu menu = new JMenu(title);
    List<DataClass> selectableClasses = Utils.getSubClassesDeep(parentClass);
    selectableClasses.add(0, parentClass);
    selectableClasses.forEach(
        dataClass -> {
          JMenuItem menuItem = new JCheckBoxMenuItem(dataClass.getName());
          menuItem.addActionListener(
              e ->
                  ((NESTWorkflowEditor.CustomGraph) editor.getGraphComponent().getGraph())
                      .selectGraphItemsOfClass(dataClass));
          menu.add(menuItem);
        });
    return menu;
  }

  private JMenu createClassSelectionMenu(BasicGraphEditor editor) {
    JMenu menu = new JMenu(mxResources.get("setClass"));
    menu.setEnabled(false);

    List<NESTGraphItemObject> selectedGraphItems = getSelectedGraphItems(editor);

    if (selectedGraphItems.size() > 0) {
      DataClass firstItemDataClass = selectedGraphItems.get(0).getDataClass();
      DataClass commonSystemSuperClass =
          firstItemDataClass.isSystemClass()
              ? firstItemDataClass
              : firstItemDataClass.getSystemSuperClass();
      if (selectedGraphItems.stream()
          .allMatch(
              graphItem ->
                  graphItem.getDataClass() == commonSystemSuperClass
                      || graphItem.getDataClass().getSystemSuperClass()
                      == commonSystemSuperClass)) { // only allow class change when all selected
        // items have the same SystemSuperClass or
        // are the same SystemClass
        List<DataClass> selectableClasses = new LinkedList<>();
        selectableClasses.add(commonSystemSuperClass);
        selectableClasses.addAll(Utils.getSubClassesDeep(commonSystemSuperClass));
        selectableClasses =
            selectableClasses.stream()
                .filter(DataClass::isInstantiable)
                .collect(Collectors.toList());
        selectableClasses.forEach(
            dataClass -> {
              JMenuItem menuItem = new JCheckBoxMenuItem(dataClass.getName());
              menuItem.addActionListener(
                  e ->
                      selectedGraphItems.forEach(
                          graphItem -> {
                            graphItem.setDataClass(dataClass);
                          }));
              if (selectedGraphItems.size() == 1 && firstItemDataClass == dataClass) {
                menuItem.setSelected(true);
              }
              menu.add(menuItem);
            });
        menu.setEnabled(true);
      }
    }
    return menu;
  }

  private List<NESTGraphItemObject> getSelectedGraphItems(BasicGraphEditor editor) {
    return this.getSelectedCells(editor).stream()
        .map(mxICell::getValue)
        .filter(cellValue -> cellValue instanceof NESTGraphItemObject)
        .map(NESTGraphItemObject.class::cast)
        .collect(Collectors.toList());
  }

  private List<mxICell> getSelectedCells(BasicGraphEditor editor) {
    return Arrays.stream(editor.getGraphComponent().getGraph().getSelectionCells())
        .map(mxICell.class::cast)
        .collect(Collectors.toList());
  }
}
