package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor;

import com.mxgraph.analysis.mxAnalysisGraph;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxGraphActions;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxResources;
import com.mxgraph.view.mxGraph;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.NESTWorkflowEditor;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.utils.Utils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.*;

import static de.uni_trier.wi2.procake.gui.Constants.NESTWORKFLOW_RESOURCES;

public class EditorMenuBar extends JMenuBar {

  /**
   *
   */
  private static final long serialVersionUID = 4060203894740766714L;

  private NESTWorkflowEditor editor;

  public EditorMenuBar(final NESTWorkflowEditor editor) {
    this.editor = editor;
    final mxGraphComponent graphComponent = editor.getGraphComponent();
    final mxGraph graph = graphComponent.getGraph();
    mxAnalysisGraph aGraph = new mxAnalysisGraph();

    JMenu menu = null;
    JMenu submenu = null;

    // Creates the file menu
    menu = add(new JMenu(mxResources.get("file")));

    JMenu nestWorkflowClassSelectionMenu = new JMenu(mxResources.get("new"));
    nestWorkflowClassSelectionMenu.setIcon(new ImageIcon(
        BasicGraphEditor.class.getResource(NESTWORKFLOW_RESOURCES + "images/new.gif")));
    Utils.getNESTWorkflowClasses()
        .forEach(nestWorkflowClass -> nestWorkflowClassSelectionMenu.add(editor
            .bind(nestWorkflowClass.getName(),
                new EditorActions.NewNESTWorkflowAction(nestWorkflowClass))));
    menu.add(nestWorkflowClassSelectionMenu);

    menu.add(
        editor.bind(
            mxResources.get("openFile"),
            new EditorActions.OpenAction(),
            NESTWORKFLOW_RESOURCES + "images/open.gif"));

    menu.add(
        editor.bind(
            mxResources.get("save"),
            new EditorActions.SaveInObjectAction(),
            NESTWORKFLOW_RESOURCES + "images/save.gif"));

    menu.add(
        editor.bind(
            mxResources.get("exportAs"),
            new EditorActions.ExportAsAction(true),
            NESTWORKFLOW_RESOURCES + "images/saveas.gif"));

    menu.addSeparator();
    menu.add(new JCheckBoxMenuItem(
        EditorActions.getActionFor(EditorActions.ToggleAutoImportExportConfigAction.class)));

    menu.addSeparator();

    menu.add(
        editor.bind(
            mxResources.get("pageSetup"),
            new EditorActions.PageSetupAction(),
            NESTWORKFLOW_RESOURCES + "images/pagesetup.gif"));
    menu.add(
        editor.bind(
            mxResources.get("print"),
            new EditorActions.PrintAction(),
            NESTWORKFLOW_RESOURCES + "images/print.gif"));

    menu.addSeparator();

    menu.add(editor.bind(mxResources.get("exit"), new EditorActions.ExitAction()));

    // Creates the edit menu
    menu = add(new JMenu(mxResources.get("edit")));

    //		menu.add(editor.bind(mxResources.get("undo"), new EditorActions.HistoryAction(true),
    // NESTWORKFLOW_RESOURCES + "images/undo.gif"));
    //		menu.add(editor.bind(mxResources.get("redo"), new EditorActions.HistoryAction(false),
    // NESTWORKFLOW_RESOURCES + "images/redo.gif"));

    //		menu.addSeparator();

    //		menu.add(editor.bind(mxResources.get("cut"), TransferHandler.getCutAction(),
    // NESTWORKFLOW_RESOURCES + "images/cut.gif"));
    menu.add(
        editor.bind(
            mxResources.get("copy"),
            TransferHandler.getCopyAction(),
            NESTWORKFLOW_RESOURCES + "images/copy.gif"));
    menu.add(
        editor.bind(
            mxResources.get("paste"),
            TransferHandler.getPasteAction(),
            NESTWORKFLOW_RESOURCES + "images/paste.gif"));

    menu.addSeparator();

    menu.add(
        editor.bind(
            mxResources.get("delete"),
            mxGraphActions.getDeleteAction(),
            NESTWORKFLOW_RESOURCES + "images/delete.gif"));

    menu.addSeparator();

    menu.add(editor.bind(mxResources.get("selectAll"), mxGraphActions.getSelectAllAction()));
    menu.add(editor.bind(mxResources.get("selectNone"), mxGraphActions.getSelectNoneAction()));

    menu.addSeparator();

    //		menu.add(editor.bind(mxResources.get("warning"), new EditorActions.WarningAction()));
    menu.add(editor.bind(mxResources.get("edit"), mxGraphActions.getEditAction()));

    // Creates the view menu
    menu = add(new JMenu(mxResources.get("view")));

    menu.add(new EditorActions.LayoutNESTWorkflowAction());

    menu.addSeparator();

    menu.add(
        new JCheckBoxMenuItem(
            EditorActions.getActionFor(EditorActions.ToggleWorkflowNodeVisibilityAction.class)));
    menu.add(
        new JCheckBoxMenuItem(
            EditorActions.getActionFor(EditorActions.ToggleDataNodeVisibilityAction.class)));
    menu.add(
        new JCheckBoxMenuItem(
            EditorActions.getActionFor(EditorActions.ToggleSequenceNodeVisibilityAction.class)));

    menu.addSeparator();

    menu.add(
        new JCheckBoxMenuItem(
            EditorActions.getActionFor(EditorActions.ToggleIdVisibilityAction.class)));
    menu.add(
        new JCheckBoxMenuItem(
            EditorActions.getActionFor(EditorActions.ToggleEdgeLabelVisibilityAction.class)));
    menu.add(
        new JCheckBoxMenuItem(
            EditorActions.getActionFor(EditorActions.ToggleCellTooltipVisibilityAction.class)));
    //		menu.add(new
    // JCheckBoxMenuItem(EditorActions.getActionFor(EditorActions.ToggleDataFlowEdgeStyleAction.class)));

    menu.addSeparator();

    JMenuItem item =
        menu.add(
            new EditorActions.TogglePropertyItem(
                graphComponent,
                mxResources.get("pageLayout"),
                "PageVisible",
                true,
                new ActionListener() {
                  /** */
                  public void actionPerformed(ActionEvent e) {
                    if (graphComponent.isPageVisible() && graphComponent.isCenterPage()) {
                      graphComponent.zoomAndCenter();
                    } else {
                      graphComponent.getGraphControl().updatePreferredSize();
                    }
                  }
                }));

    item.addActionListener(
        new ActionListener() {
          /*
           * (non-Javadoc)
           * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
           */
          public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof EditorActions.TogglePropertyItem) {
              final mxGraphComponent graphComponent = editor.getGraphComponent();
              EditorActions.TogglePropertyItem toggleItem =
                  (EditorActions.TogglePropertyItem) e.getSource();

              if (toggleItem.isSelected()) {
                // Scrolls the view to the center
                SwingUtilities.invokeLater(
                    new Runnable() {
                      /*
                       * (non-Javadoc)
                       * @see java.lang.Runnable#run()
                       */
                      public void run() {
                        graphComponent.scrollToCenter(true);
                        graphComponent.scrollToCenter(false);
                      }
                    });
              } else {
                // Resets the translation of the view
                mxPoint tr = graphComponent.getGraph().getView().getTranslate();

                if (tr.getX() != 0 || tr.getY() != 0) {
                  graphComponent.getGraph().getView().setTranslate(new mxPoint());
                }
              }
            }
          }
        });

    menu.add(
        new EditorActions.TogglePropertyItem(
            graphComponent, mxResources.get("antialias"), "AntiAlias", true));

    menu.addSeparator();

    submenu = (JMenu) menu.add(new JMenu(mxResources.get("grid")));
    submenu.add(new EditorActions.ToggleGridItem(editor, mxResources.get("showGrid")));

    submenu.addSeparator();

    submenu.add(
        editor.bind(
            mxResources.get("gridSize"),
            new EditorActions.PromptPropertyAction(graph, "Grid Size", "GridSize")));
    submenu.add(editor.bind(mxResources.get("gridColor"), new EditorActions.GridColorAction()));

    submenu.addSeparator();

    submenu.add(
        editor.bind(
            mxResources.get("dashed"),
            new EditorActions.GridStyleAction(mxGraphComponent.GRID_STYLE_DASHED)));
    submenu.add(
        editor.bind(
            mxResources.get("dot"),
            new EditorActions.GridStyleAction(mxGraphComponent.GRID_STYLE_DOT)));
    submenu.add(
        editor.bind(
            mxResources.get("line"),
            new EditorActions.GridStyleAction(mxGraphComponent.GRID_STYLE_LINE)));
    submenu.add(
        editor.bind(
            mxResources.get("cross"),
            new EditorActions.GridStyleAction(mxGraphComponent.GRID_STYLE_CROSS)));

    menu.add(submenu);

    menu.add(new EditorActions.ToggleRulersItem(editor, mxResources.get("rulers")));

    menu.addSeparator();

    submenu = (JMenu) menu.add(new JMenu(mxResources.get("zoom")));

    submenu.add(editor.bind("400%", new EditorActions.ScaleAction(4)));
    submenu.add(editor.bind("200%", new EditorActions.ScaleAction(2)));
    submenu.add(editor.bind("150%", new EditorActions.ScaleAction(1.5)));
    submenu.add(editor.bind("100%", new EditorActions.ScaleAction(1)));
    submenu.add(editor.bind("75%", new EditorActions.ScaleAction(0.75)));
    submenu.add(editor.bind("50%", new EditorActions.ScaleAction(0.5)));

    submenu.addSeparator();

    submenu.add(editor.bind(mxResources.get("custom"), new EditorActions.ScaleAction(0)));

    menu.addSeparator();

    menu.add(editor.bind(mxResources.get("zoomIn"), mxGraphActions.getZoomInAction()));
    menu.add(editor.bind(mxResources.get("zoomOut"), mxGraphActions.getZoomOutAction()));

    menu.addSeparator();

    menu.add(
        editor.bind(
            mxResources.get("page"),
            new EditorActions.ZoomPolicyAction(mxGraphComponent.ZOOM_POLICY_PAGE)));

    menu.addSeparator();

    menu.add(editor.bind(mxResources.get("actualSize"), mxGraphActions.getZoomActualAction()));

    // Creates the format menu
    menu = add(new JMenu(mxResources.get("format")));

    populateFormatMenu(menu, editor);

    // Creates the diagram menu
    menu = add(new JMenu(mxResources.get("diagram")));

    menu.add(new EditorActions.ToggleOutlineItem(editor, mxResources.get("outline")));

    menu.addSeparator();

    submenu = (JMenu) menu.add(new JMenu(mxResources.get("background")));

    submenu.add(
        editor.bind(mxResources.get("backgroundColor"), new EditorActions.BackgroundAction()));
    submenu.add(
        editor.bind(mxResources.get("backgroundImage"), new EditorActions.BackgroundImageAction()));

    submenu.addSeparator();

    submenu.add(
        editor.bind(mxResources.get("pageBackground"), new EditorActions.PageBackgroundAction()));

    menu.addSeparator();

    submenu = (JMenu) menu.add(new JMenu(mxResources.get("layout")));

    submenu.add(editor.graphLayout("verticalHierarchical", true));
    submenu.add(editor.graphLayout("horizontalHierarchical", true));

    // Creates the options menu
    menu = add(new JMenu(mxResources.get("options")));

    submenu = (JMenu) menu.add(new JMenu(mxResources.get("display")));

    submenu.add(
        editor.bind(
            mxResources.get("tolerance"),
            new EditorActions.PromptPropertyAction(graphComponent, "Tolerance")));

    submenu = (JMenu) menu.add(new JMenu(mxResources.get("zoom")));

    submenu.add(
        new EditorActions.TogglePropertyItem(
            graphComponent, mxResources.get("centerZoom"), "CenterZoom", true));
    submenu.add(
        new EditorActions.TogglePropertyItem(
            graphComponent,
            mxResources.get("zoomToSelection"),
            "KeepSelectionVisibleOnZoom",
            true));

    submenu.addSeparator();

    submenu.add(
        new EditorActions.TogglePropertyItem(
            graphComponent,
            mxResources.get("centerPage"),
            "CenterPage",
            true,
            new ActionListener() {
              /** */
              public void actionPerformed(ActionEvent e) {
                if (graphComponent.isPageVisible() && graphComponent.isCenterPage()) {
                  graphComponent.zoomAndCenter();
                }
              }
            }));

    menu.addSeparator();

    submenu = (JMenu) menu.add(new JMenu(mxResources.get("labels")));

    submenu.add(
        new EditorActions.TogglePropertyItem(
            graph, mxResources.get("htmlLabels"), "HtmlLabels", true));
    submenu.add(
        new EditorActions.TogglePropertyItem(
            graph, mxResources.get("showLabels"), "LabelsVisible", true));

    submenu.addSeparator();

    submenu.add(
        new EditorActions.TogglePropertyItem(
            graph, mxResources.get("moveEdgeLabels"), "EdgeLabelsMovable"));
    submenu.add(
        new EditorActions.TogglePropertyItem(
            graph, mxResources.get("moveVertexLabels"), "VertexLabelsMovable"));

    menu = add(new JMenu("Analyze"));
    menu.add(editor.bind("Validate NESTWorkflow", new EditorActions.ValidateNESTWorkflowAction()));

    this.add(menu);
  }

  /**
   * Adds menu items to the given shape menu. This is factored out because the shape menu appears in
   * the menubar and also in the popupmenu.
   */
  public static void populateShapeMenu(JMenu menu, BasicGraphEditor editor) {
    menu.add(
        editor.bind(
            mxResources.get("home"),
            mxGraphActions.getHomeAction(),
            NESTWORKFLOW_RESOURCES + "images/house.gif"));

    menu.addSeparator();

    menu.add(
        editor.bind(
            mxResources.get("exitGroup"),
            mxGraphActions.getExitGroupAction(),
            NESTWORKFLOW_RESOURCES + "images/up.gif"));
    menu.add(
        editor.bind(
            mxResources.get("enterGroup"),
            mxGraphActions.getEnterGroupAction(),
            NESTWORKFLOW_RESOURCES + "images/down.gif"));

    menu.addSeparator();

    menu.add(
        editor.bind(
            mxResources.get("group"),
            mxGraphActions.getGroupAction(),
            NESTWORKFLOW_RESOURCES + "images/group.gif"));
    menu.add(
        editor.bind(
            mxResources.get("ungroup"),
            mxGraphActions.getUngroupAction(),
            NESTWORKFLOW_RESOURCES + "images/ungroup.gif"));

    menu.addSeparator();

    menu.add(
        editor.bind(
            mxResources.get("removeFromGroup"), mxGraphActions.getRemoveFromParentAction()));

    menu.add(
        editor.bind(
            mxResources.get("updateGroupBounds"), mxGraphActions.getUpdateGroupBoundsAction()));

    menu.addSeparator();

    menu.add(
        editor.bind(
            mxResources.get("collapse"),
            mxGraphActions.getCollapseAction(),
            NESTWORKFLOW_RESOURCES + "images/collapse.gif"));
    menu.add(
        editor.bind(
            mxResources.get("expand"),
            mxGraphActions.getExpandAction(),
            NESTWORKFLOW_RESOURCES + "images/expand.gif"));

    menu.addSeparator();

    menu.add(
        editor.bind(
            mxResources.get("toBack"),
            mxGraphActions.getToBackAction(),
            NESTWORKFLOW_RESOURCES + "images/toback.gif"));
    menu.add(
        editor.bind(
            mxResources.get("toFront"),
            mxGraphActions.getToFrontAction(),
            NESTWORKFLOW_RESOURCES + "images/tofront.gif"));

    menu.addSeparator();

    JMenu submenu = (JMenu) menu.add(new JMenu(mxResources.get("align")));

    submenu.add(
        editor.bind(
            mxResources.get("left"),
            new EditorActions.AlignCellsAction(mxConstants.ALIGN_LEFT),
            NESTWORKFLOW_RESOURCES + "images/alignleft.gif"));
    submenu.add(
        editor.bind(
            mxResources.get("center"),
            new EditorActions.AlignCellsAction(mxConstants.ALIGN_CENTER),
            NESTWORKFLOW_RESOURCES + "images/aligncenter.gif"));
    submenu.add(
        editor.bind(
            mxResources.get("right"),
            new EditorActions.AlignCellsAction(mxConstants.ALIGN_RIGHT),
            NESTWORKFLOW_RESOURCES + "images/alignright.gif"));

    submenu.addSeparator();

    submenu.add(
        editor.bind(
            mxResources.get("top"),
            new EditorActions.AlignCellsAction(mxConstants.ALIGN_TOP),
            NESTWORKFLOW_RESOURCES + "images/aligntop.gif"));
    submenu.add(
        editor.bind(
            mxResources.get("middle"),
            new EditorActions.AlignCellsAction(mxConstants.ALIGN_MIDDLE),
            NESTWORKFLOW_RESOURCES + "images/alignmiddle.gif"));
    submenu.add(
        editor.bind(
            mxResources.get("bottom"),
            new EditorActions.AlignCellsAction(mxConstants.ALIGN_BOTTOM),
            NESTWORKFLOW_RESOURCES + "images/alignbottom.gif"));

    menu.addSeparator();

    menu.add(editor.bind(mxResources.get("autosize"), new EditorActions.AutosizeAction()));
  }

  /**
   * Adds menu items to the given format menu. This is factored out because the format menu appears
   * in the menubar and also in the popupmenu.
   */
  public static void populateFormatMenu(JMenu menu, BasicGraphEditor editor) {
    JMenu submenu = (JMenu) menu.add(new JMenu(mxResources.get("background")));

    submenu.add(
        editor.bind(
            mxResources.get("fillcolor"),
            new EditorActions.ColorAction("Fillcolor", mxConstants.STYLE_FILLCOLOR),
            NESTWORKFLOW_RESOURCES + "images/fillcolor.gif"));
    submenu.add(
        editor.bind(
            mxResources.get("gradient"),
            new EditorActions.ColorAction("Gradient", mxConstants.STYLE_GRADIENTCOLOR)));

    submenu.addSeparator();

    submenu.add(
        editor.bind(
            mxResources.get("image"),
            new EditorActions.PromptValueAction(mxConstants.STYLE_IMAGE, "Image")));
    submenu.add(
        editor.bind(
            mxResources.get("shadow"), new EditorActions.ToggleAction(mxConstants.STYLE_SHADOW)));

    submenu.addSeparator();

    submenu.add(
        editor.bind(
            mxResources.get("opacity"),
            new EditorActions.PromptValueAction(mxConstants.STYLE_OPACITY, "Opacity (0-100)")));

    submenu = (JMenu) menu.add(new JMenu(mxResources.get("label")));

    submenu.add(
        editor.bind(
            mxResources.get("fontcolor"),
            new EditorActions.ColorAction("Fontcolor", mxConstants.STYLE_FONTCOLOR),
            NESTWORKFLOW_RESOURCES + "images/fontcolor.gif"));

    submenu.addSeparator();

    submenu.add(
        editor.bind(
            mxResources.get("labelFill"),
            new EditorActions.ColorAction("Label Fill", mxConstants.STYLE_LABEL_BACKGROUNDCOLOR)));
    submenu.add(
        editor.bind(
            mxResources.get("labelBorder"),
            new EditorActions.ColorAction("Label Border", mxConstants.STYLE_LABEL_BORDERCOLOR)));

    submenu.addSeparator();

    submenu.add(
        editor.bind(
            mxResources.get("rotateLabel"),
            new EditorActions.ToggleAction(mxConstants.STYLE_HORIZONTAL, true)));

    submenu.add(
        editor.bind(
            mxResources.get("textOpacity"),
            new EditorActions.PromptValueAction(
                mxConstants.STYLE_TEXT_OPACITY, "Opacity (0-100)")));

    submenu.addSeparator();

    JMenu subsubmenu = (JMenu) submenu.add(new JMenu(mxResources.get("position")));

    subsubmenu.add(
        editor.bind(
            mxResources.get("top"),
            new EditorActions.SetLabelPositionAction(
                mxConstants.ALIGN_TOP, mxConstants.ALIGN_BOTTOM)));
    subsubmenu.add(
        editor.bind(
            mxResources.get("middle"),
            new EditorActions.SetLabelPositionAction(
                mxConstants.ALIGN_MIDDLE, mxConstants.ALIGN_MIDDLE)));
    subsubmenu.add(
        editor.bind(
            mxResources.get("bottom"),
            new EditorActions.SetLabelPositionAction(
                mxConstants.ALIGN_BOTTOM, mxConstants.ALIGN_TOP)));

    subsubmenu.addSeparator();

    subsubmenu.add(
        editor.bind(
            mxResources.get("left"),
            new EditorActions.SetLabelPositionAction(
                mxConstants.ALIGN_LEFT, mxConstants.ALIGN_RIGHT)));
    subsubmenu.add(
        editor.bind(
            mxResources.get("center"),
            new EditorActions.SetLabelPositionAction(
                mxConstants.ALIGN_CENTER, mxConstants.ALIGN_CENTER)));
    subsubmenu.add(
        editor.bind(
            mxResources.get("right"),
            new EditorActions.SetLabelPositionAction(
                mxConstants.ALIGN_RIGHT, mxConstants.ALIGN_LEFT)));

    submenu.addSeparator();

    submenu.add(
        editor.bind(
            mxResources.get("wordWrap"),
            new EditorActions.KeyValueAction(mxConstants.STYLE_WHITE_SPACE, "wrap")));
    submenu.add(
        editor.bind(
            mxResources.get("noWordWrap"),
            new EditorActions.KeyValueAction(mxConstants.STYLE_WHITE_SPACE, null)));

    submenu.addSeparator();

    submenu.add(
        editor.bind(
            mxResources.get("hide"), new EditorActions.ToggleAction(mxConstants.STYLE_NOLABEL)));

    menu.addSeparator();

    submenu = (JMenu) menu.add(new JMenu(mxResources.get("line")));

    submenu.add(
        editor.bind(
            mxResources.get("linecolor"),
            new EditorActions.ColorAction("Linecolor", mxConstants.STYLE_STROKECOLOR),
            NESTWORKFLOW_RESOURCES + "images/linecolor.gif"));

    submenu.addSeparator();

    submenu.add(
        editor.bind(
            mxResources.get("orthogonal"),
            new EditorActions.ToggleAction(mxConstants.STYLE_ORTHOGONAL)));
    submenu.add(
        editor.bind(
            mxResources.get("dashed"), new EditorActions.ToggleAction(mxConstants.STYLE_DASHED)));

    submenu.addSeparator();

    submenu.add(
        editor.bind(
            mxResources.get("linewidth"),
            new EditorActions.PromptValueAction(mxConstants.STYLE_STROKEWIDTH, "Linewidth")));

    menu.addSeparator();

    submenu = (JMenu) menu.add(new JMenu(mxResources.get("linestart")));

    submenu.add(
        editor.bind(
            mxResources.get("open"),
            new EditorActions.KeyValueAction(mxConstants.STYLE_STARTARROW, mxConstants.ARROW_OPEN),
            NESTWORKFLOW_RESOURCES + "images/open_start.gif"));
    submenu.add(
        editor.bind(
            mxResources.get("classic"),
            new EditorActions.KeyValueAction(
                mxConstants.STYLE_STARTARROW, mxConstants.ARROW_CLASSIC),
            NESTWORKFLOW_RESOURCES + "images/classic_start.gif"));
    submenu.add(
        editor.bind(
            mxResources.get("block"),
            new EditorActions.KeyValueAction(mxConstants.STYLE_STARTARROW, mxConstants.ARROW_BLOCK),
            NESTWORKFLOW_RESOURCES + "images/block_start.gif"));

    submenu.addSeparator();

    submenu.add(
        editor.bind(
            mxResources.get("diamond"),
            new EditorActions.KeyValueAction(
                mxConstants.STYLE_STARTARROW, mxConstants.ARROW_DIAMOND),
            NESTWORKFLOW_RESOURCES + "images/diamond_start.gif"));
    submenu.add(
        editor.bind(
            mxResources.get("oval"),
            new EditorActions.KeyValueAction(mxConstants.STYLE_STARTARROW, mxConstants.ARROW_OVAL),
            NESTWORKFLOW_RESOURCES + "images/oval_start.gif"));

    submenu.addSeparator();

    submenu.add(
        editor.bind(
            mxResources.get("none"),
            new EditorActions.KeyValueAction(mxConstants.STYLE_STARTARROW, mxConstants.NONE)));
    submenu.add(
        editor.bind(
            mxResources.get("size"),
            new EditorActions.PromptValueAction(mxConstants.STYLE_STARTSIZE, "Linestart Size")));

    submenu = (JMenu) menu.add(new JMenu(mxResources.get("lineend")));

    submenu.add(
        editor.bind(
            mxResources.get("open"),
            new EditorActions.KeyValueAction(mxConstants.STYLE_ENDARROW, mxConstants.ARROW_OPEN),
            NESTWORKFLOW_RESOURCES + "images/open_end.gif"));
    submenu.add(
        editor.bind(
            mxResources.get("classic"),
            new EditorActions.KeyValueAction(mxConstants.STYLE_ENDARROW, mxConstants.ARROW_CLASSIC),
            NESTWORKFLOW_RESOURCES + "images/classic_end.gif"));
    submenu.add(
        editor.bind(
            mxResources.get("block"),
            new EditorActions.KeyValueAction(mxConstants.STYLE_ENDARROW, mxConstants.ARROW_BLOCK),
            NESTWORKFLOW_RESOURCES + "images/block_end.gif"));

    submenu.addSeparator();

    submenu.add(
        editor.bind(
            mxResources.get("diamond"),
            new EditorActions.KeyValueAction(mxConstants.STYLE_ENDARROW, mxConstants.ARROW_DIAMOND),
            NESTWORKFLOW_RESOURCES + "images/diamond_end.gif"));
    submenu.add(
        editor.bind(
            mxResources.get("oval"),
            new EditorActions.KeyValueAction(mxConstants.STYLE_ENDARROW, mxConstants.ARROW_OVAL),
            NESTWORKFLOW_RESOURCES + "images/oval_end.gif"));

    submenu.addSeparator();

    submenu.add(
        editor.bind(
            mxResources.get("none"),
            new EditorActions.KeyValueAction(mxConstants.STYLE_ENDARROW, mxConstants.NONE)));
    submenu.add(
        editor.bind(
            mxResources.get("size"),
            new EditorActions.PromptValueAction(mxConstants.STYLE_ENDSIZE, "Lineend Size")));

    menu.addSeparator();

    submenu = (JMenu) menu.add(new JMenu(mxResources.get("alignment")));

    submenu.add(
        editor.bind(
            mxResources.get("left"),
            new EditorActions.KeyValueAction(mxConstants.STYLE_ALIGN, mxConstants.ALIGN_LEFT),
            NESTWORKFLOW_RESOURCES + "images/left.gif"));
    submenu.add(
        editor.bind(
            mxResources.get("center"),
            new EditorActions.KeyValueAction(mxConstants.STYLE_ALIGN, mxConstants.ALIGN_CENTER),
            NESTWORKFLOW_RESOURCES + "images/center.gif"));
    submenu.add(
        editor.bind(
            mxResources.get("right"),
            new EditorActions.KeyValueAction(mxConstants.STYLE_ALIGN, mxConstants.ALIGN_RIGHT),
            NESTWORKFLOW_RESOURCES + "images/right.gif"));

    submenu.addSeparator();

    submenu.add(
        editor.bind(
            mxResources.get("top"),
            new EditorActions.KeyValueAction(
                mxConstants.STYLE_VERTICAL_ALIGN, mxConstants.ALIGN_TOP),
            NESTWORKFLOW_RESOURCES + "images/top.gif"));
    submenu.add(
        editor.bind(
            mxResources.get("middle"),
            new EditorActions.KeyValueAction(
                mxConstants.STYLE_VERTICAL_ALIGN, mxConstants.ALIGN_MIDDLE),
            NESTWORKFLOW_RESOURCES + "images/middle.gif"));
    submenu.add(
        editor.bind(
            mxResources.get("bottom"),
            new EditorActions.KeyValueAction(
                mxConstants.STYLE_VERTICAL_ALIGN, mxConstants.ALIGN_BOTTOM),
            NESTWORKFLOW_RESOURCES + "images/bottom.gif"));

    //		submenu = (JMenu) menu.add(new JMenu(mxResources.get("spacing")));
    //
    //		submenu.add(editor.bind(mxResources.get("top"), new
    // EditorActions.PromptValueAction(mxConstants.STYLE_SPACING_TOP, "Top Spacing")));
    //		submenu.add(editor.bind(mxResources.get("right"), new
    // EditorActions.PromptValueAction(mxConstants.STYLE_SPACING_RIGHT, "Right Spacing")));
    //		submenu.add(editor.bind(mxResources.get("bottom"), new
    // EditorActions.PromptValueAction(mxConstants.STYLE_SPACING_BOTTOM, "Bottom Spacing")));
    //		submenu.add(editor.bind(mxResources.get("left"), new
    // EditorActions.PromptValueAction(mxConstants.STYLE_SPACING_LEFT, "Left Spacing")));
    //
    //		submenu.addSeparator();
    //
    //		submenu.add(editor.bind(mxResources.get("global"), new
    // EditorActions.PromptValueAction(mxConstants.STYLE_SPACING, "Spacing")));
    //
    //		submenu.addSeparator();
    //
    //		submenu.add(editor.bind(mxResources.get("sourceSpacing"), new
    // EditorActions.PromptValueAction(mxConstants.STYLE_SOURCE_PERIMETER_SPACING,
    //				mxResources.get("sourceSpacing"))));
    //		submenu.add(editor.bind(mxResources.get("targetSpacing"), new
    // EditorActions.PromptValueAction(mxConstants.STYLE_TARGET_PERIMETER_SPACING,
    //				mxResources.get("targetSpacing"))));
    //
    //		submenu.addSeparator();
    //
    //		submenu.add(editor.bind(mxResources.get("perimeter"), new
    // EditorActions.PromptValueAction(mxConstants.STYLE_PERIMETER_SPACING,
    //				"Perimeter Spacing")));
    //
    //		submenu = (JMenu) menu.add(new JMenu(mxResources.get("direction")));
    //
    //		submenu.add(editor.bind(mxResources.get("north"), new
    // EditorActions.KeyValueAction(mxConstants.STYLE_DIRECTION, mxConstants.DIRECTION_NORTH)));
    //		submenu.add(editor.bind(mxResources.get("east"), new
    // EditorActions.KeyValueAction(mxConstants.STYLE_DIRECTION, mxConstants.DIRECTION_EAST)));
    //		submenu.add(editor.bind(mxResources.get("south"), new
    // EditorActions.KeyValueAction(mxConstants.STYLE_DIRECTION, mxConstants.DIRECTION_SOUTH)));
    //		submenu.add(editor.bind(mxResources.get("west"), new
    // EditorActions.KeyValueAction(mxConstants.STYLE_DIRECTION, mxConstants.DIRECTION_WEST)));
    //
    //		submenu.addSeparator();
    //
    //		submenu.add(editor.bind(mxResources.get("rotation"), new
    // EditorActions.PromptValueAction(mxConstants.STYLE_ROTATION, "Rotation (0-360)")));

    //		menu.addSeparator();

    //		menu.add(editor.bind(mxResources.get("rounded"), new
    // EditorActions.ToggleAction(mxConstants.STYLE_ROUNDED)));

    //		menu.add(editor.bind(mxResources.get("style"), new EditorActions.StyleAction()));
  }

  public static void populateFormatMenu(JMenu menu, BasicGraphEditor editor,
      boolean enableEditSize) {
    populateFormatMenu(menu, editor);
    menu.addSeparator();
    menu.add(
        editor.bind("Edit Size", new EditorActions.
            EditSizeAction(editor.getGraphComponent().getGraph()))).setEnabled(enableEditSize);

  }

//  public static void populateFormatMenu(JMenu menu, BasicGraphEditor editor,
//      boolean enableEditSize) {
//    populateFormatMenu(menu, editor);
//    menu.addSeparator();
//    menu.add(
//            editor.bind("Edit Size", new EditorActions.
//                EditSizeAction(editor.getGraphComponent().getGraph(), editor.getGraphComponent())))
//        .setEnabled(enableEditSize);
//
//  }

  public BasicGraphEditor getEditor() {
    return editor;
  }
};
