/**
 * Copyright (c) 2008, Gaudenz Alder
 */
package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor;

import com.mxgraph.swing.handler.mxKeyboardHandler;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxGraphActions;
import javax.swing.*;

/**
 * @author Administrator
 */
public class EditorKeyboardHandler extends mxKeyboardHandler {

  /**
   * @param graphComponent
   */
  public EditorKeyboardHandler(mxGraphComponent graphComponent) {
    super(graphComponent);
  }

  /**
   * Return JTree's input map.
   */
  protected InputMap getInputMap(int condition) {
    InputMap map = super.getInputMap(condition);

    if (condition == JComponent.WHEN_FOCUSED && map != null) {
      map.put(KeyStroke.getKeyStroke("control S"), "save");
      map.put(KeyStroke.getKeyStroke("control shift S"), "saveAs");
      map.put(KeyStroke.getKeyStroke("control shift V"), "selectVertices");
      map.put(KeyStroke.getKeyStroke("control shift E"), "selectEdges");

      map.remove(KeyStroke.getKeyStroke("CUT"));
      map.remove(KeyStroke.getKeyStroke("control X"));
    }

    return map;
  }

  /**
   * Return the mapping between JTree's input map and JGraph's actions.
   */
  protected ActionMap createActionMap() {
    try {
      ActionMap map = super.createActionMap();

      map.put("save", new EditorActions.ExportAsAction(false));
      map.put("saveAs", new EditorActions.ExportAsAction(true));
      map.put("open", new EditorActions.OpenAction());
      map.put("undo", new EditorActions.HistoryAction(true));
      map.put("redo", new EditorActions.HistoryAction(false));
      map.put("selectVertices", mxGraphActions.getSelectVerticesAction());
      map.put("selectEdges", mxGraphActions.getSelectEdgesAction());

      return map;
    }
    catch (NullPointerException e){
      // This happens in the CI environment
      return null;
    }
  }
}
