package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.editor;

import com.mxgraph.util.mxResources;
import de.uni_trier.wi2.procake.gui.objecteditor.ObjectEditor;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.NESTWorkflowEditor;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.NESTWorkflowLayout;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.swing.layouts.BasicGridLayout;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.swing.misc.DocumentAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import javax.swing.*;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;

public class EditorControlsPanel extends JPanel {

  protected static final Logger logger = LoggerFactory.getLogger(EditorControlsPanel.class);
  private NESTWorkflowEditor.CustomGraph graph;
  private NESTWorkflowLayout layout;

  public EditorControlsPanel(NESTWorkflowEditor.CustomGraph graph) {
    this.graph = graph;
    this.layout = graph.getLayout();

    setBorder(new EmptyBorder(10, 10, 0, 0));
    setLayout(new BasicGridLayout(0, 1, 2, 10));

    addNodeVisibilitySection();
    addLayoutConfigSection();
    addCellLabelsSection();
    addMiscSection();
  }

  private void addNodeVisibilitySection() {
    add(new JLabel("<html><b>Node visibility</b></html>"));
    add(new JSeparator(SwingConstants.HORIZONTAL));
    add(
        new JCheckBox(
            EditorActions.getActionFor(EditorActions.ToggleWorkflowNodeVisibilityAction.class)));
    add(
        new JCheckBox(
            EditorActions.getActionFor(EditorActions.ToggleDataNodeVisibilityAction.class)));
    add(
        new JCheckBox(
            EditorActions.getActionFor(EditorActions.ToggleSequenceNodeVisibilityAction.class)));
    add(new JLabel("<html><b> </b></html>"));
  }

  private void addLayoutConfigSection() {
    JLabel spacer = new JLabel("");
    spacer.setBorder(new EmptyBorder(0, 15, 0, 0));

    add(new JLabel("<html><b>Layout configuration</b></html>"));
    add(new JSeparator(SwingConstants.HORIZONTAL));

    JPanel routeDataflowEdges = new JPanel(new BasicGridLayout(2, 1));
    {

      // TODO: As soon as libavoid is integrated into the next Eclipse ELK release
      /*
      JCheckBox orthogonalDataflowEdgeRoutingCheckBox =
          new JCheckBox("Orthogonal dataflow edge routing");
      orthogonalDataflowEdgeRoutingCheckBox.setToolTipText(
          mxResources.get("orthogonalDataflowEdgeRoutingTooltip"));
      orthogonalDataflowEdgeRoutingCheckBox.setSelected(
          layout.getLayoutConfig().isOrthogonalDataflowEdgeRouting());
      orthogonalDataflowEdgeRoutingCheckBox.addActionListener(
          e ->
              graph
                  .getLayout()
                  .getLayoutConfig().setOrthogonalDataflowEdgeRouting(
                      orthogonalDataflowEdgeRoutingCheckBox.isSelected()));
      routeDataflowEdges.add(orthogonalDataflowEdgeRoutingCheckBox);
      */

      JPanel indent = new JPanel(new BasicGridLayout(1, 2));
      {
        indent.add(spacer); // TODO: does not work

        JPanel routedEdgesParametersPanel = new JPanel(new BasicGridLayout(2, 2));
        {
          JLabel label = new JLabel("Edge to edge spacing: ");
          label.setToolTipText(mxResources.get("dataflowEdgeToEdgeSpacingTooltip"));

          label.setBorder(new EmptyBorder(0, 15, 0, 0));
          routedEdgesParametersPanel.add(label);

          JTextField idealNudgingDistanceInput = new JTextField(2);
          idealNudgingDistanceInput.setText(
              layout.getLayoutConfig().getIdealNudgingDistance() + "");
          idealNudgingDistanceInput
              .getDocument()
              .addDocumentListener(
                  new DocumentAdapter() {
                    @Override
                    public void documentChanged(DocumentEvent e) {
                      try {
                        graph
                            .getLayout()
                            .getLayoutConfig().setIdealNudgingDistance(
                                Integer.parseInt(idealNudgingDistanceInput.getText()));
                      } catch (NumberFormatException exception) {
                        logger.error("Number format error", exception);
                      }
                    }
                  });
          routedEdgesParametersPanel.add(idealNudgingDistanceInput);

          label = new JLabel("Edge to node spacing: ");
          label.setToolTipText(mxResources.get("dataflowEdgeToNodeSpacingTooltip"));
          label.setBorder(new EmptyBorder(0, 15, 0, 0));
          routedEdgesParametersPanel.add(label);

          JTextField shapeBufferDistanceInput = new JTextField(2);
          shapeBufferDistanceInput.setText(layout.getLayoutConfig().getShapeBufferDistance() + "");
          shapeBufferDistanceInput
              .getDocument()
              .addDocumentListener(
                  new DocumentAdapter() {
                    @Override
                    public void documentChanged(DocumentEvent e) {
                      try {
                        graph
                            .getLayout()
                            .getLayoutConfig().setShapeBufferDistance(
                                Integer.parseInt(shapeBufferDistanceInput.getText()));
                      } catch (NumberFormatException exception) {
                        logger.error("Number format error", exception);
                      }
                    }
                  });
          routedEdgesParametersPanel.add(shapeBufferDistanceInput);

          indent.add(routedEdgesParametersPanel);
        }

        routeDataflowEdges.add(indent);
      }
      add(routeDataflowEdges);
    }

    JPanel placeDataNodesNearTaskNodes = new JPanel(new BasicGridLayout(2, 1));
    {
      JCheckBox dataNodesNearTaskNodesCheckBox =
          new JCheckBox(
              "<html><p style ='font-size:0.9583em'>Place data nodes vertically close <br>to their task nodes</p></html>");
      dataNodesNearTaskNodesCheckBox.setToolTipText(
          mxResources.get("dataNodesCloseToTaskNodesTooltip"));
      dataNodesNearTaskNodesCheckBox.setSelected(
          layout.getLayoutConfig().isPlaceDataNodesVerticallyNearTaskNodes());
      dataNodesNearTaskNodesCheckBox.addActionListener(
          e ->
              graph
                  .getLayout()
                  .getLayoutConfig().setPlaceDataNodesVerticallyNearTaskNodes(
                      dataNodesNearTaskNodesCheckBox.isSelected()));
      placeDataNodesNearTaskNodes.add(dataNodesNearTaskNodesCheckBox);

      JPanel indent = new JPanel(new BasicGridLayout(0, 2));
      {
        indent.add(spacer);

        JCheckBox alsoPlaceAboveTaskNodesCheckBox =
            new JCheckBox("Additionally place above task nodes");
        alsoPlaceAboveTaskNodesCheckBox.setToolTipText(
            mxResources.get("additionallyPlaceDataNodesAboveTaskNodesTooltip"));
        alsoPlaceAboveTaskNodesCheckBox.setSelected(
            layout.getLayoutConfig().isAlsoPlaceDataNodesAboveTaskNodes());
        alsoPlaceAboveTaskNodesCheckBox.addActionListener(
            e ->
                graph
                    .getLayout()
                    .getLayoutConfig().setAlsoPlaceDataNodesAboveTaskNodes(
                        alsoPlaceAboveTaskNodesCheckBox.isSelected()));
        indent.add(alsoPlaceAboveTaskNodesCheckBox);

        placeDataNodesNearTaskNodes.add(indent);
      }
      add(placeDataNodesNearTaskNodes);
    }

    JPanel layoutParametersPanel = new JPanel(new BasicGridLayout(2, 2));

    JLabel sequenceNodeVerticalSpacing = new JLabel("Vertical spacing for seq. nodes: ");
    layoutParametersPanel.add(sequenceNodeVerticalSpacing);
    JTextField sequenceNodeVerticalSpacingInput = new JTextField(2);
    sequenceNodeVerticalSpacingInput.setText(
        layout.getLayoutConfig().getSequenceNodeVerticalSpacing() + "");
    sequenceNodeVerticalSpacingInput
        .getDocument()
        .addDocumentListener(
            new DocumentAdapter() {
              @Override
              public void documentChanged(DocumentEvent e) {
                try {
                  graph
                      .getLayout()
                      .getLayoutConfig().setSequenceNodeVerticalSpacing(
                          Integer.parseInt(sequenceNodeVerticalSpacingInput.getText()));
                } catch (NumberFormatException exception) {
                  logger.error("Number format error", exception);
                }
              }
            });
    layoutParametersPanel.add(sequenceNodeVerticalSpacingInput);

    JLabel taskNodeDataNodeVerticalSpacing =
        new JLabel(
            "<html><p style ='font-size:0.9583em'>Vertical spacing between task <br>and data nodes: </p></html>");
    layoutParametersPanel.add(taskNodeDataNodeVerticalSpacing);
    JTextField taskNodeDataNodeVerticalSpacingInput = new JTextField(2);
    taskNodeDataNodeVerticalSpacingInput.setText(
        layout.getLayoutConfig().getTaskNodeToDataNodeVerticalSpacing() + "");
    taskNodeDataNodeVerticalSpacingInput
        .getDocument()
        .addDocumentListener(
            new DocumentAdapter() {
              @Override
              public void documentChanged(DocumentEvent e) {
                try {
                  graph
                      .getLayout()
                      .getLayoutConfig().setTaskNodeToDataNodeVerticalSpacing(
                          Integer.parseInt(taskNodeDataNodeVerticalSpacingInput.getText()));
                } catch (NumberFormatException exception) {
                  logger.error("Number format error", exception);
                }
              }
            });
    layoutParametersPanel.add(taskNodeDataNodeVerticalSpacingInput);

    JLabel sequenceNodesHorizontalSpacingLabel =
        new JLabel(
            "<html><p style ='font-size:0.9583em'>Horizontal spacing for se-<br>quence nodes: </p></html>");
    sequenceNodesHorizontalSpacingLabel.setToolTipText(
        mxResources.get("sequenceNodesHorizontalSpacingTooltip"));
    layoutParametersPanel.add(sequenceNodesHorizontalSpacingLabel);

    JTextField sequenceNodesHorizontalSpacingInput = new JTextField(2);
    sequenceNodesHorizontalSpacingInput.setText(
        layout.getLayoutConfig().getSequenceNodesHorizontalSpacing() + "");
    sequenceNodesHorizontalSpacingInput
        .getDocument()
        .addDocumentListener(
            new DocumentAdapter() {
              @Override
              public void documentChanged(DocumentEvent e) {
                try {
                  graph
                      .getLayout()
                      .getLayoutConfig().setSequenceNodesHorizontalSpacing(
                          Integer.parseInt(sequenceNodesHorizontalSpacingInput.getText()));
                } catch (NumberFormatException exception) {
                  logger.error("Number format error", exception);
                }
              }
            });
    layoutParametersPanel.add(sequenceNodesHorizontalSpacingInput);

    JLabel controlflowEdgeLabelMargin = new JLabel("Controlflow edge label margin: ");
    controlflowEdgeLabelMargin.setToolTipText(mxResources.get("controlflowEdgeLabelMarginTooltip"));
    layoutParametersPanel.add(controlflowEdgeLabelMargin);
    JTextField edgeLabelMarginInput = new JTextField(2);
    edgeLabelMarginInput.setText(
        layout.getLayoutConfig().getControlflowEdgeLabelHorizontalSpacing() + "");
    edgeLabelMarginInput
        .getDocument()
        .addDocumentListener(
            new DocumentAdapter() {
              @Override
              public void documentChanged(DocumentEvent e) {
                try {
                  graph
                      .getLayout()
                      .getLayoutConfig().setControlflowEdgeLabelHorizontalSpacing(
                          Integer.parseInt(edgeLabelMarginInput.getText()));
                } catch (NumberFormatException exception) {
                  logger.error("Number format error", exception);
                }
              }
            });
    layoutParametersPanel.add(edgeLabelMarginInput);

    add(layoutParametersPanel);

    add(new JCheckBox(EditorActions.getActionFor(EditorActions.ToggleReLayoutAction.class)));

    add(new JButton(new EditorActions.LayoutNESTWorkflowAction()));

    add(new JLabel("<html><b> </b></html>"));
  }

  private void addCellLabelsSection() {
    add(new JLabel("<html><b>Cell labels</b></html>"));
    add(new JSeparator(SwingConstants.HORIZONTAL));
    add(new JCheckBox(EditorActions.getActionFor(EditorActions.ToggleIdVisibilityAction.class)));
    add(
        new JCheckBox(
            EditorActions.getActionFor(EditorActions.ToggleEdgeLabelVisibilityAction.class)));
    add(new JLabel("<html><b> </b></html>"));
  }

  private void addMiscSection() {
    add(new JLabel("<html><b>Misc</b></html>"));
    add(new JSeparator(SwingConstants.HORIZONTAL));
    add(
        new JCheckBox(
            EditorActions.getActionFor(EditorActions.ToggleCellTooltipVisibilityAction.class)));
    add(new JButton(new EditorActions.EditStylesheetAction()));
    //add(new JButton(new EditorActions.RefreshNESTWorkflowAction()));
    add(new JButton(new EditorActions.ValidateNESTWorkflowAction()));
    add(new JLabel("<html><b> </b></html>"));
  }
}
