package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor;

import java.awt.*;
import javax.swing.*;


public class StylesheetEditor extends JDialog {

  public StylesheetEditor(NESTWorkflowEditor.CustomGraphComponent graphComponent) {
    super((JFrame) SwingUtilities.getWindowAncestor(graphComponent));
    this.setLayout(new BorderLayout());
    JTextArea textArea = new JTextArea(graphComponent.getStylesheet());
    JScrollPane scrollPane = new JScrollPane(textArea);
    this.add(scrollPane, BorderLayout.CENTER);

    JButton saveButton = new JButton("Save");
    saveButton.addActionListener(
        e -> {
          graphComponent.setStylesheet(textArea.getText());
          graphComponent.getGraph().refresh();
          this.dispose();
        });
    this.add(saveButton, BorderLayout.PAGE_END);
//    this.pack();
    Rectangle bounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
    this.setBounds(bounds);
    this.setDefaultCloseOperation(DISPOSE_ON_CLOSE);
    this.setVisible(true);
  }
}
