package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor;

import com.mxgraph.model.mxICell;
import com.mxgraph.swing.mxGraphComponent;
import java.awt.*;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.*;


public class StringCellEditor extends JDialog {

  public StringCellEditor(mxICell cell, mxGraphComponent graphComponent) {
    super((JFrame) SwingUtilities.getWindowAncestor(graphComponent));
    this.addWindowListener(
        new WindowAdapter() {
          public void windowClosed(WindowEvent e) {
            graphComponent.labelChanged(cell, cell.getValue(), null);
            graphComponent.requestFocusInWindow();
          }

          public void windowClosing(WindowEvent e) {
            // do nothing
          }

        });

    this.setLayout(new BorderLayout());
    JTextArea textArea = new JTextArea((String) cell.getValue());
    this.add(textArea, BorderLayout.CENTER);

    JButton saveButton = new JButton("Save");
    saveButton.addActionListener(
        e -> {
          cell.setValue(textArea.getText());
          graphComponent.labelChanged(cell, cell.getValue(), null);
          this.dispose();
        });
    this.add(saveButton, BorderLayout.PAGE_END);

    this.pack();
    Point mouseLocation = MouseInfo.getPointerInfo().getLocation();
    this.setLocation(
        Math.max(0, (int) (mouseLocation.getX() - this.getWidth() / 2)),
        Math.max(0, (int) (mouseLocation.getY() - this.getHeight() / 2)));
    this.setDefaultCloseOperation(DISPOSE_ON_CLOSE);
    this.setVisible(true);
  }
}
