package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor;

import com.mxgraph.model.mxICell;
import com.mxgraph.util.mxPoint;
import com.mxgraph.view.mxGraph;
import de.uni_trier.wi2.procake.data.model.DataClass;
import de.uni_trier.wi2.procake.data.model.nest.NESTGraphItemClass;
import de.uni_trier.wi2.procake.data.model.nest.NESTWorkflowNodeClass;
import de.uni_trier.wi2.procake.data.object.nest.NESTAbstractWorkflowObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTEdgeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTGraphItemObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTWorkflowNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTWorkflowObject;
import de.uni_trier.wi2.procake.data.object.nest.controlflowNode.NESTControlflowNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.utils.NESTWorkflowModifier;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.NESTWorkflowEditor.CustomGraph;
import java.util.Collections;


public enum NodeInsertType {
  TASK() {
    @Override
    NESTGraphItemObject insertNewNESTNode(
        NESTAbstractWorkflowObject nestWorkflow, mxGraph mxGraph, mxICell cell) {
      return nestWorkflow.getModifier().insertNewTaskNode(null);
    }
  },
  DATA() {
    @Override
    NESTGraphItemObject insertNewNESTNode(
        NESTAbstractWorkflowObject nestWorkflow, mxGraph mxGraph, mxICell cell) {
      return nestWorkflow.getModifier().insertNewDataNode(null);
    }
  },
  SUBWORKFLOW() {
    @Override
    NESTGraphItemObject insertNewNESTNode(
        NESTAbstractWorkflowObject nestWorkflow, mxGraph mxGraph, mxICell cell) {
      return nestWorkflow.getModifier()
          .insertNewSubWorkflowNode(nestWorkflow.getWorkflowNode(), null);
    }
  },
  WORKFLOW() {
    @Override
    NESTGraphItemObject insertNewNESTNode(
        NESTAbstractWorkflowObject nestWorkflow, mxGraph mxGraph, mxICell cell) {
      NESTWorkflowNodeObject workflowNode =
          nestWorkflow.getModel().createObject(NESTWorkflowNodeClass.CLASS_NAME);
      workflowNode = nestWorkflow.getIDManager().assignUniqueNodeId(workflowNode);
      nestWorkflow.addGraphNode(workflowNode);
      return workflowNode;
    }
  },
  AND_BLOCK() {
    @Override
    NESTGraphItemObject insertNewNESTNode(
        NESTAbstractWorkflowObject nestWorkflow, mxGraph mxGraph, mxICell startCell) {
      return this.insertAndBlock((NESTWorkflowObject) nestWorkflow, mxGraph, startCell);
    }
  },
  XOR_BLOCK() {
    @Override
    NESTGraphItemObject insertNewNESTNode(
        NESTAbstractWorkflowObject nestWorkflow, mxGraph mxGraph, mxICell startCell) {
      return this.insertXorBlock((NESTWorkflowObject) nestWorkflow, mxGraph, startCell);
    }
  },
  OR_BLOCK() {
    @Override
    NESTGraphItemObject insertNewNESTNode(
        NESTAbstractWorkflowObject nestWorkflow, mxGraph mxGraph, mxICell startCell) {
      return this.insertOrBlock((NESTWorkflowObject) nestWorkflow, mxGraph, startCell);
    }
  },
  LOOP_BLOCK() {
    @Override
    NESTGraphItemObject insertNewNESTNode(
        NESTAbstractWorkflowObject nestWorkflow, mxGraph mxGraph, mxICell startCell) {
      return this.insertLoopBlock((NESTWorkflowObject) nestWorkflow, mxGraph, startCell);
    }
  };

  public static NodeInsertType get(NESTNodeObject node) throws Exception {
    if (node.isNESTTaskNode()) {
      return TASK;
    } else if (node.isNESTDataNode()) {
      return DATA;
    } else if (node.isNESTSubWorkflowNode()) {
      return SUBWORKFLOW;
    } else if (node.isNESTWorkflowNode()) {
      return WORKFLOW;
    } else if (node.isNESTControlflowNode()) {
      NESTControlflowNodeObject controlflowNode = (NESTControlflowNodeObject) node;
      if (controlflowNode.isAndEndNode()) {
        return AND_BLOCK;
      } else if (controlflowNode.isXorEndNode()) {
        return XOR_BLOCK;
      } else if (controlflowNode.isLoopStartNode()) {
        return LOOP_BLOCK;
      }
      // for AndStart, XorStart and LoopEnd --> do nothing
    }
    throw new Exception("Unsupported node type: " + node.getDataClass());
  }

  abstract NESTGraphItemObject insertNewNESTNode(
      NESTAbstractWorkflowObject nestWorkflow, mxGraph mxGraph, mxICell cell);

  public NESTGraphItemObject doInsertion(
      NESTAbstractWorkflowObject nestWorkflow, mxGraph mxGraph, mxICell cell) {
    CustomGraph customGraph = (CustomGraph) mxGraph;
    NESTGraphItemObject insertedNode = this.insertNewNESTNode(nestWorkflow, mxGraph, cell);
    DataClass semanticDescriptorClass = ((NESTGraphItemClass) insertedNode.getDataClass()).getSemanticDescriptorClass();
    insertedNode.setSemanticDescriptor(
        semanticDescriptorClass == null || !semanticDescriptorClass.isInstantiable()
            ? null
            : semanticDescriptorClass.newObject());
    customGraph.setCellId(cell, insertedNode.getId());
    customGraph.syncOutgoingEdges((NESTNodeObject) insertedNode);
    cell.getGeometry().setHeight(customGraph.getLayout().getLayoutConfig().getNodeHeight());
    mxGraph.cellLabelChanged(cell, insertedNode, true);
    return insertedNode;
  }

  public NESTGraphItemObject insertXorBlock(
      NESTWorkflowObject nestWorkflow, mxGraph mxGraph, mxICell startCell) {
    NESTWorkflowModifier modifier = nestWorkflow.getModifier();
    NESTWorkflowModifier.NESTControlflowNodePair pair = modifier.insertNewXorSequence(null, null);
    return insertControlflowBlock(nestWorkflow, mxGraph, startCell, pair);
  }

  public NESTGraphItemObject insertOrBlock(
      NESTWorkflowObject nestWorkflow, mxGraph mxGraph, mxICell startCell) {
    NESTWorkflowModifier modifier = nestWorkflow.getModifier();
    NESTWorkflowModifier.NESTControlflowNodePair pair = modifier.insertNewOrSequence(null, null);
    return insertControlflowBlock(nestWorkflow, mxGraph, startCell, pair);
  }

  public NESTGraphItemObject insertAndBlock(
      NESTWorkflowObject nestWorkflow, mxGraph mxGraph, mxICell startCell) {
    NESTWorkflowModifier modifier = nestWorkflow.getModifier();
    NESTWorkflowModifier.NESTControlflowNodePair pair = modifier.insertNewAndSequence(null, null);
    return insertControlflowBlock(nestWorkflow, mxGraph, startCell, pair);
  }

  public NESTGraphItemObject insertLoopBlock(
      NESTWorkflowObject nestWorkflow, mxGraph mxGraph, mxICell startCell) {
    NESTWorkflowModifier modifier = nestWorkflow.getModifier();
    NESTWorkflowModifier.NESTControlflowNodePair pair = modifier.insertNewLoopSequence(null, null);
    return insertControlflowBlock(nestWorkflow, mxGraph, startCell, pair);
  }

  private NESTGraphItemObject insertControlflowBlock(
      NESTWorkflowObject nestWorkflow,
      mxGraph mxGraph,
      mxICell startCell,
      NESTWorkflowModifier.NESTControlflowNodePair pair) {
    NESTWorkflowModifier modifier = nestWorkflow.getModifier();

    mxGraph.getModel().beginUpdate();
    try {
      ((NESTWorkflowEditor.CustomGraph) mxGraph).setCellId(startCell, pair.getStartNode().getId());
      mxICell endCell =
          (mxICell)
              mxGraph.insertVertex(
                  mxGraph.getDefaultParent(),
                  pair.getEndNode().getId(),
                  pair.getEndNode(),
                  startCell.getGeometry().getX() + 250,
                  startCell.getGeometry().getY(),
                  ((CustomGraph) mxGraph).getLayout().getLayoutConfig().getNodeWidth(),
                  ((CustomGraph) mxGraph).getLayout().getLayoutConfig().getNodeHeight(),
                  NESTWorkflowEditor.CellStyle.get(pair.getEndNode()));

      pair.getEndNode().getOutgoingEdges().stream()
          .filter(NESTEdgeObject::isNESTPartOfEdge)
          .forEach(
              ((NESTWorkflowEditor.CustomGraph) mxGraph)
                  ::syncEdge); // draw outgoing partOf edge of end node of controlflow block

      NESTEdgeObject newNESTEdge =
          modifier.insertNewControlflowEdge(pair.getStartNode(), pair.getEndNode(), null);
      mxICell mxEdge = ((NESTWorkflowEditor.CustomGraph) mxGraph).syncEdge(newNESTEdge);
      double centerX =
          startCell.getGeometry().getX()
              + (endCell.getGeometry().getX() - startCell.getGeometry().getX()) / 2
              + startCell.getGeometry().getWidth()
              / 2; // x coordinate of the center of the space between the two controlflow nodes
      if (!pair.getStartNode().isLoopNode()) {
        mxEdge
            .getGeometry()
            .setPoints(
                Collections.singletonList(
                    new mxPoint(
                        centerX,
                        startCell.getGeometry().getY()
                            - startCell
                            .getGeometry()
                            .getHeight()))); // set a point above and between the two nodes to
        // avoid edge overlapping
      }

      newNESTEdge =
          pair.getStartNode().isLoopNode()
              ? modifier.insertNewControlflowEdge(pair.getEndNode(), pair.getStartNode(), null)
              : modifier.insertNewControlflowEdge(pair.getStartNode(), pair.getEndNode(), null);
      mxEdge = ((NESTWorkflowEditor.CustomGraph) mxGraph).syncEdge(newNESTEdge);
      if (!pair.getStartNode().isLoopNode()) {
        mxEdge
            .getGeometry()
            .setPoints(
                Collections.singletonList(
                    new mxPoint(
                        centerX,
                        startCell.getGeometry().getY()
                            + startCell.getGeometry().getHeight()
                            * 2))); // set a point below and between the two nodes to avoid edge
        // overlapping
      } else {
        mxEdge
            .getGeometry()
            .setPoints(
                Collections.singletonList(
                    new mxPoint(
                        centerX,
                        startCell.getGeometry().getY() - startCell.getGeometry().getHeight())));
      }
    } finally {
      mxGraph.getModel().endUpdate();
    }
    return pair.getStartNode();
  }
}
