package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor;

import com.mxgraph.model.mxCell;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import de.uni_trier.wi2.procake.data.object.nest.NESTEdgeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTNodeObject;

/**
 * Listens for changes in endpoints of existing edges. Listener for new edge creation is implemented
 * in EdgeCreationListener. Is registered listening for mxEvent.CONNECT_CELL events CustomGraph.
 */
public class EdgeTerminalModificationListener implements mxEventSource.mxIEventListener {

  @Override
  public void invoke(Object sender, mxEventObject mxEventObject) {
    mxCell edgeCell = (mxCell) mxEventObject.getProperty("edge");
    NESTNodeObject pre = (NESTNodeObject) edgeCell.getSource().getValue();
    NESTNodeObject post = (NESTNodeObject) edgeCell.getTarget().getValue();
    NESTEdgeObject nestEdge = (NESTEdgeObject) edgeCell.getValue();
    nestEdge.setPre(pre);
    nestEdge.setPost(post);

    NESTWorkflowEditor.CustomGraph mxGraph = (NESTWorkflowEditor.CustomGraph) sender;
    mxGraph
        .getModel()
        .setStyle(
            edgeCell,
            (NESTWorkflowEditor.CellStyle.get(
                (NESTEdgeObject)
                    edgeCell.getValue()))); // style is only rendered in the view when set via the
    // model, directly setting it on the cell does not work

    if (mxGraph.getLayout().isExecuteOnEdgeInsertion()) {
      mxGraph.executeLayout();
    }
  }
}
