package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor;

import com.mxgraph.model.mxICell;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import de.uni_trier.wi2.procake.data.object.nest.NESTAbstractWorkflowObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTEdgeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTSequenceNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.controlflowNode.NESTControlflowNodeObject;

// is registered listening for mxEvent.SPLIT_EDGE events on mxGraph in CustomGraphComponent
public class EdgeSplitListener implements mxEventSource.mxIEventListener {

  @Override
  public void invoke(Object sender, mxEventObject mxEventObject) {
    NESTWorkflowEditor.CustomGraph mxGraph = (NESTWorkflowEditor.CustomGraph) sender;
    NESTAbstractWorkflowObject nestWorkflow = mxGraph.getNestWorkflow();

    // Before drop:
    // [pre] --edge--> [post]
    // After drop on edge:
    // [pre] --newEdge--> [newNode] --edge--> [post]
    // For layout purposes it is needed to keep "edge" before "newNode" (first edge in branch needs
    // to keep the same id):
    // [pre] --edge--> [newNode] --newEdge--> [post]

    mxICell edgeMx = (mxICell) mxEventObject.getProperty("edge");
    mxICell newEdgeMx = ((mxICell) mxEventObject.getProperty("newEdge"));

    NESTEdgeObject edge = ((NESTEdgeObject) edgeMx.getValue());
    NESTNodeObject newNode =
        (NESTNodeObject) ((mxICell) ((Object[]) mxEventObject.getProperty("cells"))[0]).getValue();
    NESTNodeObject post = edge.getPost();

    mxGraph.setEventsEnabled(false);
    mxGraph.removeCells(new Object[]{edgeMx, newEdgeMx});
    edge.setPost(newNode);
    NESTEdgeObject newEdge =
        nestWorkflow
            .getModifier()
            .insertNewControlflowEdge(
                (NESTSequenceNodeObject) newNode, (NESTSequenceNodeObject) post, null);
    newEdge.setSemanticDescriptor(
        edge.getSemanticDescriptor() == null ? null : edge.getSemanticDescriptor().copy());

    if (newNode.isNESTControlflowNode()) { // controlflow node pair dropped
      NESTControlflowNodeObject matchingBlockControlflowNode =
          ((NESTControlflowNodeObject) newNode).getMatchingBlockControlflowNode();
      newEdge.setPre(matchingBlockControlflowNode);
    }

    mxGraph.syncEdge(edge);
    mxGraph.syncEdge(newEdge);

    mxGraph.setEventsEnabled(true);

    mxGraph.executeLayout();
    mxGraph.refresh();
  }
}
