package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor;

import com.mxgraph.model.mxCell;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.view.mxGraph;
import de.uni_trier.wi2.procake.data.model.Model;
import de.uni_trier.wi2.procake.data.object.nest.NESTEdgeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTGraphObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTNodeObject;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.utils.Utils;

/**
 * Is notified on creation of NEW edges. Listener for changing endpoints of existing edges is
 * implemented in EdgeTerminalModificationListener. Is registered listening for mxEvent.CONNECT
 * events on mxConnectionHandler in CustomGraphComponent.
 */

public class EdgeCreationListener implements mxEventSource.mxIEventListener {

  private final mxGraph mxGraph;

  public EdgeCreationListener(mxGraph mxGraph) {
    this.mxGraph = mxGraph;
  }

  @Override
  public void invoke(
      Object sender,
      mxEventObject mxEventObject) { // is invoked either on newly created edges or on edge endpoint
    // modifications
    mxCell edgeCell = (mxCell) mxEventObject.getProperty("cell");
    NESTNodeObject pre = (NESTNodeObject) edgeCell.getSource().getValue();
    NESTNodeObject post = (NESTNodeObject) edgeCell.getTarget().getValue();

    NESTEdgeObject newNESTEdge = this.insertSuitableEdge(pre, post);
    if (newNESTEdge == null) { // should not happen as connection should already be validated in
      // CustomGraph.getEdgeValidationError
      System.err.println(
          "No suitable edge class for node connection of type "
              + pre.getDataClass().getName()
              + " -> "
              + post.getDataClass().getName()
              + " found.");
      this.mxGraph.removeCells(
          new Object[]{
              edgeCell
          }); // edgeCell.getParent().remove(edgeCell) leaves a green marker for the deleted edge
      // behind which does not happen when removing the edge via the mxGraph
      return;
    }
    edgeCell.setValue(newNESTEdge);
    ((NESTWorkflowEditor.CustomGraph) this.mxGraph).setCellId(edgeCell, newNESTEdge.getId());

    this.mxGraph
        .getModel()
        .setStyle(
            edgeCell,
            (NESTWorkflowEditor.CellStyle.get(
                (NESTEdgeObject)
                    edgeCell.getValue()))); // style is only rendered in the view when set via the
    // model, directly setting it on the cell does not work

    if (((NESTWorkflowEditor.CustomGraph) this.mxGraph).getLayout().isExecuteOnEdgeInsertion()) {
      ((NESTWorkflowEditor.CustomGraph) this.mxGraph).executeLayout();
    }
  }

  private NESTEdgeObject insertSuitableEdge(NESTNodeObject pre, NESTNodeObject post) {
    if (pre == null || post == null) {
      return null;
    }

    NESTGraphObject workflow = pre.getGraph();
    Model model = workflow.getModel();

    String edgeClassName = Utils.getEdgeClassForNodeConnection(pre, post);

    if (edgeClassName != null) {
      NESTEdgeObject edge = model.createObject(edgeClassName);
      workflow.getIDManager().assignUniqueEdgeId(edge);
      edge.setGraph(workflow);
      edge.setPre(pre);
      edge.setPost(post);

      return edge;
    }

    return null; // no suitable edge class found
  }
}
