package de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxICell;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import de.uni_trier.wi2.procake.data.object.nest.NESTEdgeObject;
import de.uni_trier.wi2.procake.data.object.nest.NESTGraphItemObject;
import de.uni_trier.wi2.procake.data.object.nest.controlflowNode.NESTControlflowNodeObject;
import de.uni_trier.wi2.procake.data.object.nest.utils.NESTAbstractWorkflowModifier;
import de.uni_trier.wi2.procake.gui.objecteditor.nestworkfloweditor.utils.Utils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

// is registered listening for mxEvent.CELLS_REMOVED events on mxGraph in CustomGraphComponent

public class CellRemoveListener implements mxEventSource.mxIEventListener {

  @Override
  public void invoke(Object sender, mxEventObject mxEventObject) {
    NESTWorkflowEditor.CustomGraph mxGraph = (NESTWorkflowEditor.CustomGraph) sender;
    NESTAbstractWorkflowModifier modifier = mxGraph.getNestWorkflow().getModifier();
    Set<mxCell> removedCells =
        Arrays.stream((Object[]) mxEventObject.getProperty("cells"))
            .map(mxCell.class::cast)
            .collect(Collectors.toCollection(HashSet::new));
    removedCells.forEach(
        removedCell -> {
          if (removedCell != null && removedCell.getValue() instanceof NESTGraphItemObject) {
            NESTGraphItemObject graphItem = (NESTGraphItemObject) removedCell.getValue();
            if (graphItem.isNESTEdge()) {
              NESTEdgeObject edge = (NESTEdgeObject) graphItem;
              if (Utils.isEdgeLoopReturnEdge(edge)
                  && !removedCells.contains(removedCell.getTerminal(true))
                  && !removedCells.contains(removedCell.getTerminal(false))) {
                reAddDeletedLoopReturnEdgeCell(mxGraph, edge);
              } else {
                modifier.removeEdge(edge);
              }
            } else if (graphItem.isNESTNode()) {
              if (graphItem.isNESTControlflowNode()) {
                NESTControlflowNodeObject matchingNode =
                    ((NESTControlflowNodeObject) graphItem).getMatchingBlockControlflowNode();
                if (matchingNode != null) {
                  mxGraph.removeCells(
                      new Object[]{mxGraph.getCellById(matchingNode.getId())},
                      true); // remove matching controlflow node of block, causes another
                  // mxEvent.CELLS_REMOVED
                }
              }
              graphItem.getGraph().removeGraphNode(graphItem.getId());
            }
          }
        });
  }

  private void reAddDeletedLoopReturnEdgeCell(
      NESTWorkflowEditor.CustomGraph mxGraph, NESTEdgeObject edge) {
    // do not remove and re-add to mxGraph
    mxGraph.setEventsEnabled(false);
    try {
      mxICell edgeCell = mxGraph.syncEdge(edge);
      List<mxPoint> mxPointPath =
          Collections.singletonList(
              new mxPoint(
                  edgeCell.getTerminal(true).getGeometry().getCenterX(),
                  edgeCell.getTerminal(true).getGeometry().getY()
                      - mxGraph.getLayout().getLayoutConfig().getNodeHeight() / 2.0
                      - mxGraph.getLayout().getLayoutConfig().getNodeVerticalSpacing()));
      edgeCell.getGeometry().setPoints(mxPointPath);
    } finally {
      mxGraph.setEventsEnabled(true);
    }
  }
}
